/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.nfe.consultanfedoc;

import com.fincatto.documentofiscal.nfe.classes.distribuicao.NFDistribuicaoDocumentoZip;
import com.fincatto.documentofiscal.nfe.classes.distribuicao.NFDistribuicaoIntRetorno;
import com.touchcomp.basementor.constants.enums.configservicos.EnumConstConfigServicos;
import com.touchcomp.basementor.constants.enums.configservicos.impl.ConstantsDistribuicaoXMLCTes;
import com.touchcomp.basementor.constants.enums.configservicos.impl.ConstantsDistribuicaoXMLNFes;
import com.touchcomp.basementor.constants.enums.configuracaocertificado.ConstAmbiente;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstDistribuicaoNFeStatus;
import com.touchcomp.basementor.constants.enums.tasks.EnumConstantsTaskResult;
import com.touchcomp.basementor.model.vo.ConfigServicos;
import com.touchcomp.basementor.model.vo.ConfiguracaoCertificado;
import com.touchcomp.basementor.model.vo.ConsultaNFeDestDist;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementorclientwebservices.certificado.model.ParamsCertificado;
import com.touchcomp.basementorclientwebservices.nfe.impl.distribuicaonfe.WebDistribuicaoDocXMLNFe;
import com.touchcomp.basementorclientwebservices.nfe.model.env.distdocxmlnfe.ParamsDistribDocXMLNFe;
import com.touchcomp.basementorexceptions.exceptions.impl.decoder.ExceptionDecodeHexString64;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.components.distribuicaoxmlnfecte.CompDistribuicaoXMLNFeCTe;
import com.touchcomp.basementorservice.components.empresa.CompEmpresa;
import com.touchcomp.basementorservice.components.nfe.consultanfedoc.AuxProcessaEventoDistNFe;
import com.touchcomp.basementorservice.components.nfe.consultanfedoc.CompStatusConsNFeDoc;
import com.touchcomp.basementorservice.helpers.impl.configservicos.HelperConfigServicos;
import com.touchcomp.basementorservice.helpers.impl.configuracaocertificado.HelperConfiguracaoCertificado;
import com.touchcomp.basementorservice.model.task.TaskProcessResult;
import com.touchcomp.basementorservice.service.impl.configservicos.ServiceConfigServicosImpl;
import com.touchcomp.basementorservice.service.impl.configuracaocertificado.ServiceConfiguracaoCertificadoImpl;
import com.touchcomp.basementorservice.service.impl.consultanfedestdist.ServiceConsultaNFeDestDistImpl;
import com.touchcomp.basementorservice.service.impl.consultanfedestdist.ServiceConsultaNFeDestNSUImpl;
import com.touchcomp.basementorservice.service.impl.consultanfedestdocsdist.ServiceConsultaNFeDestDocsDistImpl;
import com.touchcomp.basementorservice.service.impl.consultanfedestevtdist.ServiceConsultaNFeDestEvtDistImpl;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.notafiscalterceiros.ServiceNotaFiscalTerceirosImpl;
import com.touchcomp.basementorservice.service.impl.unidadefatfornecedor.ServiceUnidadeFatFornecedorImpl;
import com.touchcomp.basementorservice.service.impl.unidadefederativa.ServiceUnidadeFederativaImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementorxml.service.impl.xmlnfecteevt.ServiceXMLNFeCTeEvtImpl;
import com.touchcomp.basementorxml.service.interfaces.ServiceXMLNFeCTe;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class CompConsultaNFeEmitidasDoc {
    private final ServiceConsultaNFeDestDocsDistImpl serviceConsultaNFeDestDocImpl;
    private final ServiceConsultaNFeDestDistImpl serviceConsultaNFeDestImpl;
    private final ServiceConfiguracaoCertificadoImpl serviceConfiguracaoCertificadoImpl;
    private final HelperConfiguracaoCertificado helperConfigCertificado;
    private final WebDistribuicaoDocXMLNFe distribuicaoNFe;
    private final ServiceXMLNFeCTe serviceXmlNFeCte;
    private final ServiceXMLNFeCTeEvtImpl serviceXmlNFeCteEvt;
    private final ServiceConsultaNFeDestEvtDistImpl serviceConsultaNFeDestEvtImpl;
    private final ServiceUnidadeFatFornecedorImpl serviceUnidadeFatFornecedorImpl;
    private final ServiceUnidadeFederativaImpl serviceUF;
    private final CompStatusConsNFeDoc compStatusConsDoc;
    private final ServiceConsultaNFeDestNSUImpl serviceConsultaNFeDestNSUImpl;
    private final ServiceNotaFiscalTerceirosImpl serviceNotaFiscalTerceirosImpl;
    private final ServiceConfigServicosImpl serviceConfigServicosImpl;
    private final ServiceEmpresaImpl serviceEmpresaImpl;
    private final HelperConfigServicos helperConfigServicos;
    private final CompEmpresa compEmpresa;
    private final CompDistribuicaoXMLNFeCTe compDistribuicaoXMLNFeCTe;

    public CompConsultaNFeEmitidasDoc(ServiceXMLNFeCTe serviceXmlNFeCte, ServiceXMLNFeCTeEvtImpl serviceXmlNFeCteEvt, WebDistribuicaoDocXMLNFe webDistribuicaoNFe, ServiceConsultaNFeDestDocsDistImpl serviceConsultaNFeDestDocImpl, ServiceConsultaNFeDestEvtDistImpl serviceConsultaNFeDestEvtImpl, ServiceUnidadeFatFornecedorImpl serviceUnidadeFatFornecedorImpl, ServiceConsultaNFeDestDistImpl serviceConsultaNFeDestImpl, HelperConfiguracaoCertificado helperConfigCertificado, WebDistribuicaoDocXMLNFe distribuicaoNFe, ServiceUnidadeFederativaImpl serviceUF, CompStatusConsNFeDoc compStatusConsDoc, ServiceConsultaNFeDestNSUImpl serviceConsultaNFeDestNSUImpl, ServiceNotaFiscalTerceirosImpl serviceNotaFiscalTerceirosImpl, ServiceConfigServicosImpl serviceConfigServicosImpl1, HelperConfigServicos helperConfigServicos, ServiceEmpresaImpl serviceEmpresaImpl, ServiceConfiguracaoCertificadoImpl serviceConfiguracaoCertificadoImpl, CompEmpresa compEmpresa, CompDistribuicaoXMLNFeCTe compDistribuicaoXMLNFeCTe) {
        this.serviceConsultaNFeDestDocImpl = serviceConsultaNFeDestDocImpl;
        this.serviceConsultaNFeDestImpl = serviceConsultaNFeDestImpl;
        this.helperConfigCertificado = helperConfigCertificado;
        this.distribuicaoNFe = distribuicaoNFe;
        this.serviceConfigServicosImpl = serviceConfigServicosImpl1;
        this.helperConfigServicos = helperConfigServicos;
        this.serviceEmpresaImpl = serviceEmpresaImpl;
        this.serviceConfiguracaoCertificadoImpl = serviceConfiguracaoCertificadoImpl;
        this.serviceXmlNFeCte = serviceXmlNFeCte;
        this.serviceXmlNFeCteEvt = serviceXmlNFeCteEvt;
        this.serviceConsultaNFeDestEvtImpl = serviceConsultaNFeDestEvtImpl;
        this.serviceUnidadeFatFornecedorImpl = serviceUnidadeFatFornecedorImpl;
        this.serviceUF = serviceUF;
        this.compStatusConsDoc = compStatusConsDoc;
        this.serviceConsultaNFeDestNSUImpl = serviceConsultaNFeDestNSUImpl;
        this.serviceNotaFiscalTerceirosImpl = serviceNotaFiscalTerceirosImpl;
        this.compEmpresa = compEmpresa;
        this.compDistribuicaoXMLNFeCTe = compDistribuicaoXMLNFeCTe;
    }

    public TaskProcessResult distribuicaoNFeNSUEspecifico(Empresa empresa, String nsuEspecifico) throws Exception {
        TaskProcessResult result = new TaskProcessResult();
        ConfigServicos config = this.serviceConfigServicosImpl.getContainsValueOrThrow(EnumConstConfigServicos.DITRIBUICAO_XML_NFES, ConstantsDistribuicaoXMLNFes.ID_EMPRESA.getChave(), empresa.getIdentificador().toString());
        String idCertificados = this.helperConfigServicos.build(config).getValue(ConstantsDistribuicaoXMLCTes.ID_CONFIGURACAO_CERTIFICADO.getChave());
        Long idCertificadoEmpresa = this.compDistribuicaoXMLNFeCTe.getIdCertificado(empresa, idCertificados);
        ConfiguracaoCertificado configCert = this.getConfiguracaoCertificado(idCertificadoEmpresa);
        ConstAmbiente tipoAmbiente = this.getTipoAmbiente(config, result);
        ParamsCertificado params = this.helperConfigCertificado.build(configCert).getParamsCertificado(tipoAmbiente);
        NFDistribuicaoIntRetorno ret = this.distribuicaoNFe.consultarDistribuicaoXML(params, this.getParamsEnv(null, empresa, tipoAmbiente.getCodigo(), nsuEspecifico));
        if (!EnumConstDistribuicaoNFeStatus.isStatusFinal((String)ret.getCodigoStatusReposta())) {
            result.addDet(EnumConstantsTaskResult.RESULT_ERRO, ret.getCodigoStatusReposta() + " - " + ret.getMotivo());
            return result;
        }
        if (!EnumConstDistribuicaoNFeStatus.isDocFound((String)ret.getCodigoStatusReposta())) {
            result.addDet(EnumConstantsTaskResult.RESULT_OK, ret.getCodigoStatusReposta() + " - " + ret.getMotivo());
            return result;
        }
        if (EnumConstDistribuicaoNFeStatus.isServicoParado((String)ret.getCodigoStatusReposta())) {
            result.addDet(EnumConstantsTaskResult.RESULT_ADVERTENCIA, ret.getCodigoStatusReposta() + " - " + ret.getMotivo());
            return result;
        }
        this.efetuaProcessamentoESalva(ret, empresa, result, config);
        result.addDetByCode(EnumConstantsTaskResult.RESULT_OK, "M.TSK.0025.001", 1);
        return result;
    }

    public void distribuicaoNFe(Empresa empresa, TaskProcessResult result) throws Exception {
        ConfigServicos conf = this.serviceConfigServicosImpl.getContainsValueOrThrow(EnumConstConfigServicos.DITRIBUICAO_XML_NFES, ConstantsDistribuicaoXMLNFes.ID_EMPRESA.getChave(), empresa.getIdentificador().toString());
        this.distribuicaoNFe(conf, result, empresa);
    }

    public void distribuicaoNFe(String idConfServicos, TaskProcessResult result) throws Exception {
        String[] idsConfs;
        for (String idsConf : idsConfs = ToolString.splitString((String)idConfServicos, (char[])new char[0])) {
            ConfigServicos config = (ConfigServicos)this.serviceConfigServicosImpl.getOrThrow(idsConf);
            if (!TMethods.isEquals((Object)EnumConstConfigServicos.get((Object)config.getChave()), (Object)EnumConstConfigServicos.DITRIBUICAO_XML_NFES)) {
                result.addError("E.TSK.0023.006", EnumConstConfigServicos.DITRIBUICAO_XML_NFES.getChave(), config.getChave());
                return;
            }
            String idEmpresas = this.helperConfigServicos.build(config).getValue(ConstantsDistribuicaoXMLCTes.ID_EMPRESA.getChave());
            List<Empresa> empresas = this.compEmpresa.getEmpresas(idEmpresas, result);
            if (empresas == null) continue;
            Empresa[] arrEmpresas = (Empresa[])empresas.toArray(Empresa[]::new);
            this.distribuicaoNFe(config, result, arrEmpresas);
        }
    }

    public synchronized void distribuicaoNFe(ConfigServicos config, TaskProcessResult result, Empresa ... empresas) throws Exception {
        ConstAmbiente tpAmb = this.getTipoAmbiente(config, result);
        String nsuInicial = this.helperConfigServicos.build(config).getValue(ConstantsDistribuicaoXMLCTes.NSU_INICIAL.getChave());
        if (!TMethods.isStrWithData((String)nsuInicial)) {
            nsuInicial = "0";
        }
        String idCertificados = this.helperConfigServicos.build(config).getValue(ConstantsDistribuicaoXMLCTes.ID_CONFIGURACAO_CERTIFICADO.getChave());
        for (Empresa empresa : empresas) {
            Long idCertificadoEmpresa = this.compDistribuicaoXMLNFeCTe.getIdCertificado(empresa, idCertificados);
            ConfiguracaoCertificado configCert = this.getConfiguracaoCertificado(idCertificadoEmpresa);
            Long nsuIn = this.compDistribuicaoXMLNFeCTe.getNSUEmpresa(empresa, nsuInicial);
            if (nsuIn < 0L) {
                this.serviceConsultaNFeDestImpl.desconsiderarConsultasEmpresa(empresa);
                nsuInicial = this.compDistribuicaoXMLNFeCTe.atualizarNSUEmpresa(empresa, nsuInicial, 0L);
                config = this.atualizarNSUProximaExec(config, nsuInicial);
            }
            this.distribuicaoNFe(configCert, empresa, tpAmb, nsuIn, result, config);
        }
    }

    public synchronized void distribuicaoNFe(ConfiguracaoCertificado configCert, Empresa empresa, ConstAmbiente tipoAmbiente, Long nsuInicial, TaskProcessResult result, ConfigServicos configServicos) throws Exception {
        String maxNsu;
        String ultNsu = this.serviceConsultaNFeDestImpl.getUltimaConsulta(empresa);
        if (nsuInicial == null) {
            nsuInicial = 0L;
        }
        if (!ToolMethods.isStrWithData((String)ultNsu)) {
            ultNsu = nsuInicial.toString();
        }
        if (!ToolMethods.isStrWithData((String)ultNsu)) {
            ultNsu = "0";
        }
        if (nsuInicial != null && nsuInicial < 0L) {
            ultNsu = "0";
        }
        int count = 0;
        do {
            ParamsDistribDocXMLNFe pDist;
            ParamsCertificado params;
            NFDistribuicaoIntRetorno ret;
            if (!EnumConstDistribuicaoNFeStatus.isStatusFinal((String)(ret = this.distribuicaoNFe.consultarDistribuicaoXML(params = this.helperConfigCertificado.build(configCert).getParamsCertificado(tipoAmbiente), pDist = this.getParamsEnv(ultNsu, empresa, tipoAmbiente.getCodigo(), null))).getCodigoStatusReposta())) {
                result.addDetByCode(EnumConstantsTaskResult.RESULT_ERRO, "E.TSK.0022.009", empresa, ultNsu, ret.getUltimoNSU(), ret.getCodigoStatusReposta(), ret.getMotivo());
                break;
            }
            if (!EnumConstDistribuicaoNFeStatus.isDocFound((String)ret.getCodigoStatusReposta())) {
                result.addDetByCode(EnumConstantsTaskResult.RESULT_OK, "M.TSK.0022.006", empresa, ultNsu, ret.getUltimoNSU(), ret.getCodigoStatusReposta(), ret.getMotivo());
                break;
            }
            if (EnumConstDistribuicaoNFeStatus.isServicoParado((String)ret.getCodigoStatusReposta())) {
                result.addDetByCode(EnumConstantsTaskResult.RESULT_ADVERTENCIA, "M.TSK.0022.007", empresa, ultNsu, ret.getUltimoNSU(), ret.getCodigoStatusReposta(), ret.getMotivo());
                break;
            }
            maxNsu = ret.getMaximoNSU();
            ultNsu = ret.getUltimoNSU();
            this.efetuaProcessamentoESalva(ret, empresa, result, configServicos);
            ++count;
        } while (!ToolMethods.isEquals((Object)maxNsu, (Object)ultNsu));
        result.addDetByCode(EnumConstantsTaskResult.RESULT_OK, "M.TSK.0022.008", count);
    }

    private void efetuaProcessamentoESalva(NFDistribuicaoIntRetorno ret, Empresa empresa, TaskProcessResult result, ConfigServicos configServicos) throws ExceptionDecodeHexString64, Exception {
        ConsultaNFeDestDist consulta = this.getConsulta(ret, empresa);
        for (NFDistribuicaoDocumentoZip doc : ret.getLote().getDocZip()) {
            this.getAuxProcessamentoNFe(configServicos).readAndSave(doc, result, empresa, consulta);
        }
        this.salvarConsulta(consulta);
    }

    private void salvarConsulta(ConsultaNFeDestDist consulta) {
        consulta.setConsiderarNSUConsulta(Short.valueOf((short)1));
        this.serviceConsultaNFeDestImpl.saveOrUpdateFlush(consulta);
    }

    private ConsultaNFeDestDist getConsulta(NFDistribuicaoIntRetorno ret, Empresa empresa) {
        ConsultaNFeDestDist toSave = new ConsultaNFeDestDist();
        toSave.setConsiderarNSUConsulta(Short.valueOf((short)1));
        toSave.setDataCadastro(new Date());
        toSave.setDataConsulta(new Date());
        toSave.setEmpresa(empresa);
        toSave.setNumeroNSU(ret.getUltimoNSU());
        toSave.setUltNSUConsulta(ret.getMaximoNSU());
        toSave.setConsiderarNSUConsulta(Short.valueOf((short)0));
        toSave = this.serviceConsultaNFeDestImpl.saveOrUpdateFlush(toSave);
        return toSave;
    }

    private ParamsDistribDocXMLNFe getParamsEnv(String ultNSU, Empresa empresa, String tipoAmbiente, String nsuEspecifico) {
        ParamsDistribDocXMLNFe p = new ParamsDistribDocXMLNFe();
        if (ToolMethods.isEquals((Object)tipoAmbiente, (Object)String.valueOf(1))) {
            p.setAmbiente(ConstAmbiente.PRODUCAO);
        } else {
            p.setAmbiente(ConstAmbiente.HOMOLOGACAO);
        }
        String cpfCnpj = ToolString.onlyNumbers((String)empresa.getPessoa().getComplemento().getCnpj());
        if (cpfCnpj.length() > 11) {
            p.setCnpj(cpfCnpj);
        } else {
            p.setCpf(cpfCnpj);
        }
        p.setNsuEpecifico(null);
        p.setUltimoNSU(null);
        p.setCodIbgeUF(empresa.getPessoa().getEndereco().getCidade().getUf().getCodIbge());
        if (ToolMethods.isStrWithData((String)ultNSU)) {
            p.setUltimoNSU(ultNSU);
        } else if (ToolMethods.isStrWithData((String)ToolString.onlyNumbers((String)nsuEspecifico))) {
            p.setNsuEpecifico(nsuEspecifico);
        } else {
            p.setUltimoNSU("0");
        }
        return p;
    }

    private ConfiguracaoCertificado getConfiguracaoCertificado(Long idCert) throws ExceptionObjNotFound {
        ConfiguracaoCertificado configCert = (ConfiguracaoCertificado)this.serviceConfiguracaoCertificadoImpl.get(idCert);
        if (configCert == null) {
            throw new ExceptionObjNotFound(new ExcepCodeDetail("E.TSK.0022.002"));
        }
        return configCert;
    }

    private ConstAmbiente getTipoAmbiente(ConfigServicos config, TaskProcessResult result) {
        String tipoAmbiente = this.helperConfigServicos.build(config).getValue(ConstantsDistribuicaoXMLCTes.HOMOLOGACAO_PRODUCAO.getChave());
        if (!ToolMethods.isStrWithData((String)(tipoAmbiente = ToolString.onlyNumbers((String)tipoAmbiente)))) {
            return ConstAmbiente.PRODUCAO;
        }
        ConstAmbiente tp = ConstAmbiente.valueOfCodigo((String)tipoAmbiente);
        if (tp == null) {
            return ConstAmbiente.PRODUCAO;
        }
        return tp;
    }

    private ConfigServicos atualizarNSUProximaExec(ConfigServicos config, String nsu) {
        this.helperConfigServicos.build(config).setValue(ConstantsDistribuicaoXMLCTes.NSU_INICIAL.getChave(), nsu);
        return this.serviceConfigServicosImpl.saveOrUpdate(config);
    }

    private AuxProcessaEventoDistNFe getAuxProcessamentoNFe(ConfigServicos configServicos) {
        return new AuxProcessaEventoDistNFe(this.serviceXmlNFeCte, this.serviceXmlNFeCteEvt, this.serviceConsultaNFeDestDocImpl, this.serviceConsultaNFeDestEvtImpl, this.serviceUnidadeFatFornecedorImpl, this.serviceUF, this.compStatusConsDoc, this.serviceConsultaNFeDestNSUImpl, this.serviceNotaFiscalTerceirosImpl, configServicos, this.helperConfigServicos);
    }

    private String montarRespostas(String ultNsu, Empresa empresa, NFDistribuicaoIntRetorno ret) {
        String resp = ret.getCodigoStatusReposta() + " - " + ret.getMotivo() + ": " + String.valueOf(empresa);
        resp = resp + ". NSU Consultado: " + ultNsu;
        resp = resp + ", NSU Retornado: " + ret.getUltimoNSU();
        resp = resp + ", NSU Maximo: " + ret.getMaximoNSU();
        return resp;
    }
}

