/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.nfe.enviolotefaturamento.v400;

import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ObservacaoIntFiscalNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ObservacaoNotaPropria;
import com.touchcomp.basementorclientwebservices.nfe.model.env.nfe.NFeNotaFiscalPropria;
import com.touchcomp.basementorservice.components.nfe.BaseNFeMethods;
import com.touchcomp.basementorservice.components.nfe.enviolotefaturamento.interfaces.InterfaceConvertInfAdNota;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import java.util.LinkedList;
import java.util.List;

public class AuxConvertInfAdicionalNota
extends BaseNFeMethods
implements InterfaceConvertInfAdNota {
    final String LABEL_VR_FCP = "Vr FCP: ";
    final String LABEL_VR_FCP_ST = "Vr FCP ST: ";
    final String LABEL_VR_FCP_ST_RETIDO = "Vr FCP ST Retido: ";
    final String LABEL_SEPARADOR = ";";

    @Override
    public NFeNotaFiscalPropria.NFeNotaInfoInformacoesAdicionais getInfAdic(NotaFiscalPropria nf) {
        NFeNotaFiscalPropria.NFeNotaInfoInformacoesAdicionais inf = new NFeNotaFiscalPropria.NFeNotaInfoInformacoesAdicionais();
        inf.setObservacoesFisco(this.getObsFisco(nf));
        inf.setObservacoesContribuinte(this.getObsContribuinte(nf));
        if (!inf.getObservacoesFisco().isEmpty()) {
            return inf;
        }
        if (!inf.getObservacoesFisco().isEmpty()) {
            return inf;
        }
        return null;
    }

    List<NFeNotaFiscalPropria.NFeNotaInfoInformacoesAdicionais.NFeNotaInfoObservacao> getObsContribuinte(NotaFiscalPropria nf) {
        LinkedList<NFeNotaFiscalPropria.NFeNotaInfoInformacoesAdicionais.NFeNotaInfoObservacao> obsCont = new LinkedList<NFeNotaFiscalPropria.NFeNotaInfoInformacoesAdicionais.NFeNotaInfoObservacao>();
        for (ObservacaoNotaPropria obs : nf.getObservacaoNota()) {
            NFeNotaFiscalPropria.NFeNotaInfoInformacoesAdicionais.NFeNotaInfoObservacao nfeInfoObs = new NFeNotaFiscalPropria.NFeNotaInfoInformacoesAdicionais.NFeNotaInfoObservacao();
            nfeInfoObs.setConteudoCampo(this.refinaXML(obs.getConteudo()));
            nfeInfoObs.setIdentificacaoCampo(this.refinaXML(obs.getIdentificador().toString()));
            obsCont.add(nfeInfoObs);
        }
        return obsCont;
    }

    List<NFeNotaFiscalPropria.NFeNotaInfoInformacoesAdicionais.NFeNotaInfoObservacao> getObsFisco(NotaFiscalPropria nf) {
        LinkedList<NFeNotaFiscalPropria.NFeNotaInfoInformacoesAdicionais.NFeNotaInfoObservacao> obsFisco = new LinkedList<NFeNotaFiscalPropria.NFeNotaInfoInformacoesAdicionais.NFeNotaInfoObservacao>();
        for (ObservacaoIntFiscalNotaFiscalPropria obs : nf.getObservacaoIntFiscalNotaFiscalPropria()) {
            NFeNotaFiscalPropria.NFeNotaInfoInformacoesAdicionais.NFeNotaInfoObservacao nfeInfoObs = new NFeNotaFiscalPropria.NFeNotaInfoInformacoesAdicionais.NFeNotaInfoObservacao();
            nfeInfoObs.setConteudoCampo(this.refinaXML(obs.getConteudo()));
            nfeInfoObs.setIdentificacaoCampo(this.refinaXML(obs.getIdentificador().toString()));
            obsFisco.add(nfeInfoObs);
        }
        obsFisco.add(this.getValoresFCP(nf));
        return obsFisco;
    }

    NFeNotaFiscalPropria.NFeNotaInfoInformacoesAdicionais.NFeNotaInfoObservacao getValoresFCP(NotaFiscalPropria nf) {
        Double valorFCP = 0.0;
        Double valorFCPSt = 0.0;
        Double valorFCPStRetido = 0.0;
        for (ItemNotaFiscalPropria i : nf.getItensNotaPropria()) {
            valorFCP = valorFCP + i.getItemNotaLivroFiscal().getValorFCP();
            valorFCPSt = valorFCPSt + i.getItemNotaLivroFiscal().getValorFCPSt();
            valorFCPStRetido = valorFCPStRetido + i.getItemNotaLivroFiscal().getValorFCPStRetido();
        }
        StringBuilder sb = new StringBuilder();
        if (valorFCP > 0.0) {
            sb.append("Vr FCP: ");
            sb.append(ToolFormatter.arrredondarNumero((Double)valorFCP, (int)2));
            sb.append(";");
        }
        if (valorFCPSt > 0.0) {
            sb.append("Vr FCP ST: ");
            sb.append(ToolFormatter.arrredondarNumero((Double)valorFCPSt, (int)2));
            sb.append(";");
        }
        if (valorFCPStRetido > 0.0) {
            sb.append("Vr FCP ST Retido: ");
            sb.append(ToolFormatter.arrredondarNumero((Double)valorFCPStRetido, (int)2));
            sb.append(";");
        }
        String str = sb.toString();
        NFeNotaFiscalPropria.NFeNotaInfoInformacoesAdicionais.NFeNotaInfoObservacao inf = new NFeNotaFiscalPropria.NFeNotaInfoInformacoesAdicionais.NFeNotaInfoObservacao();
        inf.setConteudoCampo(str);
        return inf;
    }
}

