/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.nfe.enviolotefaturamento.v400;

import com.touchcomp.basementor.model.vo.InfPagamentoNfPropria;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorclientwebservices.nfe.model.env.nfe.NFeNotaFiscalPropria;
import com.touchcomp.basementorservice.components.nfe.BaseNFeMethods;
import com.touchcomp.basementorservice.components.nfe.enviolotefaturamento.interfaces.InterfaceConvertCobranca;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.ArrayList;
import java.util.List;

public class AuxConverteCobranca
extends BaseNFeMethods
implements InterfaceConvertCobranca {
    @Override
    public NFeNotaFiscalPropria.NFNotaInfoCobranca getInfoCobranca(NotaFiscalPropria nf) {
        if (!this.existeTitulosNF(nf).booleanValue()) {
            return null;
        }
        NFeNotaFiscalPropria.NFNotaInfoCobranca c = new NFeNotaFiscalPropria.NFNotaInfoCobranca();
        List<Titulo> titulosOrdenados = new ArrayList<Titulo>();
        for (InfPagamentoNfPropria i : nf.getInfPagamentoNfPropria()) {
            if (!i.getTipoPagamentoNFe().getExibirTitulos().equals((short)1)) continue;
            titulosOrdenados.addAll(i.getTitulos());
        }
        Double valor = this.getParcelas(titulosOrdenados = this.getOrdenarTitulosPorDataVencimento(titulosOrdenados), c);
        if (valor > 0.0) {
            c.setInfoFatura(this.getInfoFatura(nf, valor));
        }
        return c;
    }

    protected NFeNotaFiscalPropria.NFNotaInfoFatura getInfoFatura(NotaFiscalPropria nf, Double valorParcelas) {
        NFeNotaFiscalPropria.NFNotaInfoFatura f = new NFeNotaFiscalPropria.NFNotaInfoFatura();
        f.setNumeroFatura(this.refina(nf.getNumeroNota()));
        f.setValorLiquidoFatura(this.formatarNumeros(valorParcelas, 2));
        f.setValorOriginalFatura(this.formatarNumeros(valorParcelas, 2));
        f.setValorDesconto(this.formatarNumeros(0.0, 2));
        return f;
    }

    protected Double getParcelas(List<Titulo> titulosOrdenados, NFeNotaFiscalPropria.NFNotaInfoCobranca c) {
        Integer cont = 1;
        Double valor = 0.0;
        for (Titulo t : titulosOrdenados) {
            NFeNotaFiscalPropria.NFNotaInfoParcela f = new NFeNotaFiscalPropria.NFNotaInfoParcela();
            f.setDataVencimento(this.formatarLocalData(t.getDataVencimento()));
            f.setValorParcela(this.formatarNumeros(t.getValor(), 2));
            f.setNumeroParcela(ToolString.completaZeros((String)cont.toString(), (int)3, (boolean)true));
            c.getParcelas().add(f);
            valor = valor + t.getValor();
            Integer n = cont;
            cont = cont + 1;
        }
        return valor;
    }

    protected Boolean existeTitulosNF(NotaFiscalPropria vo) {
        for (InfPagamentoNfPropria i : vo.getInfPagamentoNfPropria()) {
            if (i.getTitulos() == null || i.getTitulos().isEmpty()) continue;
            return true;
        }
        return false;
    }

    protected List<Titulo> getOrdenarTitulosPorDataVencimento(List<Titulo> titulosOrdenados) {
        if (titulosOrdenados != null) {
            titulosOrdenados.sort((a, b) -> a.getDataVencimento().compareTo(b.getDataVencimento()));
            return titulosOrdenados;
        }
        return new ArrayList<Titulo>();
    }
}

