/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.nfe.enviolotefaturamento.v400;

import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstContrEstadoIcms;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeIndicadorIEDest;
import com.touchcomp.basementor.constants.enums.uf.EnumConstUF;
import com.touchcomp.basementor.model.vo.Complemento;
import com.touchcomp.basementor.model.vo.EmailPessoa;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementorclientwebservices.nfe.model.env.nfe.NFeNotaFiscalPropria;
import com.touchcomp.basementorservice.components.nfe.BaseNFeMethods;
import com.touchcomp.basementorservice.components.nfe.enviolotefaturamento.interfaces.InterfaceConvertDestinatario;
import com.touchcomp.basementorservice.components.nfe.enviolotefaturamento.v400.AuxConvertEndereco;
import com.touchcomp.basementorservice.helpers.impl.unidadefatcliente.HelperUnidadeFatCliente;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;

public class AuxConverteDestinatario
extends BaseNFeMethods
implements InterfaceConvertDestinatario {
    private static final Date dataInicioAltCampoIE = ToolDate.strToDate((String)"01/01/2016");
    private AuxConvertEndereco auxEndereco = new AuxConvertEndereco();

    @Override
    public NFeNotaFiscalPropria.NFeDestinatario getDestinatario(NotaFiscalPropria nf) {
        NFeNotaFiscalPropria.NFeDestinatario e = new NFeNotaFiscalPropria.NFeDestinatario();
        HelperUnidadeFatCliente helper = ((HelperUnidadeFatCliente)ConfApplicationContext.getBean(HelperUnidadeFatCliente.class)).build(nf.getUnidadeFatCliente());
        Endereco end = helper.get().getPessoa().getEndereco();
        this.getIdentificacaoPessoa(helper.get().getPessoa(), e);
        this.getIndicadorIEDestinatario(nf, e, end, helper.get().getPessoa().getComplemento().getInscEst());
        e.setInscricaoSuframa(this.refinaNull(helper.get().getCliente().getPessoa().getComplemento().getSuframa()));
        this.setDadosDestinatario(e, helper, end);
        e.setEmail(this.refinaXMLNull(this.getEmail(helper.get().getCliente().getPessoa().getComplemento())));
        return e;
    }

    void setDadosDestinatario(NFeNotaFiscalPropria.NFeDestinatario e, HelperUnidadeFatCliente helper, Endereco end) {
        e.setRazaoSocial(this.refinaXML(helper.get().getCliente().getPessoa().getNome()));
        e.setEndereco(this.auxEndereco.getTEndereco(end, this.getFone(helper.get().getCliente().getPessoa().getComplemento())));
        if (!this.isEmptyString(helper.get().getCliente().getPessoa().getComplemento().getInscricaoMunicipal()).booleanValue()) {
            e.setInscricaoMunicipal(this.refina(helper.get().getCliente().getPessoa().getComplemento().getInscricaoMunicipal()));
        }
    }

    void getIndicadorIEDestinatario(NotaFiscalPropria nf, NFeNotaFiscalPropria.NFeDestinatario e, Endereco end, String inscEst) {
        if (nf.getDataEmissaoNota().before(dataInicioAltCampoIE)) {
            this.getIndicadorIEAntesAlteracaoCampo(e, end, inscEst);
        } else {
            this.getIndicadorIEDepoisAlteracaoCampo(nf, e);
        }
        if ((this.isEquals(e.getIndicadorIEDestinatario(), ConstNFeIndicadorIEDest.CONTRIBUINTE_ICMS).booleanValue() || this.isEquals(e.getIndicadorIEDestinatario(), ConstNFeIndicadorIEDest.NAO_CONTRIBUINTE).booleanValue()) && !this.isEmptyString(inscEst).booleanValue()) {
            e.setIndicadorIEDestinatario(ConstNFeIndicadorIEDest.valueOfCodigo((String)inscEst));
        }
    }

    void getIndicadorIEDepoisAlteracaoCampo(NotaFiscalPropria nf, NFeNotaFiscalPropria.NFeDestinatario e) {
        if (this.isEquals(nf.getContribuinteEstado(), EnumConstContrEstadoIcms.CONTRIBUINTE.getEnumId()).booleanValue()) {
            e.setIndicadorIEDestinatario(ConstNFeIndicadorIEDest.CONTRIBUINTE_ICMS);
        } else if (this.isEquals(nf.getContribuinteEstado(), EnumConstContrEstadoIcms.ISENTO.getEnumId()).booleanValue()) {
            e.setIndicadorIEDestinatario(ConstNFeIndicadorIEDest.CONTRIBUINTE_ISENTO_INSCRICAO_CONTRIBUINTES_ICMS);
        } else {
            e.setIndicadorIEDestinatario(ConstNFeIndicadorIEDest.NAO_CONTRIBUINTE);
        }
    }

    void getIndicadorIEAntesAlteracaoCampo(NFeNotaFiscalPropria.NFeDestinatario e, Endereco end, String inscEst) {
        if (this.isEmptyString(inscEst).booleanValue() || this.isEquals(end.getCidade().getUf().getSigla(), EnumConstUF.EX.getValue()).booleanValue()) {
            e.setIndicadorIEDestinatario(ConstNFeIndicadorIEDest.NAO_CONTRIBUINTE);
        } else if (this.isEquals(inscEst, "ISENTO").booleanValue()) {
            e.setIndicadorIEDestinatario(ConstNFeIndicadorIEDest.CONTRIBUINTE_ISENTO_INSCRICAO_CONTRIBUINTES_ICMS);
        } else {
            e.setIndicadorIEDestinatario(ConstNFeIndicadorIEDest.CONTRIBUINTE_ICMS);
        }
    }

    String getEmail(Complemento complemento) {
        String email = null;
        for (EmailPessoa e : complemento.getEmails()) {
            if (!ToolMethods.isStrWithData((String)e.getEmail())) continue;
            email = e.getEmail();
            break;
        }
        return email;
    }

    void getIdentificacaoPessoa(Pessoa pessoa, NFeNotaFiscalPropria.NFeDestinatario e) {
        Endereco end = pessoa.getEndereco();
        String cpfCnpj = this.refina(pessoa.getComplemento().getCnpj());
        if (!this.isEquals(end.getCidade().getUf().getSigla(), EnumConstUF.EX.getValue()).booleanValue()) {
            e.setCnpjCpf(cpfCnpj);
        }
        if (this.isEquals(end.getCidade().getUf().getSigla(), EnumConstUF.EX.getValue()).booleanValue() || !this.isEmptyString(cpfCnpj).booleanValue()) {
            if (!this.isEmptyString(pessoa.getComplemento().getPassaporte()).booleanValue()) {
                e.setIdEstrangeiro(this.refina(pessoa.getComplemento().getPassaporte()));
            } else {
                e.setIdEstrangeiro("");
            }
        }
    }
}

