/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.nfe.enviolotefaturamento.v400;

import com.touchcomp.basementor.model.vo.DadosFiscaisUF;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementorclientwebservices.nfe.model.env.nfe.NFeNotaFiscalPropria;
import com.touchcomp.basementorservice.components.nfe.BaseNFeMethods;
import com.touchcomp.basementorservice.components.nfe.enviolotefaturamento.interfaces.InterfaceConvertEmitente;
import com.touchcomp.basementorservice.components.nfe.enviolotefaturamento.v400.AuxConvertEndereco;
import com.touchcomp.basementorservice.service.interfaces.ServiceDadosFiscaisUF;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;

public class AuxConverteEmitente
extends BaseNFeMethods
implements InterfaceConvertEmitente {
    private AuxConvertEndereco auxEndereco = new AuxConvertEndereco();

    @Override
    public NFeNotaFiscalPropria.NFeEmitente getEmitente(NotaFiscalPropria nf) {
        NFeNotaFiscalPropria.NFeEmitente e = new NFeNotaFiscalPropria.NFeEmitente();
        Empresa emp = nf.getEmpresa();
        Endereco end = emp.getPessoa().getEndereco();
        this.getDadosEmpresaEmitente(e, emp);
        this.getInscMunClassNacAtEco(e);
        this.getEndereco(e, end, emp);
        DadosFiscaisUF d = this.findDadosFiscaisUF(emp, nf.getUnidadeFatCliente().getPessoa().getEndereco().getCidade().getUf());
        this.setDadosFiscais(e, nf, emp, d);
        return e;
    }

    void getDadosEmpresaEmitente(NFeNotaFiscalPropria.NFeEmitente e, Empresa emp) {
        e.setCnpjCpf(this.refina(emp.getPessoa().getComplemento().getCnpj()));
        e.setRazaoSocial(emp.getPessoa().getNome());
        String aux = this.refinaXML(emp.getPessoa().getNomeFantasia());
        e.setNomeFantasia(this.isEmptyString(aux) == false ? aux : null);
        e.setInscricaoEstadual(this.refina(emp.getPessoa().getComplemento().getInscEst()));
        e.setCodRegimeTributario(emp.getEmpresaDados().getRegimeTributario().getCodigo().toString());
        e.setInscricaoMunicipal(this.refinaNull(emp.getPessoa().getComplemento().getInscricaoMunicipal()));
        if (emp.getEmpresaDados().getCnae() != null) {
            e.setClassificacaoNacionalAtividadesEconomicas(this.refinaNull(emp.getEmpresaDados().getCnae().getCodigo()));
        }
    }

    void setDadosFiscais(NFeNotaFiscalPropria.NFeEmitente e, NotaFiscalPropria nf, Empresa emp, DadosFiscaisUF d) {
        if (this.isEquals(d.getInscritoEstado(), (short)1).booleanValue()) {
            e.setInscricaoEstadual(this.refinaNull(d.getInscricaoEstadual()));
        }
    }

    void getEndereco(NFeNotaFiscalPropria.NFeEmitente e, Endereco end, Empresa emp) {
        NFeNotaFiscalPropria.NFeEndereco te = this.auxEndereco.getTEndereco(end, emp.getPessoa().getComplemento().getFone1());
        e.setEndereco(te);
    }

    void getInscMunClassNacAtEco(NFeNotaFiscalPropria.NFeEmitente e) {
        if (!this.isEmptyString(e.getInscricaoMunicipal()).booleanValue() && this.isEmptyString(e.getClassificacaoNacionalAtividadesEconomicas()).booleanValue()) {
            e.setInscricaoMunicipal(null);
            e.setClassificacaoNacionalAtividadesEconomicas(null);
        }
        if (!this.isEmptyString(e.getClassificacaoNacionalAtividadesEconomicas()).booleanValue() && this.isEmptyString(e.getInscricaoMunicipal()).booleanValue()) {
            e.setInscricaoMunicipal(null);
            e.setClassificacaoNacionalAtividadesEconomicas(null);
        }
    }

    private DadosFiscaisUF findDadosFiscaisUF(Empresa empresa, UnidadeFederativa unidadeFederativa) {
        try {
            ServiceDadosFiscaisUF service = (ServiceDadosFiscaisUF)ConfApplicationContext.getBean(ServiceDadosFiscaisUF.class);
            DadosFiscaisUF d = service.get(unidadeFederativa, empresa);
            return d;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
            return null;
        }
    }
}

