/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.nfe.enviolotefaturamento.v400;

import com.touchcomp.basementor.constants.enums.configuracaocertificado.ConstAmbiente;
import com.touchcomp.basementor.constants.enums.modelodocfiscal.EnumConstModDocFiscal;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeIndIntermediador;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeFinalidade;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeIdentificacaoLocalDestOperacao;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeIndicadorPresenca;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeIntermediadorComerical;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeOperacaoConsumidorFinal;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeTipoEmissao;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeTipoEntSai;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeTipoImpressao;
import com.touchcomp.basementor.constants.enums.uf.EnumConstUF;
import com.touchcomp.basementor.model.vo.DocumentosRefMod1APR;
import com.touchcomp.basementor.model.vo.DocumentosRefNFCePR;
import com.touchcomp.basementor.model.vo.DocumentosRefNFProdutorPR;
import com.touchcomp.basementor.model.vo.DocumentosRefNFPropriaPR;
import com.touchcomp.basementor.model.vo.DocumentosRefNFTerceirosPR;
import com.touchcomp.basementor.model.vo.GrupoDocumentosRefPR;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementorclientwebservices.nfe.model.env.nfe.NFeNotaFiscalPropria;
import com.touchcomp.basementorservice.components.nfe.BaseNFeMethods;
import com.touchcomp.basementorservice.components.nfe.enviolotefaturamento.interfaces.InterfaceConvertIdentificacaoNFe;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AuxConverteIdentificacaoNFe
extends BaseNFeMethods
implements InterfaceConvertIdentificacaoNFe {
    protected static String VERSAO_MENTOR = "MENTOR_ERP_NFE_400";

    @Override
    public NFeNotaFiscalPropria.NFeIdentificacao getIdentificacao(NotaFiscalPropria nf, ConstAmbiente tpAmb) {
        NFeNotaFiscalPropria.NFeIdentificacao i = this.getDadosIdentificacao(nf, tpAmb);
        i.getReferenciadas().addAll(this.getNFRef(nf));
        return i;
    }

    NFeNotaFiscalPropria.NFeIdentificacao getDadosIdentificacao(NotaFiscalPropria nf, ConstAmbiente tpAmb) {
        NFeNotaFiscalPropria.NFeIdentificacao i = new NFeNotaFiscalPropria.NFeIdentificacao();
        i.setCodigoUf(nf.getEmpresa().getPessoa().getEndereco().getCidade().getUf().getCodIbge());
        i.setCodigoRandomico(ToolString.completaZeros((String)this.formatarNumeros(nf.getCodChaveAcesso()), (int)8, (boolean)true));
        i.setNaturezaOperacao(this.refinaXML(nf.getNaturezaOperacao().getDescricao()));
        i.setModelo(EnumConstModDocFiscal.get((Object)nf.getModeloDocFiscal().getCodigo()));
        i.setSerie(nf.getSerie());
        i.setNumeroNota(Long.valueOf(this.formatarNumeros(nf.getNumeroNota())));
        i.setDataHoraEmissao(this.dateToZonedDateTime(nf.getDataEmissaoNota(), nf.getEmpresa().getEmpresaDados().getFusoHorario()));
        i.setDataHoraSaidaOuEntrada(this.dateToZonedDateTime(nf.getDataEntradaSaida(), nf.getEmpresa().getEmpresaDados().getFusoHorario()));
        Short tipoOp = (short)(nf.getNaturezaOperacao().getEntradaSaida() != 2 ? 1 : 0);
        i.setTipo(ConstNFeTipoEntSai.valueOfCodigo((String)this.formatarNumeros(tipoOp)));
        i.setIdentificadorLocalDestinoOperacao(this.getLocalDestinoOperacao(nf.getUnidadeFatCliente().getPessoa().getEndereco().getCidade().getUf(), nf.getEmpresa().getPessoa().getEndereco().getCidade().getUf()));
        i.setCodigoMunicipio(nf.getEmpresa().getPessoa().getEndereco().getCidade().getUf().getCodIbge() + nf.getEmpresa().getPessoa().getEndereco().getCidade().getCodIbge());
        i.setTipoImpressao(ConstNFeTipoImpressao.valueOfCodigo((String)this.formatarNumeros(nf.getFormatoImpressao())));
        i.setTipoEmissao(ConstNFeTipoEmissao.valueOfCodigo((String)this.formatarNumeros(nf.getPeriodoEmissaoNFe().getTipoEmissaoNfe().getCodigo())));
        i.setDigitoVerificador(nf.getDigitoVerificador());
        i.setTipo(ConstNFeTipoEntSai.valueOfCodigo((String)tpAmb.getCodigo()));
        i.setFinalidade(ConstNFeFinalidade.valueOfCodigo((String)nf.getFinalidadeEmNFe().getCodigo()));
        i.setOperacaoConsumidorFinal(ConstNFeOperacaoConsumidorFinal.valueOfCodigo((String)nf.getIndicadorConsumidorFinal().toString()));
        i.setIndicadorPresencaComprador(ConstNFeIndicadorPresenca.valueOfCodigo((String)nf.getIndicadorPresencaConsumidor().toString()));
        if (EnumConstNFeIndIntermediador.valueOfCodigo((Short)nf.getTipoIntermediadorComercial()) != null && !ToolMethods.isEquals((Object)EnumConstNFeIndIntermediador.valueOfCodigo((Short)nf.getTipoIntermediadorComercial()), (Object)EnumConstNFeIndIntermediador.NAO_SE_APLICA)) {
            i.setTipoIntermediador(ConstNFeIntermediadorComerical.valueOfCodigo((String)nf.getTipoIntermediadorComercial().toString()));
        }
        i.setVersaoEmissor(VERSAO_MENTOR);
        this.getParametrosContingencia(nf, i);
        return i;
    }

    void getParametrosContingencia(NotaFiscalPropria nf, NFeNotaFiscalPropria.NFeIdentificacao i) {
        if (nf.getPeriodoEmissaoNFe().getTipoEmissaoNfe().getCodigo() != 1) {
            if (nf.getEmpresa().getEmpresaDados().getFusoHorario() != null && ToolMethods.isStrWithData((String)nf.getEmpresa().getEmpresaDados().getFusoHorario().getCodigo())) {
                i.setDataHoraContigencia(ZonedDateTime.ofInstant(nf.getPeriodoEmissaoNFe().getDataInicial().toInstant(), ZoneId.of(nf.getEmpresa().getEmpresaDados().getFusoHorario().getCodigo())));
            } else {
                i.setDataHoraContigencia(ZonedDateTime.ofInstant(nf.getPeriodoEmissaoNFe().getDataInicial().toInstant(), ZoneId.systemDefault()));
            }
            i.setJustificativaEntradaContingencia(this.refinaXML(nf.getPeriodoEmissaoNFe().getDescricao()));
        }
    }

    ConstNFeIdentificacaoLocalDestOperacao getLocalDestinoOperacao(UnidadeFederativa ufCliente, UnidadeFederativa ufEmpresa) {
        if (ufCliente.getSigla().equalsIgnoreCase(EnumConstUF.EX.getValue())) {
            return ConstNFeIdentificacaoLocalDestOperacao.OPERACAO_COM_EXTERIOR;
        }
        if (ufCliente.equals((Object)ufEmpresa)) {
            return ConstNFeIdentificacaoLocalDestOperacao.OPERACAO_INTERNA;
        }
        return ConstNFeIdentificacaoLocalDestOperacao.OPERACAO_INTERESTADUAL;
    }

    private Collection<? extends NFeNotaFiscalPropria.NFeIdentificacao.NFeInfoReferenciada> getNFRef(NotaFiscalPropria nf) {
        ArrayList l = new ArrayList();
        this.getNFRefDocumentos(nf, l);
        this.getNFRefCTes(nf, l);
        return l;
    }

    private void getNFRefCTes(NotaFiscalPropria nf, List l) {
    }

    void getNotasPropriasEletronicas(GrupoDocumentosRefPR gr, List notas) {
        for (DocumentosRefNFPropriaPR nfRef : gr.getNotasProprias()) {
            NFeNotaFiscalPropria.NFeIdentificacao.NFeInfoReferenciada n = new NFeNotaFiscalPropria.NFeIdentificacao.NFeInfoReferenciada();
            n.setChaveAcesso(nfRef.getChaveNFe());
            notas.add(n);
        }
    }

    void getNotasModeloAntigo(GrupoDocumentosRefPR gr, List notas) {
        for (DocumentosRefMod1APR nfRef : gr.getNotasMod1A()) {
            NFeNotaFiscalPropria.NFeIdentificacao.NFeInfoReferenciada n = new NFeNotaFiscalPropria.NFeIdentificacao.NFeInfoReferenciada();
            NFeNotaFiscalPropria.NFeIdentificacao.NFeInfoReferenciada.NFeInfoModelo1Por1AReferenciada ref = new NFeNotaFiscalPropria.NFeIdentificacao.NFeInfoReferenciada.NFeInfoModelo1Por1AReferenciada();
            ref.setCodigoUf(nfRef.getEmissor().getEndereco().getCidade().getUf().getCodIbge());
            ref.setAnoMesEmissaoNFe(this.formatarData(nfRef.getDataEmissao(), "yyMM"));
            ref.setCnpj(this.refina(nfRef.getEmissor().getComplemento().getCnpj()));
            ref.setModeloDocumentoFiscal(nfRef.getModeloDocFiscal().getCodigo());
            ref.setSerie(this.stringToInteger(this.refina(nfRef.getSerie())));
            ref.setNumeroDocumentoFiscal(this.formatarNumeros(nfRef.getNumero()));
            n.setModelo1por1Referenciada(ref);
            notas.add(n);
        }
    }

    void getNotasProdutor(GrupoDocumentosRefPR gr, List notas) {
        for (DocumentosRefNFProdutorPR nfRef : gr.getNotasProdutor()) {
            NFeNotaFiscalPropria.NFeIdentificacao.NFeInfoReferenciada n = new NFeNotaFiscalPropria.NFeIdentificacao.NFeInfoReferenciada();
            NFeNotaFiscalPropria.NFeIdentificacao.NFeInfoReferenciada.NFeInfoProdutorRuralReferenciada ref = new NFeNotaFiscalPropria.NFeIdentificacao.NFeInfoReferenciada.NFeInfoProdutorRuralReferenciada();
            ref.setCodigoUfEmitente(nfRef.getEmissor().getEndereco().getCidade().getUf().getCodIbge());
            ref.setAnoMesEmissao(this.formatarData(nfRef.getDataEmissao(), "yyMM"));
            String cpfCNPJ = this.refina(nfRef.getEmissor().getComplemento().getCnpj());
            ref.setCnpjCpfEmitente(cpfCNPJ);
            String inscEst = this.refina(nfRef.getEmissor().getComplemento().getInscEst());
            if (!this.isEmptyString(inscEst).booleanValue()) {
                ref.setIeEmitente(inscEst);
            } else {
                ref.setIeEmitente("ISENTO");
            }
            ref.setModeloDocumentoFiscal(nfRef.getModeloDocFiscal().getCodigo());
            ref.setSerieDocumentoFiscal(this.stringToInteger(nfRef.getSerie()));
            ref.setNumeroDocumentoFiscal(nfRef.getNumero());
            n.setInfoNFProdutorRuralReferenciada(ref);
            notas.add(n);
        }
    }

    void getNotasTerceirosEletronicas(GrupoDocumentosRefPR gr, List notas) {
        for (DocumentosRefNFTerceirosPR nfRef : gr.getNotasTerceiros()) {
            NFeNotaFiscalPropria.NFeIdentificacao.NFeInfoReferenciada n = new NFeNotaFiscalPropria.NFeIdentificacao.NFeInfoReferenciada();
            n.setChaveAcesso(nfRef.getChaveNFe());
            notas.add(n);
        }
    }

    void getNotasNFCePR(NotaFiscalPropria nf, List notas) {
        for (DocumentosRefNFCePR nfRef : nf.getGrupoDocumentosRefPR().getNfces()) {
            NFeNotaFiscalPropria.NFeIdentificacao.NFeInfoReferenciada n = new NFeNotaFiscalPropria.NFeIdentificacao.NFeInfoReferenciada();
            n.setChaveAcesso(nfRef.getChaveNFe());
            notas.add(n);
        }
    }

    private void getNFRefDocumentos(NotaFiscalPropria nf, List l) {
        if (nf.getGrupoDocumentosRefPR() == null) {
            return;
        }
        GrupoDocumentosRefPR gr = nf.getGrupoDocumentosRefPR();
        this.getNotasPropriasEletronicas(gr, l);
        this.getNotasModeloAntigo(gr, l);
        this.getNotasProdutor(gr, l);
        this.getNotasTerceirosEletronicas(gr, l);
        this.getNotasNFCePR(nf, l);
    }
}

