/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.nfe.enviolotefaturamento.v400;

import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeIdentificacaoLocalDestOperacao;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeModalidadeFrete;
import com.touchcomp.basementor.constants.enums.uf.EnumConstUF;
import com.touchcomp.basementor.model.vo.DadosTransNfPropria;
import com.touchcomp.basementor.model.vo.LacreVolumeNFe;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.Transportador;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementor.model.vo.VolumeNFe;
import com.touchcomp.basementorclientwebservices.nfe.model.env.nfe.NFeNotaFiscalPropria;
import com.touchcomp.basementorservice.components.nfe.BaseNFeMethods;
import com.touchcomp.basementorservice.components.nfe.enviolotefaturamento.interfaces.InterfaceConvertInfoTransporte;
import java.util.ArrayList;
import java.util.List;

public class AuxConverteInfoTransporte
extends BaseNFeMethods
implements InterfaceConvertInfoTransporte {
    OpcoesFaturamento opcoesFaturamento;

    public AuxConverteInfoTransporte(OpcoesFaturamento opcoesFaturamento) {
        this.opcoesFaturamento = opcoesFaturamento;
    }

    @Override
    public NFeNotaFiscalPropria.NFeNotaInfoTransporte getInfoTransporte(NotaFiscalPropria nf) {
        ConstNFeIdentificacaoLocalDestOperacao idDest;
        NFeNotaFiscalPropria.NFeNotaInfoTransporte t = new NFeNotaFiscalPropria.NFeNotaInfoTransporte();
        DadosTransNfPropria d = nf.getDadosTransNfPropria();
        t.setModalidadeFrete(this.getModalidadeFrete(d));
        if (!this.isEquals(d.getTipoFrete().getFretePorConta(), (short)9).booleanValue()) {
            t.setTransportador(this.getTransportador(d.getTransportador()));
        }
        if (!this.isEquals(idDest = this.getLocalDestinoOperacao(nf.getUnidadeFatCliente().getPessoa().getEndereco().getCidade().getUf(), nf.getEmpresa().getPessoa().getEndereco().getCidade().getUf()), ConstNFeIdentificacaoLocalDestOperacao.OPERACAO_INTERESTADUAL).booleanValue()) {
            t.setVeiculo(this.getVeiculo(d));
            t.getReboques().addAll(this.getReboques(d));
        }
        t.getVolumes().addAll(this.getVolumes(nf));
        return t;
    }

    ConstNFeModalidadeFrete getModalidadeFrete(DadosTransNfPropria d) {
        Short tpFrete = d.getTipoFrete().getFretePorConta();
        if (tpFrete != null && tpFrete == 0) {
            return ConstNFeModalidadeFrete.CONTRATACAO_POR_CONTA_DO_REMETENTE;
        }
        if (tpFrete != null && tpFrete == 1) {
            return ConstNFeModalidadeFrete.CONTRATACAO_POR_CONTA_DO_DESTINATARIO;
        }
        if (tpFrete != null && tpFrete == 2) {
            return ConstNFeModalidadeFrete.CONTRATACAO_POR_CONTA_DE_TERCEIROS;
        }
        if (tpFrete != null && tpFrete == 3) {
            return ConstNFeModalidadeFrete.PROPRIO_POR_CONTA_DO_REMETENTE;
        }
        if (tpFrete != null && tpFrete == 4) {
            return ConstNFeModalidadeFrete.PROPRIO_POR_CONTA_DO_DESTINATARIO;
        }
        return ConstNFeModalidadeFrete.SEM_OCORRENCIA_TRANSPORTE;
    }

    NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeInfoTransportador getTransportador(Transportador transportador) {
        String SEPARADOR = ",";
        if (transportador == null) {
            return null;
        }
        NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeInfoTransportador tr = new NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeInfoTransportador();
        String cpfCnpj = this.refinaNull(transportador.getPessoa().getComplemento().getCnpj());
        if (!this.isEmptyString(cpfCnpj).booleanValue()) {
            tr.setCnpjCpf(cpfCnpj);
        }
        tr.setRazaoSocial(this.refinaXMLNull(transportador.getPessoa().getNome()));
        tr.setInscricaoEstadual(this.refinaNull(transportador.getPessoa().getComplemento().getInscEst()));
        StringBuilder sb = new StringBuilder();
        sb.append(transportador.getPessoa().getEndereco().getLogradouro());
        if (transportador.getPessoa().getEndereco().getNumero() != null) {
            sb.append(",").append(transportador.getPessoa().getEndereco().getNumero());
        }
        if (transportador.getPessoa().getEndereco().getBairro() != null) {
            sb.append(",").append(transportador.getPessoa().getEndereco().getBairro());
        }
        if (sb.length() > 60) {
            sb = new StringBuilder(sb.substring(0, 60));
        }
        tr.setEnderecoComplemento(this.refinaXMLNull(sb.toString()));
        tr.setNomeMunicipio(this.refinaXML(transportador.getPessoa().getEndereco().getCidade().getDescricao()));
        tr.setUf(transportador.getPessoa().getEndereco().getCidade().getUf().getSigla());
        return tr;
    }

    ConstNFeIdentificacaoLocalDestOperacao getLocalDestinoOperacao(UnidadeFederativa ufCliente, UnidadeFederativa ufEmpresa) {
        if (ufCliente.getSigla().equalsIgnoreCase(EnumConstUF.EX.getValue())) {
            return ConstNFeIdentificacaoLocalDestOperacao.OPERACAO_COM_EXTERIOR;
        }
        if (ufCliente.equals((Object)ufEmpresa)) {
            return ConstNFeIdentificacaoLocalDestOperacao.OPERACAO_INTERNA;
        }
        return ConstNFeIdentificacaoLocalDestOperacao.OPERACAO_INTERESTADUAL;
    }

    NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoVeiculo getVeiculo(DadosTransNfPropria d) {
        String insc = this.refinaXMLNull(d.getInscricaoAntt());
        String placa = this.refinaXMLNull(d.getPlacaVeiculo());
        String uf = this.refinaXMLNull(d.getUfPlacaVeiculo());
        if (insc != null || placa != null) {
            NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoVeiculo v = new NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoVeiculo();
            v.setPlacaVeiculo(placa);
            v.setRegistroNacionalTransportadorCarga(insc);
            v.setUf(uf);
            return v;
        }
        return null;
    }

    List<NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoReboque> getReboques(DadosTransNfPropria d) {
        ArrayList<NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoReboque> reb = new ArrayList<NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoReboque>();
        String insc = this.refinaXMLNull(d.getInscricaoAnttReboque1());
        String placa = this.refinaXMLNull(d.getPlacaReboque1());
        String uf = this.refinaXMLNull(d.getUfPlacaReboque1());
        if (insc != null || placa != null) {
            NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoReboque v = new NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoReboque();
            v.setPlacaVeiculo(placa);
            v.setRegistroNacionalTransportadorCarga(this.refinaXML(insc));
            v.setCodigoUf(uf);
            reb.add(v);
        }
        String insc2 = this.refinaXMLNull(d.getInscricaoAnttReboque2());
        String placa2 = this.refinaXMLNull(d.getPlacaReboque2());
        String uf2 = this.refinaXMLNull(d.getUfPlacaReboque2());
        if (insc2 != null || placa2 != null) {
            NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoReboque v = new NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoReboque();
            v.setPlacaVeiculo(placa2);
            v.setRegistroNacionalTransportadorCarga(insc2);
            v.setCodigoUf(uf2);
            reb.add(v);
        }
        return reb;
    }

    List<NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoVolume> getVolumes(NotaFiscalPropria nf) {
        ArrayList<NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoVolume> vol = new ArrayList<NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoVolume>();
        List volumes = nf.getVolumes();
        if (volumes != null && volumes.size() > 0) {
            for (VolumeNFe vf : volumes) {
                NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoVolume v = new NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoVolume();
                v.setQuantidadeVolumesTransportados(Long.valueOf(vf.getQuantidade().intValue()));
                if (vf.getEmbalagem() != null) {
                    v.setEspecieVolumesTransportados(this.refinaXML(vf.getEmbalagem().getNome()));
                }
                if (this.opcoesFaturamento.getNaoImpMarcaDanfe() != 1) {
                    if (vf.getMarca() != null && vf.getMarca().trim().length() > 0) {
                        v.setMarca(this.refinaXMLNull(vf.getMarca()));
                    } else {
                        v.setMarca(this.refina(nf.getNumeroNota()));
                    }
                }
                v.setNumeracaoVolumesTransportados(this.formatarNumerosNullCaso0(vf.getNumeroVolume()));
                v.setPesoLiquido(this.formatarNumerosNullCaso0(vf.getPesoLiquido(), 3));
                v.setPesoBruto(this.formatarNumerosNullCaso0(vf.getPesoBruto(), 3));
                v.getLacres().addAll(this.getLacresVolumesNFe(vf.getLacres()));
                if (v.getEspecieVolumesTransportados() == null && v.getQuantidadeVolumesTransportados() == null && v.getMarca() == null && v.getNumeracaoVolumesTransportados() == null && v.getPesoBruto() == null && v.getPesoLiquido() == null && (v.getLacres() == null || v.getLacres().isEmpty())) continue;
                vol.add(v);
            }
        }
        return vol;
    }

    List<NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoVolume.NFeNotaInfoLacre> getLacresVolumesNFe(List<LacreVolumeNFe> lacres) {
        ArrayList<NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoVolume.NFeNotaInfoLacre> lista = new ArrayList<NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoVolume.NFeNotaInfoLacre>();
        for (LacreVolumeNFe l : lacres) {
            NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoVolume.NFeNotaInfoLacre lacre = new NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoVolume.NFeNotaInfoLacre();
            lacre.setNumeroLacres(l.getLacre());
            lista.add(lacre);
        }
        return lista;
    }
}

