/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.nfe.enviolotefaturamento.v400.itensnota;

import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeIndicadorEscalaRelevante;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.CodigoBarras;
import com.touchcomp.basementor.model.vo.GradeItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemParamNomeclaturaProdutoXML;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesFaturamentoCliente;
import com.touchcomp.basementor.model.vo.ParamNomeclaturaProdutoXML;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementorclientwebservices.nfe.model.env.nfe.NFeNotaFiscalPropriaItem;
import com.touchcomp.basementorservice.components.nfe.BaseNFeMethods;
import com.touchcomp.basementorservice.components.nfe.enviolotefaturamento.interfaces.itemnota.InterfaceConvertItensNota;
import com.touchcomp.basementorservice.components.nfe.enviolotefaturamento.interfaces.itemnota.impostoitem.InterfaceConvertCofins;
import com.touchcomp.basementorservice.components.nfe.enviolotefaturamento.interfaces.itemnota.impostoitem.InterfaceConvertCofinsST;
import com.touchcomp.basementorservice.components.nfe.enviolotefaturamento.interfaces.itemnota.impostoitem.InterfaceConvertISSQN;
import com.touchcomp.basementorservice.components.nfe.enviolotefaturamento.interfaces.itemnota.impostoitem.InterfaceConvertIcms;
import com.touchcomp.basementorservice.components.nfe.enviolotefaturamento.interfaces.itemnota.impostoitem.InterfaceConvertIcmsUfDestino;
import com.touchcomp.basementorservice.components.nfe.enviolotefaturamento.interfaces.itemnota.impostoitem.InterfaceConvertImpostoImportacao;
import com.touchcomp.basementorservice.components.nfe.enviolotefaturamento.interfaces.itemnota.impostoitem.InterfaceConvertIpi;
import com.touchcomp.basementorservice.components.nfe.enviolotefaturamento.interfaces.itemnota.impostoitem.InterfaceConvertPis;
import com.touchcomp.basementorservice.components.nfe.enviolotefaturamento.interfaces.itemnota.impostoitem.InterfaceConvertPisST;
import com.touchcomp.basementorservice.components.nfe.enviolotefaturamento.v400.itensnota.AuxConverteDeclaracaoImportacaoItem;
import com.touchcomp.basementorservice.components.nfe.enviolotefaturamento.v400.itensnota.AuxConverteImpostoItem;
import com.touchcomp.basementorservice.dao.impl.DaoPedidoImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AuxConverteItensNota
extends BaseNFeMethods
implements InterfaceConvertItensNota {
    OpcoesFaturamento opcoesFaturamento;
    OpcoesFaturamentoCliente opcoesFaturamentoCliente;
    final Short CODIGO_BARRAS_EAN = 0;
    final Short CODIGO_BARRAS_EAN_TRIB = 1;
    final String SEM_GTIN = "SEM GTIN";

    @Override
    public List<NFeNotaFiscalPropriaItem> getItensNota(NotaFiscalPropria nf, InterfaceConvertCofins iCofins, InterfaceConvertCofinsST iCofinsST, InterfaceConvertISSQN iSSQN, InterfaceConvertIcms iIcms, InterfaceConvertImpostoImportacao iII, InterfaceConvertIpi iIpi, InterfaceConvertPis iPis, InterfaceConvertPisST iPisST, InterfaceConvertIcmsUfDestino iIcmsUfDest) throws Exception {
        ArrayList<NFeNotaFiscalPropriaItem> toRet = new ArrayList<NFeNotaFiscalPropriaItem>();
        Cliente c = nf.getUnidadeFatCliente().getCliente();
        List<ItemNotaFiscalPropria> itens = this.ordenarItensPorNrSequencial(nf.getItensNotaPropria());
        for (ItemNotaFiscalPropria i : itens) {
            NFeNotaFiscalPropriaItem d = new NFeNotaFiscalPropriaItem();
            d.setNumeroItem(i.getNumeroItem());
            d.setProduto(this.getProduto(nf, i, nf.getUnidadeFatCliente().getCliente()));
            AuxConverteImpostoItem converteImpostoItem = new AuxConverteImpostoItem();
            d.setImposto(converteImpostoItem.getImposto(nf, i, iCofins, iCofinsST, iSSQN, iIcms, iII, iIpi, iPis, iPisST, iIcmsUfDest));
            d.setInformacoesAdicionais(this.combinaStrings(i.getInfAdicionalItemSistema(), i.getInfAdicionalItem(), this.getInfAdicionalProdutoParametrizacaoNomeXML(c, i.getProduto())));
            d.setImpostoDevolvido(this.getImpostoDevol(i));
            toRet.add(d);
        }
        return toRet;
    }

    NFeNotaFiscalPropriaItem.NFeImpostoDevolvido getImpostoDevol(ItemNotaFiscalPropria i) {
        if (i.getItemNotaLivroFiscal().getValorIpiDevolucao() > 0.0) {
            NFeNotaFiscalPropriaItem.NFeImpostoDevolvido id = new NFeNotaFiscalPropriaItem.NFeImpostoDevolvido();
            id.setPercentualDevolucao(this.formatarNumeros(i.getItemNotaLivroFiscal().getPercIpiDevolucao(), 2));
            id.setInformacaoIPIDevolvido(this.formatarNumeros(i.getItemNotaLivroFiscal().getValorIpiDevolucao(), 2));
            return id;
        }
        return null;
    }

    private String getNrPedidoCliente(NotaFiscalPropria nf) {
        DaoPedidoImpl daoPedido = (DaoPedidoImpl)ConfApplicationContext.getBean(DaoPedidoImpl.class);
        Pedido p = (Pedido)daoPedido.get(nf.getExpedicao().getPedido().getIdentificador());
        if (p == null || this.isEmptyString(p.getNrPedidoCliente()).booleanValue()) {
            return null;
        }
        return p.getNrPedidoCliente();
    }

    private List<ItemNotaFiscalPropria> ordenarItensPorNrSequencial(List<ItemNotaFiscalPropria> itensNotaPropria) {
        if (itensNotaPropria != null) {
            Collections.sort(itensNotaPropria, (o1, o2) -> {
                ItemNotaFiscalPropria item1 = (ItemNotaFiscalPropria)o1;
                ItemNotaFiscalPropria item2 = (ItemNotaFiscalPropria)o2;
                return item1.getNumeroItem().compareTo(item2.getNumeroItem());
            });
            return itensNotaPropria;
        }
        return new ArrayList<ItemNotaFiscalPropria>();
    }

    String getCodigoItemProduto(ItemNotaFiscalPropria i) {
        if (this.isAffirmative(this.opcoesFaturamento.getUsarCodAuxNfe()).booleanValue() && ToolMethods.isStrWithData((String)i.getProduto().getCodigoAuxiliar())) {
            return this.refinaXML(i.getProduto().getCodigoAuxiliar());
        }
        return this.refina(i.getProduto().getIdentificador().toString());
    }

    void getCodigoBarras(ItemNotaFiscalPropria i, Cliente cliente, NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto p) {
        String cEAN = "";
        String cEANTrib = "";
        if (this.opcoesFaturamentoCliente != null) {
            cEAN = this.getCodigoBarrasParametrizacaoNomeXML(cliente, i.getProduto(), this.CODIGO_BARRAS_EAN);
            cEANTrib = this.getCodigoBarrasParametrizacaoNomeXML(cliente, i.getProduto(), this.CODIGO_BARRAS_EAN_TRIB);
        }
        for (CodigoBarras c : i.getProduto().getCodigoBarras()) {
            if (!ToolMethods.isStrWithData((String)cEAN) && c.getUsarComoCodigoPrinc() != null && c.getUsarComoCodigoPrinc() == 1) {
                cEAN = ToolString.clearSpecialCharacXML((String)c.getCodigoBarras());
            }
            if (ToolMethods.isStrWithData((String)cEANTrib) || c.getUsarComoCodPrincTrib() == null || c.getUsarComoCodPrincTrib() != 1) continue;
            cEANTrib = ToolString.clearSpecialCharacXML((String)c.getCodigoBarras());
        }
        if (!cEAN.isEmpty() && !cEANTrib.isEmpty()) {
            p.setCodigoDeBarras(cEAN);
            p.setCodigoDeBarrasTributavel(cEANTrib);
        }
        if (!ToolMethods.isStrWithData((String)p.getCodigoDeBarras()) && !ToolMethods.isStrWithData((String)p.getCodigoDeBarrasTributavel())) {
            p.setCodigoDeBarras("SEM GTIN");
            p.setCodigoDeBarrasTributavel("SEM GTIN");
        }
    }

    String getNomeProduto(ItemNotaFiscalPropria i) {
        Object nome = i.getProduto().getNome().trim();
        if (this.opcoesFaturamento.getConcCodBarrasItensNfDanfe() != null && this.opcoesFaturamento.getConcCodBarrasItensNfDanfe() == 1 && i.getProduto().getCodigoBarras() != null && !i.getProduto().getCodigoBarras().isEmpty()) {
            nome = (String)nome + " - " + String.valueOf(i.getProduto().getCodigoBarras().get(0));
        }
        if (((String)nome).length() > 120) {
            nome = ((String)nome).substring(0, 120);
        }
        return nome;
    }

    String getDescricao(ItemNotaFiscalPropria i, Cliente cliente, String nome) {
        if (this.opcoesFaturamentoCliente != null) {
            return this.refinaXML(this.getNomeProdutoParametrizacaoNomeXML(cliente, i.getProduto(), nome));
        }
        return this.refinaXML(nome);
    }

    String getNcm(ItemNotaFiscalPropria i) {
        if (i.getProduto().getNcm() != null) {
            return this.refina(i.getProduto().getNcm().getCodigo());
        }
        if (i.getProduto().getGenero() != null) {
            return this.refina(i.getProduto().getGenero().getCodigo());
        }
        return null;
    }

    ConstNFeIndicadorEscalaRelevante getCodigoIndicadorTotal(Short indicador) {
        if (indicador == 0) {
            return ConstNFeIndicadorEscalaRelevante.PRODUZIDO_EM_ESCALA_NAO_RELEVANTE;
        }
        if (indicador == 1) {
            return ConstNFeIndicadorEscalaRelevante.PRODUZIDO_EM_ESCALA_RELEVANTE;
        }
        return null;
    }

    NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto getProduto(NotaFiscalPropria nf, ItemNotaFiscalPropria i, Cliente cliente) {
        NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto p = new NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto();
        p.setCodigo(this.getCodigoItemProduto(i));
        this.getCodigoBarras(i, cliente, p);
        String nome = this.getNomeProduto(i);
        p.setDescricao(this.getDescricao(i, cliente, nome));
        p.setNcm(this.getNcm(i));
        if (i.getProduto().getRegraExcecaoNCM() != null && i.getProduto().getTipoProduto() != 1) {
            p.setExtipi(this.refina(i.getProduto().getRegraExcecaoNCM().getCodigo()));
        }
        p.setCfop(this.refina(i.getItemNotaLivroFiscal().getCfop().getCodigo()));
        if (i.getUnidadeMedidaCom() != null && i.getQuantidadeTotalCom() != null && i.getQuantidadeTotalCom() > 0.0 && i.getValorUnitarioCom() != null && i.getValorUnitarioCom() > 0.0) {
            p.setUnidadeComercial(i.getUnidadeMedidaCom().getSigla());
            p.setQuantidadeComercial(this.formatarNumeros(i.getQuantidadeTotalCom(), 4));
            p.setValorUnitario(this.formatarNumeros(i.getValorUnitarioCom(), 6));
        } else {
            p.setUnidadeComercial(i.getProduto().getUnidadeMedida().getSigla());
            p.setQuantidadeComercial(this.formatarNumeros(i.getQuantidadeTotal(), 4));
            p.setValorUnitario(this.formatarNumeros(i.getValorUnitario(), 6));
        }
        if (i.getUnidadeMedidaTrib() != null && i.getQuantidadeTotalTrib() != null && i.getQuantidadeTotalTrib() > 0.0 && i.getValorUnitarioTrib() != null && i.getValorUnitarioTrib() > 0.0) {
            p.setUnidadeTributavel(i.getUnidadeMedidaTrib().getSigla());
            p.setQuantidadeTributavel(this.formatarNumeros(i.getQuantidadeTotalTrib(), 4));
            p.setValorUnitarioTributavel(this.formatarNumeros(i.getValorUnitarioTrib(), 6));
        } else {
            p.setUnidadeTributavel(i.getProduto().getUnidadeMedida().getSigla());
            p.setQuantidadeTributavel(this.formatarNumeros(i.getQuantidadeTotal(), 4));
            p.setValorUnitarioTributavel(this.formatarNumeros(i.getValorUnitario(), 6));
        }
        p.setValorTotalBruto(this.formatarNumeros(i.getVrProduto() + i.getVrServico(), 2));
        p.setValorFrete(this.formatarNumerosNullCaso0(i.getValorFrete(), 2));
        p.setValorSeguro(this.formatarNumerosNullCaso0(i.getVrSeguro(), 2));
        p.setValorDesconto(this.formatarNumerosNullCaso0(i.getValorDesconto(), 2));
        p.setValorOutrasDespesasAcessorias(this.formatarNumerosNullCaso0(i.getValorDespAcessoria(), 2));
        p.setIndicadorEscalaRelevante(this.getCodigoIndicadorTotal(i.getIndicadorTotal()));
        AuxConverteDeclaracaoImportacaoItem auxCDecImportItem = new AuxConverteDeclaracaoImportacaoItem();
        p.getDeclaracoesImportacao().addAll(auxCDecImportItem.getDI(i));
        if (i.getNrPedido() != null && i.getNrPedido().trim().length() > 0) {
            p.setNumeroPedidoCliente(this.refinaXML(i.getNrPedido()));
        } else {
            p.setNumeroPedidoCliente(this.getNrPedidoCliente(nf));
        }
        if (i.getNrItemPedido() != null) {
            p.setNumeroPedidoCliente(this.refinaXML(i.getNrItemPedido().toString()));
        }
        p.setVeiculo(null);
        p.setCombustivel(this.getComb(i));
        p.setCodigoEspecificadorSituacaoTributaria(this.getCest(i));
        if (i.getProduto().getCodBeneficioFiscal() != null && i.getProduto().getCodBeneficioFiscal().trim().length() > 0) {
            p.setCodigoBeneficioFiscalUF(i.getProduto().getCodBeneficioFiscal());
        }
        p.getRastros().addAll(this.getRastro(i.getGradesNotaFiscalPropria()));
        p.setMedicamento(this.getMed(i.getProduto()));
        if (i.getModeloFiscal().getUtilizaCodigoFCI() != null && i.getModeloFiscal().getUtilizaCodigoFCI().equals((short)1) && i.getProduto().getCodigoFCI() != null && !i.getProduto().getCodigoFCI().isEmpty()) {
            p.setNumeroControleFCI(i.getProduto().getCodigoFCI());
        }
        return p;
    }

    NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoMedicamento getMed(Produto produto) {
        if (produto.getTipoMedicamento() != null) {
            NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoMedicamento p = new NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoMedicamento();
            p.setCodigoProdutoAnvisa(produto.getCodAnvisa());
            p.setPrecoMaximoConsumidor(this.formatarNumeros(produto.getValorMaximoConsumo(), 2));
            return p;
        }
        return null;
    }

    List<NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoRastreabilidade> getRastro(List<GradeItemNotaFiscalPropria> grades) {
        ArrayList<NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoRastreabilidade> lista = new ArrayList<NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoRastreabilidade>();
        for (GradeItemNotaFiscalPropria g : grades) {
            if (g.getLoteFabricacao() == null || !g.getLoteFabricacao().getUnico().equals((short)0) || g.getLoteFabricacao().getDataFabricacao() == null || g.getLoteFabricacao().getDataValidade() == null) continue;
            LoteFabricacao lote = g.getLoteFabricacao();
            NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoRastreabilidade r = new NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoRastreabilidade();
            r.setNumeroLote(lote.getLoteFabricacao());
            if (r.getNumeroLote().trim().length() > 20) {
                r.setNumeroLote(r.getNumeroLote().substring(0, 19));
            }
            r.setDataFabricacao(this.formatarLocalData(lote.getDataFabricacao()));
            r.setDataValidade(this.formatarLocalData(lote.getDataValidade()));
            r.setQuantidadeLote(this.formatarNumeros(g.getQuantidade(), 3));
            if (lote.getCodigoAgregacao() != null && lote.getCodigoAgregacao().trim().length() > 0) {
                r.setCodigoAgregacao(lote.getCodigoAgregacao());
            }
            lista.add(r);
        }
        return lista;
    }

    String getCest(ItemNotaFiscalPropria i) {
        if (i.getProduto().getCest() != null) {
            return this.refina(i.getProduto().getCest().getCodigo());
        }
        return null;
    }

    NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoCombustivel getComb(ItemNotaFiscalPropria i) {
        if (i.getProduto().getClassificacaoProdutoANP() != null && i.getItemNotaLivroFiscal().getUfConsumoComb() != null) {
            NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoCombustivel c = new NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoCombustivel();
            if (i.getProduto().getClassificacaoProdutoANP() != null) {
                c.setCodigoProdutoANP(i.getProduto().getClassificacaoProdutoANP().getCodigo());
                c.setDescricaoProdutoANP(i.getProduto().getClassificacaoProdutoANP().getDescricao());
                c.setPercentualGLPDerivadoPetroleo(this.formatarNumerosNullCaso0(i.getProduto().getPercGLP(), 4));
                c.setPercentualGasNaturalNacional(this.formatarNumerosNullCaso0(i.getProduto().getPercGNN(), 4));
                c.setPercentualGasNaturalImportado(this.formatarNumerosNullCaso0(i.getProduto().getPercGNI(), 4));
                c.setValorPartida(this.formatarNumerosNullCaso0(i.getItemNotaLivroFiscal().getValorPartida(), 2));
            }
            c.setQuantidade(this.formatarNumerosNullCaso0(i.getItemNotaLivroFiscal().getQtdCombTempAmb(), 4));
            c.setUf(i.getItemNotaLivroFiscal().getUfConsumoComb().getSigla());
            NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoCombustivel.NFeNotaInfoItemProdutoCombustivelCIDE ci = new NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoCombustivel.NFeNotaInfoItemProdutoCombustivelCIDE();
            c.setCide(ci);
            ci.setQuantidadeBCCIDE(this.formatarNumeros(i.getItemNotaLivroFiscal().getQuantidadeBCCIDE(), 4));
            ci.setValorAliquota(this.formatarNumeros(i.getItemNotaLivroFiscal().getAliquotaCIDE(), 4));
            ci.setValor(this.formatarNumeros(i.getItemNotaLivroFiscal().getValorCIDE(), 2));
            return c;
        }
        return null;
    }

    String getCodigoBarrasParametrizacaoNomeXML(Cliente cliente, Produto produto, Short tipoCodigoBarras) {
        if (this.opcoesFaturamentoCliente == null) {
            return "";
        }
        if (this.isEquals(this.opcoesFaturamentoCliente.getAplicarTodoCliente(), (short)1).booleanValue()) {
            for (ParamNomeclaturaProdutoXML p : this.opcoesFaturamentoCliente.getProdutos()) {
                for (ItemParamNomeclaturaProdutoXML item : p.getItens()) {
                    if (!this.isEquals(item.getProduto(), produto).booleanValue()) continue;
                    if (this.isEquals(tipoCodigoBarras, this.CODIGO_BARRAS_EAN).booleanValue() && ToolMethods.isStrWithData((String)item.getCodigoBarrasEan())) {
                        return item.getCodigoBarrasEan();
                    }
                    if (!this.isEquals(tipoCodigoBarras, this.CODIGO_BARRAS_EAN_TRIB).booleanValue() || !ToolMethods.isStrWithData((String)item.getCodigoBarrasEanTrib())) continue;
                    return item.getCodigoBarrasEanTrib();
                }
            }
        }
        if (this.isEquals(this.opcoesFaturamentoCliente.getAplicarTodoCliente(), (short)0).booleanValue()) {
            for (ParamNomeclaturaProdutoXML p : this.opcoesFaturamentoCliente.getProdutos()) {
                if (!this.isEquals(p.getCliente(), cliente).booleanValue()) continue;
                for (ItemParamNomeclaturaProdutoXML item : p.getItens()) {
                    if (!this.isEquals(item.getProduto(), produto).booleanValue()) continue;
                    if (this.isEquals(tipoCodigoBarras, this.CODIGO_BARRAS_EAN).booleanValue() && ToolMethods.isStrWithData((String)item.getCodigoBarrasEan())) {
                        return item.getCodigoBarrasEan();
                    }
                    if (!this.isEquals(tipoCodigoBarras, this.CODIGO_BARRAS_EAN_TRIB).booleanValue() || !ToolMethods.isStrWithData((String)item.getCodigoBarrasEanTrib())) continue;
                    return item.getCodigoBarrasEanTrib();
                }
            }
        }
        return "";
    }

    String getInfAdicionalProdutoParametrizacaoNomeXML(Cliente cliente, Produto produto) {
        if (this.opcoesFaturamentoCliente == null) {
            return "";
        }
        if (this.isEquals(this.opcoesFaturamentoCliente.getAplicarTodoCliente(), (short)1).booleanValue()) {
            for (ParamNomeclaturaProdutoXML p : this.opcoesFaturamentoCliente.getProdutos()) {
                for (ItemParamNomeclaturaProdutoXML item : p.getItens()) {
                    if (!this.isEquals(item.getProduto(), produto).booleanValue() || !this.isEquals(item.getConcatInfAddProduto(), (short)1).booleanValue()) continue;
                    return item.getDescricao();
                }
            }
        }
        if (this.isEquals(this.opcoesFaturamentoCliente.getAplicarTodoCliente(), (short)0).booleanValue()) {
            for (ParamNomeclaturaProdutoXML p : this.opcoesFaturamentoCliente.getProdutos()) {
                if (!this.isEquals(p.getCliente(), cliente).booleanValue()) continue;
                for (ItemParamNomeclaturaProdutoXML item : p.getItens()) {
                    if (!this.isEquals(item.getProduto(), produto).booleanValue() || !this.isEquals(item.getConcatInfAddProduto(), (short)1).booleanValue()) continue;
                    return item.getDescricao();
                }
            }
        }
        return "";
    }

    String getNomeProdutoParametrizacaoNomeXML(Cliente cliente, Produto produto, String nome) {
        if (this.opcoesFaturamentoCliente == null) {
            return nome;
        }
        if (this.isEquals(this.opcoesFaturamentoCliente.getAplicarTodoCliente(), (short)1).booleanValue()) {
            for (ParamNomeclaturaProdutoXML p : this.opcoesFaturamentoCliente.getProdutos()) {
                for (ItemParamNomeclaturaProdutoXML item : p.getItens()) {
                    if (!this.isEquals(item.getProduto(), produto).booleanValue() || this.isEquals(item.getConcatInfAddProduto(), (short)1).booleanValue()) continue;
                    return item.getDescricao();
                }
            }
        }
        if (this.isEquals(this.opcoesFaturamentoCliente.getAplicarTodoCliente(), (short)0).booleanValue()) {
            for (ParamNomeclaturaProdutoXML p : this.opcoesFaturamentoCliente.getProdutos()) {
                if (!this.isEquals(p.getCliente(), cliente).booleanValue()) continue;
                for (ItemParamNomeclaturaProdutoXML item : p.getItens()) {
                    if (!this.isEquals(item.getProduto(), produto).booleanValue() || this.isEquals(item.getConcatInfAddProduto(), (short)1).booleanValue()) continue;
                    return item.getDescricao();
                }
            }
        }
        return nome;
    }
}

