/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.nfse;

import com.fincatto.documentofiscal.nfe400.classes.NFTipo;
import com.fincatto.documentofiscal.nfse.classes.evento.TCEvento;
import com.fincatto.documentofiscal.nfse.classes.evento.TCInfPedReg;
import com.fincatto.documentofiscal.nfse.classes.nota.TCDPS;
import com.fincatto.documentofiscal.nfse.classes.nota.TCNFSe;
import com.fincatto.documentofiscal.utils.DFPersister;
import com.touchcomp.basementor.constants.enums.nfse.EnumConstNSeStatus;
import com.touchcomp.basementor.constants.enums.nfse.EnumConstTipoEventoNFSe;
import com.touchcomp.basementor.constants.enums.notasfiscais.EnumConstStatLancNFTerceiros;
import com.touchcomp.basementor.constants.enums.tasks.EnumConstantsTaskResult;
import com.touchcomp.basementor.model.vo.ConfigServicos;
import com.touchcomp.basementor.model.vo.ConsultaNFSeDestDist;
import com.touchcomp.basementor.model.vo.ConsultaNFSeDestDocsDist;
import com.touchcomp.basementor.model.vo.ConsultaNFSeDestEvtDist;
import com.touchcomp.basementor.model.vo.ConsultaNFSeDestNSU;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementorclientwebservices.nfse.impl.distribuicaonfse.model.NFSeDistribuicaoIntRetorno;
import com.touchcomp.basementorexceptions.exceptions.impl.decoder.ExceptionDecodeHexString64;
import com.touchcomp.basementorexceptions.exceptions.impl.zip.ExceptionZip;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.components.nfse.CompStatusDistNFSeDoc;
import com.touchcomp.basementorservice.helpers.impl.configservicos.HelperConfigServicos;
import com.touchcomp.basementorservice.model.task.TaskProcessResult;
import com.touchcomp.basementorservice.service.impl.cidade.ServiceCidadeImpl;
import com.touchcomp.basementorservice.service.impl.consultanfedestevtdist.ServiceConsultaNFeDestEvtDistImpl;
import com.touchcomp.basementorservice.service.impl.consultanfsedestdist.ServiceConsultaNFSeDestDocsDistImpl;
import com.touchcomp.basementorservice.service.impl.consultanfsedestdist.ServiceConsultaNFSeDestNSUImpl;
import com.touchcomp.basementorservice.service.impl.consultanfsedestevtdist.ServiceConsultaNFSeDestEvtDistImpl;
import com.touchcomp.basementorservice.service.impl.notafiscalterceiros.ServiceNotaFiscalTerceirosImpl;
import com.touchcomp.basementorservice.service.impl.unidadefatfornecedor.ServiceUnidadeFatFornecedorImpl;
import com.touchcomp.basementortools.tools.base64.ToolBase64;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementortools.tools.zip.ToolZipUtils;
import com.touchcomp.basementorxml.model.XMLNFeCTe;
import com.touchcomp.basementorxml.model.XMLNFeCTeEvt;
import com.touchcomp.basementorxml.service.impl.xmlnfecteevt.ServiceXMLNFeCTeEvtImpl;
import com.touchcomp.basementorxml.service.interfaces.ServiceXMLNFeCTe;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;

class AuxProcessaEventoDistNFSe {
    final ServiceXMLNFeCTe serviceXmlNFeCte;
    final ServiceXMLNFeCTeEvtImpl serviceXmlNFeCteEvt;
    final ServiceConsultaNFSeDestDocsDistImpl serviceConsultaNFSeDestDocImpl;
    final ServiceUnidadeFatFornecedorImpl serviceUnidadeFatFornecedorImpl;
    final ServiceCidadeImpl serviceCidadeImpl;
    final CompStatusDistNFSeDoc compStatusDoc;
    final ServiceConsultaNFSeDestNSUImpl serviceConsultaNFSeDestNSUImpl;
    final ServiceConsultaNFSeDestEvtDistImpl serviceConsultaNFSeDestEvtDistImpl;
    final ServiceNotaFiscalTerceirosImpl serviceNotaFiscalTerceiros;
    final ConfigServicos configServicos;
    private final String TIPO_DOC_NFSE = "NFSE";
    private final String TIPO_DOC_EVENTO = "EVENTO";
    private final String TIPO_DOC_PEDIDO_REGISTRO_EVENTO = "PEDIDO_REGISTRO_EVENTO";
    private final String TIPO_DOC_DPS = "DPS";

    public AuxProcessaEventoDistNFSe(ServiceXMLNFeCTe serviceXmlNFeCte, ServiceXMLNFeCTeEvtImpl serviceXmlNFeCteEvt, ServiceConsultaNFSeDestDocsDistImpl serviceConsultaNFeDestDocImpl, ServiceConsultaNFeDestEvtDistImpl serviceConsultaNFeDestEvtDistImpl, ServiceUnidadeFatFornecedorImpl serviceUnidadeFatFornecedorImpl, ServiceCidadeImpl serviceCidadeImpl, CompStatusDistNFSeDoc compStatusConsDoc, ServiceConsultaNFSeDestNSUImpl serviceConsultaNFSeDestNSUImpl, ServiceNotaFiscalTerceirosImpl serviceNotaFiscalTerceiros, ConfigServicos configServicos, HelperConfigServicos helperConfigServicos, ServiceConsultaNFSeDestEvtDistImpl serviceConsultaNFSeDestEvtDistImpl) {
        this.serviceXmlNFeCte = serviceXmlNFeCte;
        this.serviceXmlNFeCteEvt = serviceXmlNFeCteEvt;
        this.serviceConsultaNFSeDestDocImpl = serviceConsultaNFeDestDocImpl;
        this.serviceUnidadeFatFornecedorImpl = serviceUnidadeFatFornecedorImpl;
        this.serviceCidadeImpl = serviceCidadeImpl;
        this.compStatusDoc = compStatusConsDoc;
        this.serviceConsultaNFSeDestNSUImpl = serviceConsultaNFSeDestNSUImpl;
        this.serviceNotaFiscalTerceiros = serviceNotaFiscalTerceiros;
        this.configServicos = configServicos;
        this.serviceConsultaNFSeDestEvtDistImpl = serviceConsultaNFSeDestEvtDistImpl;
    }

    void readAndSave(NFSeDistribuicaoIntRetorno.DFe doc, TaskProcessResult result, Empresa empresa, ConsultaNFSeDestDist consulta) throws ExceptionZip, ExceptionDecodeHexString64, Exception {
        String xml = doc.getArquivoXml();
        String tipoDocumento = doc.getTipoDocumento();
        Long nsu = Long.valueOf(doc.getNsu());
        consulta.setNumeroNSU(nsu);
        consulta.setUltNSUConsulta(nsu);
        ConsultaNFSeDestNSU consultaNsu = this.serviceConsultaNFSeDestNSUImpl.getOrCreate(tipoDocumento, nsu, empresa);
        boolean proc = false;
        try {
            byte[] data = ToolBase64.decodeBase64((String)xml);
            xml = ToolZipUtils.decompress((byte[])data);
            proc = this.processaXML(tipoDocumento, xml, nsu, result, empresa, consultaNsu, consulta);
        }
        catch (Exception ex) {
            this.logError(ex);
            result.addDetByCode(EnumConstantsTaskResult.RESULT_ERRO, "E.TSK.0029.006", empresa, nsu, ex.getMessage());
        }
        consultaNsu.setProcessado(Short.valueOf(proc ? (short)1 : 0));
        this.serviceConsultaNFSeDestNSUImpl.saveOrUpdateFlush(consultaNsu);
    }

    protected boolean processaXML(String schema, String xml, Long nsu, TaskProcessResult result, Empresa empresa, ConsultaNFSeDestNSU consultaNsu, ConsultaNFSeDestDist consulta) throws Exception {
        this.saveXml(nsu, xml, schema);
        if (schema.contains("NFSE")) {
            this.readNFSe(xml, nsu, result, consultaNsu, consulta, empresa);
            return true;
        }
        if (schema.contains("EVENTO")) {
            this.readEvento(xml, nsu, result, consultaNsu, consulta, empresa);
            return true;
        }
        result.addError("E.TSK.0029.007", empresa, nsu, schema);
        return false;
    }

    private void readNFSe(String xml, Long nsu, TaskProcessResult result, ConsultaNFSeDestNSU consultaNsu, ConsultaNFSeDestDist consulta, Empresa empresa) {
        try {
            TCNFSe nfe = this.getData(TCNFSe.class, xml);
            TCDPS dps = nfe.getInfNFSe().getDPS();
            String cnpjCliente = dps.getInfDPS().getToma().getCNPJ();
            if (TMethods.isStrWithData((String)dps.getInfDPS().getToma().getCPF())) {
                cnpjCliente = dps.getInfDPS().getToma().getCPF();
            }
            String chaveNFSe = ToolString.onlyNumbers((String)nfe.getInfNFSe().getId());
            String cnpjEmitente = nfe.getInfNFSe().getEmit().getCNPJ();
            XMLNFeCTe x = this.readAndSaveXMLNFe(xml, cnpjEmitente, cnpjCliente, chaveNFSe);
            ConsultaNFSeDestDocsDist c = this.serviceConsultaNFSeDestDocImpl.getByChave(chaveNFSe);
            if (c == null) {
                c = new ConsultaNFSeDestDocsDist();
                c.setConsultaNFSeDestDist(consulta);
            }
            c.setUnidadeFatFornecedor(this.serviceUnidadeFatFornecedorImpl.getFirstByCnpjCPFAtivo(cnpjEmitente));
            c.setNumeroDoc(nfe.getInfNFSe().getNNFSe());
            c.setSerieDPS(dps.getInfDPS().getSerie());
            c.setNumeroDPS(dps.getInfDPS().getNDPS());
            c.setDataEmissaoDPS(ToolDate.asDate((ZonedDateTime)dps.getInfDPS().getDhEmi()));
            c.setDataCompetenciaDPS(ToolDate.asDate((LocalDate)dps.getInfDPS().getDCompet()));
            c.setCidadeEmissao(this.serviceCidadeImpl.getByCodigoIBGECompleto(nfe.getInfNFSe().getCLocIncid()));
            c.setCidadePrestacao(this.serviceCidadeImpl.getByCodigoIBGECompleto(dps.getInfDPS().getServ().getLocPrest().getCLocPrestacao()));
            c.setNsu(nsu);
            c.setEmpresa(empresa);
            c.setIdRegXMLTerc(x.getIdentificador());
            c.setCnpjDestinatarioTomador(cnpjCliente);
            c.setCnpjEmitente(cnpjEmitente);
            c.setStatusSefaz(EnumConstNSeStatus.AUTORIZADO.getValueShort());
            c.setChave(chaveNFSe);
            c.setConsultaNFSeDestDist(consulta);
            c.setConsultaNFSeDestNSU(consultaNsu);
            if (nfe.getInfNFSe().getDPS() != null && nfe.getInfNFSe().getDPS().getInfDPS() != null && nfe.getInfNFSe().getDPS().getInfDPS().getServ() != null && nfe.getInfNFSe().getDPS().getInfDPS().getServ().getCServ() != null) {
                c.setDescricaoServico(nfe.getInfNFSe().getDPS().getInfDPS().getServ().getCServ().getXDescServ());
            }
            consultaNsu.setChaveNFe(chaveNFSe);
            c.setDataProcessamento(ToolDate.asDate((ZonedDateTime)nfe.getInfNFSe().getDhProc()));
            c.setNome(nfe.getInfNFSe().getEmit().getXNome());
            c.setNomeFantasia(nfe.getInfNFSe().getEmit().getXFant());
            c.setValor(nfe.getInfNFSe().getValores().getVLiq());
            c.setObservacao(MessagesBaseMentor.getTextDetailsMsg((String)"M.ERP.1910.001", (Object[])new Object[0]));
            this.compStatusDoc.definirStatusConsultaDoc(c, EnumConstStatLancNFTerceiros.STAT_INTER_DOWNLOAD_COMPLETO);
            List<ConsultaNFSeDestEvtDist> evts = this.serviceConsultaNFSeDestEvtDistImpl.getEvento(chaveNFSe, EnumConstTipoEventoNFSe.getStatusCancelado());
            if (ToolMethods.isWithData(evts)) {
                c.setStatusSefaz(EnumConstNSeStatus.CANCELADA.getValueShort());
                this.compStatusDoc.definirStatusConsultaDoc(c, EnumConstStatLancNFTerceiros.STAT_FINAL_DENEGADADA_CANCELADA);
            }
            c.setNotaFiscalTerceiros(this.serviceNotaFiscalTerceiros.findNotaTerceirosPorChave(chaveNFSe));
            c = this.serviceConsultaNFSeDestDocImpl.saveOrUpdateFlush(c);
            result.addDetByCode(EnumConstantsTaskResult.RESULT_OK, "M.TSK.0029.001", empresa, chaveNFSe);
        }
        catch (Throwable ex) {
            this.logError(ex);
            result.addDetByCode(EnumConstantsTaskResult.RESULT_ERRO, "E.TSK.0029.006", empresa, nsu, ex.getMessage());
            this.saveXmlErroLeitura(xml);
        }
    }

    private XMLNFeCTe readAndSaveXMLNFe(String xml, String cnpjEmitente, String cnpjClienteTomador, String chave) {
        XMLNFeCTe x = this.serviceXmlNFeCte.getOrCreateXMlNfeCTeChaveNFe(chave);
        x.setChaveNFe(chave);
        x.setCnpjEmitente(cnpjEmitente);
        x.setCnpjDestinatarioCliente(cnpjClienteTomador);
        x.setFlag(Integer.valueOf(0));
        x.setConteudoXML(xml);
        x.setDataChegada(new Date());
        x = (XMLNFeCTe)this.serviceXmlNFeCte.saveOrUpdate((Object)x);
        return x;
    }

    private void logError(Throwable ex) {
        TLogger.get(this.getClass()).error(ex);
    }

    private <E> E getData(Class<E> aClass, String xml) throws Exception {
        Object data = new DFPersister().read(aClass, xml, false);
        return (E)data;
    }

    private void saveXml(Long nsu, String schema, String xml) {
    }

    protected boolean arquivarNota(NFTipo tipo, String cnpjDestinatario, Empresa empresa) {
        return true;
    }

    private void readEvento(String xml, Long nsu, TaskProcessResult result, ConsultaNFSeDestNSU consultaNsu, ConsultaNFSeDestDist consulta, Empresa empresa) {
        try {
            ConsultaNFSeDestEvtDist evt = this.processarEvento(nsu, xml, consultaNsu, consulta);
            result.addDetByCode(EnumConstantsTaskResult.RESULT_OK, "M.TSK.0029.003", empresa, evt.getChave(), EnumConstTipoEventoNFSe.getByCodigo((String)String.valueOf(evt.getTipoEventoSefaz())));
        }
        catch (Throwable ex) {
            this.logError(ex);
            result.addDetByCode(EnumConstantsTaskResult.RESULT_ERRO, "E.TSK.0029.006", empresa, nsu, ex.getMessage());
            this.saveXmlErroLeitura(xml);
        }
    }

    private ConsultaNFSeDestEvtDist processarEvento(Long nsu, String xml, ConsultaNFSeDestNSU consultaNsu, ConsultaNFSeDestDist consulta) throws Exception {
        TCEvento e = this.getData(TCEvento.class, xml);
        TCInfPedReg infEvt = e.getInfEvento().getPedRegEvento().getInfPedReg();
        EnumConstTipoEventoNFSe tipoEventoSefaz = this.getTipoEvento(infEvt);
        String chaveDoc = infEvt.getChNFSe();
        ConsultaNFSeDestEvtDist evt = this.serviceConsultaNFSeDestEvtDistImpl.getEvento(chaveDoc, tipoEventoSefaz.getValueLong());
        if (evt == null) {
            evt = new ConsultaNFSeDestEvtDist();
        }
        evt.setChave(chaveDoc);
        evt.setTipoEventoSefaz(tipoEventoSefaz.getValueLong());
        evt.setNsu(nsu);
        evt.setConsultaNFSeDestDist(consulta);
        evt.setConsultaNFSeDoc(this.serviceConsultaNFSeDestDocImpl.getByChave(chaveDoc));
        evt.setConsultaNFSeDestNSU(consultaNsu);
        consultaNsu.setChaveNFe(chaveDoc);
        this.definirStatusNFeConfEvento(tipoEventoSefaz, evt);
        evt = this.serviceConsultaNFSeDestEvtDistImpl.saveOrUpdateFlush(evt);
        XMLNFeCTeEvt xmlEvt = this.serviceXmlNFeCteEvt.getByNSU(String.valueOf(nsu));
        if (xmlEvt == null) {
            xmlEvt = new XMLNFeCTeEvt();
        }
        xmlEvt.setChaveDoc(evt.getChave());
        xmlEvt.setConteudoXML(xml);
        xmlEvt.setNsu(String.valueOf(nsu));
        xmlEvt.setDataChegada(new Date());
        this.serviceXmlNFeCteEvt.saveOrUpdate((Object)xmlEvt);
        return evt;
    }

    private void saveXmlErroLeitura(String xml) {
    }

    private EnumConstTipoEventoNFSe getTipoEvento(TCInfPedReg infEvt) {
        EnumConstTipoEventoNFSe tipoEventoSefaz = EnumConstTipoEventoNFSe.EVT_NAO_MAPEADO;
        if (infEvt.getEvtAnuRejE205208() != null) {
            tipoEventoSefaz = EnumConstTipoEventoNFSe.ANULACAO_REJEICAO;
        } else if (infEvt.getEvtBloqOficioE305102() != null) {
            tipoEventoSefaz = EnumConstTipoEventoNFSe.BLOQUEIO_OFICIO;
        } else if (infEvt.getEvtCancDefE105104() != null) {
            tipoEventoSefaz = EnumConstTipoEventoNFSe.CANCELAMENTO_DEFERIDO;
        } else if (infEvt.getEvtCancE101101() != null) {
            tipoEventoSefaz = EnumConstTipoEventoNFSe.CANCELAMENTO;
        } else if (infEvt.getEvtCancIndefE105105() != null) {
            tipoEventoSefaz = EnumConstTipoEventoNFSe.CANCELAMENTO_INDEFERIDO;
        } else if (infEvt.getEvtCancOficioE305101() != null) {
            tipoEventoSefaz = EnumConstTipoEventoNFSe.CANCELAMENTO_OFICIO;
        } else if (infEvt.getEvtCancSubstE105102() != null) {
            tipoEventoSefaz = EnumConstTipoEventoNFSe.CANCELAMENTO_SUBSTITUICAO;
        } else if (infEvt.getEvtConfInterE204203() != null) {
            tipoEventoSefaz = EnumConstTipoEventoNFSe.CONFIRMACAO_INTERMEDIARIO;
        } else if (infEvt.getEvtConfPrestE202201() != null) {
            tipoEventoSefaz = EnumConstTipoEventoNFSe.CONFIRMACAO_PRESTAD0R;
        } else if (infEvt.getEvtConfTacitaE205204() != null) {
            tipoEventoSefaz = EnumConstTipoEventoNFSe.CONFIRMACAO_TACITA;
        } else if (infEvt.getEvtConfTomaE203202() != null) {
            tipoEventoSefaz = EnumConstTipoEventoNFSe.CONFIRMACAO_TOMADOR;
        } else if (infEvt.getEvtDesbOficioE305103() != null) {
            tipoEventoSefaz = EnumConstTipoEventoNFSe.DESLOBQUEIO_OFICIO;
        } else if (infEvt.getEvtRejInterE204207() != null) {
            tipoEventoSefaz = EnumConstTipoEventoNFSe.REJEICAO_INTERMEDIARIO;
        } else if (infEvt.getEvtRejPrestaE202205() != null) {
            tipoEventoSefaz = EnumConstTipoEventoNFSe.REJEICAO_PRESTADOR;
        } else if (infEvt.getEvtRejTomaE203206() != null) {
            tipoEventoSefaz = EnumConstTipoEventoNFSe.REJEICAO_TOMADOR;
        } else if (infEvt.getEvtSolCancelaE101103() != null) {
            tipoEventoSefaz = EnumConstTipoEventoNFSe.SOLICITACAO_CANCELAMENTO;
        }
        return tipoEventoSefaz;
    }

    private void definirStatusNFeConfEvento(EnumConstTipoEventoNFSe tipoEventoSefaz, ConsultaNFSeDestEvtDist evt) {
        if (evt.getConsultaNFSeDoc() == null) {
            return;
        }
        this.compStatusDoc.definirStatusConsultaDoc(evt.getConsultaNFSeDoc(), tipoEventoSefaz);
        evt.setConsultaNFSeDoc(this.serviceConsultaNFSeDestDocImpl.saveOrUpdateFlush(evt.getConsultaNFSeDoc()));
    }
}

