/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.nfse;

import com.touchcomp.basementor.constants.enums.configservicos.EnumConstConfigServicos;
import com.touchcomp.basementor.constants.enums.configservicos.impl.ConstantsDistribuicaoXMLNFSes;
import com.touchcomp.basementor.constants.enums.configuracaocertificado.ConstAmbiente;
import com.touchcomp.basementor.constants.enums.nfse.EnumConstDistribuicaoNFSeStatus;
import com.touchcomp.basementor.constants.enums.tasks.EnumConstantsTaskResult;
import com.touchcomp.basementor.model.vo.ConfigServicos;
import com.touchcomp.basementor.model.vo.ConfiguracaoCertificado;
import com.touchcomp.basementor.model.vo.ConsultaNFSeDestDist;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementorclientwebservices.certificado.model.ParamsCertificado;
import com.touchcomp.basementorclientwebservices.nfe.impl.distribuicaonfe.WebDistribuicaoDocXMLNFe;
import com.touchcomp.basementorclientwebservices.nfse.impl.distribuicaonfse.WebDistribuicaoDocXMLNFSe;
import com.touchcomp.basementorclientwebservices.nfse.impl.distribuicaonfse.model.NFSeDistribuicaoIntRetorno;
import com.touchcomp.basementorclientwebservices.nfse.impl.distribuicaonfse.model.ParamsDistribDocXMLNFSe;
import com.touchcomp.basementorexceptions.exceptions.impl.decoder.ExceptionDecodeHexString64;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.components.distribuicaoxmlnfecte.CompDistribuicaoXMLNFeCTe;
import com.touchcomp.basementorservice.components.empresa.CompEmpresa;
import com.touchcomp.basementorservice.components.nfse.AuxProcessaEventoDistNFSe;
import com.touchcomp.basementorservice.components.nfse.CompStatusDistNFSeDoc;
import com.touchcomp.basementorservice.helpers.impl.configservicos.HelperConfigServicos;
import com.touchcomp.basementorservice.helpers.impl.configuracaocertificado.HelperConfiguracaoCertificado;
import com.touchcomp.basementorservice.model.task.TaskProcessResult;
import com.touchcomp.basementorservice.service.impl.cidade.ServiceCidadeImpl;
import com.touchcomp.basementorservice.service.impl.configservicos.ServiceConfigServicosImpl;
import com.touchcomp.basementorservice.service.impl.configuracaocertificado.ServiceConfiguracaoCertificadoImpl;
import com.touchcomp.basementorservice.service.impl.consultanfedestevtdist.ServiceConsultaNFeDestEvtDistImpl;
import com.touchcomp.basementorservice.service.impl.consultanfsedestdist.ServiceConsultaNFSeDestDistImpl;
import com.touchcomp.basementorservice.service.impl.consultanfsedestdist.ServiceConsultaNFSeDestDocsDistImpl;
import com.touchcomp.basementorservice.service.impl.consultanfsedestdist.ServiceConsultaNFSeDestNSUImpl;
import com.touchcomp.basementorservice.service.impl.consultanfsedestevtdist.ServiceConsultaNFSeDestEvtDistImpl;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.notafiscalterceiros.ServiceNotaFiscalTerceirosImpl;
import com.touchcomp.basementorservice.service.impl.unidadefatfornecedor.ServiceUnidadeFatFornecedorImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementorxml.service.impl.xmlnfecteevt.ServiceXMLNFeCTeEvtImpl;
import com.touchcomp.basementorxml.service.interfaces.ServiceXMLNFeCTe;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class CompConsultaNFSeEmitidasDoc {
    private final ServiceConsultaNFSeDestDocsDistImpl serviceConsultaNFeDestDocImpl;
    private final ServiceConsultaNFSeDestDistImpl serviceConsultaNFSeDestImpl;
    private final ServiceConfiguracaoCertificadoImpl serviceConfiguracaoCertificadoImpl;
    private final HelperConfiguracaoCertificado helperConfigCertificado;
    private final WebDistribuicaoDocXMLNFSe distribuicaoNFSe;
    private final ServiceXMLNFeCTe serviceXmlNFeCte;
    private final ServiceXMLNFeCTeEvtImpl serviceXmlNFeCteEvt;
    private final ServiceConsultaNFeDestEvtDistImpl serviceConsultaNFeDestEvtImpl;
    private final ServiceUnidadeFatFornecedorImpl serviceUnidadeFatFornecedorImpl;
    private final ServiceCidadeImpl serviceCidadeImpl;
    private final CompStatusDistNFSeDoc compStatusConsDoc;
    private final ServiceConsultaNFSeDestNSUImpl serviceConsultaNFeDestNSUImpl;
    private final ServiceNotaFiscalTerceirosImpl serviceNotaFiscalTerceirosImpl;
    private final ServiceConsultaNFSeDestEvtDistImpl serviceConsultaNFSeDestEvtDistImpl;
    private final ServiceConfigServicosImpl serviceConfigServicosImpl;
    private final ServiceEmpresaImpl serviceEmpresaImpl;
    private final HelperConfigServicos helperConfigServicos;
    private final CompEmpresa compEmpresa;
    private final CompDistribuicaoXMLNFeCTe compDistribuicaoXMLNFeNFSeCTe;

    public CompConsultaNFSeEmitidasDoc(ServiceXMLNFeCTe serviceXmlNFeCte, ServiceXMLNFeCTeEvtImpl serviceXmlNFeCteEvt, WebDistribuicaoDocXMLNFe webDistribuicaoNFe, ServiceConsultaNFSeDestDocsDistImpl serviceConsultaNFeDestDocImpl, ServiceConsultaNFeDestEvtDistImpl serviceConsultaNFeDestEvtImpl, ServiceUnidadeFatFornecedorImpl serviceUnidadeFatFornecedorImpl, ServiceConsultaNFSeDestDistImpl serviceConsultaNFSeDestImpl, HelperConfiguracaoCertificado helperConfigCertificado, WebDistribuicaoDocXMLNFSe distribuicaoNFSe, ServiceCidadeImpl serviceCidade, CompStatusDistNFSeDoc compStatusConsDoc, ServiceConsultaNFSeDestNSUImpl serviceConsultaNFSeDestNSUImpl, ServiceNotaFiscalTerceirosImpl serviceNotaFiscalTerceirosImpl, ServiceConfigServicosImpl serviceConfigServicosImpl1, HelperConfigServicos helperConfigServicos, ServiceEmpresaImpl serviceEmpresaImpl, ServiceConfiguracaoCertificadoImpl serviceConfiguracaoCertificadoImpl, CompEmpresa compEmpresa, CompDistribuicaoXMLNFeCTe compDistribuicaoXMLNFeCTe, ServiceConsultaNFSeDestEvtDistImpl serviceConsultaNFSeDestEvtDistImpl) {
        this.serviceConsultaNFeDestDocImpl = serviceConsultaNFeDestDocImpl;
        this.serviceConsultaNFSeDestImpl = serviceConsultaNFSeDestImpl;
        this.helperConfigCertificado = helperConfigCertificado;
        this.distribuicaoNFSe = distribuicaoNFSe;
        this.serviceConfigServicosImpl = serviceConfigServicosImpl1;
        this.helperConfigServicos = helperConfigServicos;
        this.serviceEmpresaImpl = serviceEmpresaImpl;
        this.serviceConfiguracaoCertificadoImpl = serviceConfiguracaoCertificadoImpl;
        this.serviceXmlNFeCte = serviceXmlNFeCte;
        this.serviceXmlNFeCteEvt = serviceXmlNFeCteEvt;
        this.serviceConsultaNFeDestEvtImpl = serviceConsultaNFeDestEvtImpl;
        this.serviceUnidadeFatFornecedorImpl = serviceUnidadeFatFornecedorImpl;
        this.serviceCidadeImpl = serviceCidade;
        this.compStatusConsDoc = compStatusConsDoc;
        this.serviceConsultaNFeDestNSUImpl = serviceConsultaNFSeDestNSUImpl;
        this.serviceNotaFiscalTerceirosImpl = serviceNotaFiscalTerceirosImpl;
        this.compEmpresa = compEmpresa;
        this.compDistribuicaoXMLNFeNFSeCTe = compDistribuicaoXMLNFeCTe;
        this.serviceConsultaNFSeDestEvtDistImpl = serviceConsultaNFSeDestEvtDistImpl;
    }

    public TaskProcessResult distribuicaoNFSeNSUEspecifico(Empresa empresa, String chaveNFSeEspecifica) throws Exception {
        ParamsDistribDocXMLNFSe pDist;
        TaskProcessResult result = new TaskProcessResult();
        ConfigServicos config = this.serviceConfigServicosImpl.getContainsValueOrThrow(EnumConstConfigServicos.DITRIBUICAO_XML_NFSES, ConstantsDistribuicaoXMLNFSes.ID_EMPRESA.getChave(), empresa.getIdentificador().toString());
        String idCertificados = this.helperConfigServicos.build(config).getValue(ConstantsDistribuicaoXMLNFSes.ID_CONFIGURACAO_CERTIFICADO.getChave());
        Long idCertificadoEmpresa = this.compDistribuicaoXMLNFeNFSeCTe.getIdCertificado(empresa, idCertificados);
        ConfiguracaoCertificado configCert = this.getConfiguracaoCertificado(idCertificadoEmpresa);
        ConstAmbiente tipoAmbiente = this.getTipoAmbiente(config, result);
        ParamsCertificado params = this.helperConfigCertificado.build(configCert).getParamsCertificado(tipoAmbiente);
        NFSeDistribuicaoIntRetorno ret = this.distribuicaoNFSe.consultarDistribuicaoXML(params, pDist = this.getParamsEnv(null, empresa, tipoAmbiente.getCodigo(), chaveNFSeEspecifica));
        if (!EnumConstDistribuicaoNFSeStatus.isStatusFinal((String)ret.getStatusProcessamento())) {
            result.addDetByCode(EnumConstantsTaskResult.RESULT_ERRO, "M.TSK.0029.004", new Object[0]);
            return result;
        }
        this.efetuaProcessamentoESalva(ret, empresa, result, config);
        result.addDetByCode(EnumConstantsTaskResult.RESULT_OK, "M.TSK.0025.001", 1);
        return result;
    }

    public TaskProcessResult distribuicaoNFSe(Empresa empresa) throws Exception {
        TaskProcessResult result = new TaskProcessResult();
        this.distribuicaoNFSe(empresa, result);
        return result;
    }

    public void distribuicaoNFSe(Empresa empresa, TaskProcessResult result) throws Exception {
        ConfigServicos conf = this.serviceConfigServicosImpl.getContainsValueOrThrow(EnumConstConfigServicos.DITRIBUICAO_XML_NFSES, ConstantsDistribuicaoXMLNFSes.ID_EMPRESA.getChave(), empresa.getIdentificador().toString());
        this.distribuicaoNFSe(conf, result, empresa);
    }

    public void distribuicaoNFSe(String idConfServicos, TaskProcessResult result) throws Exception {
        String[] idsConfs;
        for (String idsConf : idsConfs = ToolString.splitString((String)idConfServicos, (char[])new char[0])) {
            ConfigServicos config = (ConfigServicos)this.serviceConfigServicosImpl.getOrThrow(idsConf);
            if (!TMethods.isEquals((Object)EnumConstConfigServicos.get((Object)config.getChave()), (Object)EnumConstConfigServicos.DITRIBUICAO_XML_NFSES)) {
                result.addError("E.TSK.0029.006", EnumConstConfigServicos.DITRIBUICAO_XML_NFSES.getChave(), config.getChave());
                return;
            }
            String idEmpresas = this.helperConfigServicos.build(config).getValue(ConstantsDistribuicaoXMLNFSes.ID_EMPRESA.getChave());
            List<Empresa> empresas = this.compEmpresa.getEmpresas(idEmpresas, result);
            if (empresas == null) continue;
            Empresa[] arrEmpresas = (Empresa[])empresas.toArray(Empresa[]::new);
            this.distribuicaoNFSe(config, result, arrEmpresas);
        }
    }

    public synchronized void distribuicaoNFSe(ConfigServicos config, TaskProcessResult result, Empresa ... empresas) throws Exception {
        ConstAmbiente tpAmb = this.getTipoAmbiente(config, result);
        String nsuInicial = this.helperConfigServicos.build(config).getValue(ConstantsDistribuicaoXMLNFSes.NSU_INICIAL.getChave());
        if (!TMethods.isStrWithData((String)nsuInicial)) {
            nsuInicial = "0";
        }
        String idCertificados = this.helperConfigServicos.build(config).getValue(ConstantsDistribuicaoXMLNFSes.ID_CONFIGURACAO_CERTIFICADO.getChave());
        for (Empresa empresa : empresas) {
            Long idCertificadoEmpresa = this.compDistribuicaoXMLNFeNFSeCTe.getIdCertificado(empresa, idCertificados);
            ConfiguracaoCertificado configCert = this.getConfiguracaoCertificado(idCertificadoEmpresa);
            Long nsuIn = this.compDistribuicaoXMLNFeNFSeCTe.getNSUEmpresa(empresa, nsuInicial);
            if (nsuIn < 0L) {
                this.serviceConsultaNFSeDestImpl.desconsiderarConsultasEmpresa(empresa);
                nsuInicial = this.compDistribuicaoXMLNFeNFSeCTe.atualizarNSUEmpresa(empresa, nsuInicial, 0L);
                config = this.atualizarNSUProximaExec(config, nsuInicial);
            }
            this.distribuicaoNFSe(configCert, empresa, tpAmb, nsuIn, result, config);
        }
    }

    public synchronized void distribuicaoNFSe(ConfiguracaoCertificado configCert, Empresa empresa, ConstAmbiente tipoAmbiente, Long nsuInicial, TaskProcessResult result, ConfigServicos configServicos) throws Exception {
        NFSeDistribuicaoIntRetorno ret;
        String ultNsu = this.serviceConsultaNFSeDestImpl.getUltimaConsulta(empresa);
        if (nsuInicial == null) {
            nsuInicial = 0L;
        }
        if (!ToolMethods.isStrWithData((String)ultNsu)) {
            ultNsu = nsuInicial.toString();
        }
        if (!ToolMethods.isStrWithData((String)ultNsu)) {
            ultNsu = "0";
        }
        if (nsuInicial < 0L) {
            ultNsu = "0";
        }
        int count = 0;
        do {
            ParamsDistribDocXMLNFSe pDist;
            ParamsCertificado params;
            if (!EnumConstDistribuicaoNFSeStatus.isStatusFinal((String)(ret = this.distribuicaoNFSe.consultarDistribuicaoXML(params = this.helperConfigCertificado.build(configCert).getParamsCertificado(tipoAmbiente), pDist = this.getParamsEnv(ultNsu, empresa, tipoAmbiente.getCodigo(), null))).getStatusProcessamento())) {
                result.addDetByCode(EnumConstantsTaskResult.RESULT_ERRO, "E.TSK.0029.004", ret.getStatusProcessamento());
                break;
            }
            ConsultaNFSeDestDist cons = this.efetuaProcessamentoESalva(ret, empresa, result, configServicos);
            ultNsu = String.valueOf(cons.getUltNSUConsulta());
            ++count;
        } while (!EnumConstDistribuicaoNFSeStatus.NENHUM_DOCUMENTO_LOCALIZADO.equals((Object)EnumConstDistribuicaoNFSeStatus.getByCodigo((String)ret.getStatusProcessamento())));
        result.addDetByCode(EnumConstantsTaskResult.RESULT_OK, "M.TSK.0029.002", count);
    }

    private ConsultaNFSeDestDist efetuaProcessamentoESalva(NFSeDistribuicaoIntRetorno ret, Empresa empresa, TaskProcessResult result, ConfigServicos configServicos) throws ExceptionDecodeHexString64, Exception {
        ConsultaNFSeDestDist consulta = this.getConsulta(ret, empresa);
        for (NFSeDistribuicaoIntRetorno.DFe doc : ret.getDocumentos()) {
            this.getAuxProcessamentoNFe(configServicos).readAndSave(doc, result, empresa, consulta);
        }
        this.salvarConsulta(consulta);
        return consulta;
    }

    private void salvarConsulta(ConsultaNFSeDestDist consulta) {
        consulta.setConsiderarNSUConsulta(Short.valueOf((short)1));
        this.serviceConsultaNFSeDestImpl.saveOrUpdateFlush(consulta);
    }

    private ConsultaNFSeDestDist getConsulta(NFSeDistribuicaoIntRetorno ret, Empresa empresa) {
        ConsultaNFSeDestDist toSave = new ConsultaNFSeDestDist();
        toSave.setConsiderarNSUConsulta(Short.valueOf((short)1));
        toSave.setDataCadastro(new Date());
        toSave.setDataConsulta(new Date());
        toSave.setEmpresa(empresa);
        toSave.setConsiderarNSUConsulta(Short.valueOf((short)0));
        toSave = this.serviceConsultaNFSeDestImpl.saveOrUpdateFlush(toSave);
        return toSave;
    }

    private ParamsDistribDocXMLNFSe getParamsEnv(String ultNSU, Empresa empresa, String tipoAmbiente, String chaveAcessoEspecifica) {
        ParamsDistribDocXMLNFSe p = new ParamsDistribDocXMLNFSe();
        if (ToolMethods.isEquals((Object)tipoAmbiente, (Object)String.valueOf(1))) {
            p.setAmbiente(ConstAmbiente.PRODUCAO);
        } else {
            p.setAmbiente(ConstAmbiente.HOMOLOGACAO);
        }
        String cpfCnpj = ToolString.onlyNumbers((String)empresa.getPessoa().getComplemento().getCnpj());
        if (cpfCnpj.length() > 11) {
            p.setCnpj(cpfCnpj);
        } else {
            p.setCpf(cpfCnpj);
        }
        p.setChaveAcesso(null);
        p.setUltimoNSU(null);
        if (ToolMethods.isStrWithData((String)ultNSU)) {
            p.setUltimoNSU(ultNSU);
        } else if (ToolMethods.isStrWithData((String)ToolString.onlyNumbers((String)chaveAcessoEspecifica))) {
            p.setChaveAcesso(chaveAcessoEspecifica);
        } else {
            p.setUltimoNSU("0");
        }
        return p;
    }

    private ConfiguracaoCertificado getConfiguracaoCertificado(Long idCert) throws ExceptionObjNotFound {
        ConfiguracaoCertificado configCert = (ConfiguracaoCertificado)this.serviceConfiguracaoCertificadoImpl.get(idCert);
        if (configCert == null) {
            throw new ExceptionObjNotFound(new ExcepCodeDetail("E.TSK.0029.002"));
        }
        return configCert;
    }

    private ConstAmbiente getTipoAmbiente(ConfigServicos config, TaskProcessResult result) {
        String tipoAmbiente = this.helperConfigServicos.build(config).getValue(ConstantsDistribuicaoXMLNFSes.HOMOLOGACAO_PRODUCAO.getChave());
        if (!ToolMethods.isStrWithData((String)(tipoAmbiente = ToolString.onlyNumbers((String)tipoAmbiente)))) {
            return ConstAmbiente.PRODUCAO;
        }
        ConstAmbiente tp = ConstAmbiente.valueOfCodigo((String)tipoAmbiente);
        if (tp == null) {
            return ConstAmbiente.PRODUCAO;
        }
        return tp;
    }

    private ConfigServicos atualizarNSUProximaExec(ConfigServicos config, String nsu) {
        this.helperConfigServicos.build(config).setValue(ConstantsDistribuicaoXMLNFSes.NSU_INICIAL.getChave(), nsu);
        return this.serviceConfigServicosImpl.saveOrUpdate(config);
    }

    private AuxProcessaEventoDistNFSe getAuxProcessamentoNFe(ConfigServicos configServicos) {
        return new AuxProcessaEventoDistNFSe(this.serviceXmlNFeCte, this.serviceXmlNFeCteEvt, this.serviceConsultaNFeDestDocImpl, this.serviceConsultaNFeDestEvtImpl, this.serviceUnidadeFatFornecedorImpl, this.serviceCidadeImpl, this.compStatusConsDoc, this.serviceConsultaNFeDestNSUImpl, this.serviceNotaFiscalTerceirosImpl, configServicos, this.helperConfigServicos, this.serviceConsultaNFSeDestEvtDistImpl);
    }
}

