/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.notapropria;

import com.touchcomp.basementor.model.impl.LivroFiscalItem;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.Cooperado;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemNotaLivroFiscal;
import com.touchcomp.basementor.model.vo.LivroFiscal;
import com.touchcomp.basementor.model.vo.ModeloDocFiscal;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ObservacaoLivroFiscal;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.SituacaoDocumento;
import com.touchcomp.basementorexceptions.exceptions.impl.avaliadorexpressoes.ExceptionAvaliadorExpressoes;
import com.touchcomp.basementorservice.components.totalizadores.CompTotalizadores;
import com.touchcomp.basementorservice.service.impl.notafiscalpropria.UtilityAjustesIcmsDocFiscalNotaPropria;
import com.touchcomp.basementorservice.service.interfaces.ServiceCooperado;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class CompCalculoNotaPropria {
    public void calcularTotalizadores(NotaFiscalPropria nf) {
        CompTotalizadores calc = new CompTotalizadores();
        calc.calculaTotalizadores(nf);
        Cooperado cooperado = this.getCooperadoPorCliente(nf.getUnidadeFatCliente().getCliente());
        if (cooperado != null && (cooperado.getTipoRAT() != null && cooperado.getTipoRAT() == 1 || cooperado.getTipoSenar() != null && cooperado.getTipoRAT() == 1 || cooperado.getTipoInss() != null && cooperado.getTipoInss() == 1)) {
            this.calcularInssCooperado(nf, cooperado);
            this.calcularRATCooperado(nf, cooperado);
            this.calcularSenarCooperado(nf, cooperado);
        }
    }

    private Cooperado getCooperadoPorCliente(Cliente cliente) {
        ServiceCooperado serviceCooperado = (ServiceCooperado)ConfApplicationContext.getBean(ServiceCooperado.class);
        return serviceCooperado.findCooperadoPorCliente(cliente);
    }

    private void calcularRATCooperado(NotaFiscalPropria nf, Cooperado cooperado) {
        Double aliquotaRAT = 0.0;
        Double bcRAT = 0.0;
        Double valorRAT = 0.0;
        if (cooperado.getTipoRAT() != null && cooperado.getTipoRAT() == 1) {
            aliquotaRAT = cooperado.getAliquotaRAT();
            bcRAT = nf.getValoresNfPropria().getValorTotal();
            valorRAT = aliquotaRAT / 100.0 * bcRAT;
        } else if (cooperado.getTipoRAT() != null && cooperado.getTipoRAT() == 0) {
            valorRAT = 0.0;
        }
        nf.getValoresNfPropria().setValorRAT(ToolFormatter.arrredondarNumero((Double)valorRAT, (int)2, (int)4));
    }

    private void calcularInssCooperado(NotaFiscalPropria nf, Cooperado cooperado) {
        Double aliquotaInss = 0.0;
        Double bcInss = 0.0;
        Double valorInss = 0.0;
        if (cooperado.getTipoInss() != null && cooperado.getTipoInss() == 1) {
            aliquotaInss = cooperado.getAliquotaInss();
            bcInss = nf.getValoresNfPropria().getValorTotal();
            valorInss = aliquotaInss / 100.0 * bcInss;
        } else if (cooperado.getTipoInss() != null && cooperado.getTipoInss() == 0) {
            valorInss = 0.0;
        }
        nf.getValoresNfPropria().setValorInssNaoRetido(ToolFormatter.arrredondarNumero((Double)valorInss, (int)2, (int)4));
    }

    private void calcularSenarCooperado(NotaFiscalPropria nf, Cooperado cooperado) {
        Double aliquotaSenar = 0.0;
        Double bcSenar = 0.0;
        Double valorSenar = 0.0;
        if (cooperado.getTipoSenar() != null && cooperado.getTipoSenar() == 1) {
            aliquotaSenar = cooperado.getAliquotaSenar();
            bcSenar = nf.getValoresNfPropria().getValorTotal();
            valorSenar = aliquotaSenar / 100.0 * bcSenar;
        } else if (cooperado.getTipoSenar() != null && cooperado.getTipoSenar() == 0) {
            valorSenar = 0.0;
        }
        nf.getValoresNfPropria().setValorSenar(ToolFormatter.arrredondarNumero((Double)valorSenar, (int)2, (int)4));
    }

    public List getLivroFiscaisResumo(List itens, List livrosOld, ModeloDocFiscal modeloDocFiscal, SituacaoDocumento situacaoDoc) throws ExceptionAvaliadorExpressoes {
        if (modeloDocFiscal == null) {
            return new ArrayList();
        }
        if (itens == null || modeloDocFiscal.getGeraLivroFiscal() != null && modeloDocFiscal.getGeraLivroFiscal() != 1) {
            return new ArrayList();
        }
        LivroFiscal lv = null;
        ArrayList<LivroFiscal> livros = new ArrayList<LivroFiscal>();
        boolean achou = false;
        HashMap<LivroFiscal, LivroFiscalItem> h = new HashMap<LivroFiscal, LivroFiscalItem>();
        for (Object o : itens) {
            ItemNotaFiscalPropria itemNotaFiscalPropria = (ItemNotaFiscalPropria)o;
            Date dataLivro = null;
            PlanoConta planoConta = null;
            dataLivro = itemNotaFiscalPropria.getNotaFiscalPropria().getDataEmissaoNota();
            planoConta = itemNotaFiscalPropria.getPlanoContaCred();
            lv = new LivroFiscal(itemNotaFiscalPropria.getItemNotaLivroFiscal().getCfop(), planoConta, itemNotaFiscalPropria.getIncidenciaIcms(), itemNotaFiscalPropria.getIncidenciaIpi(), itemNotaFiscalPropria.getItemNotaLivroFiscal().getAliquotaIcms(), itemNotaFiscalPropria.getProduto().getAliquotaIcms(), itemNotaFiscalPropria.getNotaFiscalPropria() != null ? dataLivro : new Date(), itemNotaFiscalPropria.getIncidenciaPisCofins(), itemNotaFiscalPropria.getIncidenciaPisCofins(), itemNotaFiscalPropria.getItemNotaLivroFiscal().getAliquotaPis(), itemNotaFiscalPropria.getItemNotaLivroFiscal().getAliquotaCofins(), itemNotaFiscalPropria.getItemNotaLivroFiscal().getAliquotaPisQtde(), itemNotaFiscalPropria.getItemNotaLivroFiscal().getAliquotaCofinsQtde());
            int aux = livros.indexOf(lv);
            if (aux > -1) {
                lv = (LivroFiscal)livros.get(aux);
                achou = true;
                if (h.get(lv) != null) {
                    LivroFiscalItem itemLivroItem = (LivroFiscalItem)h.get(lv);
                    itemLivroItem.getItensNotaPopria().add(itemNotaFiscalPropria);
                    h.put(lv, itemLivroItem);
                }
            }
            ItemNotaLivroFiscal lf = itemNotaFiscalPropria.getItemNotaLivroFiscal();
            lv.setValorFreteIcmsST(itemNotaFiscalPropria.getItemNotaLivroFiscal().getFreteIcmsST());
            lv.setCancelado(Short.valueOf((short)0));
            lv.setValorBCIcmsSt(Double.valueOf(lv.getValorBCIcmsSt() + lf.getVrBcCalculoIcmsSt()));
            lv.setValorIcms(ToolFormatter.arrredondarNumero((Double)(lv.getValorIcms() + lf.getVrIcms()), (int)2));
            lv.setValorIcmsIsento(Double.valueOf(lv.getValorIcmsIsento() + lf.getVrIcmsIsento()));
            lv.setValorIcmsOutros(Double.valueOf(lv.getValorIcmsOutros() + lf.getVrIcmsOutros()));
            lv.setValorIcmsSt(Double.valueOf(lv.getValorIcmsSt() + lf.getVrIcmsSt()));
            lv.setValorIcmsTributado(Double.valueOf(lv.getValorIcmsTributado() + lf.getVrIcmsTributado()));
            lv.setValorIcmsSemAprov(Double.valueOf(lv.getValorIcmsSemAprov() + lf.getVrIcmsSemAprov()));
            lv.setValorInss(Double.valueOf(lv.getValorInss() + lf.getVrInss()));
            lv.setValorIpiIndustria(Double.valueOf(lv.getValorIpiIndustria() + lf.getVrIpiIndustria()));
            lv.setValorIpiIsento(Double.valueOf(lv.getValorIpiIsento() + lf.getVrIpiIsento()));
            lv.setValorIpiOutros(Double.valueOf(lv.getValorIpiOutros() + lf.getVrIpiOutros()));
            lv.setValorIpiTributado(Double.valueOf(lv.getValorIpiTributado() + lf.getVrIpiTributado()));
            lv.setValorIpiComercio(Double.valueOf(lv.getValorIpiComercio() + lf.getVrIpiComercio()));
            lv.setValorIpiObservacao(Double.valueOf(lv.getValorIpiObservacao() + lf.getVrIpiObservacao()));
            lv.setValorIrrf(Double.valueOf(lv.getValorIrrf() + lf.getVrIrrf()));
            lv.setValorIss(Double.valueOf(lv.getValorIss() + lf.getVrIss()));
            lv.setValorLei10833(Double.valueOf(lv.getValorLei10833() + lf.getVrLei10833()));
            lv.setValorFunrural(Double.valueOf(lv.getValorFunrural() + lf.getVrFunrural()));
            lv.setValorOutros(Double.valueOf(lv.getValorOutros() + lf.getVrOutros()));
            lv.setValorTotal(ToolFormatter.arrredondarNumero((Double)(lv.getValorTotal() + lf.getValorTotal()), (int)2));
            lv.setVrBCCofins(Double.valueOf(lv.getVrBCCofins() + lf.getVrBCCofins()));
            lv.setVrBCPis(Double.valueOf(lv.getVrBCPis() + lf.getVrBCPis()));
            if (lv.getValorDifAliquota() == null) {
                lv.setValorDifAliquota(Double.valueOf(0.0));
            }
            lv.setValorDifAliquota(Double.valueOf(lv.getValorDifAliquota() + lf.getVrDifAliquota()));
            lv.setUfIcmsSt(lf.getUfIcmsSt());
            if (lv.getValorContSocial() == null) {
                lv.setValorContSocial(Double.valueOf(0.0));
            }
            if (lf.getVrContSoc() == null) {
                lf.setVrContSoc(Double.valueOf(0.0));
            }
            lv.setValorContSocial(Double.valueOf(lv.getValorContSocial() + lf.getVrContSoc()));
            if (lv.getValorCofins() == null) {
                lv.setValorCofins(Double.valueOf(0.0));
            }
            lv.setValorCofins(Double.valueOf(lv.getValorCofins() + lf.getVrCofins()));
            if (lv.getValorPis() == null) {
                lv.setValorPis(Double.valueOf(0.0));
            }
            lv.setValorPis(Double.valueOf(lv.getValorPis() + lf.getVrPis()));
            if (lf.getValorSestSenat() == null) {
                lf.setValorSestSenat(Double.valueOf(0.0));
            }
            lv.setValorSestSenat(Double.valueOf(lv.getValorSestSenat() + lf.getValorSestSenat()));
            if (lf.getVrNaoTribICMS() == null) {
                lf.setVrNaoTribICMS(Double.valueOf(0.0));
            }
            lv.setVrNaoTribIcms(Double.valueOf(lv.getVrNaoTribIcms() + lf.getVrNaoTribICMS()));
            if (itemNotaFiscalPropria.getNotaFiscalPropria() != null) {
                lv.setEmpresa(itemNotaFiscalPropria.getNotaFiscalPropria().getEmpresa());
                lv.setUf(itemNotaFiscalPropria.getNotaFiscalPropria().getUnidadeFatCliente().getPessoa().getEndereco().getCidade().getUf());
                lv.setCidade(itemNotaFiscalPropria.getNotaFiscalPropria().getUnidadeFatCliente().getPessoa().getEndereco().getCidade());
            }
            if (itemNotaFiscalPropria.getNotaFiscalPropria().getNaturezaOperacao() != null) {
                lv.setEntradaSaidaNaturezaOp(itemNotaFiscalPropria.getNotaFiscalPropria().getNaturezaOperacao().getEntradaSaida());
            }
            if (itemNotaFiscalPropria.getModeloFiscal() != null) {
                lv.setDescartarDapi(itemNotaFiscalPropria.getModeloFiscal().getDescartarDapi());
            }
            if (situacaoDoc != null && situacaoDoc.getCodigo().equalsIgnoreCase("02")) {
                lv.setCancelado(Short.valueOf((short)1));
            }
            lv.setVrBCCustoICMSST(Double.valueOf(lv.getVrBCCustoICMSST() + lf.getVrBCCustoICMSST()));
            lv.setVrCustoICMSST(Double.valueOf(lv.getVrCustoICMSST() + lf.getVrCustoICMSST()));
            lv.setValorIcmsPartilhaDest(Double.valueOf(lv.getValorIcmsPartilhaDest() + lf.getValorIcmsPartilhaDest()));
            lv.setValorIcmsPartilhaRem(Double.valueOf(lv.getValorIcmsPartilhaRem() + lf.getValorIcmsPartilhaRem()));
            lv.setValorFundoPobreza(Double.valueOf(lv.getValorFundoPobreza() + lf.getValorFundoPobreza()));
            lv.setValorFCP(Double.valueOf(lv.getValorFCP() + lf.getValorFCP()));
            lv.setAliquotaFCP(lf.getAliquotaFCP());
            lv.setValorFCPSt(Double.valueOf(lv.getValorFCPSt() + lf.getValorFCPSt()));
            lv.setAliquotaFCPSt(lf.getAliquotaFCPSt());
            lv.setValorFCPStRetido(Double.valueOf(lv.getValorFCPStRetido() + lf.getValorFCPStRetido()));
            lv.setAliquotaFCPStRetido(lf.getAliquotaFCPStRetido());
            lv.setValorIpiDevolucao(Double.valueOf(lv.getValorIpiDevolucao() + lf.getValorIpiDevolucao()));
            lv.setValorIcmsDiferimento(Double.valueOf(lv.getValorIcmsDiferimento() + lf.getValorIcmsDiferimento()));
            if (lf.getValorIcmsDiferimento() == null) {
                lf.setValorIcmsDiferimento(Double.valueOf(0.0));
            }
            if (!achou) {
                livros.add(lv);
                LivroFiscalItem l = new LivroFiscalItem();
                l.setLivroFiscal(lv);
                l.getItensNotaPopria().add(itemNotaFiscalPropria);
                h.put(lv, l);
            }
            achou = false;
        }
        ArrayList<LivroFiscalItem> lista = new ArrayList<LivroFiscalItem>();
        for (Object e : livros) {
            LivroFiscal lvf = (LivroFiscal)e;
            LivroFiscalItem livroItem = (LivroFiscalItem)h.get(lvf);
            if (livroItem == null) continue;
            lista.add(livroItem);
        }
        this.updateLivros(livrosOld, livros);
        new UtilityAjustesIcmsDocFiscalNotaPropria().gerarAjustesIcmsDocFiscal(lista);
        return livros;
    }

    private void updateLivros(List livrosOld, List livros) {
        if (livrosOld != null && !livrosOld.isEmpty()) {
            for (Object o : livros) {
                LivroFiscal lvNew = (LivroFiscal)o;
                int index = livrosOld.indexOf(lvNew);
                if (index <= -1) continue;
                LivroFiscal lvOld = (LivroFiscal)livrosOld.get(index);
                lvNew.setIdentificador(lvOld.getIdentificador());
                lvNew.setObsLivroFiscal(lvOld.getObsLivroFiscal());
                if (lvNew.getObsLivroFiscal() == null) continue;
                for (Object oc : lvNew.getObsLivroFiscal()) {
                    ObservacaoLivroFiscal os = (ObservacaoLivroFiscal)oc;
                    os.setLivroFiscal(lvNew);
                }
            }
        }
    }
}

