/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.notapropria;

import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstDisponibilidade;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.constants.enums.opcoesestoque.EnumConstOpEstoqueEstrategia;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoCarregQtdeVlr;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoSaldo;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoSaldoQtde;
import com.touchcomp.basementor.model.impl.SaldoEstoqueGeral;
import com.touchcomp.basementor.model.interfaces.InterfaceEstoqueDisp;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Expedicao;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.GradeItemPedido;
import com.touchcomp.basementor.model.vo.GradeItemPedidoLoteFab;
import com.touchcomp.basementor.model.vo.GradeItemTransfCentroEstoque;
import com.touchcomp.basementor.model.vo.ItemPedido;
import com.touchcomp.basementor.model.vo.ItemTransfCentroEstoque;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.ProdutoGrade;
import com.touchcomp.basementor.model.vo.TransferenciaCentroEstoque;
import com.touchcomp.basementor.model.vo.WmsSaidaEstoque;
import com.touchcomp.basementor.model.vo.WmsSaidaEstoqueGrade;
import com.touchcomp.basementor.model.vo.WmsSaidaEstoqueItem;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorservice.components.estoquepeps.CompEstoqueDisponibilidade;
import com.touchcomp.basementorservice.components.estoquepeps.single.EstoqueDisponivel;
import com.touchcomp.basementorservice.service.impl.saldoestoque.ServiceSaldoEstoqueImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompNotaPropriaEstoqueGrades {
    @Autowired
    ServiceSaldoEstoqueImpl serviceSaldoEstoqueImpl;
    @Autowired
    CompEstoqueDisponibilidade compDisp;
    @Autowired
    CompEstoqueDisponibilidade compDispSaldo;

    public List<GradeItemNotaFiscalPropria> defineGrades(Date dataEmissao, Pedido pedido, Expedicao expedicao, ItemPedido itemPedido, OpcoesFaturamento opcoesFaturamento, CentroEstoque centroEstoque) throws ExceptionInvalidState {
        List<Object> itensReservados = new LinkedList();
        itensReservados = expedicao != null && expedicao.getWmsPedido() != null ? this.buildReserva(expedicao.getWmsPedido().getWmsSeparacaoPedido().getWmsSaidaEstoque()) : (TMethods.isAffirmative((Number)pedido.getReservarEstoque()) && TMethods.isWithData((Collection)pedido.getTransferencias()) ? this.buildReserva(pedido.getTransferencias()) : this.buildReserva(itemPedido));
        ItemFaturamento aux = this.getItemFaturamento(itemPedido);
        return this.defineGrades(itemPedido.getPedido().getEmpresa(), opcoesFaturamento, centroEstoque, itemPedido.getPedido().getNaturezaOperacao(), dataEmissao, aux, itensReservados);
    }

    private List<GradeItemNotaFiscalPropria> defineGrades(Empresa empresa, OpcoesFaturamento opcoesFaturamento, CentroEstoque centroEstoque, NaturezaOperacao natOp, Date dataEmissao, ItemFaturamento item, List<ItemReserva> itensReservados) throws ExceptionInvalidState {
        Optional<GradeCor> foundGrPrin;
        LinkedList<GradeItemNotaFiscalPropria> gradesNF = new LinkedList<GradeItemNotaFiscalPropria>();
        GradeCor principal = null;
        if (item.getProduto().getGradesProduto().size() > 0 && (foundGrPrin = ((ProdutoGrade)item.getProduto().getGradesProduto().get(0)).getGradesCores().stream().filter(i -> ToolMethods.isAffirmative((Number)i.getGradePrincipal())).findFirst()).isPresent()) {
            principal = foundGrPrin.get();
            double total = item.getGrades().stream().mapToDouble(i -> i.getQuantidade()).sum();
            ItemGradeFaturamentoImpl aux = new ItemGradeFaturamentoImpl();
            aux.gradeCor = principal;
            aux.quantidade = total;
            item.getGrades().clear();
            item.getGrades().add(aux);
        }
        if (ToolMethods.isWithData(itensReservados)) {
            this.definirGradesBaseReservaEst(empresa, natOp, dataEmissao, item, itensReservados, gradesNF);
            return gradesNF;
        }
        this.definirGradesEstDisponivel(natOp, item, centroEstoque, empresa, dataEmissao, gradesNF, opcoesFaturamento);
        return gradesNF;
    }

    private void definirGradesBaseReservaEst(Empresa emp, NaturezaOperacao natOp, Date dataEmissao, ItemFaturamento item, List<ItemReserva> itensReservados, List<GradeItemNotaFiscalPropria> gradesNF) throws ExceptionInvalidState {
        EnumConstOpEstoqueEstrategia estrategia = EnumConstOpEstoqueEstrategia.MENOS_VARIACOES;
        for (ItemGradeFaturamento grade : item.getGrades()) {
            ArrayList<ItemReserva> itensReservadosGrade = new ArrayList<ItemReserva>();
            for (ItemReserva itemR : itensReservados) {
                if (!ToolMethods.isEquals((Object)itemR.getProduto(), (Object)grade.getGradeCor().getProdutoGrade().getProduto())) continue;
                itensReservadosGrade.add(itemR);
            }
            List aux = this.compDisp.getDisponibilidades(itensReservadosGrade, grade.getQuantidade(), grade.getGradeCor(), estrategia, CompEstoqueDisponibilidade.OpcaoSaldoParcial.SETAR_QTD_ULT_ITEM, CompEstoqueDisponibilidade.OpcaoTotalmenteSemSaldo.LANCAR_EXCECAO_FALTA_ESTOQUE);
            for (EstoqueDisponivel estD : aux) {
                GradeItemNotaFiscalPropria gi = new GradeItemNotaFiscalPropria(grade.getGradeCor());
                gi.setDataEntradaSaida(dataEmissao);
                gi.setMovimentacaoFisica(item.getModeloFiscal().getMovimentacaoFisica());
                gi.setQuantidade(estD.getQuantidade());
                gi.setLoteFabricacao(((ItemReserva)estD.getEstoque().getSource()).getLoteFab());
                gi.setCentroEstoque(((ItemReserva)estD.getEstoque().getSource()).getCentroEstoque());
                gi.setEntradaSaida(natOp.getEntradaSaida());
                gi.setEmpresa(emp);
                gradesNF.add(gi);
            }
        }
    }

    private void definirGradesEstDisponivel(NaturezaOperacao natOp, ItemFaturamento item, CentroEstoque centroEstoque, Empresa empresa, Date dataEntradaSaida, List<GradeItemNotaFiscalPropria> gradesNF, OpcoesFaturamento opFat) throws ExceptionInvalidState {
        for (ItemGradeFaturamento grade : item.getGrades()) {
            this.definirGradesEstDisponivel(natOp, item, grade, centroEstoque, empresa, dataEntradaSaida, gradesNF, opFat);
        }
    }

    private void definirGradesEstDisponivel(NaturezaOperacao natOp, ItemFaturamento item, ItemGradeFaturamento grade, CentroEstoque centroEstoque, Empresa empresa, Date dataEntradaSaida, List<GradeItemNotaFiscalPropria> gradesNF, OpcoesFaturamento opFat) throws ExceptionInvalidState {
        ModeloFiscal m = item.getModeloFiscal();
        List<Object> saldos = new ArrayList();
        if (TMethods.isAffirmative((Number)m.getMovimentacaoFisica())) {
            saldos = this.getSaldosEstoque(dataEntradaSaida, grade.getGradeCor(), item.getProduto(), centroEstoque, empresa);
        }
        int i = 0;
        double qtdRemas = grade.getQuantidade();
        EnumConstOpEstoqueEstrategia estrategia = EnumConstOpEstoqueEstrategia.PEPS_MAIS_ANTIGO;
        if (!ToolMethods.isAffirmative((Number)opFat.getFaturamentoPeps())) {
            estrategia = EnumConstOpEstoqueEstrategia.MENOS_VARIACOES;
        }
        List saldosUtilizacao = this.compDispSaldo.getDisponibilidades(saldos, qtdRemas, grade.getGradeCor(), estrategia, CompEstoqueDisponibilidade.OpcaoSaldoParcial.SETAR_QTD_ULT_ITEM, CompEstoqueDisponibilidade.OpcaoTotalmenteSemSaldo.LISTA_EST_VAZIA);
        do {
            GradeItemNotaFiscalPropria gi = new GradeItemNotaFiscalPropria(grade.getGradeCor());
            gi.setDataEntradaSaida(dataEntradaSaida);
            gi.setMovimentacaoFisica(item.getModeloFiscal().getMovimentacaoFisica());
            gi.setEntradaSaida(natOp.getEntradaSaida());
            gi.setEmpresa(empresa);
            gi.setCentroEstoque(centroEstoque);
            gradesNF.add(gi);
            if (!saldosUtilizacao.isEmpty()) {
                EstoqueDisponivel est = saldosUtilizacao.get(i);
                gi.setQuantidade(est.getQuantidade());
                gi.setCentroEstoque(((SaldoEstoqueGeral)est.getEstoque().getSource()).getCentroEstoque());
                gi.setLoteFabricacao(((SaldoEstoqueGeral)est.getEstoque().getSource()).getLoteFabricacao());
                ++i;
                continue;
            }
            gi.setQuantidade(Double.valueOf(qtdRemas));
        } while (i < saldosUtilizacao.size());
    }

    private List<SaldoEstoqueGeral> getSaldosEstoque(Date dataEmissao, GradeCor gradeCor, Produto produto, CentroEstoque centroEstoque, Empresa empresa) {
        List<SaldoEstoqueGeral> aux = this.serviceSaldoEstoqueImpl.findSaldoGradeCentroEstoqueLoteLista(produto, produto, gradeCor, gradeCor, dataEmissao, empresa, empresa, null, centroEstoque, centroEstoque, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS, EnumConstCentroEstTipoPropTerc.get((Object)centroEstoque.getTipoEstProprioTerceiros()), null, EnumConstSaldoEstTipoSaldo.TIPO_SALDO_LOTE_FABRICACAO, EnumConstSaldoEstTipoSaldoQtde.TIPO_SALDO_QTQ_MAIOR_0, EnumConstSaldoEstTipoCarregQtdeVlr.TIPO_SALDO_QTQ_VLR_SOMENTE_QTD);
        return aux;
    }

    ItemFaturamento getItemFaturamento(final ItemPedido itemPedido) {
        final LinkedList<ItemGradeFaturamento> grades = new LinkedList<ItemGradeFaturamento>();
        for (GradeItemPedido gradeItemPedido : itemPedido.getGradeItemPedido()) {
            grades.add(this.getGradeItemFat(gradeItemPedido));
        }
        ItemFaturamento item = new ItemFaturamento(){

            @Override
            public Produto getProduto() {
                return itemPedido.getProduto();
            }

            @Override
            public ModeloFiscal getModeloFiscal() {
                return itemPedido.getModeloFiscal();
            }

            @Override
            public List<ItemGradeFaturamento> getGrades() {
                return grades;
            }
        };
        return item;
    }

    ItemGradeFaturamento getGradeItemFat(final GradeItemPedido gradeItemPedido) {
        ItemGradeFaturamento grade = new ItemGradeFaturamento(){

            @Override
            public GradeCor getGradeCor() {
                return gradeItemPedido.getGradeCor();
            }

            @Override
            public Double getQuantidade() {
                return gradeItemPedido.getQuantidade();
            }
        };
        return grade;
    }

    List<ItemReserva> buildReserva(List<TransferenciaCentroEstoque> transferencias) {
        LinkedList<ItemReserva> itensReservados = new LinkedList<ItemReserva>();
        for (TransferenciaCentroEstoque tr : transferencias) {
            for (ItemTransfCentroEstoque item : tr.getItemTransfCentroEstoque()) {
                for (GradeItemTransfCentroEstoque gr : item.getGradeItemTransCentroEst()) {
                    Optional<ItemReserva> found = itensReservados.stream().filter(i -> TMethods.isEquals((Object)i.loteFab, (Object)gr.getLoteFabricacao()) && TMethods.isEquals((Object)i.centroEstoque, (Object)gr.getDestino())).findFirst();
                    if (found.isPresent()) {
                        found.get().setQuantidade(found.get().getQuantidade() + gr.getQuantidade());
                        continue;
                    }
                    ItemReserva i2 = new ItemReserva(item.getProduto(), gr.getLoteFabricacao(), gr.getQuantidade(), gr.getDestino());
                    itensReservados.add(i2);
                }
            }
        }
        return itensReservados;
    }

    List<ItemReserva> buildReserva(ItemPedido itemPed) {
        LinkedList<ItemReserva> itensReservados = new LinkedList<ItemReserva>();
        for (GradeItemPedido tr : itemPed.getGradeItemPedido()) {
            for (GradeItemPedidoLoteFab gr : tr.getLotesFabricacao()) {
                Optional<ItemReserva> found = itensReservados.stream().filter(i -> TMethods.isEquals((Object)i.loteFab, (Object)gr.getLoteFabricacao())).findFirst();
                if (found.isPresent()) {
                    found.get().setQuantidade(found.get().getQuantidade() + gr.getQuantidade());
                    continue;
                }
                ItemReserva i2 = new ItemReserva(itemPed.getProduto(), gr.getLoteFabricacao(), gr.getQuantidade(), null);
                itensReservados.add(i2);
            }
        }
        return itensReservados;
    }

    List<ItemReserva> buildReserva(WmsSaidaEstoque wmsSaida) {
        if (wmsSaida.getTransfCentroEstocagem() != null) {
            return this.buildReserva(TMethods.toList((Object[])new Object[]{wmsSaida.getTransfCentroEstocagem()}));
        }
        LinkedList<ItemReserva> itensReservados = new LinkedList<ItemReserva>();
        for (WmsSaidaEstoqueItem item : wmsSaida.getItens()) {
            for (WmsSaidaEstoqueGrade gr : item.getGrades()) {
                Optional<ItemReserva> found = itensReservados.stream().filter(i -> TMethods.isEquals((Object)i.loteFab, (Object)gr.getLoteFabricacao())).findFirst();
                if (found.isPresent()) {
                    found.get().setQuantidade(found.get().getQuantidade() + gr.getQuantidade());
                    continue;
                }
                ItemReserva i2 = new ItemReserva(item.getProduto(), gr.getLoteFabricacao(), gr.getQuantidade(), gr.getWmsEndereco().getCentroEstoque());
                itensReservados.add(i2);
            }
        }
        return itensReservados;
    }

    public static interface ItemFaturamento {
        public Produto getProduto();

        public ModeloFiscal getModeloFiscal();

        public List<ItemGradeFaturamento> getGrades();
    }

    public static class ItemGradeFaturamentoImpl
    implements ItemGradeFaturamento {
        private GradeCor gradeCor;
        private Double quantidade = 0.0;

        @Override
        public GradeCor getGradeCor() {
            return this.gradeCor;
        }

        @Override
        public Double getQuantidade() {
            return this.quantidade;
        }
    }

    public static interface ItemGradeFaturamento {
        public GradeCor getGradeCor();

        public Double getQuantidade();
    }

    public static class ItemReserva
    implements InterfaceEstoqueDisp<ItemReserva> {
        private Produto produto;
        private LoteFabricacao loteFab;
        private Double quantidade;
        private CentroEstoque centroEstoque;

        public ItemReserva(Produto produto, LoteFabricacao loteFab, Double quantidade, CentroEstoque centroEstoque) {
            this.produto = produto;
            this.loteFab = loteFab;
            this.quantidade = quantidade;
            this.centroEstoque = centroEstoque;
        }

        public Produto getProduto() {
            return this.produto;
        }

        public void setProduto(Produto produto) {
            this.produto = produto;
        }

        public LoteFabricacao getLoteFab() {
            return this.loteFab;
        }

        public void setLoteFab(LoteFabricacao loteFab) {
            this.loteFab = loteFab;
        }

        public Double getQuantidade() {
            return this.quantidade;
        }

        public void setQuantidade(Double quantidade) {
            this.quantidade = quantidade;
        }

        public CentroEstoque getCentroEstoque() {
            return this.centroEstoque;
        }

        public void setCentroEstoque(CentroEstoque centroEstoque) {
            this.centroEstoque = centroEstoque;
        }

        public ItemReserva getSource() {
            return this;
        }

        public Double getQuantidadeAvaliacao() {
            return this.getQuantidade();
        }

        public Date getDataAvaliacao() {
            return this.loteFab != null && this.loteFab.getDataFabricacao() != null ? this.loteFab.getDataFabricacao() : new Date();
        }

        public void setQuantidadeAvaliacao(Double aValue) {
            this.setQuantidade(aValue);
        }
    }
}

