/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.notapropria;

import com.touchcomp.basementor.constants.enums.opcoesfaturamento.EnumConstOpFatTipoPesoNFe;
import com.touchcomp.basementor.constants.enums.opcoesfaturamento.EnumConstOpFatTipoQtdVolNFe;
import com.touchcomp.basementor.constants.enums.opcoesfaturamento.EnumConstOpFatTipoVolNFe;
import com.touchcomp.basementor.model.vo.EmbalagemExpedicao;
import com.touchcomp.basementor.model.vo.Expedicao;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemPedido;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.VolumeNFe;
import com.touchcomp.basementor.model.vo.WmsSeparacaoPedidoEmb;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.LinkedList;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class CompNotaPropriaVolumes {
    public void criarVolumesExpedicao(NotaFiscalPropria nota, Expedicao expedicao, OpcoesFaturamento opcoesFat) throws ExceptionInvalidData {
        if (TMethods.isNull((Object)opcoesFat.getTipoEmbalagemVolNFe()).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.0228.005", new Object[]{opcoesFat});
        }
        nota.getVolumes().clear();
        this.definirEmbalagens(nota, expedicao, opcoesFat);
        this.definirQtdVolumes(nota, expedicao, opcoesFat);
        this.definirPesoVolume(nota, expedicao, opcoesFat);
        nota.getVolumes().forEach(v -> v.setNotaFiscalPropria(nota));
    }

    private void criarQtdConfPedido(NotaFiscalPropria nota, Expedicao expedicao) {
        int nrVolumesTotal = 0;
        for (ItemPedido itemPedido : expedicao.getPedido().getItemPedido()) {
            nrVolumesTotal = (int)((double)nrVolumesTotal + itemPedido.getQuantidadeTotal());
        }
        int nrVolumesAux = nrVolumesTotal / nota.getVolumes().size();
        int total = 0;
        Object last = null;
        for (VolumeNFe volume : nota.getVolumes()) {
            volume.setQuantidade(Integer.valueOf(nrVolumesAux));
            total += nrVolumesAux;
        }
        if (last != null) {
            last.setQuantidade(Integer.valueOf(last.getQuantidade() + (nrVolumesTotal - total)));
        }
    }

    private void criarQtdConfPedidoVsVolume(NotaFiscalPropria nota, Expedicao expedicao) throws ExceptionInvalidData {
        int nrVolumesTotal = 0;
        for (ItemNotaFiscalPropria item : nota.getItensNotaPropria()) {
            if (item.getProduto().getQtdVolume() <= 0.0) {
                throw new ExceptionInvalidData("E.ERP.0228.004", new Object[]{item.getProduto()});
            }
            nrVolumesTotal = (int)((double)nrVolumesTotal + Math.ceil(item.getQuantidadeTotal() / item.getProduto().getQtdVolume()));
        }
        int nrVolumesAux = nrVolumesTotal / nota.getVolumes().size();
        int total = 0;
        Object last = null;
        for (VolumeNFe volume : nota.getVolumes()) {
            volume.setQuantidade(Integer.valueOf(nrVolumesAux));
            total += nrVolumesAux;
        }
        if (last != null) {
            last.setQuantidade(Integer.valueOf(last.getQuantidade() + (nrVolumesTotal - total)));
        }
    }

    private void definirEmbalagens(NotaFiscalPropria nota, Expedicao expedicao, OpcoesFaturamento opcoesFat) throws ExceptionInvalidData {
        if (TMethods.isNull((Object)opcoesFat.getTipoPesoExpedicaoVolNFe()).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.0228.001", new Object[]{nota, opcoesFat});
        }
        if (TMethods.isEquals((Object)opcoesFat.getTipoEmbalagemVolNFe(), (Object)EnumConstOpFatTipoVolNFe.TIPO_VOL_NFE_EMB_NAO_CRIAR.getValue())) {
            return;
        }
        if (TMethods.isEquals((Object)opcoesFat.getTipoEmbalagemVolNFe(), (Object)EnumConstOpFatTipoVolNFe.TIPO_VOL_NFE_EMB_UNICA.getValue())) {
            this.criarVolumeUnico(nota, expedicao, opcoesFat);
            return;
        }
        if (TMethods.isEquals((Object)opcoesFat.getTipoEmbalagemVolNFe(), (Object)EnumConstOpFatTipoVolNFe.TIPO_VOL_NFE_EMB_EXPEDICAO.getValue())) {
            this.criarVariosVolumesWms(nota, expedicao);
            return;
        }
    }

    private void criarVolumeUnico(NotaFiscalPropria nota, Expedicao expedicao, OpcoesFaturamento opFat) throws ExceptionInvalidData {
        if (opFat.getEmbalagem() == null) {
            throw new ExceptionInvalidData("E.ERP.0228.002", new Object[]{nota, opFat});
        }
        VolumeNFe v = new VolumeNFe();
        v.setEmbalagem(opFat.getEmbalagem());
        v.setNumeroVolume(Long.valueOf(1L));
        double pesoBrutoTotal = 0.0;
        double pesoLiquidoTotal = 0.0;
        for (ItemNotaFiscalPropria item : nota.getItensNotaPropria()) {
            double pesoLiquido = item.getQuantidadeTotal() * item.getProduto().getPesoUnitario();
            double pesoBruto = pesoLiquido + item.getProduto().getPesoEmbalagem() * item.getQuantidadeTotal();
            pesoLiquidoTotal += pesoLiquido;
            pesoBrutoTotal += pesoBruto;
        }
        v.setPesoBruto(Double.valueOf(pesoBrutoTotal));
        v.setPesoLiquido(Double.valueOf(pesoLiquidoTotal));
        if (expedicao.getWmsPedido() != null && expedicao.getWmsPedido().getWmsSeparacaoPedido() != null) {
            v.setQuantidade(Integer.valueOf(expedicao.getWmsPedido().getWmsSeparacaoPedido().getEmbalagens().size()));
        } else {
            v.setQuantidade(Integer.valueOf(expedicao.getEmbalagemExpedicao().size()));
        }
        if (TMethods.isEquals((Object)opFat.getTipoPesoExpedicaoVolNFe(), (Object)EnumConstOpFatTipoPesoNFe.TIPO_VOL_NFE_PESO_EXPEDICAO.getValue())) {
            v.setPesoBruto(this.getPesoBrutoExpedicaoPedido(expedicao, v));
        } else {
            v.setPesoBruto(Double.valueOf(v.getPesoLiquido() + v.getEmbalagem().getPeso()));
        }
        v.setNotaFiscalPropria(nota);
        nota.getVolumes().add(v);
    }

    private Double getPesoBrutoExpedicaoPedido(Expedicao expedicao, VolumeNFe v) {
        Double pesoBruto = 0.0;
        for (EmbalagemExpedicao em : expedicao.getEmbalagemExpedicao()) {
            pesoBruto = pesoBruto + (em.getPesoBruto() - em.getPesoLiquido());
        }
        return pesoBruto + expedicao.getPedido().getPesoTotal();
    }

    private void criarVariosVolumesWms(NotaFiscalPropria nota, Expedicao expedicao) throws ExceptionInvalidData {
        LinkedList<VolumeNFe> vols = new LinkedList<VolumeNFe>();
        long nrEm = 1L;
        if (expedicao.getEmbalagemExpedicao().size() > 0) {
            for (EmbalagemExpedicao em : expedicao.getEmbalagemExpedicao()) {
                VolumeNFe vol;
                Optional<VolumeNFe> found = vols.stream().filter(i -> TMethods.isEquals((Object)i.getEmbalagem(), (Object)em.getEmbalagem())).findFirst();
                if (found.isPresent()) {
                    vol = found.get();
                } else {
                    vol = new VolumeNFe();
                    vol.setEmbalagem(em.getEmbalagem());
                    vol.setNumeroVolume(Long.valueOf(nrEm));
                    vols.add(vol);
                    ++nrEm;
                }
                vol.setPesoBruto(Double.valueOf(vol.getPesoBruto() + em.getPesoBruto()));
                vol.setPesoLiquido(Double.valueOf(vol.getPesoLiquido() + em.getPesoLiquido()));
                vol.setQuantidade(Integer.valueOf(vol.getQuantidade() + 1));
            }
        } else if (expedicao.getWmsPedido() != null) {
            if (TMethods.isNull((Object)expedicao.getWmsPedido().getWmsSeparacaoPedido()).booleanValue()) {
                throw new ExceptionInvalidData("E.ERP.0228.006", new Object[]{nota});
            }
            if (TMethods.isNull((Object)expedicao.getWmsPedido().getWmsSeparacaoPedido().getWmsSaidaEstoque()).booleanValue()) {
                throw new ExceptionInvalidData("E.ERP.0228.006", new Object[]{nota});
            }
            for (WmsSeparacaoPedidoEmb em : expedicao.getWmsPedido().getWmsSeparacaoPedido().getEmbalagens()) {
                VolumeNFe vol;
                Optional<VolumeNFe> found = vols.stream().filter(i -> TMethods.isEquals((Object)i.getEmbalagem(), (Object)em.getEmbalagem())).findFirst();
                if (found.isPresent()) {
                    vol = found.get();
                } else {
                    vol = new VolumeNFe();
                    vol.setEmbalagem(em.getEmbalagem());
                    vol.setNumeroVolume(Long.valueOf(nrEm));
                    vols.add(vol);
                    ++nrEm;
                }
                vol.setPesoLiquido(Double.valueOf(vol.getPesoLiquido() + em.getPesoUtilizado()));
                vol.setPesoBruto(Double.valueOf(vol.getPesoBruto() + em.getPesoUtilizado() + em.getEmbalagem().getPeso()));
                vol.setQuantidade(Integer.valueOf(vol.getQuantidade() + 1));
            }
        }
        nota.setVolumes(vols);
        if (nota.getVolumes().size() == 0) {
            throw new ExceptionInvalidData("E.ERP.0228.003", new Object[]{nota});
        }
    }

    private void definirQtdVolumes(NotaFiscalPropria nota, Expedicao expedicao, OpcoesFaturamento opcoesFat) throws ExceptionInvalidData {
        if (nota.getVolumes().isEmpty()) {
            return;
        }
        if (TMethods.isEquals((Object)opcoesFat.getTipoQtdVolExpedicaoVolNFe(), (Object)EnumConstOpFatTipoQtdVolNFe.TIPO_VOL_NFE_QTD_VOL_UNICO.getValue())) {
            nota.getVolumes().forEach(i -> i.setQuantidade(Integer.valueOf(1)));
            return;
        }
        if (TMethods.isEquals((Object)opcoesFat.getTipoQtdVolExpedicaoVolNFe(), (Object)EnumConstOpFatTipoQtdVolNFe.TIPO_VOL_NFE_QTD_VOL_EXPEDICAO.getValue())) {
            return;
        }
        if (TMethods.isEquals((Object)opcoesFat.getTipoQtdVolExpedicaoVolNFe(), (Object)EnumConstOpFatTipoQtdVolNFe.TIPO_VOL_NFE_QTD_VOL_ITENS_PEDIDO.getValue())) {
            this.criarQtdConfPedido(nota, expedicao);
            return;
        }
        if (TMethods.isEquals((Object)opcoesFat.getTipoQtdVolExpedicaoVolNFe(), (Object)EnumConstOpFatTipoQtdVolNFe.TIPO_VOL_NFE_QTD_VOL_ITENS_PEDIDO_VS_QTD_VOL_PROD.getValue())) {
            this.criarQtdConfPedidoVsVolume(nota, expedicao);
            return;
        }
    }

    private void definirPesoVolume(NotaFiscalPropria nota, Expedicao expedicao, OpcoesFaturamento opcoesFat) {
        if (nota.getVolumes().isEmpty()) {
            return;
        }
        if (TMethods.isEquals((Object)opcoesFat.getTipoPesoExpedicaoVolNFe(), (Object)EnumConstOpFatTipoPesoNFe.TIPO_VOL_NFE_PESO_EXPEDICAO.getValue())) {
            return;
        }
        if (TMethods.isEquals((Object)opcoesFat.getTipoPesoExpedicaoVolNFe(), (Object)EnumConstOpFatTipoPesoNFe.TIPO_VOL_NFE_PESO_PEDIDO.getValue())) {
            double pesoBrutoTotal = 0.0;
            double pesoLiquidoTotal = 0.0;
            double pesoBrutoTotalDist = 0.0;
            double pesoLiquidoTotalDist = 0.0;
            for (ItemNotaFiscalPropria item : nota.getItensNotaPropria()) {
                double pesoLiquido = item.getQuantidadeTotal() * item.getProduto().getPesoUnitario();
                double pesoBruto = pesoLiquido + item.getProduto().getPesoEmbalagem() * item.getQuantidadeTotal();
                pesoLiquidoTotal += pesoLiquido;
                pesoBrutoTotal += pesoBruto;
            }
            int nrVolumes = nota.getVolumes().size();
            VolumeNFe last = null;
            for (VolumeNFe volume : nota.getVolumes()) {
                volume.setPesoLiquido(ToolFormatter.arrredondarNumero((Double)(pesoLiquidoTotal / (double)nrVolumes), (int)2));
                volume.setPesoBruto(ToolFormatter.arrredondarNumero((Double)(pesoBrutoTotal / (double)nrVolumes), (int)2));
                pesoBrutoTotalDist += volume.getPesoBruto().doubleValue();
                pesoLiquidoTotalDist += volume.getPesoLiquido().doubleValue();
                last = volume;
            }
            if (last != null) {
                last.setPesoBruto(Double.valueOf(last.getPesoBruto() + (pesoBrutoTotal - pesoBrutoTotalDist)));
                last.setPesoLiquido(Double.valueOf(last.getPesoLiquido() + (pesoLiquidoTotal - pesoLiquidoTotalDist)));
            }
            for (VolumeNFe volume : nota.getVolumes()) {
                volume.setPesoBruto(Double.valueOf(volume.getPesoBruto() + volume.getEmbalagem().getPeso() * (double)volume.getQuantidade().intValue()));
            }
            return;
        }
    }
}

