/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.notaterceiros.avaliacaocriticasnfterceiros;

import com.touchcomp.basementor.constants.enums.configservicos.impl.ConstantsAvaliacaoCriticaNFTerc;
import com.touchcomp.basementor.constants.enums.mensagemmuralusuario.EnumConstMensagemChaveMural;
import com.touchcomp.basementor.model.vo.Cidade;
import com.touchcomp.basementor.model.vo.ConfigServicos;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.MensagemMural;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.Pais;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementorclientwebservices.cte.model.env.CTNota;
import com.touchcomp.basementorclientwebservices.nfe.model.env.nfe.NFeNotaFiscalPropria;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.components.notaterceiros.avaliacaocriticasnfterceiros.AuxBaseAvalia;
import com.touchcomp.basementorservice.components.obsdinamica.CompOBSDinamica;
import com.touchcomp.basementorservice.helpers.impl.configservicos.HelperConfigServicos;
import com.touchcomp.basementorservice.helpers.impl.mensagemmural.HelperMensagemMural;
import com.touchcomp.basementorservice.service.impl.mensagemmural.ServiceMensagemMuralImpl;
import com.touchcomp.basementorservice.service.impl.objectobsdinamica.ServiceObjectObsDinamicaImpl;
import com.touchcomp.basementorservice.service.impl.prioridademarketing.ServicePrioridadeMarketingImpl;
import com.touchcomp.basementorservice.service.impl.usuario.ServiceUsuarioImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.List;

class AuxAvaliaEndereco
extends AuxBaseAvalia {
    final HelperMensagemMural helperMsgUsuarios;

    public AuxAvaliaEndereco(HelperConfigServicos helperConfigServicos, HelperMensagemMural helperTarefasUsuarios, ServicePrioridadeMarketingImpl servicePrioridadeMarketing, ServiceUsuarioImpl serviceUsuario, ServiceObjectObsDinamicaImpl serviceObjectObsDinamicaImpl, CompOBSDinamica compObsDinamica, ServiceMensagemMuralImpl serviceMensagemMuralImpl) {
        super(servicePrioridadeMarketing, serviceUsuario, helperConfigServicos, serviceMensagemMuralImpl, serviceObjectObsDinamicaImpl, compObsDinamica);
        this.helperMsgUsuarios = helperTarefasUsuarios;
    }

    public List<MensagemMural> avaliarDadosEndereco(NotaFiscalTerceiros nf, CTNota ctNota, ConfigServicos configServicos) throws ExceptionInvalidData {
        this.mensagensMural.clear();
        if (ctNota.getEmitente() == null || ctNota.getEmitente().getEndereco() == null) {
            return this.mensagensMural;
        }
        this.helperConfigServicos.build(configServicos);
        Endereco end = nf.getUnidadeFatFornecedor().getPessoa().getEndereco();
        this.avaliarUFSigla(nf, end.getCidade().getUf(), ctNota.getEmitente().getEndereco().getSiglaUF());
        this.avaliarCidade(nf, end.getCidade(), ctNota.getEmitente().getEndereco().getCodigoMunicipio());
        this.avaliarLogradouro(nf, end, ctNota.getEmitente().getEndereco().getLogradouro());
        this.avaliarBairro(nf, end, ctNota.getEmitente().getEndereco().getBairro());
        this.avaliarNumero(nf, end, ctNota.getEmitente().getEndereco().getNumero());
        this.avaliarComplemento(nf, end, ctNota.getEmitente().getEndereco().getComplemento());
        this.avaliarCep(nf, end, ctNota.getEmitente().getEndereco().getCep());
        return this.mensagensMural;
    }

    public List<MensagemMural> avaliarDadosEndereco(NotaFiscalTerceiros nf, NFeNotaFiscalPropria nfNota, ConfigServicos configServicos) throws ExceptionInvalidData {
        if (nfNota.getEmitente() == null || nfNota.getEmitente().getEndereco() == null) {
            return this.mensagensMural;
        }
        this.helperConfigServicos.build(configServicos);
        Endereco end = nf.getUnidadeFatFornecedor().getPessoa().getEndereco();
        this.avaliarPais(nf, end.getCidade().getUf().getPais(), nfNota.getEmitente().getEndereco().getCodigoPais());
        this.avaliarUF(nf, end.getCidade().getUf(), nfNota.getEmitente().getEndereco().getCodigoUF());
        this.avaliarCidade(nf, end.getCidade(), nfNota.getEmitente().getEndereco().getCodigoMunicipio());
        this.avaliarLogradouro(nf, end, nfNota.getEmitente().getEndereco().getLogradouro());
        this.avaliarBairro(nf, end, nfNota.getEmitente().getEndereco().getBairro());
        this.avaliarCep(nf, end, nfNota.getEmitente().getEndereco().getCep());
        this.avaliarNumero(nf, end, nfNota.getEmitente().getEndereco().getNumero());
        this.avaliarComplemento(nf, end, nfNota.getEmitente().getEndereco().getComplemento());
        return this.mensagensMural;
    }

    private void avaliarPais(NotaFiscalTerceiros nf, Pais pais, String codIBGEPais) throws ExceptionInvalidData {
        boolean ret = this.helperConfigServicos.getValueAsBoolean(ConstantsAvaliacaoCriticaNFTerc.AVALIAR_PAIS.getChave());
        if (!ret) {
            return;
        }
        if (ToolMethods.isEquals((Object)pais.getCodIbge(), (Object)codIBGEPais)) {
            return;
        }
        String chavePais = "001";
        String chave = EnumConstMensagemChaveMural.CHAVE_MSG_CRITICA_NF_TERC_END_MURAL.getValue() + "." + chavePais + "." + nf.getUnidadeFatFornecedor().getPessoa().getComplemento().getCnpj();
        String message = this.getMessage(this.helperConfigServicos.getValue(ConstantsAvaliacaoCriticaNFTerc.MSG_AVALIAR_PAIS.getChave()), nf, "msg_inconsistencia_nf_terc_pais", nf.getUnidadeFatFornecedor().getPessoa().getComplemento().getCnpj(), pais.getCodIbge(), codIBGEPais, nf.getSerie(), nf.getNumeroNota(), nf.getEmpresa());
        String chaveTitle = ConstantsAvaliacaoCriticaNFTerc.TITLE_AVALIAR_PAIS.getChave();
        String title = this.getMessageTitle(this.helperConfigServicos.getValue(chaveTitle), chaveTitle);
        this.addMsg(this.helperMsgUsuarios.novaMsgCriticaNFTerc(nf, this.getUsuarioResponsavel(), this.getPrioridadeMarketing(), chave, message, title, EnumConstMensagemChaveMural.CHAVE_MSG_CRITICA_NF_TERC_END_MURAL));
    }

    private void avaliarUF(NotaFiscalTerceiros nf, UnidadeFederativa uf, String siglaUF) throws ExceptionInvalidData {
        boolean ret = this.helperConfigServicos.getValueAsBoolean(ConstantsAvaliacaoCriticaNFTerc.AVALIAR_UF.getChave());
        if (!ret) {
            return;
        }
        if (ToolMethods.isEquals((Object)uf.getSigla(), (Object)siglaUF)) {
            return;
        }
        String chaveUF = "002";
        String chave = EnumConstMensagemChaveMural.CHAVE_MSG_CRITICA_NF_TERC_END_MURAL.getValue() + "." + chaveUF + "." + nf.getUnidadeFatFornecedor().getPessoa().getComplemento().getCnpj();
        String message = this.getMessage(this.helperConfigServicos.getValue(ConstantsAvaliacaoCriticaNFTerc.MSG_AVALIAR_UF.getChave()), nf, "msg_inconsistencia_nf_terc_uf", nf.getUnidadeFatFornecedor().getPessoa().getComplemento().getCnpj(), uf.getCodIbge(), siglaUF, nf.getSerie(), nf.getNumeroNota(), nf.getEmpresa());
        String chaveTitle = ConstantsAvaliacaoCriticaNFTerc.TITLE_AVALIAR_UF.getChave();
        String title = this.getMessageTitle(this.helperConfigServicos.getValue(chaveTitle), chaveTitle);
        this.addMsg(this.helperMsgUsuarios.novaMsgCriticaNFTerc(nf, this.getUsuarioResponsavel(), this.getPrioridadeMarketing(), chave, message, title, EnumConstMensagemChaveMural.CHAVE_MSG_CRITICA_NF_TERC_END_MURAL));
    }

    private void avaliarUFSigla(NotaFiscalTerceiros nf, UnidadeFederativa uf, String sigla) throws ExceptionInvalidData {
        boolean ret = this.helperConfigServicos.getValueAsBoolean(ConstantsAvaliacaoCriticaNFTerc.AVALIAR_UF.getChave());
        if (!ret) {
            return;
        }
        if (ToolMethods.isEquals((Object)uf.getSigla(), (Object)sigla)) {
            return;
        }
        String chaveUF = "002";
        String chave = EnumConstMensagemChaveMural.CHAVE_MSG_CRITICA_NF_TERC_END_MURAL.getValue() + "." + chaveUF + "." + nf.getUnidadeFatFornecedor().getPessoa().getComplemento().getCnpj();
        String message = this.getMessage(this.helperConfigServicos.getValue(ConstantsAvaliacaoCriticaNFTerc.MSG_AVALIAR_UF.getChave()), nf, "msg_inconsistencia_nf_terc_uf", nf.getUnidadeFatFornecedor().getPessoa().getComplemento().getCnpj(), uf.getSigla(), sigla, nf.getSerie(), nf.getNumeroNota(), nf.getEmpresa());
        String chaveTitle = ConstantsAvaliacaoCriticaNFTerc.TITLE_AVALIAR_UF.getChave();
        String title = this.getMessageTitle(this.helperConfigServicos.getValue(chaveTitle), chaveTitle);
        this.addMsg(this.helperMsgUsuarios.novaMsgCriticaNFTerc(nf, this.getUsuarioResponsavel(), this.getPrioridadeMarketing(), chave, message, title, EnumConstMensagemChaveMural.CHAVE_MSG_CRITICA_NF_TERC_END_MURAL));
    }

    private void avaliarCidade(NotaFiscalTerceiros nf, Cidade cidade, String codIBGECidade) throws ExceptionInvalidData {
        boolean ret = this.helperConfigServicos.getValueAsBoolean(ConstantsAvaliacaoCriticaNFTerc.AVALIAR_CIDADE.getChave());
        if (!ret) {
            return;
        }
        if (ToolMethods.isEquals((Object)cidade.getCodIbgeCompleto(), (Object)codIBGECidade)) {
            return;
        }
        String chaveCidade = "004";
        String chave = EnumConstMensagemChaveMural.CHAVE_MSG_CRITICA_NF_TERC_END_MURAL.getValue() + "." + chaveCidade + "." + nf.getUnidadeFatFornecedor().getPessoa().getComplemento().getCnpj();
        String message = this.getMessage(this.helperConfigServicos.getValue(ConstantsAvaliacaoCriticaNFTerc.MSG_AVALIAR_CIDADE.getChave()), nf, "msg_inconsistencia_nf_terc_cidade", nf.getUnidadeFatFornecedor().getPessoa().getComplemento().getCnpj(), cidade.getCodIbge(), codIBGECidade, nf.getSerie(), nf.getNumeroNota(), nf.getEmpresa());
        String chaveTitle = ConstantsAvaliacaoCriticaNFTerc.TITLE_AVALIAR_CIDADE.getChave();
        String title = this.getMessageTitle(this.helperConfigServicos.getValue(chaveTitle), chaveTitle);
        this.addMsg(this.helperMsgUsuarios.novaMsgCriticaNFTerc(nf, this.getUsuarioResponsavel(), this.getPrioridadeMarketing(), chave, message, title, EnumConstMensagemChaveMural.CHAVE_MSG_CRITICA_NF_TERC_END_MURAL));
    }

    private void avaliarLogradouro(NotaFiscalTerceiros nf, Endereco endereco, String logradouro) throws ExceptionInvalidData {
        boolean ret = this.helperConfigServicos.getValueAsBoolean(ConstantsAvaliacaoCriticaNFTerc.AVALIAR_LOGRADOURO.getChave());
        if (!ret) {
            return;
        }
        if (this.isStrSimilar(endereco.getLogradouro(), logradouro)) {
            return;
        }
        String chaveLogradouro = "005";
        String chave = EnumConstMensagemChaveMural.CHAVE_MSG_CRITICA_NF_TERC_END_MURAL.getValue() + "." + chaveLogradouro + "." + nf.getUnidadeFatFornecedor().getPessoa().getComplemento().getCnpj();
        String message = this.getMessage(this.helperConfigServicos.getValue(ConstantsAvaliacaoCriticaNFTerc.MSG_AVALIAR_LOGRADOURO.getChave()), nf, "msg_inconsistencia_nf_terc_logradouro", nf.getUnidadeFatFornecedor().getPessoa().getComplemento().getCnpj(), endereco.getLogradouro(), logradouro, nf.getSerie(), nf.getNumeroNota(), nf.getEmpresa());
        String chaveTitle = ConstantsAvaliacaoCriticaNFTerc.TITLE_AVALIAR_LOGRADOURO.getChave();
        String title = this.getMessageTitle(this.helperConfigServicos.getValue(chaveTitle), chaveTitle);
        this.addMsg(this.helperMsgUsuarios.novaMsgCriticaNFTerc(nf, this.getUsuarioResponsavel(), this.getPrioridadeMarketing(), chave, message, title, EnumConstMensagemChaveMural.CHAVE_MSG_CRITICA_NF_TERC_END_MURAL));
    }

    private void avaliarBairro(NotaFiscalTerceiros nf, Endereco endereco, String bairro) throws ExceptionInvalidData {
        boolean ret = this.helperConfigServicos.getValueAsBoolean(ConstantsAvaliacaoCriticaNFTerc.AVALIAR_BAIRRO.getChave());
        if (!ret) {
            return;
        }
        if (this.isStrSimilar(endereco.getBairro(), bairro)) {
            return;
        }
        String chaveBairro = "006";
        String chave = EnumConstMensagemChaveMural.CHAVE_MSG_CRITICA_NF_TERC_END_MURAL.getValue() + "." + chaveBairro + "." + nf.getUnidadeFatFornecedor().getPessoa().getComplemento().getCnpj();
        String message = this.getMessage(this.helperConfigServicos.getValue(ConstantsAvaliacaoCriticaNFTerc.MSG_AVALIAR_BAIRRO.getChave()), nf, "msg_inconsistencia_nf_terc_bairro", nf.getUnidadeFatFornecedor().getPessoa().getComplemento().getCnpj(), endereco.getBairro(), bairro, nf.getSerie(), nf.getNumeroNota(), nf.getEmpresa());
        String chaveTitle = ConstantsAvaliacaoCriticaNFTerc.TITLE_AVALIAR_BAIRRO.getChave();
        String title = this.getMessageTitle(this.helperConfigServicos.getValue(chaveTitle), chaveTitle);
        this.addMsg(this.helperMsgUsuarios.novaMsgCriticaNFTerc(nf, this.getUsuarioResponsavel(), this.getPrioridadeMarketing(), chave, message, title, EnumConstMensagemChaveMural.CHAVE_MSG_CRITICA_NF_TERC_END_MURAL));
    }

    private void avaliarNumero(NotaFiscalTerceiros nf, Endereco endereco, String numero) throws ExceptionInvalidData {
        boolean ret = this.helperConfigServicos.getValueAsBoolean(ConstantsAvaliacaoCriticaNFTerc.AVALIAR_NUMERO.getChave());
        if (!ret) {
            return;
        }
        if (this.isStrSimilar(endereco.getNumero(), numero)) {
            return;
        }
        String chaveNumero = "007";
        String chave = EnumConstMensagemChaveMural.CHAVE_MSG_CRITICA_NF_TERC_END_MURAL.getValue() + "." + chaveNumero + "." + nf.getUnidadeFatFornecedor().getPessoa().getComplemento().getCnpj();
        String message = this.getMessage(this.helperConfigServicos.getValue(ConstantsAvaliacaoCriticaNFTerc.MSG_AVALIAR_NUMERO.getChave()), nf, "msg_inconsistencia_nf_terc_numero", nf.getUnidadeFatFornecedor().getPessoa().getComplemento().getCnpj(), endereco.getNumero(), numero, nf.getSerie(), nf.getNumeroNota(), nf.getEmpresa());
        String chaveTitle = ConstantsAvaliacaoCriticaNFTerc.TITLE_AVALIAR_NUMERO.getChave();
        String title = this.getMessageTitle(this.helperConfigServicos.getValue(chaveTitle), chaveTitle);
        this.addMsg(this.helperMsgUsuarios.novaMsgCriticaNFTerc(nf, this.getUsuarioResponsavel(), this.getPrioridadeMarketing(), chave, message, title, EnumConstMensagemChaveMural.CHAVE_MSG_CRITICA_NF_TERC_END_MURAL));
    }

    private void avaliarComplemento(NotaFiscalTerceiros nf, Endereco endereco, String complemento) throws ExceptionInvalidData {
        boolean ret = this.helperConfigServicos.getValueAsBoolean(ConstantsAvaliacaoCriticaNFTerc.AVALIAR_COMPLEMENTO.getChave());
        if (!ret) {
            return;
        }
        if (this.isStrSimilar(endereco.getComplemento(), complemento)) {
            return;
        }
        String chaveComplemento = "008";
        String chave = EnumConstMensagemChaveMural.CHAVE_MSG_CRITICA_NF_TERC_END_MURAL.getValue() + "." + chaveComplemento + "." + nf.getUnidadeFatFornecedor().getPessoa().getComplemento().getCnpj();
        String message = this.getMessage(this.helperConfigServicos.getValue(ConstantsAvaliacaoCriticaNFTerc.MSG_AVALIAR_COMPLEMENTO.getChave()), nf, "msg_inconsistencia_nf_terc_complemento", nf.getUnidadeFatFornecedor().getPessoa().getComplemento().getCnpj(), endereco.getComplemento(), complemento, nf.getSerie(), nf.getNumeroNota(), nf.getEmpresa());
        String chaveTitle = ConstantsAvaliacaoCriticaNFTerc.TITLE_AVALIAR_COMPLEMENTO.getChave();
        String title = this.getMessageTitle(this.helperConfigServicos.getValue(chaveTitle), chaveTitle);
        this.addMsg(this.helperMsgUsuarios.novaMsgCriticaNFTerc(nf, this.getUsuarioResponsavel(), this.getPrioridadeMarketing(), chave, message, title, EnumConstMensagemChaveMural.CHAVE_MSG_CRITICA_NF_TERC_END_MURAL));
    }

    private void avaliarCep(NotaFiscalTerceiros nf, Endereco endereco, String cep) throws ExceptionInvalidData {
        boolean ret = this.helperConfigServicos.getValueAsBoolean(ConstantsAvaliacaoCriticaNFTerc.AVALIAR_CEP.getChave());
        if (!ret) {
            return;
        }
        if (ToolMethods.isEquals((Object)endereco.getCep(), (Object)cep)) {
            return;
        }
        String chaveCep = "009";
        String chave = EnumConstMensagemChaveMural.CHAVE_MSG_CRITICA_NF_TERC_END_MURAL.getValue() + "." + chaveCep + "." + nf.getUnidadeFatFornecedor().getPessoa().getComplemento().getCnpj();
        String message = this.getMessage(this.helperConfigServicos.getValue(ConstantsAvaliacaoCriticaNFTerc.MSG_AVALIAR_CEP.getChave()), nf, "msg_inconsistencia_nf_terc_cep", nf.getUnidadeFatFornecedor().getPessoa().getComplemento().getCnpj(), endereco.getCep(), cep, nf.getSerie(), nf.getNumeroNota(), nf.getEmpresa());
        String chaveTitle = ConstantsAvaliacaoCriticaNFTerc.TITLE_AVALIAR_CEP.getChave();
        String title = this.getMessageTitle(this.helperConfigServicos.getValue(chaveTitle), chaveTitle);
        this.addMsg(this.helperMsgUsuarios.novaMsgCriticaNFTerc(nf, this.getUsuarioResponsavel(), this.getPrioridadeMarketing(), chave, message, title, EnumConstMensagemChaveMural.CHAVE_MSG_CRITICA_NF_TERC_END_MURAL));
    }
}

