/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.notaterceiros.avaliacaocriticasnfterceiros;

import com.touchcomp.basementor.constants.enums.configservicos.impl.ConstantsAvaliacaoCriticaNFTerc;
import com.touchcomp.basementor.constants.enums.mensagemmuralusuario.EnumConstMensagemChaveMural;
import com.touchcomp.basementor.model.vo.ConfigServicos;
import com.touchcomp.basementor.model.vo.DeParaFornecedorItem;
import com.touchcomp.basementor.model.vo.ItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.MensagemMural;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementorclientwebservices.nfe.model.env.nfe.NFeNotaFiscalPropria;
import com.touchcomp.basementorclientwebservices.nfe.model.env.nfe.NFeNotaFiscalPropriaItem;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.components.notaterceiros.avaliacaocriticasnfterceiros.AuxBaseAvalia;
import com.touchcomp.basementorservice.components.obsdinamica.CompOBSDinamica;
import com.touchcomp.basementorservice.helpers.impl.configservicos.HelperConfigServicos;
import com.touchcomp.basementorservice.helpers.impl.mensagemmural.HelperMensagemMural;
import com.touchcomp.basementorservice.service.impl.mensagemmural.ServiceMensagemMuralImpl;
import com.touchcomp.basementorservice.service.impl.objectobsdinamica.ServiceObjectObsDinamicaImpl;
import com.touchcomp.basementorservice.service.impl.prioridademarketing.ServicePrioridadeMarketingImpl;
import com.touchcomp.basementorservice.service.impl.usuario.ServiceUsuarioImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.List;
import java.util.Optional;

class AuxAvaliaNCMCEST
extends AuxBaseAvalia {
    final HelperMensagemMural helperMsgUsuarios;

    public AuxAvaliaNCMCEST(HelperConfigServicos helperConfigServicos, HelperMensagemMural helperTarefasUsuarios, ServicePrioridadeMarketingImpl servicePrioridadeMarketing, ServiceUsuarioImpl serviceUsuario, ServiceObjectObsDinamicaImpl serviceObjectObsDinamicaImpl, CompOBSDinamica compObsDinamica, ServiceMensagemMuralImpl serviceMensagemMuralImpl) {
        super(servicePrioridadeMarketing, serviceUsuario, helperConfigServicos, serviceMensagemMuralImpl, serviceObjectObsDinamicaImpl, compObsDinamica);
        this.helperMsgUsuarios = helperTarefasUsuarios;
    }

    List<MensagemMural> avaliarProdutos(NotaFiscalTerceiros nf, NFeNotaFiscalPropria nfNota, List<DeParaFornecedorItem> dados, ConfigServicos configServicos) throws ExceptionInvalidData {
        this.mensagensMural.clear();
        this.helperConfigServicos.build(configServicos);
        for (DeParaFornecedorItem item : dados) {
            Optional<ItemNotaTerceiros> foundItemNotaTerc = nf.getItemNotaTerceiros().stream().filter(i -> ToolMethods.isEquals((Object)i.getProduto().getIdentificador(), (Object)item.getProdutoEntrada().getIdentificador())).findFirst();
            Optional<NFeNotaFiscalPropriaItem> foundNFItem = nfNota.getItens().stream().filter(i -> ToolMethods.isEquals((Object)i.getProduto().getCodigo(), (Object)item.getCodigo())).findFirst();
            this.compareNCMsCESTs(nf, foundItemNotaTerc, foundNFItem);
        }
        return this.mensagensMural;
    }

    private void compareNCMsCESTs(NotaFiscalTerceiros nf, Optional<ItemNotaTerceiros> foundItemNotaTerc, Optional<NFeNotaFiscalPropriaItem> foundNFItem) throws ExceptionInvalidData {
        if (!foundItemNotaTerc.isPresent()) {
            return;
        }
        if (!foundNFItem.isPresent()) {
            return;
        }
        String ncm1 = "";
        if (foundItemNotaTerc.get().getNcm() != null) {
            ncm1 = foundItemNotaTerc.get().getNcm().getCodigo();
        }
        String ncm2 = foundNFItem.get().getProduto().getNcm();
        this.gerarMsgNCM(nf, foundItemNotaTerc.get().getProduto(), ncm1, ncm2);
        String cest1 = "";
        if (foundItemNotaTerc.get().getCest() != null) {
            cest1 = foundItemNotaTerc.get().getCest().getCodigo();
        }
        String cest2 = foundNFItem.get().getProduto().getCodigoEspecificadorSituacaoTributaria();
        this.gerarMsgCEST(nf, foundItemNotaTerc.get().getProduto(), cest1, cest2);
    }

    private void gerarMsgNCM(NotaFiscalTerceiros nf, Produto produto, String ncm1, String ncm2) throws ExceptionInvalidData {
        boolean ret = this.helperConfigServicos.getValueAsBoolean(ConstantsAvaliacaoCriticaNFTerc.AVALIAR_NCM_PRODUTOS.getChave());
        if (!ret) {
            return;
        }
        if (this.isEquals(ncm1, ncm2)) {
            return;
        }
        String chaveNCM = "001";
        String chave = EnumConstMensagemChaveMural.CHAVE_MSG_CRITICA_NF_TERC_NCM_MURAL.getValue() + "." + chaveNCM + "." + nf.getUnidadeFatFornecedor().getPessoa().getComplemento().getCnpj() + "." + produto.getIdentificador();
        String message = this.getMessage(this.helperConfigServicos.getValue(ConstantsAvaliacaoCriticaNFTerc.MSG_AVALIAR_NCM_PRODUTOS.getChave()), nf, "msg_inconsistencia_nf_terc_ncm", nf.getUnidadeFatFornecedor().getPessoa().getComplemento().getCnpj(), produto, ncm1, ncm2, nf.getSerie(), nf.getNumeroNota(), nf.getEmpresa());
        String chaveTitle = ConstantsAvaliacaoCriticaNFTerc.TITLE_AVALIAR_NCM_PRODUTOS.getChave();
        String title = this.getMessageTitle(this.helperConfigServicos.getValue(chaveTitle), chaveTitle);
        this.addMsg(this.helperMsgUsuarios.novaMsgCriticaNFTerc(nf, this.getUsuarioResponsavel(), this.getPrioridadeMarketing(), chave, message, title, EnumConstMensagemChaveMural.CHAVE_MSG_CRITICA_NF_TERC_NCM_MURAL));
    }

    private void gerarMsgCEST(NotaFiscalTerceiros nf, Produto produto, String cest1, String cest2) throws ExceptionInvalidData {
        boolean ret = this.helperConfigServicos.getValueAsBoolean(ConstantsAvaliacaoCriticaNFTerc.AVALIAR_CEST.getChave());
        if (!ret) {
            return;
        }
        if (this.isEquals(cest1, cest2)) {
            return;
        }
        String chaveCEST = "002";
        String chave = EnumConstMensagemChaveMural.CHAVE_MSG_CRITICA_NF_TERC_CEST_MURAL.getValue() + "." + chaveCEST + "." + nf.getUnidadeFatFornecedor().getPessoa().getComplemento().getCnpj() + "." + produto.getIdentificador();
        String message = this.getMessage(this.helperConfigServicos.getValue(ConstantsAvaliacaoCriticaNFTerc.MSG_AVALIAR_CEST.getChave()), nf, "msg_inconsistencia_nf_terc_cest", nf.getUnidadeFatFornecedor().getPessoa().getComplemento().getCnpj(), produto, cest1, cest2, nf.getSerie(), nf.getNumeroNota(), nf.getEmpresa());
        String chaveTitle = ConstantsAvaliacaoCriticaNFTerc.TITLE_AVALIAR_CEST.getChave();
        String title = this.getMessageTitle(this.helperConfigServicos.getValue(chaveTitle), chaveTitle);
        this.addMsg(this.helperMsgUsuarios.novaMsgCriticaNFTerc(nf, this.getUsuarioResponsavel(), this.getPrioridadeMarketing(), chave, message, title, EnumConstMensagemChaveMural.CHAVE_MSG_CRITICA_NF_TERC_CEST_MURAL));
    }
}

