/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.notaterceiros.avaliacaocriticasnfterceiros;

import com.touchcomp.basementor.constants.enums.configservicos.impl.ConstantsAvaliacaoCriticaNFTerc;
import com.touchcomp.basementor.model.vo.MensagemMural;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.ObjectObsDinamica;
import com.touchcomp.basementor.model.vo.PrioridadeMarketing;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.components.obsdinamica.CompOBSDinamica;
import com.touchcomp.basementorservice.helpers.impl.configservicos.HelperConfigServicos;
import com.touchcomp.basementorservice.service.impl.mensagemmural.ServiceMensagemMuralImpl;
import com.touchcomp.basementorservice.service.impl.objectobsdinamica.ServiceObjectObsDinamicaImpl;
import com.touchcomp.basementorservice.service.impl.prioridademarketing.ServicePrioridadeMarketingImpl;
import com.touchcomp.basementorservice.service.impl.usuario.ServiceUsuarioImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

class AuxBaseAvalia {
    final List<MensagemMural> mensagensMural = new LinkedList<MensagemMural>();
    private Usuario usuarioResponsavel;
    private PrioridadeMarketing prioridadeMarketing;
    final ServicePrioridadeMarketingImpl servicePrioridadeMarketing;
    final ServiceUsuarioImpl serviceUsuario;
    final ServiceMensagemMuralImpl serviceMensagemMuralImpl;
    final HelperConfigServicos helperConfigServicos;
    final ServiceObjectObsDinamicaImpl serviceObjectObsDinamicaImpl;
    final CompOBSDinamica compObsDinamica;

    public AuxBaseAvalia(ServicePrioridadeMarketingImpl servicePrioridadeMarketing, ServiceUsuarioImpl serviceUsuario, HelperConfigServicos helperConfigServicos, ServiceMensagemMuralImpl serviceMensagemMuralImpl, ServiceObjectObsDinamicaImpl serviceObjectObsDinamicaImpl, CompOBSDinamica compObsDinamica) {
        this.servicePrioridadeMarketing = servicePrioridadeMarketing;
        this.serviceUsuario = serviceUsuario;
        this.helperConfigServicos = helperConfigServicos;
        this.serviceMensagemMuralImpl = serviceMensagemMuralImpl;
        this.serviceObjectObsDinamicaImpl = serviceObjectObsDinamicaImpl;
        this.compObsDinamica = compObsDinamica;
    }

    Usuario getUsuarioResponsavel() {
        if (this.usuarioResponsavel == null) {
            this.usuarioResponsavel = (Usuario)this.serviceUsuario.get(this.helperConfigServicos.getValueAsLong(ConstantsAvaliacaoCriticaNFTerc.ID_USUARIO.getChave()));
        }
        return this.usuarioResponsavel;
    }

    PrioridadeMarketing getPrioridadeMarketing() {
        if (this.prioridadeMarketing == null) {
            this.prioridadeMarketing = (PrioridadeMarketing)this.servicePrioridadeMarketing.get(this.helperConfigServicos.getValueAsLong(ConstantsAvaliacaoCriticaNFTerc.ID_PRIORIDADE_MARKETING.getChave()));
        }
        return this.prioridadeMarketing;
    }

    void addMsg(MensagemMural msg) {
        boolean exists = this.serviceMensagemMuralImpl.existeMsgChave(msg.getChaveMensagem());
        if (exists) {
            return;
        }
        Optional<MensagemMural> found = this.mensagensMural.stream().filter(i -> ToolMethods.isEquals((Object)i.getChaveMensagem(), (Object)msg.getChaveMensagem())).findFirst();
        if (found.isPresent()) {
            return;
        }
        this.mensagensMural.add(msg);
    }

    String getMessageTitle(String value, String chave) {
        if (TMethods.isStrWithData((String)value)) {
            return value;
        }
        return MessagesBaseMentor.getTextDetailsMsg((String)chave, (Object[])new Object[0]);
    }

    String getMessage(String message, NotaFiscalTerceiros nf, String keyMessage, Object ... params) throws ExceptionInvalidData {
        ObjectObsDinamica ob;
        if (ToolMethods.isStrWithData((String)(message = ToolString.onlyNumbers((String)message))) && (ob = (ObjectObsDinamica)this.serviceObjectObsDinamicaImpl.get(Long.valueOf(message))) != null) {
            try {
                return this.compObsDinamica.build(nf, ob.getObservacao(), true);
            }
            catch (ExceptionInvalidData | ExceptionReflection ex) {
                TLogger.get(this.getClass()).error(ex);
                throw new ExceptionInvalidData("E.ERP.0284.001", new Object[]{ob});
            }
        }
        return MessagesBaseMentor.getTextDetailsMsg((String)keyMessage, (Object[])params);
    }

    boolean isStrSimilar(String str1, String str2) {
        double ret;
        if (str1 == null) {
            str1 = "";
        }
        if (str2 == null) {
            str2 = "";
        }
        if ((ret = this.helperConfigServicos.getValueAsDouble(ConstantsAvaliacaoCriticaNFTerc.PERCENTUAL_AVALIACAO_SIMILARIDADE.getChave())) <= 0.0) {
            return true;
        }
        double d = ToolString.similarityBetweenStrings((String)str1, (String)str2);
        return d >= ret;
    }

    boolean isEquals(String value1, String value2) {
        if (value1 == null || value1.equalsIgnoreCase("null")) {
            value1 = "";
        }
        if (value2 == null || value1.equalsIgnoreCase("null")) {
            value2 = "";
        }
        return ToolMethods.isEquals((Object)value1, (Object)value2);
    }
}

