/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.notaterceiros.avaliacaocriticasnfterceiros;

import com.touchcomp.basementor.constants.enums.configservicos.EnumConstConfigServicos;
import com.touchcomp.basementor.constants.enums.configservicos.impl.ConstantsAvaliacaoCriticaNFTerc;
import com.touchcomp.basementor.constants.enums.modelodocfiscal.EnumConstModDocFiscal;
import com.touchcomp.basementor.model.vo.ConfigServicos;
import com.touchcomp.basementor.model.vo.DeParaFornecedorItem;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.MensagemMural;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementorclientwebservices.cte.cte.WebCTe;
import com.touchcomp.basementorclientwebservices.cte.model.env.CTNota;
import com.touchcomp.basementorclientwebservices.nfe.model.env.nfe.NFeNotaFiscalPropria;
import com.touchcomp.basementorclientwebservices.nfe.nfe.WebNFe;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.components.notaterceiros.avaliacaocriticasnfterceiros.AuxAvaliaEndereco;
import com.touchcomp.basementorservice.components.notaterceiros.avaliacaocriticasnfterceiros.AuxAvaliaNCMCEST;
import com.touchcomp.basementorservice.components.obsdinamica.CompOBSDinamica;
import com.touchcomp.basementorservice.helpers.impl.configservicos.HelperConfigServicos;
import com.touchcomp.basementorservice.helpers.impl.mensagemmural.HelperMensagemMural;
import com.touchcomp.basementorservice.service.impl.configservicos.ServiceConfigServicosImpl;
import com.touchcomp.basementorservice.service.impl.deparafornecedor.ServiceDeParaFornecedorItemImpl;
import com.touchcomp.basementorservice.service.impl.mensagemmural.ServiceMensagemMuralImpl;
import com.touchcomp.basementorservice.service.impl.objectobsdinamica.ServiceObjectObsDinamicaImpl;
import com.touchcomp.basementorservice.service.impl.prioridademarketing.ServicePrioridadeMarketingImpl;
import com.touchcomp.basementorservice.service.impl.usuario.ServiceUsuarioImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorxml.model.XMLNfeTerceiros;
import com.touchcomp.basementorxml.service.impl.xmlnfeterceiros.ServiceXMLNFeTerceirosImpl;
import java.util.LinkedList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class CompAvaliacaoCriticasNFTerceiros {
    final HelperConfigServicos helperConfigServicos;
    final ServiceMensagemMuralImpl serviceMensagemMuralImpl;
    final AuxAvaliaEndereco auxAvaliaEndereco;
    final AuxAvaliaNCMCEST auxAvaliaNcm;
    final ServiceXMLNFeTerceirosImpl serviceXMLNFeTerceiros;
    final ServiceConfigServicosImpl serviceConfigServicos;
    final ServiceDeParaFornecedorItemImpl serviceDeparaFornItem;
    final ServicePrioridadeMarketingImpl servicePrioridadeMarketing;
    final ServiceUsuarioImpl serviceUsuario;
    final ServiceObjectObsDinamicaImpl serviceObjectObsDinamicaImpl;
    final CompOBSDinamica compObsDinamica;
    final HelperMensagemMural helperTarefasUsuarios;

    public CompAvaliacaoCriticasNFTerceiros(HelperConfigServicos helperConfigServicos, ServiceMensagemMuralImpl serviceMensagemMuralImpl, ServiceXMLNFeTerceirosImpl serviceXMLNFeTerceiros, ServiceConfigServicosImpl serviceConfigServicos, ServiceDeParaFornecedorItemImpl serviceDeparaFornItem, ServicePrioridadeMarketingImpl servicePrioridadeMarketing, ServiceUsuarioImpl serviceUsuario, ServiceObjectObsDinamicaImpl serviceObjectObsDinamicaImpl, CompOBSDinamica compObsDinamica, HelperMensagemMural helperTarefasUsuarios) {
        this.helperConfigServicos = helperConfigServicos;
        this.serviceMensagemMuralImpl = serviceMensagemMuralImpl;
        this.serviceXMLNFeTerceiros = serviceXMLNFeTerceiros;
        this.serviceConfigServicos = serviceConfigServicos;
        this.serviceDeparaFornItem = serviceDeparaFornItem;
        this.servicePrioridadeMarketing = servicePrioridadeMarketing;
        this.serviceUsuario = serviceUsuario;
        this.serviceObjectObsDinamicaImpl = serviceObjectObsDinamicaImpl;
        this.compObsDinamica = compObsDinamica;
        this.helperTarefasUsuarios = helperTarefasUsuarios;
        this.auxAvaliaNcm = new AuxAvaliaNCMCEST(helperConfigServicos, helperTarefasUsuarios, servicePrioridadeMarketing, serviceUsuario, serviceObjectObsDinamicaImpl, compObsDinamica, serviceMensagemMuralImpl);
        this.auxAvaliaEndereco = new AuxAvaliaEndereco(helperConfigServicos, helperTarefasUsuarios, servicePrioridadeMarketing, serviceUsuario, serviceObjectObsDinamicaImpl, compObsDinamica, serviceMensagemMuralImpl);
    }

    public void avaliaNFTerceiros(NotaFiscalTerceiros nf) throws ExceptionInvalidData {
        try {
            ConfigServicos configServicos = this.getConfig(nf.getEmpresa());
            if (configServicos == null) {
                return;
            }
            EnumConstModDocFiscal mod = EnumConstModDocFiscal.get((Object)nf.getModeloDocFiscal().getCodigo());
            if (mod == null) {
                return;
            }
            XMLNfeTerceiros xml = this.serviceXMLNFeTerceiros.getByChave(nf.getChaveNFE());
            if (xml == null) {
                return;
            }
            LinkedList<MensagemMural> msgs = new LinkedList<MensagemMural>();
            if (ToolMethods.isEquals((Object)mod, (Object)EnumConstModDocFiscal.NFE)) {
                NFeNotaFiscalPropria nfNota = new WebNFe().readXMLNFeProc(xml.getConteudoXML());
                List<DeParaFornecedorItem> dados = this.getDepara(nf);
                msgs.addAll(this.auxAvaliaEndereco.avaliarDadosEndereco(nf, nfNota, configServicos));
                msgs.addAll(this.auxAvaliaNcm.avaliarProdutos(nf, nfNota, dados, configServicos));
            }
            if (ToolMethods.isEquals((Object)mod, (Object)EnumConstModDocFiscal.CTE)) {
                CTNota ctNota = new WebCTe().readXML(xml.getConteudoXML());
                msgs.addAll(this.auxAvaliaEndereco.avaliarDadosEndereco(nf, ctNota, configServicos));
            }
            this.serviceMensagemMuralImpl.saveOrUpdateFlush(msgs);
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new ExceptionInvalidData("", new Object[]{nf.getChaveNFE(), ex.getMessage()});
        }
    }

    public void avaliaNFTerceiros(NotaFiscalTerceiros nf, CTNota ctNota, ConfigServicos configServicos) throws ExceptionInvalidData {
        List<MensagemMural> msgs = this.auxAvaliaEndereco.avaliarDadosEndereco(nf, ctNota, configServicos);
        this.serviceMensagemMuralImpl.saveOrUpdateFlush(msgs);
    }

    private ConfigServicos getConfig(Empresa e) {
        return this.serviceConfigServicos.getContainsValue(EnumConstConfigServicos.AVALIACAO_CRITICAS_NF_TERCEIROS, ConstantsAvaliacaoCriticaNFTerc.ID_EMPRESA.getChave(), e.getIdentificador().toString());
    }

    private List<DeParaFornecedorItem> getDepara(NotaFiscalTerceiros nf) {
        LinkedList<DeParaFornecedorItem> ret = new LinkedList<DeParaFornecedorItem>();
        for (ItemNotaTerceiros item : nf.getItemNotaTerceiros()) {
            DeParaFornecedorItem dePara = this.serviceDeparaFornItem.getDeParaFornecedorItem(item.getNaturezaOperacao(), item.getProduto(), nf.getUnidadeFatFornecedor().getFornecedor());
            if (dePara == null) continue;
            ret.add(dePara);
        }
        return ret;
    }
}

