/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.ordemcompra;

import com.touchcomp.basementor.constants.enums.liberacaoordemcompra.ConstEnumLiberacaoOrdemCompra;
import com.touchcomp.basementor.model.vo.ClassificacaoOrdemCompra;
import com.touchcomp.basementor.model.vo.ConfiguracaoLiberacaoEmpresa;
import com.touchcomp.basementor.model.vo.ConfiguracaoLiberacaoOrdemCompra;
import com.touchcomp.basementor.model.vo.Especie;
import com.touchcomp.basementor.model.vo.ItemConfLibOCClassificacao;
import com.touchcomp.basementor.model.vo.ItemConfLibOrdemCompraUsuario;
import com.touchcomp.basementor.model.vo.ItemConfLibUsuOCEspecie;
import com.touchcomp.basementor.model.vo.ItemOrdemCompra;
import com.touchcomp.basementor.model.vo.LiberacaoOrdemCompra;
import com.touchcomp.basementor.model.vo.LiberacaoOrdemCompraItem;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OrdemCompra;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.erroprogramacao.ExceptionErroProgramacao;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.titulo.ExceptionTitulo;
import com.touchcomp.basementorservice.components.titulos.impl.CompGerarTitulosOrdemCompra;
import com.touchcomp.basementorservice.service.impl.configuracaoliberacaoordemcompra.ServiceConfiguracaoLiberacaoEmpresa;
import com.touchcomp.basementorservice.service.impl.configuracaoliberacaoordemcompra.ServiceItemConfLibOrdemCompraImpl;
import com.touchcomp.basementorservice.service.impl.opcoescontabeis.ServiceOpcoesContabeisImpl;
import com.touchcomp.basementorservice.service.impl.opcoesfinanceiras.ServiceOpcoesFinanceirasImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompLiberacaoOrdemCompra {
    @Autowired
    private CompGerarTitulosOrdemCompra compGerarTitulosOrdemCompra;
    @Autowired
    private ServiceItemConfLibOrdemCompraImpl serviceConfiguracaoLiberacaoOCItem;
    @Autowired
    private ServiceOpcoesFinanceirasImpl serviceOpcoesFinanceirasImpl;
    @Autowired
    private ServiceOpcoesContabeisImpl serviceOpcoesContabeis;
    @Autowired
    private ServiceConfiguracaoLiberacaoEmpresa serviceConfiguracaoLiberacaoEmpresa;

    public OrdemCompra avaliarOC(OrdemCompra ordemCompra) throws ExceptionTitulo, ExceptionInvalidData {
        OpcoesContabeis opcoesContabeis = this.serviceOpcoesContabeis.getByIdEmpresa(ordemCompra.getEmpresa().getIdentificador());
        return this.avaliarOC(ordemCompra, ordemCompra.getUsuario(), opcoesContabeis);
    }

    public OrdemCompra avaliarOC(OrdemCompra ordemCompra, Usuario usuario, OpcoesContabeis opcoesContabeis) throws ExceptionTitulo, ExceptionInvalidData {
        ItemConfLibOrdemCompraUsuario conf = this.serviceConfiguracaoLiberacaoOCItem.get(ordemCompra.getEmpresa(), usuario);
        ConfiguracaoLiberacaoOrdemCompra confEmpresa = null;
        if (conf != null) {
            confEmpresa = conf.getConfLiberacaoOC();
        } else {
            ConfiguracaoLiberacaoEmpresa confAux = this.serviceConfiguracaoLiberacaoEmpresa.getConfiguracaoLiberacaoOrdemCompraEmpresa(ordemCompra.getEmpresa());
            if (confAux != null) {
                confEmpresa = confAux.getConfLiberacaoOrdemCompra();
            }
        }
        if (confEmpresa == null) {
            throw new ExceptionInvalidData("E.ERP.0274.001", new Object[]{usuario, ordemCompra.getEmpresa()});
        }
        ConstEnumLiberacaoOrdemCompra tpOrdemCompra = ConstEnumLiberacaoOrdemCompra.valueOfByValue((Integer)confEmpresa.getTipoLiberacaoOC().intValue());
        LiberacaoOrdemCompra liberacao = ordemCompra.getLiberacaoOrdemCompra();
        if (liberacao == null) {
            liberacao = new LiberacaoOrdemCompra();
            liberacao.setDataCadastro(new Date());
            liberacao.setEmpresa(ordemCompra.getEmpresa());
            liberacao.setOrdemCompra(ordemCompra);
            liberacao.setUsuario(usuario);
            if (tpOrdemCompra != null) {
                liberacao.setTipoLiberacaoOC(Short.valueOf(tpOrdemCompra.getValue()));
            }
        } else {
            ConstEnumLiberacaoOrdemCompra tpLibOC = ConstEnumLiberacaoOrdemCompra.valueOfByValue((Integer)liberacao.getTipoLiberacaoOC().intValue());
            if (!tpLibOC.equals((Object)tpOrdemCompra)) {
                liberacao.getItens().clear();
            }
        }
        switch (tpOrdemCompra) {
            case TIPO_LIBERACAO_NENHUM: {
                this.liberarOCNenhum(liberacao, ordemCompra, usuario);
                break;
            }
            case TIPO_LIBERACAO_VALOR: {
                this.liberarOCValor(conf, liberacao, ordemCompra, usuario);
                break;
            }
            case TIPO_LIBERACAO_CLASSIFICACAO: {
                this.liberarClassificacao(conf, liberacao, ordemCompra, usuario);
                break;
            }
            case TIPO_LIBERACAO_ESPECIE: {
                this.liberarEspecie(conf, liberacao, ordemCompra, usuario);
                break;
            }
            default: {
                throw new ExceptionErroProgramacao("Tipo de Liberacao da Ordem de Compra nao mapeado.");
            }
        }
        if (ToolMethods.isAffirmative((Number)confEmpresa.getObrigarLiberarOCLibNovamenteAoEditar()) && !ToolMethods.isEquals((Object)tpOrdemCompra, (Object)ConstEnumLiberacaoOrdemCompra.TIPO_LIBERACAO_NENHUM)) {
            for (LiberacaoOrdemCompraItem i : liberacao.getItens()) {
                i.setLiberado(Short.valueOf((short)0));
            }
        }
        this.liberarOrdemCompra(liberacao);
        if (Objects.equals(liberacao.getLiberado(), (short)1)) {
            ordemCompra.setStatusOrdemCompra(confEmpresa.getStatusOCLiberado());
            if (!ToolMethods.isWithData((Collection)ordemCompra.getTitulos())) {
                ordemCompra.setTitulos(this.compGerarTitulosOrdemCompra.criarTitulos(ordemCompra, this.serviceOpcoesFinanceirasImpl.findByEmpresa(ordemCompra.getEmpresa()), opcoesContabeis));
            }
        } else {
            ordemCompra.setStatusOrdemCompra(confEmpresa.getStatusOCBloqueada());
        }
        for (ItemOrdemCompra itemOrdemCompra : ordemCompra.getItemOrdemCompra()) {
            itemOrdemCompra.setFechado(ordemCompra.getStatusOrdemCompra().getStatus());
        }
        ordemCompra.setLiberacaoOrdemCompra(liberacao);
        this.verificarItensLiberacaoOrdemCompra(ordemCompra);
        return ordemCompra;
    }

    private void liberarOCNenhum(LiberacaoOrdemCompra liberacao, OrdemCompra ordemCompra, Usuario usuario) {
        LiberacaoOrdemCompraItem item;
        if (liberacao.getItens().size() > 0) {
            item = (LiberacaoOrdemCompraItem)liberacao.getItens().get(0);
        } else {
            item = new LiberacaoOrdemCompraItem();
            liberacao.getItens().add(item);
        }
        item.setLiberado(Short.valueOf((short)1));
        item.setUsuario(usuario);
        item.setLiberacaoOrdemCompra(liberacao);
        item.setValor(ordemCompra.getValorTotal());
        liberacao.setLiberado(Short.valueOf((short)1));
    }

    private void liberarOCValor(ItemConfLibOrdemCompraUsuario conf, LiberacaoOrdemCompra liberacao, OrdemCompra ordemCompra, Usuario usuario) {
        LiberacaoOrdemCompraItem item;
        if (liberacao.getItens().size() > 0) {
            item = (LiberacaoOrdemCompraItem)liberacao.getItens().get(0);
        } else {
            item = new LiberacaoOrdemCompraItem();
            liberacao.getItens().add(item);
        }
        item.setLiberacaoOrdemCompra(liberacao);
        if (item.getValor() < ordemCompra.getValorTotal()) {
            item.setLiberado(Short.valueOf((short)0));
        }
        item.setValor(ordemCompra.getValorTotal());
        if (ToolMethods.isEquals((Object)item.getLiberado(), (Object)0)) {
            if (conf != null && conf.getItemConfLibOCValor() != null && ordemCompra.getValorTotal() >= conf.getItemConfLibOCValor().getValorMinimo() && ordemCompra.getValorTotal() <= conf.getItemConfLibOCValor().getValorMaximo()) {
                this.setLiberacaoItem(item, usuario);
            } else {
                this.removerLiberacaoItem(item);
            }
        }
    }

    private void liberarClassificacao(ItemConfLibOrdemCompraUsuario conf, LiberacaoOrdemCompra liberacao, OrdemCompra ordemCompra, Usuario usuario) {
        LiberacaoOrdemCompraItem item;
        if (liberacao.getItens().size() > 0) {
            item = (LiberacaoOrdemCompraItem)liberacao.getItens().get(0);
        } else {
            item = new LiberacaoOrdemCompraItem();
            liberacao.getItens().add(item);
        }
        item.setClassificacaoOrdemCompra(ordemCompra.getClassificacaoOC());
        item.setLiberacaoOrdemCompra(liberacao);
        if (item.getValor() < ordemCompra.getValorTotal()) {
            item.setLiberado(Short.valueOf((short)0));
        }
        item.setValor(ordemCompra.getValorTotal());
        ItemConfLibOCClassificacao itemLibConf = this.getItemLibClassificacao(conf, item.getClassificacaoOrdemCompra());
        if (ToolMethods.isEquals((Object)item.getLiberado(), (Object)0)) {
            if (conf != null && itemLibConf != null && item.getValor() >= itemLibConf.getValorMinimo() && item.getValor() <= itemLibConf.getValorMaximo()) {
                this.setLiberacaoItem(item, usuario);
            } else {
                this.removerLiberacaoItem(item);
            }
        }
    }

    private void liberarEspecie(ItemConfLibOrdemCompraUsuario conf, LiberacaoOrdemCompra liberacao, OrdemCompra ordemCompra, Usuario usuario) {
        for (ItemOrdemCompra itemOrdemCompra : ordemCompra.getItemOrdemCompra()) {
            LiberacaoOrdemCompraItem item;
            Optional<LiberacaoOrdemCompraItem> found = liberacao.getItens().stream().filter(i -> Objects.equals(i.getEspecie(), itemOrdemCompra.getProduto().getEspecie())).findFirst();
            if (found.isPresent()) {
                item = found.get();
            } else {
                item = new LiberacaoOrdemCompraItem();
                liberacao.getItens().add(item);
            }
            item.setEspecie(itemOrdemCompra.getProduto().getEspecie());
            if (item.getValor() < itemOrdemCompra.getItemOrdemCompraLF().getValorTotal()) {
                item.setLiberado(Short.valueOf((short)0));
            }
            item.setValor(itemOrdemCompra.getItemOrdemCompraLF().getValorTotal());
            item.setLiberacaoOrdemCompra(liberacao);
            ItemConfLibUsuOCEspecie espLib = this.getItemLibEspecie(conf, item.getEspecie());
            if (!ToolMethods.isEquals((Object)item.getLiberado(), (Object)0)) continue;
            if (espLib != null && item.getValor() >= espLib.getValorMinimo() && item.getValor() <= espLib.getValorMaximo()) {
                this.setLiberacaoItem(item, usuario);
                continue;
            }
            this.removerLiberacaoItem(item);
        }
    }

    private void verificarItensLiberacaoOrdemCompra(OrdemCompra oc) {
        Boolean liberada = true;
        List itens = oc.getLiberacaoOrdemCompra().getItens();
        for (LiberacaoOrdemCompraItem item : itens) {
            if (!ToolMethods.isEquals((Object)item.getLiberado(), (Object)0)) continue;
            liberada = false;
            break;
        }
        if (liberada.booleanValue()) {
            oc.setLiberada(Short.valueOf((short)1));
        }
    }

    public ItemConfLibOCClassificacao getItemLibClassificacao(ItemConfLibOrdemCompraUsuario conf, ClassificacaoOrdemCompra classificacaoOrdemCompra) {
        if (conf == null) {
            return null;
        }
        Optional<ItemConfLibOCClassificacao> found = conf.getItemClassificacao().stream().filter(i -> Objects.equals(i.getClassificacaoOC(), classificacaoOrdemCompra)).findAny();
        return found.isPresent() ? found.get() : null;
    }

    public ItemConfLibUsuOCEspecie getItemLibEspecie(ItemConfLibOrdemCompraUsuario conf, Especie especie) {
        if (conf == null) {
            return null;
        }
        Optional<ItemConfLibUsuOCEspecie> found = conf.getEspecieLiberacaoOrdemCompra().stream().filter(i -> Objects.equals(i.getEspecie(), especie)).findAny();
        return found.isPresent() ? found.get() : null;
    }

    private void liberarOrdemCompra(LiberacaoOrdemCompra liberacao) {
        boolean val = true;
        for (LiberacaoOrdemCompraItem item : liberacao.getItens()) {
            val = val && Objects.equals(item.getLiberado(), (short)1);
        }
        if (val) {
            liberacao.setLiberado(Short.valueOf((short)1));
        } else {
            liberacao.setLiberado(Short.valueOf((short)0));
        }
    }

    private void removerLiberacaoItem(LiberacaoOrdemCompraItem item) {
        item.setLiberado(Short.valueOf((short)0));
        item.setDataLiberacao(null);
        item.setUsuario(null);
        item.setGrupoLibOrdemCompraItem(null);
    }

    private void setLiberacaoItem(LiberacaoOrdemCompraItem item, Usuario usuario) {
        item.setLiberado(Short.valueOf((short)1));
        item.setDataLiberacao(new Date());
        item.setUsuario(usuario);
    }
}

