/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.ordemcompra.calculo;

import com.touchcomp.basementor.constants.enums.produto.EnumConstTipoProduto;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeItemOrdemCompra;
import com.touchcomp.basementor.model.vo.ItemOrdemCompra;
import com.touchcomp.basementor.model.vo.ItemOrdemCompraLivroFiscal;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.OrdemCompra;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.UnidadeFatFornecedor;
import com.touchcomp.basementorexceptions.exceptions.impl.impostoicms.ExceptionImpostoIcms;
import com.touchcomp.basementorexceptions.exceptions.impl.impostoipi.ExceptionImpostoIPI;
import com.touchcomp.basementorrules.impostos.icms.model.IcmsCalculado;
import com.touchcomp.basementorrules.impostos.ipi.model.IPICalculado;
import com.touchcomp.basementorservice.BaseMethods;
import com.touchcomp.basementorservice.components.ordemcompra.calculo.impl.AuxCalculoIcmsItemOrdemCompra;
import com.touchcomp.basementorservice.components.ordemcompra.calculo.impl.AuxCalculoIpiItemOrdemCompra;
import com.touchcomp.basementorservice.components.ordemcompra.calculo.impl.AuxCalculoOutrosImpostosItemOrdemCompra;
import com.touchcomp.basementorservice.service.impl.empresacontabilidade.ServiceEmpresaContabilidadeImpl;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompCalculoImpostosFiscaisOrdemCompra
extends BaseMethods {
    @Autowired
    private ServiceEmpresaContabilidadeImpl serviceEmpresaContabilidade;

    public void calcular(OrdemCompra ordemCompra) throws Exception {
        if (ordemCompra.getItemOrdemCompra() != null) {
            for (ItemOrdemCompra item : ordemCompra.getItemOrdemCompra()) {
                this.calcularImpostosFiscaisItOrdemCompra(item, ordemCompra.getUnidadeFatFornecedor(), ordemCompra.getEmpresa());
            }
        }
    }

    public void calcularImpostosFiscaisItOrdemCompra(ItemOrdemCompra item, UnidadeFatFornecedor fornecedor, Empresa empresa) throws Exception {
        Produto produto = item.getProduto();
        if (item.getItemOrdemCompraLF() == null) {
            item.setItemOrdemCompraLF(new ItemOrdemCompraLivroFiscal());
        }
        ItemOrdemCompraLivroFiscal itLF = item.getItemOrdemCompraLF();
        Double qtdTotal = this.getQuantidadeTotal(item.getGradeItemOrdemCompra());
        item.setQuantidadeTotal(qtdTotal);
        Double vlrProduto = qtdTotal * item.getValorUnitario();
        Double bcCalculoGeral = item.getValorDesconto() * -1.0 + item.getValorDespAcessoria() + item.getValorFrete() + item.getVrSeguro() + item.getValorAgregado();
        if (!this.isNull(produto.getTipoProduto()).booleanValue() && this.isEquals(produto.getTipoProduto(), EnumConstTipoProduto.SERVICO.getValue())) {
            item.setVrServico(vlrProduto);
            bcCalculoGeral = bcCalculoGeral + item.getVrServico();
            itLF.setVrIrrf(Double.valueOf(produto.getAliquotaIrrf() / 100.0 * bcCalculoGeral));
            itLF.setVrInss(Double.valueOf(produto.getAliquotaInss() / 100.0 * bcCalculoGeral));
            itLF.setVrIss(Double.valueOf(produto.getAliquotaIss() / 100.0 * bcCalculoGeral));
            itLF.setAliquotaIcms(Double.valueOf(0.0));
            itLF.setAliquotaIpi(Double.valueOf(0.0));
            itLF.setVrBcCalculoIcmsSt(Double.valueOf(0.0));
            itLF.setVrDifAliquota(Double.valueOf(0.0));
            itLF.setVrIcms(Double.valueOf(0.0));
            itLF.setVrIcmsIsento(Double.valueOf(0.0));
            itLF.setVrIcmsOutros(Double.valueOf(0.0));
            itLF.setVrIcmsSemAprov(Double.valueOf(0.0));
            itLF.setVrIcmsSt(Double.valueOf(0.0));
            itLF.setVrIcmsTributado(Double.valueOf(0.0));
            item.setVrProduto(Double.valueOf(0.0));
        } else {
            item.setVrProduto(vlrProduto);
            item.setVrServico(Double.valueOf(0.0));
        }
        if (!this.isNull(item.getModeloFiscal()).booleanValue() && !this.isNull(fornecedor).booleanValue()) {
            IPICalculado ipiCalculado = this.calcularIpiItemOrdemCompra(itLF, item, fornecedor);
            this.calcularIcmsItemOrdemCompra(itLF, item, fornecedor, empresa, ipiCalculado);
            this.calculoOutrosImpostos(item.getItemOrdemCompraLF(), item);
        }
        this.setValorTotal(item, itLF);
        this.setValorCusto(item, itLF);
    }

    private IPICalculado calcularIpiItemOrdemCompra(ItemOrdemCompraLivroFiscal itLF, ItemOrdemCompra item, UnidadeFatFornecedor fornecedor) throws ExceptionImpostoIPI {
        AuxCalculoIpiItemOrdemCompra aux = new AuxCalculoIpiItemOrdemCompra();
        return aux.calculaValoresIpiItemOrdemCompra(itLF, item, fornecedor);
    }

    private IcmsCalculado calcularIcmsItemOrdemCompra(ItemOrdemCompraLivroFiscal itLF, ItemOrdemCompra item, UnidadeFatFornecedor fornecedor, Empresa empresa, IPICalculado ipiCalculado) throws ExceptionImpostoIcms, InstantiationException, IllegalAccessException {
        AuxCalculoIcmsItemOrdemCompra aux = new AuxCalculoIcmsItemOrdemCompra();
        return aux.calculaValoresIcmsItemOrdemCompra(itLF, item, fornecedor, ipiCalculado, empresa, this.serviceEmpresaContabilidade.findByEmpresa(empresa));
    }

    private void calculoOutrosImpostos(ItemOrdemCompraLivroFiscal itLF, ItemOrdemCompra item) throws Exception {
        AuxCalculoOutrosImpostosItemOrdemCompra aux = new AuxCalculoOutrosImpostosItemOrdemCompra();
        aux.calculoOutrosImpostos(itLF, item);
    }

    private void setValorTotal(ItemOrdemCompra item, ItemOrdemCompraLivroFiscal itLF) {
        Double valor = item.getVrProduto() + item.getVrServico() - item.getValorDesconto() + item.getValorFrete() + item.getVrSeguro() + item.getValorDespAcessoria() + itLF.getVrIpiIndustria() + itLF.getVrIpiObservacao() + itLF.getVrIcmsSt() - itLF.getVrIcmsDispensado();
        itLF.setValorTotal(this.arredondaNumero(valor, 2));
    }

    private void setValorCusto(ItemOrdemCompra item, ItemOrdemCompraLivroFiscal itLF) {
        item.setValorCusto(Double.valueOf(item.getVrProduto() + item.getVrServico() - item.getValorDesconto() + item.getValorFrete() + item.getVrSeguro() + item.getValorDespAcessoria() + itLF.getVrIcmsSt() + itLF.getVrDifAliquota() + itLF.getVrFreteExterno() - itLF.getVrCofins() - itLF.getVrPis() - itLF.getVrIpiComercio() + item.getValorAgregado()));
        ModeloFiscal modeloFiscal = item.getModeloFiscal();
        if (!this.isNull(modeloFiscal).booleanValue() && !this.isNull(modeloFiscal.getModeloFiscalIcms()).booleanValue() && this.isAffimative(modeloFiscal.getModeloFiscalIcms().getRecuperarTributosIcms())) {
            item.setValorCusto(Double.valueOf(item.getValorCusto() - itLF.getVrIcms()));
        }
        if (!this.isNull(modeloFiscal).booleanValue() && !this.isNull(modeloFiscal.getModeloFiscalIcms()).booleanValue() && this.isAffimative(modeloFiscal.getModeloFiscalIcms().getCalcularIcmsSimples())) {
            item.setValorCusto(Double.valueOf(item.getValorCusto() - itLF.getValorIcmsSimples()));
        }
        item.setValorCusto(Double.valueOf(item.getValorCusto() + itLF.getVrIpiObservacao()));
        item.setValorCusto(Double.valueOf(item.getValorCusto() / (item.getQuantidadeTotal() * item.getFatorConversao())));
        item.setValorCusto(this.arredondaNumero(item.getValorCusto(), 6));
    }

    private Double getQuantidadeTotal(List<GradeItemOrdemCompra> grades) {
        double qtdTotal = 0.0;
        if (!this.isNull(grades).booleanValue()) {
            for (GradeItemOrdemCompra grade : grades) {
                qtdTotal += grade.getQuantidade().doubleValue();
            }
        }
        return qtdTotal;
    }
}

