/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.ordemcompra.calculo.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorEntSaida;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.impostos.contsocial.EnumConstTipoCalcContSocial;
import com.touchcomp.basementor.constants.enums.impostos.funrural.EnumConstTipoCalcFunrural;
import com.touchcomp.basementor.constants.enums.impostos.inss.EnumConstTipoCalcInss;
import com.touchcomp.basementor.constants.enums.impostos.ir.EnumConstTipoCalcIr;
import com.touchcomp.basementor.constants.enums.impostos.iss.EnumConstTipoCalcIss;
import com.touchcomp.basementor.constants.enums.impostos.lei10833.EnumConstTipoCalcLei10833;
import com.touchcomp.basementor.constants.enums.impostos.outros.EnumConstTipoCalcOutros;
import com.touchcomp.basementor.constants.enums.impostos.piscofins.EnumConstNFeIncidenciaCofins;
import com.touchcomp.basementor.constants.enums.impostos.piscofins.EnumConstTipoCalcPisCofins;
import com.touchcomp.basementor.constants.enums.impostos.sestsenat.EnumConstTipoCalcSestSenat;
import com.touchcomp.basementor.constants.enums.number.EnumConstTipoArredondamento;
import com.touchcomp.basementor.model.vo.ItemOrdemCompra;
import com.touchcomp.basementor.model.vo.ItemOrdemCompraLivroFiscal;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementorrules.impostos.contsocial.CompImpostoContSocial;
import com.touchcomp.basementorrules.impostos.contsocial.model.ContSocialCalculado;
import com.touchcomp.basementorrules.impostos.contsocial.model.ContSocialParams;
import com.touchcomp.basementorrules.impostos.funrural.CompImpostoFunrural;
import com.touchcomp.basementorrules.impostos.funrural.model.FunruralCalculado;
import com.touchcomp.basementorrules.impostos.funrural.model.FunruralParams;
import com.touchcomp.basementorrules.impostos.inss.CompImpostoInss;
import com.touchcomp.basementorrules.impostos.inss.model.InssCalculado;
import com.touchcomp.basementorrules.impostos.inss.model.InssParams;
import com.touchcomp.basementorrules.impostos.ir.CompImpostoIr;
import com.touchcomp.basementorrules.impostos.ir.model.IrCalculado;
import com.touchcomp.basementorrules.impostos.ir.model.IrParams;
import com.touchcomp.basementorrules.impostos.iss.CompImpostoIss;
import com.touchcomp.basementorrules.impostos.iss.model.IssCalculado;
import com.touchcomp.basementorrules.impostos.iss.model.IssParams;
import com.touchcomp.basementorrules.impostos.lei10833.CompImpostoLei10833;
import com.touchcomp.basementorrules.impostos.lei10833.model.Lei10833Calculado;
import com.touchcomp.basementorrules.impostos.lei10833.model.Lei10833Params;
import com.touchcomp.basementorrules.impostos.outros.CompImpostoOutros;
import com.touchcomp.basementorrules.impostos.outros.model.OutrosCalculado;
import com.touchcomp.basementorrules.impostos.outros.model.OutrosParams;
import com.touchcomp.basementorrules.impostos.piscofins.CompImpostoPisCofins;
import com.touchcomp.basementorrules.impostos.piscofins.model.PisCofinsCalculado;
import com.touchcomp.basementorrules.impostos.piscofins.model.PisCofinsParams;
import com.touchcomp.basementorrules.impostos.sestsenat.CompImpostoSestSenat;
import com.touchcomp.basementorrules.impostos.sestsenat.model.SestSenatCalculado;
import com.touchcomp.basementorrules.impostos.sestsenat.model.SestSenatParams;
import com.touchcomp.basementorservice.components.calculovalores.BaseCalculoValores;

public class AuxCalculoOutrosImpostosItemOrdemCompra
extends BaseCalculoValores {
    public void calculoOutrosImpostos(ItemOrdemCompraLivroFiscal itLF, ItemOrdemCompra item) throws Exception {
        this.calculaValoresPis(itLF, item);
        this.calculaValoresContribuicaoSocial(itLF, item);
        this.calculaFunRural(itLF, item);
        this.calculaLei10833(itLF, item);
        this.calculoInss(itLF, item);
        this.calculoIrrf(itLF, item);
        this.calculoIss(itLF, item);
        this.calculoOutros(itLF, item);
        this.calculoSestSenat(itLF, item);
    }

    private void calculaValoresPis(ItemOrdemCompraLivroFiscal itLF, ItemOrdemCompra item) throws Exception {
        Produto produto = item.getProduto();
        Double aliquotaPis = AuxCalculoOutrosImpostosItemOrdemCompra.getAliquotaPis(produto, item.getModeloFiscal().getModeloFiscalPisCofins());
        Double aliquotaPisSt = this.getAliquotaPisSt(produto, item.getModeloFiscal());
        Double aliquotaCofins = AuxCalculoOutrosImpostosItemOrdemCompra.getAliquotaCofins(produto, item.getModeloFiscal().getModeloFiscalPisCofins());
        Double aliquotaCofinsSt = this.getAliquotaCofinsSt(produto, item.getModeloFiscal());
        PisCofinsParams params = new PisCofinsParams(EnumConstNFeIncidenciaCofins.valueOfCodigo((String)item.getModeloFiscal().getModeloFiscalPisCofins().getIncidenciaPisCofins().getCodigo()), aliquotaPis, aliquotaCofins, EnumConstantsMentorEntSaida.ENTRADA, EnumConstTipoCalcPisCofins.get((Object)item.getModeloFiscal().getModeloFiscalPisCofins().getCalcularPisNormal()), EnumConstTipoCalcPisCofins.get((Object)item.getModeloFiscal().getModeloFiscalPisCofins().getCalcularCofinsNormal()), EnumConstTipoCalcPisCofins.get((Object)item.getModeloFiscal().getModeloFiscalPisCofins().getCalcularPisSt()), EnumConstTipoCalcPisCofins.get((Object)item.getModeloFiscal().getModeloFiscalPisCofins().getCalcularCofinsSt()), Double.valueOf(item.getValorUnitario() * item.getQuantidadeTotal()), item.getValorDesconto(), item.getValorDespAcessoria(), item.getValorFrete(), item.getVrSeguro(), item.getQuantidadeTotal(), EnumConstantsMentorSimNao.get((Object)item.getModeloFiscal().getModeloFiscalPisCofins().getIncluiDesconto()), EnumConstantsMentorSimNao.get((Object)item.getModeloFiscal().getModeloFiscalPisCofins().getIncluirIcmsDesonerado()), EnumConstantsMentorSimNao.get((Object)item.getModeloFiscal().getModeloFiscalPisCofins().getIncluiDespAcess()), EnumConstantsMentorSimNao.get((Object)item.getModeloFiscal().getModeloFiscalPisCofins().getIncluiFrete()), EnumConstantsMentorSimNao.get((Object)item.getModeloFiscal().getModeloFiscalPisCofins().getIncluiSeguro()), EnumConstantsMentorSimNao.get((Object)item.getModeloFiscal().getModeloFiscalPisCofins().getIncluiDesconto()), EnumConstantsMentorSimNao.get((Object)item.getModeloFiscal().getModeloFiscalPisCofins().getIncluiDespAcess()), EnumConstantsMentorSimNao.get((Object)item.getModeloFiscal().getModeloFiscalPisCofins().getIncluiFrete()), EnumConstantsMentorSimNao.get((Object)item.getModeloFiscal().getModeloFiscalPisCofins().getIncluiSeguro()), null, EnumConstantsMentorSimNao.get((Object)item.getModeloFiscal().getModeloFiscalPisCofins().getIncluirIcmsDesonerado()), EnumConstantsMentorSimNao.get((Object)item.getModeloFiscal().getModeloFiscalPisCofins().getIncluirIcmsSemAproveitamento()), EnumConstantsMentorSimNao.get((Object)item.getModeloFiscal().getModeloFiscalPisCofins().getIncluirIpiObservacao()), null, EnumConstantsMentorSimNao.get((Object)item.getModeloFiscal().getModeloFiscalPisCofins().getIncluirIcmsSemAproveitamento()), EnumConstantsMentorSimNao.get((Object)item.getModeloFiscal().getModeloFiscalPisCofins().getIncluirIpiObservacao()), EnumConstantsMentorSimNao.NAO, aliquotaPisSt, aliquotaCofinsSt, itLF.getVrIcms(), itLF.getVrIcmsDispensado(), itLF.getVrIcmsSemAprov(), itLF.getVrIpiObservacao(), Double.valueOf(0.0), Double.valueOf(0.0), item.getModeloFiscal().getModeloFiscalPisCofins().getValorMinimoPis(), item.getModeloFiscal().getModeloFiscalPisCofins().getValorMinimoCofins());
        PisCofinsCalculado calc = CompImpostoPisCofins.calcularPisCofins((PisCofinsParams)params);
        itLF.setAliquotaPis(calc.getAliquotaPis());
        itLF.setAliquotaCofins(calc.getAliquotaCofins());
        itLF.setVrPis(calc.getValorPis());
        itLF.setVrCofins(calc.getValorCofins());
        itLF.setVrBCCofins(calc.getValorBCCofins());
        itLF.setVrBCPis(calc.getValorBCPis());
        itLF.setAliquotaPisSt(calc.getAliquotaPisST());
        itLF.setAliquotaCofinsSt(calc.getAliquotaCofinsST());
        itLF.setVrPisSt(calc.getValorPisST());
        itLF.setVrCofinsSt(calc.getValorCofinsST());
        itLF.setVrBCCofinsSt(calc.getValorBCCofinsST());
        itLF.setVrBCPisSt(calc.getValorBCPisST());
    }

    private void calculaValoresContribuicaoSocial(ItemOrdemCompraLivroFiscal itLF, ItemOrdemCompra item) {
        ContSocialParams params = new ContSocialParams(item.getProduto().getAliquotaContSoc(), item.getProduto().getPercRedContSoc(), itLF.getVrContSoc(), item.getModeloFiscal().getValorMinimoCSLL(), item.getValorFrete(), item.getVrSeguro(), item.getValorDespAcessoria(), item.getValorDesconto(), Double.valueOf(item.getValorUnitario() * item.getQuantidadeTotal()), EnumConstTipoArredondamento.ROUND_FLOOR, EnumConstTipoCalcContSocial.get((Object)item.getModeloFiscal().getTipoContSoc()));
        ContSocialCalculado calc = CompImpostoContSocial.calcularContSocial((ContSocialParams)params);
        itLF.setAliquotaContSoc(calc.getAliquotaContSocial());
        itLF.setVrContSoc(calc.getValorContSocial());
    }

    private void calculaFunRural(ItemOrdemCompraLivroFiscal itLF, ItemOrdemCompra item) {
        FunruralParams params = new FunruralParams(item.getProduto().getAliquotaFunrural(), item.getProduto().getPercRedFunrural(), itLF.getVrFunrural(), item.getModeloFiscal().getValorMinimoOutros(), item.getValorFrete(), item.getVrSeguro(), item.getValorDespAcessoria(), item.getValorDesconto(), Double.valueOf(item.getValorUnitario() * item.getQuantidadeTotal()), EnumConstTipoArredondamento.ROUND_FLOOR, EnumConstTipoCalcFunrural.get((Object)item.getModeloFiscal().getTipoFunrural()));
        FunruralCalculado calc = CompImpostoFunrural.calcularFunrural((FunruralParams)params);
        itLF.setAliquotaFunrural(calc.getAliquotaFunrural());
        itLF.setVrFunrural(calc.getValorFunrural());
    }

    private void calculaLei10833(ItemOrdemCompraLivroFiscal itLF, ItemOrdemCompra item) {
        Lei10833Params params = new Lei10833Params(item.getProduto().getAliquotaLei10833(), item.getProduto().getPercRedLei10833(), itLF.getVrLei10833(), Double.valueOf(0.0), item.getValorFrete(), item.getVrSeguro(), item.getValorDespAcessoria(), item.getValorDesconto(), Double.valueOf(item.getValorUnitario() * item.getQuantidadeTotal()), EnumConstTipoArredondamento.ROUND_FLOOR, EnumConstTipoCalcLei10833.get((Object)item.getModeloFiscal().getTipoLei10833()));
        Lei10833Calculado calc = CompImpostoLei10833.calcularLei10833((Lei10833Params)params);
        itLF.setAliquotaLei10833(calc.getAliquotaLei10833());
        itLF.setVrLei10833(calc.getValorLei10833());
    }

    private void calculoInss(ItemOrdemCompraLivroFiscal itLF, ItemOrdemCompra item) {
        InssParams params = new InssParams(item.getProduto().getAliquotaInss(), item.getProduto().getPercRedBCINSS(), itLF.getVrInss(), Double.valueOf(0.0), item.getModeloFiscal().getValorMinimoInss(), item.getValorFrete(), item.getVrSeguro(), item.getValorDespAcessoria(), item.getValorDesconto(), Double.valueOf(item.getValorUnitario() * item.getQuantidadeTotal()), EnumConstTipoArredondamento.ROUND_FLOOR, EnumConstTipoCalcInss.get((Object)item.getModeloFiscal().getTipoINSS()));
        InssCalculado calc = CompImpostoInss.calcularInss((InssParams)params);
        itLF.setAliquotaInss(calc.getAliquotaInss());
        itLF.setVrInss(calc.getValorInss());
        itLF.setPercRedBcInss(calc.getPercRedInss());
    }

    private void calculoIrrf(ItemOrdemCompraLivroFiscal itLF, ItemOrdemCompra item) {
        IrParams params = new IrParams(item.getProduto().getAliquotaIrrf(), item.getProduto().getPercRedIrrf(), itLF.getVrIrrf(), item.getModeloFiscal().getValorMinimoIR(), item.getValorFrete(), item.getVrSeguro(), item.getValorDespAcessoria(), item.getValorDesconto(), Double.valueOf(item.getValorUnitario() * item.getQuantidadeTotal()), EnumConstTipoArredondamento.ROUND_FLOOR, EnumConstTipoCalcIr.get((Object)item.getModeloFiscal().getTipoIRRF()));
        IrCalculado calc = CompImpostoIr.calcularIr((IrParams)params);
        itLF.setAliquotaIrrf(calc.getAliquotaIr());
        itLF.setVrIrrf(calc.getValorIr());
    }

    private void calculoIss(ItemOrdemCompraLivroFiscal itLF, ItemOrdemCompra item) {
        IssParams params = new IssParams(item.getProduto().getAliquotaIss(), Double.valueOf(0.0), itLF.getVrIss(), item.getModeloFiscal().getValorMinimoISS(), item.getValorFrete(), item.getVrSeguro(), item.getValorDespAcessoria(), item.getValorDesconto(), Double.valueOf(item.getValorUnitario() * item.getQuantidadeTotal()), EnumConstTipoArredondamento.ROUND_FLOOR, EnumConstTipoCalcIss.get((Object)item.getModeloFiscal().getIssRetido()));
        IssCalculado calc = CompImpostoIss.calcularIss((IssParams)params);
        itLF.setAliquotaIss(calc.getAliquotaIss());
        itLF.setVrIss(calc.getValorIss());
    }

    private void calculoOutros(ItemOrdemCompraLivroFiscal itLF, ItemOrdemCompra item) {
        OutrosParams params = new OutrosParams(item.getProduto().getAliquotaOutros(), item.getProduto().getPercRedOutros(), itLF.getVrOutros(), item.getModeloFiscal().getValorMinimoOutros(), item.getValorFrete(), item.getVrSeguro(), item.getValorDespAcessoria(), item.getValorDesconto(), Double.valueOf(item.getValorUnitario() * item.getQuantidadeTotal()), EnumConstTipoArredondamento.ROUND_FLOOR, EnumConstTipoCalcOutros.get((Object)item.getModeloFiscal().getTipoOutros()));
        OutrosCalculado calc = CompImpostoOutros.calcularOutros((OutrosParams)params);
        itLF.setAliquotaOutros(calc.getAliquotaOutros());
        itLF.setVrOutros(calc.getValorOutros());
    }

    private void calculoSestSenat(ItemOrdemCompraLivroFiscal itLF, ItemOrdemCompra item) {
        SestSenatParams params = new SestSenatParams(item.getProduto().getPercSestSenat(), item.getProduto().getPercRedSestSenat(), itLF.getValorSestSenat(), Double.valueOf(0.0), item.getValorFrete(), item.getVrSeguro(), item.getValorDespAcessoria(), item.getValorDesconto(), Double.valueOf(item.getValorUnitario() * item.getQuantidadeTotal()), EnumConstTipoArredondamento.ROUND_FLOOR, EnumConstTipoCalcSestSenat.get((Object)item.getModeloFiscal().getTipoSestSenat()));
        SestSenatCalculado calc = CompImpostoSestSenat.calcularSestSenat((SestSenatParams)params);
        itLF.setAliquotaSestSenat(calc.getAliquotaSestSenat());
        itLF.setValorSestSenat(calc.getValorSestSenat());
        itLF.setPercRedSestSenat(calc.getPercRedSestSenat());
    }
}

