/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.ordemservico;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.constants.enums.tipoproducao.EnumConstTipoProducao;
import com.touchcomp.basementor.constants.enums.tipoproducaosped.EnumConstTipoProducaoSped;
import com.touchcomp.basementor.model.vo.CelulaProdCentroEstoque;
import com.touchcomp.basementor.model.vo.CelulaProdutiva;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.ComunicadoProducao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FaseProdutiva;
import com.touchcomp.basementor.model.vo.FichaTecItemComProducao;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeFormulaProduto;
import com.touchcomp.basementor.model.vo.GradeItemComunicadoProducao;
import com.touchcomp.basementor.model.vo.GradeItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.ItemComProdOutrosCustos;
import com.touchcomp.basementor.model.vo.ItemComunicadoProducao;
import com.touchcomp.basementor.model.vo.ItemRequisicao;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.OpcoesPCP;
import com.touchcomp.basementor.model.vo.OrdemServicoProdLinhaProd;
import com.touchcomp.basementor.model.vo.ParametrizacaoCtbComProd;
import com.touchcomp.basementor.model.vo.PeriodoProducao;
import com.touchcomp.basementor.model.vo.Requisicao;
import com.touchcomp.basementor.model.vo.RoteiroProducao;
import com.touchcomp.basementor.model.vo.SubdivisaoOSProdLinhaProd;
import com.touchcomp.basementor.model.vo.TipoProducaoSped;
import com.touchcomp.basementorservice.BaseMethods;
import com.touchcomp.basementorservice.components.requisicao.auxcomp.AuxGradesQtd;
import com.touchcomp.basementorservice.components.requisicao.auxcomp.CacheSaldoProduto;
import com.touchcomp.basementorservice.components.requisicao.impl.comunicadoproducao.CompRequisicaoComunicadoProducao;
import com.touchcomp.basementorservice.helpers.impl.comunicadoproducao.HelperItemComunicadoProducao;
import com.touchcomp.basementorservice.model.ordemservproducaolinhaprod.OSLinhaProducao;
import com.touchcomp.basementorservice.model.ordemservproducaolinhaprod.OSLinhaResultado;
import com.touchcomp.basementorservice.service.impl.gradeformulaproduto.ServiceGradeFormulaProdutoImpl;
import com.touchcomp.basementorservice.service.impl.roteiroproducao.ServiceRoteiroProducaoImpl;
import com.touchcomp.basementorservice.service.impl.tipoproducao.ServiceTipoProducaoImpl;
import com.touchcomp.basementorservice.service.impl.tipoproducaosped.ServiceTipoProducaoSpedImpl;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompOrdemServicoLinhaProd
extends BaseMethods {
    @Autowired
    ServiceTipoProducaoImpl serviceTipoProducao;
    @Autowired
    ServiceTipoProducaoSpedImpl serviceTipoProducaoSped;
    @Autowired
    ServiceGradeFormulaProdutoImpl serviceGradeFormulaProduto;
    @Autowired
    ServiceRoteiroProducaoImpl serviceRoteiroProducao;
    @Autowired
    CompRequisicaoComunicadoProducao compRequisicaoComunicadoProducao;
    @Autowired
    HelperItemComunicadoProducao helperItemComunicadoProducao;

    public List<OrdemServicoProdLinhaProd> buildOSIndSobEncomenda(List<GradeItemNotaTerceiros> grades, PeriodoProducao periodoProducao) {
        LinkedList<OrdemServicoProdLinhaProd> ret = new LinkedList<OrdemServicoProdLinhaProd>();
        for (GradeItemNotaTerceiros grade : grades) {
            OrdemServicoProdLinhaProd os = new OrdemServicoProdLinhaProd();
            os.setTipoProducaoSped(this.getTipoProdItemSpedIndEnc());
            os.setDataCadastro(new Date());
            os.setDataEmissao(grade.getDataEntradaSaida());
            os.setDataPrevisao(grade.getDataEntradaSaida());
            os.setDataPrevisaoInicio(grade.getDataEntradaSaida());
            if (grade.getItemNotaTerceiros() != null && grade.getItemNotaTerceiros().getNotaFiscalTerceiros() != null) {
                NotaFiscalTerceiros aux = grade.getItemNotaTerceiros().getNotaFiscalTerceiros();
                os.setEmpresa(aux.getEmpresa());
                if (aux.getUnidadeFatFornecedor() != null && aux.getUnidadeFatFornecedor().getFornecedor() != null) {
                    os.setPessoaParceiro(grade.getItemNotaTerceiros().getNotaFiscalTerceiros().getUnidadeFatFornecedor().getFornecedor().getPessoa());
                }
            }
            os.setGradeCor(grade.getGradeCor());
            os.setRoteiroProducao(this.getRoteiroProducao(os));
            os.setGradeFormulaProduto(this.getGradeFormulaProd(os));
            os.setGradeItemNotaTerceiros(grade);
            os.setPeriodoProducao(periodoProducao);
            os.setQuantidadePrevProd(grade.getQuantidade());
            os.setQuantidadeRefPrevProd(grade.getQuantidade());
            os.setSubDivisoesOS(this.getSubs(os, grade));
            os.setTotalHoras(this.getTotalHoras(os));
            ret.add(os);
        }
        return ret;
    }

    public void gerarRequisicaoLinhaProd(OSLinhaResultado temp, Date data, OrdemServicoProdLinhaProd os, FaseProdutiva fase, AuxGradesQtd aux, CacheSaldoProduto cache, OpcoesPCP opcoesPCP) {
        TipoProducaoSped tp = temp.getSubOS().getOrdemServicoProdLinhaProd().getTipoProducaoSped();
        if (EnumConstTipoProducaoSped.get((Object)tp.getCodigo()).isDesmancheOuProdConjunt()) {
            List<ItemRequisicao> itensReq = this.compRequisicaoComunicadoProducao.getItemReqLinhaProd(temp.getSubOS().getQuantidadePrevista(), temp.getSubOS().getQuantidadeRefPrevProd(), temp.getSubOS().getGradeFormulaProduto(), data, os, fase, temp.getSubOS(), opcoesPCP, null, cache);
            Requisicao r = this.compRequisicaoComunicadoProducao.novaRequisicao(temp.getComProducaoGerado().getRequisicao(), null, data, itensReq, os.getEmpresa());
            temp.getComProducaoGerado().setRequisicao(r);
        } else {
            for (OSLinhaProducao item : temp.getProducao()) {
                this.gerarRequisicaoCompletaItemCom(item, temp, data, os, fase, aux, cache, opcoesPCP);
            }
        }
    }

    public void gerarRequisicaoCompletaItemCom(OSLinhaProducao item, OSLinhaResultado temp, Date data, OrdemServicoProdLinhaProd os, FaseProdutiva fase, AuxGradesQtd aux, CacheSaldoProduto cache, OpcoesPCP opcoesPCP) {
        Requisicao r;
        if ((item.getTipoProducao() != null && item.getGradeFormulaProduto() != null && this.isEquals(item.getTipoProducao().getTipo(), EnumConstTipoProducao.PRODUCAO.getValue()) || this.isEquals(item.getTipoProducao().getTipo(), EnumConstTipoProducao.REFUGO.getValue())) && !this.isNull(r = this.compRequisicaoComunicadoProducao.gerarRequisicaoItemComProducao(item.getItemComunicadoGerado(), item.getGradeFormulaProduto(), data, os, fase, temp.getSubOS(), opcoesPCP, aux, cache)).booleanValue()) {
            item.getItemComunicadoGerado().getRequisicoes().add(r);
        }
    }

    Double getTotalHoras(OrdemServicoProdLinhaProd os) {
        Double tot = 0.0;
        for (SubdivisaoOSProdLinhaProd subdivisaoOSProdLinhaProd : os.getSubDivisoesOS()) {
            tot = tot + subdivisaoOSProdLinhaProd.getHorasPrevistas();
        }
        return tot;
    }

    TipoProducaoSped getTipoProdItemSpedIndEnc() {
        return this.serviceTipoProducaoSped.get(EnumConstTipoProducaoSped.PRODUCAO_EXTERNA_INDUSTRIALIZACAO);
    }

    GradeFormulaProduto getGradeFormulaProd(OrdemServicoProdLinhaProd os) {
        return this.serviceGradeFormulaProduto.get(os.getTipoProducaoSped(), os.getGradeCor());
    }

    RoteiroProducao getRoteiroProducao(OrdemServicoProdLinhaProd os) {
        return this.serviceRoteiroProducao.get(os.getTipoProducaoSped(), os.getGradeCor());
    }

    List<SubdivisaoOSProdLinhaProd> getSubs(OrdemServicoProdLinhaProd os, GradeItemNotaTerceiros grade) {
        SubdivisaoOSProdLinhaProd sub = new SubdivisaoOSProdLinhaProd();
        sub.setDataPrevisao(os.getDataPrevisao());
        sub.setGradeCor(os.getGradeCor());
        sub.setGradeFormulaProduto(os.getGradeFormulaProduto());
        if (os.getGradeItemNotaTerceiros() != null) {
            sub.setLoteFabricacao(os.getGradeItemNotaTerceiros().getLoteFabricacao());
        }
        sub.setNrOrdem(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
        sub.setOrdemServicoProdLinhaProd(os);
        sub.setQuantidadePrevista(os.getQuantidadePrevProd());
        sub.setQuantidadeRefPrevProd(os.getQuantidadeRefPrevProd());
        sub.setRoteiroProducao(os.getRoteiroProducao());
        sub.setCentroCusto(this.getCentroCusto(os.getRoteiroProducao()));
        sub.setHorasPrevistas(this.getHoras(sub));
        LinkedList<SubdivisaoOSProdLinhaProd> l = new LinkedList<SubdivisaoOSProdLinhaProd>();
        l.add(sub);
        return l;
    }

    CentroCusto getCentroCusto(RoteiroProducao roteiroProducao) {
        if (this.isNull(roteiroProducao).booleanValue() || roteiroProducao.getFasesProdutivas().isEmpty()) {
            return null;
        }
        FaseProdutiva fase = (FaseProdutiva)roteiroProducao.getFasesProdutivas().get(0);
        return fase.getCelulaProdutiva().getCentroCusto();
    }

    Double getHoras(SubdivisaoOSProdLinhaProd sub) {
        Double tot = 0.0;
        if (sub.getRoteiroProducao() == null) {
            return tot;
        }
        for (FaseProdutiva fasesProdutiva : sub.getRoteiroProducao().getFasesProdutivas()) {
            tot = tot + sub.getQuantidadePrevista() / fasesProdutiva.getQtdePorHora();
        }
        return tot;
    }

    public ComunicadoProducao buildComunicado(ComunicadoProducao c, OSLinhaResultado temp, Date data) {
        if (c == null) {
            c = new ComunicadoProducao();
            c.setItemComunicadoProducao(new ArrayList());
        }
        if (temp.getSubOS() != null && temp.getSubOS().getOrdemServicoProdLinhaProd() != null) {
            c.setTipoProducaoSped(temp.getSubOS().getOrdemServicoProdLinhaProd().getTipoProducaoSped());
            c.setEmpresa(temp.getSubOS().getOrdemServicoProdLinhaProd().getEmpresa());
        }
        c.setDataCadastro(new Date());
        c.setDataEntradaSaida(data);
        c.setDataFinal(data);
        return c;
    }

    void buildItensComunicado(ComunicadoProducao c) {
        for (ItemComunicadoProducao i : c.getItemComunicadoProducao()) {
            i.setComunicadoProducao(c);
            for (GradeItemComunicadoProducao g : i.getGradeItemComunicadoProducao()) {
                g.setItemComunicadoProducao(i);
                g.setDataMovimentacao(c.getDataEntradaSaida());
                g.setEmpresa(c.getEmpresa());
            }
        }
    }

    public ComunicadoProducao getComunicadoProducaoLinhaProducao(ComunicadoProducao c, OSLinhaResultado temp, FaseProdutiva faseProdutiva, Date data, List<ParametrizacaoCtbComProd> param, Boolean createNewItens, Empresa empresa) {
        this.buildComunicado(c, temp, data);
        c.setItemComunicadoProducao(this.criarItensProducaoLinhaProducao(temp, faseProdutiva.getCelulaProdutiva(), c, createNewItens, empresa));
        c.setItemComunicadoProducao(this.criarItensPerdaLinhaProducao(faseProdutiva.getCelulaProdutiva(), c, temp, createNewItens, empresa));
        c.setItemComunicadoProducao(this.criarItensSobraLinhaProducao(faseProdutiva.getCelulaProdutiva(), c, temp, createNewItens, empresa));
        this.buildItensComunicado(c);
        temp.setComProducaoGerado(c);
        return c;
    }

    public List<ItemComunicadoProducao> criarItensProducaoLinhaProducao(OSLinhaResultado temp, CelulaProdutiva cel, ComunicadoProducao c, Boolean createNewItem, Empresa empresa) {
        List dados = c.getItemComunicadoProducao();
        if (temp.getQuantidadeTipoProducao() <= 0.0) {
            return dados;
        }
        for (OSLinhaProducao item : temp.getProducao()) {
            if (!this.isEquals(item.getTipoProducao().getTipo(), EnumConstTipoProducao.PRODUCAO.getValue())) continue;
            CentroEstoque centro = item.getCentroEstoque();
            ItemComunicadoProducao i = this.getItemComunicadoProducao(EnumConstTipoProducao.PRODUCAO, c.getItemComunicadoProducao(), item.getGradeCor());
            if (i == null || createNewItem.booleanValue()) {
                i = new ItemComunicadoProducao();
                dados.add(i);
            }
            if (centro == null) {
                centro = this.getCentroEstoqueComProd(cel);
            }
            i.setGradeFormulaProduto(item.getGradeFormulaProduto());
            i.setProduto(item.getGradeCor().getProdutoGrade().getProduto());
            i.setCentroEstoque(centro);
            i.setCentroCusto(temp.getSubOS().getCentroCusto());
            if (i.getCentroCusto() == null) {
                i.setCentroCusto(cel.getCentroCusto());
            }
            i.setValorAdCusto(Double.valueOf(0.0));
            i.setTipoProducao(this.serviceTipoProducao.getFirstTipoProducao(EnumConstTipoProducao.PRODUCAO));
            i.setUnidadeMedida(i.getProduto().getUnidadeMedida());
            this.setOutrosCustos(i, temp);
            List grades = i.getGradeItemComunicadoProducao();
            GradeItemComunicadoProducao gi = this.getGradeItemComunicado(item.getGradeCor(), item.getLoteFabricacao(), grades);
            if (gi == null) {
                gi = new GradeItemComunicadoProducao();
                grades.add(gi);
            }
            gi.setLoteFabricacao(item.getLoteFabricacao());
            gi.setGradeCor(item.getGradeCor());
            gi.setQuantidade(item.getQuantidadeReal());
            gi.setQuantidadeReferencia(item.getQuantidadeReferencia());
            gi.setValorUnitario(Double.valueOf(0.0));
            gi.setItemComunicadoProducao(i);
            gi.setCentroEstoque(i.getCentroEstoque());
            gi.setEmpresa(temp.getSubOS().getOrdemServicoProdLinhaProd().getEmpresa());
            i.setGradeItemComunicadoProducao(grades);
            ((HelperItemComunicadoProducao)Context.get(HelperItemComunicadoProducao.class)).calcularTotais(i);
            if (ToolMethods.isWithData(item.getEspecificacoes())) {
                i.setFichasTecnicas(item.getEspecificacoes());
                for (FichaTecItemComProducao fichasTecnica : i.getFichasTecnicas()) {
                    fichasTecnica.setItemComunicadoProducao(i);
                }
            }
            item.setItemComunicadoGerado(i);
        }
        return dados;
    }

    private List<ItemComunicadoProducao> criarItensPerdaLinhaProducao(CelulaProdutiva cel, ComunicadoProducao c, OSLinhaResultado temp, Boolean createNewItens, Empresa empresa) {
        List dados = c.getItemComunicadoProducao();
        for (OSLinhaProducao item : temp.getProducao()) {
            CentroEstoque cc;
            if (!this.isEquals(item.getTipoProducao().getTipo(), EnumConstTipoProducao.REFUGO.getValue())) continue;
            ItemComunicadoProducao i = this.getItemComunicadoProducao(EnumConstTipoProducao.REFUGO, c.getItemComunicadoProducao(), item.getGradeCor());
            if (i == null || createNewItens.booleanValue()) {
                i = new ItemComunicadoProducao();
                dados.add(i);
            }
            if ((cc = item.getCentroEstoque()) == null) {
                cc = this.getCentroEstoqueComProd(cel);
            }
            this.buildItemComunicadoProducao(i, cc, item, temp, cel);
            List grades = i.getGradeItemComunicadoProducao();
            GradeItemComunicadoProducao gi = this.getGradeItemComunicado(item.getGradeCor(), item.getLoteFabricacao(), grades);
            if (gi == null) {
                gi = new GradeItemComunicadoProducao();
                grades.add(gi);
            }
            this.buildGradeItemComunicadoProducao(i, gi, item, empresa, grades);
        }
        return dados;
    }

    private List<ItemComunicadoProducao> criarItensSobraLinhaProducao(CelulaProdutiva cel, ComunicadoProducao c, OSLinhaResultado temp, Boolean createNewItens, Empresa empresa) {
        List dados = c.getItemComunicadoProducao();
        for (OSLinhaProducao item : temp.getProducao()) {
            CentroEstoque cc;
            if (!this.isEquals(item.getTipoProducao().getTipo(), EnumConstTipoProducao.SOBRA.getValue())) continue;
            ItemComunicadoProducao i = this.getItemComunicadoProducao(EnumConstTipoProducao.SOBRA, c.getItemComunicadoProducao(), item.getGradeCor());
            if (i == null || createNewItens.booleanValue()) {
                i = new ItemComunicadoProducao();
                dados.add(i);
            }
            if ((cc = item.getCentroEstoque()) == null) {
                cc = this.getCentroEstoqueComProd(cel);
            }
            this.buildSobraLinhaProducao(i, cc, item, temp, cel);
            List grades = i.getGradeItemComunicadoProducao();
            GradeItemComunicadoProducao gi = this.getGradeItemComunicado(item.getGradeCor(), item.getLoteFabricacao(), grades);
            if (gi == null) {
                gi = new GradeItemComunicadoProducao();
                grades.add(gi);
            }
            this.buildGradeItemComunicadoProducao(i, gi, item, empresa, grades);
        }
        return dados;
    }

    void buildItemComunicadoProducao(ItemComunicadoProducao i, CentroEstoque cc, OSLinhaProducao item, OSLinhaResultado temp, CelulaProdutiva cel) {
        i.setGradeFormulaProduto(item.getGradeFormulaProduto());
        i.setCentroEstoque(cc);
        i.setProduto(item.getGradeCor().getProdutoGrade().getProduto());
        i.setCentroCusto(temp.getSubOS().getCentroCusto());
        if (i.getCentroCusto() == null) {
            i.setCentroCusto(cel.getCentroCusto());
        }
        i.setValorAdCusto(Double.valueOf(0.0));
        i.setTipoProducao(item.getTipoProducao());
        i.setTiposDefeitos(item.getTiposDefeitos());
        i.setUnidadeMedida(i.getProduto().getUnidadeMedida());
    }

    void buildSobraLinhaProducao(ItemComunicadoProducao i, CentroEstoque cc, OSLinhaProducao item, OSLinhaResultado temp, CelulaProdutiva cel) {
        this.buildItemComunicadoProducao(i, cc, item, temp, cel);
        i.setPercentualCustoDesmanche(Double.valueOf(item.getPercentualCustoDesmanche()));
    }

    void buildGradeItemComunicadoProducao(ItemComunicadoProducao i, GradeItemComunicadoProducao gi, OSLinhaProducao item, Empresa empresa, List<GradeItemComunicadoProducao> grades) {
        gi.setLoteFabricacao(item.getLoteFabricacao());
        gi.setGradeCor(item.getGradeCor());
        gi.setQuantidade(item.getQuantidadeReal());
        gi.setQuantidadeReferencia(item.getQuantidadeReferencia());
        gi.setValorUnitario(Double.valueOf(0.0));
        gi.setItemComunicadoProducao(i);
        gi.setCentroEstoque(i.getCentroEstoque());
        gi.setEmpresa(empresa);
        i.setGradeItemComunicadoProducao(grades);
        this.helperItemComunicadoProducao.calcularTotais(i);
        i.setFichasTecnicas(item.getEspecificacoes());
        item.setItemComunicadoGerado(i);
    }

    ItemComunicadoProducao getItemComunicadoProducao(EnumConstTipoProducao tipoProducao, List<ItemComunicadoProducao> itens, GradeCor p) {
        for (ItemComunicadoProducao i : itens) {
            if (i.getTipoProducao() == null || !this.isEquals(i.getTipoProducao().getTipo(), tipoProducao.getValue())) continue;
            for (GradeItemComunicadoProducao g : i.getGradeItemComunicadoProducao()) {
                if (!this.isEquals(g.getGradeCor().getIdentificador(), p.getIdentificador())) continue;
                return i;
            }
        }
        return null;
    }

    GradeItemComunicadoProducao getGradeItemComunicado(GradeCor gradeCor, LoteFabricacao lote, List<GradeItemComunicadoProducao> grades) {
        for (GradeItemComunicadoProducao g : grades) {
            if (!this.isEquals(g.getGradeCor(), gradeCor) || !this.isEquals(lote, g.getLoteFabricacao())) continue;
            return g;
        }
        return null;
    }

    CentroEstoque getCentroEstoqueComProd(CelulaProdutiva cel) {
        for (CelulaProdCentroEstoque c : cel.getCentroEstoque()) {
            CentroEstoque cen;
            if (c.getUtilizarReq() == null || !this.isAffimative(c.getUtilizarCom()) || !this.isEquals((cen = c.getCentroEstoque()).getTipoEstProprioTerceiros(), EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO.getValue())) continue;
            return cen;
        }
        return null;
    }

    void setOutrosCustos(ItemComunicadoProducao i, OSLinhaResultado temp) {
        if (temp != null && temp.getSubOS() != null && temp.getSubOS().getOrdemServicoProdLinhaProd() != null && temp.getSubOS().getOrdemServicoProdLinhaProd().getGradeItemNotaTerceiros() != null) {
            ItemComProdOutrosCustos aux = new ItemComProdOutrosCustos();
            aux.setGradeItemNFTerceirosOrigem(temp.getSubOS().getOrdemServicoProdLinhaProd().getGradeItemNotaTerceiros());
            aux.setItemComunicadoProducao(i);
            aux.setDataReferencia(aux.getGradeItemNFTerceirosOrigem().getDataEntradaSaida());
            aux.setQuantidade(aux.getGradeItemNFTerceirosOrigem().getQuantidade());
            aux.setValor(Double.valueOf(aux.getGradeItemNFTerceirosOrigem().getValorCusto() * aux.getGradeItemNFTerceirosOrigem().getQuantidade()));
            i.getItensOutrosCustos().add(aux);
        }
    }
}

