/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.ordemservico;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.opcoesmanutencaoativos.EnumConstGerarDiagnosticoFechamento;
import com.touchcomp.basementor.constants.enums.ordemservico.EnumConstStatusOrdemServico;
import com.touchcomp.basementor.constants.enums.tipopontocontrole.EnumConstTipoPontoControle;
import com.touchcomp.basementor.model.vo.AtivoDataUltimaManutencao;
import com.touchcomp.basementor.model.vo.AtivoTipoPontoControle;
import com.touchcomp.basementor.model.vo.CronogramaOrdemServico;
import com.touchcomp.basementor.model.vo.CronogramaPlanoManutencaoAtivo;
import com.touchcomp.basementor.model.vo.DiagnosticoOSAtivo;
import com.touchcomp.basementor.model.vo.DiagnosticoOSAtivoItens;
import com.touchcomp.basementor.model.vo.DiagnosticoOSAtivoServProc;
import com.touchcomp.basementor.model.vo.DiagnosticoOSAtivoServico;
import com.touchcomp.basementor.model.vo.FechamentoOrdemServico;
import com.touchcomp.basementor.model.vo.OpcoesManutencEquip;
import com.touchcomp.basementor.model.vo.OrdemServico;
import com.touchcomp.basementor.model.vo.OrdemServicoAlteracaoDataProgramacao;
import com.touchcomp.basementor.model.vo.OrdemServicoNecMateriais;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoManutencaoAtivo;
import com.touchcomp.basementor.model.vo.PlanoManutencaoAtivoAtivo;
import com.touchcomp.basementor.model.vo.PreProcedimento;
import com.touchcomp.basementor.model.vo.PreProdutoPrevManutencao;
import com.touchcomp.basementor.model.vo.PreServicoProcedimento;
import com.touchcomp.basementor.model.vo.Procedimento;
import com.touchcomp.basementor.model.vo.ProdutoPrevManutencao;
import com.touchcomp.basementor.model.vo.ServicoProcedimento;
import com.touchcomp.basementor.model.vo.SetorExecutanteServicos;
import com.touchcomp.basementorservice.helpers.impl.planomanutencaoativo.HelperPlanoManutencaoAtivo;
import com.touchcomp.basementorservice.service.impl.equipamento.ServiceEquipamentoImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompPlanoManutencaoOrdemServico {
    @Autowired
    HelperPlanoManutencaoAtivo helperPlanoManutencaoAtivo;

    public List<OrdemServicoAlteracaoDataProgramacao> gerarOrdemServicoPorPlano(List<PlanoManutencaoAtivoAtivo> planosManutencaoAtivoAtivo, Short opcaoPesquisa, Date dataInicial, Date dataFinal, OpcoesManutencEquip op, Pessoa solicitante, Pessoa responsavel) {
        ArrayList<OrdemServicoAlteracaoDataProgramacao> ordensServicoGeradas = new ArrayList<OrdemServicoAlteracaoDataProgramacao>();
        for (PlanoManutencaoAtivoAtivo planoManutencaoAtivoAtivo : planosManutencaoAtivoAtivo) {
            for (AtivoTipoPontoControle ativo1 : planoManutencaoAtivoAtivo.getAtivoTipoPontoControle()) {
                for (SetorExecutanteServicos setorExec : planoManutencaoAtivoAtivo.getPlanoManutencaoAtivo().getSetorExecutantesServicos()) {
                    this.ordemServicoAlteracaoDataProgramacao(ativo1, setorExec, ordensServicoGeradas, opcaoPesquisa, dataInicial, dataFinal, op, solicitante, responsavel);
                }
            }
        }
        return ordensServicoGeradas;
    }

    private void cronogramaPontoAcumulativo(OrdemServico os, AtivoTipoPontoControle ativoPontoControle, CronogramaOrdemServico cronograma) {
        os.setDataEmissao((Date)ativoPontoControle.getColetaLimite().getDataHoraColeta());
        os.setDataProgramada(ToolDate.toTimestamp((Date)os.getDataEmissao()));
        cronograma.setDataProgramada(ToolDate.toTimestamp((Date)os.getDataEmissao()));
    }

    private void cronogramaPontoPeriodico(AtivoTipoPontoControle ativoPontoControle, Short opcaoPesquisa, OrdemServico os, CronogramaOrdemServico cronograma, Date dataInicial, Date dataFinal) {
        ServiceEquipamentoImpl serviceEquipamento = (ServiceEquipamentoImpl)ConfApplicationContext.getBean(ServiceEquipamentoImpl.class);
        Timestamp dataUltimaManutencao = serviceEquipamento.getDataUltimaManutencao(ativoPontoControle.getPlanoManutencaoAtivoAtivo().getPlanoManutencaoAtivo(), ativoPontoControle.getAtivo(), ativoPontoControle.getPlanoManutencaoAtivoAtivo().getPlanoManutencaoAtivo().getEmpresa(), opcaoPesquisa);
        if (dataUltimaManutencao != null) {
            Date newDataUltimaManutencao = this.helperPlanoManutencaoAtivo.geraDataUltimaManutencaoComPeriodicidade(dataUltimaManutencao, dataInicial, dataFinal, ativoPontoControle.getPlanoManutencaoAtivoAtivo().getPlanoManutencaoAtivo().getPeriodicidade());
            os.setDataEmissao(newDataUltimaManutencao);
            os.setDataProgramada(ToolDate.toTimestamp((Date)os.getDataEmissao()));
            cronograma.setDataProgramada(ToolDate.toTimestamp((Date)os.getDataEmissao()));
        } else {
            for (AtivoDataUltimaManutencao ativoDataUltimaManutencao : ativoPontoControle.getPlanoManutencaoAtivoAtivo().getPlanoManutencaoAtivo().getAtivos()) {
                if (!ativoDataUltimaManutencao.getAtivo().equals((Object)ativoPontoControle.getAtivo())) continue;
                Date newDataUltimaManutencao = this.helperPlanoManutencaoAtivo.geraDataUltimaManutencaoComPeriodicidade(ativoDataUltimaManutencao.getDataUltimaManutencao(), dataInicial, dataFinal, ativoPontoControle.getPlanoManutencaoAtivoAtivo().getPlanoManutencaoAtivo().getPeriodicidade());
                os.setDataEmissao(newDataUltimaManutencao);
                os.setDataProgramada(ToolDate.toTimestamp((Date)os.getDataEmissao()));
                cronograma.setDataProgramada(ToolDate.toTimestamp((Date)os.getDataEmissao()));
            }
        }
    }

    private void cronogramaPontoDemanda(OrdemServico os, CronogramaOrdemServico cronograma) {
        os.setDataEmissao(new Date());
        os.setDataProgramada(ToolDate.toTimestamp((Date)os.getDataEmissao()));
        cronograma.setDataProgramada(ToolDate.toTimestamp((Date)os.getDataEmissao()));
    }

    private OrdemServicoAlteracaoDataProgramacao ordemServicoAlteracaoDataProgramacao(AtivoTipoPontoControle ativoPontoControle, SetorExecutanteServicos setorExec, List<OrdemServicoAlteracaoDataProgramacao> ordensServicoGeradas, Short opcaoPesquisa, Date dataInicial, Date dataFinal, OpcoesManutencEquip op, Pessoa solicitante, Pessoa responsavel) {
        for (OrdemServicoAlteracaoDataProgramacao os : ordensServicoGeradas) {
            if (!os.getOrdemServico().getEquipamento().equals((Object)ativoPontoControle.getAtivo()) || !os.getOrdemServico().getSetorExecutante().equals((Object)setorExec.getSetorExecutante())) continue;
            os.getOrdemServico().getPlanosManutencaoAtivo().add(ativoPontoControle.getPlanoManutencaoAtivoAtivo().getPlanoManutencaoAtivo());
            os.getOrdemServico().setDescricaoServico(String.valueOf(os.getOrdemServico()) + ", " + ativoPontoControle.getPlanoManutencaoAtivoAtivo().getPlanoManutencaoAtivo().getIdentificador() + " - " + ativoPontoControle.getPlanoManutencaoAtivoAtivo().getPlanoManutencaoAtivo().getDescricao());
            this.setarServicoAndProcedimentoFechamentoOrDiagnostico(os, setorExec, op);
            return os;
        }
        OrdemServico os = new OrdemServico();
        os.setDataCadastro(new Date());
        os.setEmpresa(ativoPontoControle.getEmpresa());
        CronogramaOrdemServico cronograma = new CronogramaOrdemServico();
        if (ToolMethods.isEquals((Object)ativoPontoControle.getPlanoManutencaoAtivoAtivo().getPlanoManutencaoAtivo().getTipoControle().getIdentificador(), (Object)EnumConstTipoPontoControle.TIPO_PONTO_ACUMULATIVO.getValue())) {
            this.cronogramaPontoAcumulativo(os, ativoPontoControle, cronograma);
        } else if (ToolMethods.isEquals((Object)ativoPontoControle.getPlanoManutencaoAtivoAtivo().getPlanoManutencaoAtivo().getTipoControle().getIdentificador(), (Object)EnumConstTipoPontoControle.TIPO_PONTO_PERIODICO.getValue())) {
            this.cronogramaPontoPeriodico(ativoPontoControle, opcaoPesquisa, os, cronograma, dataInicial, dataFinal);
        } else if (ToolMethods.isEquals((Object)ativoPontoControle.getPlanoManutencaoAtivoAtivo().getPlanoManutencaoAtivo().getTipoControle().getIdentificador(), (Object)EnumConstTipoPontoControle.TIPO_PONTO_DEMANDA)) {
            this.cronogramaPontoDemanda(os, cronograma);
        }
        os.setSolicitante(solicitante);
        os.setResponsavel(responsavel);
        os.setStatus(Short.valueOf(EnumConstStatusOrdemServico.ABERTO.getValue()));
        os.setGerado(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
        os.setTipoServico(ativoPontoControle.getPlanoManutencaoAtivoAtivo().getPlanoManutencaoAtivo().getTipoServico());
        os.setPrioridade(ativoPontoControle.getPlanoManutencaoAtivoAtivo().getPlanoManutencaoAtivo().getPrioridade());
        os.setDescricaoServico("Ordem Servi\u00e7o gerada por Plano de Manuten\u00e7\u00e3o Id. " + ativoPontoControle.getPlanoManutencaoAtivoAtivo().getPlanoManutencaoAtivo().getIdentificador() + " - " + ativoPontoControle.getPlanoManutencaoAtivoAtivo().getPlanoManutencaoAtivo().getDescricao());
        os.setEquipamento(ativoPontoControle.getAtivo());
        os.setCentroCusto(ativoPontoControle.getAtivo().getCentroCusto());
        os.setSetorExecutante(setorExec.getSetorExecutante());
        os.setFornecedor(setorExec.getFornecedor());
        os.setReservarEstoque(ativoPontoControle.getPlanoManutencaoAtivoAtivo().getPlanoManutencaoAtivo().getReservarEstoque());
        os.getPlanosManutencaoAtivo().add(ativoPontoControle.getPlanoManutencaoAtivoAtivo().getPlanoManutencaoAtivo());
        cronograma.setCentroCusto(ativoPontoControle.getAtivo().getCentroCusto());
        cronograma.setDataCadastro(new Date());
        cronograma.setStatus(Short.valueOf(EnumConstStatusOrdemServico.ABERTO.getValue()));
        cronograma.setTipoServico(ativoPontoControle.getPlanoManutencaoAtivoAtivo().getPlanoManutencaoAtivo().getTipoServico());
        cronograma.setEquipamento(ativoPontoControle.getAtivo());
        cronograma.setSimulado(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
        cronograma.setSetorExecutante(setorExec.getSetorExecutante());
        cronograma.setEmpresa(ativoPontoControle.getEmpresa());
        cronograma.setOrdemServico(os);
        cronograma.setPlanoManutencao(this.getPlanoManutencaoCronograma(os, cronograma));
        os.setCronogramaOrdemServico(cronograma);
        OrdemServicoAlteracaoDataProgramacao ordemServicoAlteracaoDataProgramacao = new OrdemServicoAlteracaoDataProgramacao();
        ordemServicoAlteracaoDataProgramacao.setDataCadastro(new Date());
        ordemServicoAlteracaoDataProgramacao.setEmpresa(os.getEmpresa());
        ordemServicoAlteracaoDataProgramacao.setOrdemServico(os);
        ordemServicoAlteracaoDataProgramacao.setDataProgramacaoAntiga(os.getDataProgramada());
        if (os.getDataProgramada() != null) {
            ordensServicoGeradas.add(ordemServicoAlteracaoDataProgramacao);
        }
        this.criarFechDiagnostico(ordemServicoAlteracaoDataProgramacao, setorExec, op);
        return ordemServicoAlteracaoDataProgramacao;
    }

    private void criarFechDiagnostico(OrdemServicoAlteracaoDataProgramacao osProgramacao, SetorExecutanteServicos setorExec, OpcoesManutencEquip op) {
        if (ToolMethods.isEquals((Object)op.getGerarDiagnosticoFechamento(), (Object)EnumConstGerarDiagnosticoFechamento.TIPO_GERA_FECHA_DIAG_FECHAMENTO.getValue())) {
            this.criarFechamento(osProgramacao, setorExec);
        } else if (ToolMethods.isEquals((Object)op.getGerarDiagnosticoFechamento(), (Object)EnumConstGerarDiagnosticoFechamento.TIPO_GERA_FECHA_DIAG_DIAGNOSTICO.getValue())) {
            this.criarDiagnostico(osProgramacao, setorExec.getPreServicoProcedimentos());
        }
    }

    private void criarDiagnostico(OrdemServicoAlteracaoDataProgramacao osProgramacao, List<PreServicoProcedimento> preServicoProcedimentos) {
        DiagnosticoOSAtivo vo = osProgramacao.getOrdemServico().getDiagnosticoOSAtivo();
        if (vo == null) {
            vo = new DiagnosticoOSAtivo();
        }
        vo.setDataCadastro(new Date());
        vo.setDataNecessidade(null);
        vo.setGerarPedAlmoxarifado(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
        vo.setObservacao("Diagnostico OS.");
        vo.setOrdemServico(osProgramacao.getOrdemServico());
        vo.getOrdemServico().setDiagnosticoOSAtivo(vo);
        this.setServicosOSDiagnostico(vo, preServicoProcedimentos);
    }

    private void criarFechamento(OrdemServicoAlteracaoDataProgramacao osProgramacao, SetorExecutanteServicos setorExec) {
        FechamentoOrdemServico fechamento = new FechamentoOrdemServico();
        fechamento.setDataCadastro(new Date());
        fechamento.setEmpresa(osProgramacao.getOrdemServico().getEmpresa());
        fechamento.setOrdemServico(osProgramacao.getOrdemServico());
        fechamento.setOsFechada(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
        osProgramacao.getOrdemServico().setFechamentoOrdemServico(fechamento);
        this.setServicosOS(osProgramacao, setorExec.getPreServicoProcedimentos());
    }

    private List<CronogramaPlanoManutencaoAtivo> getPlanoManutencaoCronograma(OrdemServico os, CronogramaOrdemServico crono) {
        ArrayList<CronogramaPlanoManutencaoAtivo> planos = new ArrayList<CronogramaPlanoManutencaoAtivo>();
        if (os.getPlanosManutencaoAtivo() != null && !os.getPlanosManutencaoAtivo().isEmpty()) {
            for (PlanoManutencaoAtivo p : os.getPlanosManutencaoAtivo()) {
                CronogramaPlanoManutencaoAtivo c = new CronogramaPlanoManutencaoAtivo();
                c.setCronograma(crono);
                c.setPlanoManutencaoAtivo(p);
                planos.add(c);
            }
        }
        return planos;
    }

    private void setarServicoAndProcedimentoFechamentoOrDiagnostico(OrdemServicoAlteracaoDataProgramacao os, SetorExecutanteServicos setorExec, OpcoesManutencEquip op) {
        if (ToolMethods.isEquals((Object)op.getGerarDiagnosticoFechamento(), (Object)EnumConstGerarDiagnosticoFechamento.TIPO_GERA_FECHA_DIAG_FECHAMENTO.getValue())) {
            this.setServicosOS(os, setorExec.getPreServicoProcedimentos());
        } else if (ToolMethods.isEquals((Object)op.getGerarDiagnosticoFechamento(), (Object)EnumConstGerarDiagnosticoFechamento.TIPO_GERA_FECHA_DIAG_DIAGNOSTICO.getValue())) {
            this.setServicosOSDiagnostico(os.getOrdemServico().getDiagnosticoOSAtivo(), setorExec.getPreServicoProcedimentos());
        }
    }

    private void setServicosOS(OrdemServicoAlteracaoDataProgramacao found, List<PreServicoProcedimento> preServicosProcedimentos) {
        block0: for (PreServicoProcedimento preServicoProcedimento : preServicosProcedimentos) {
            for (ServicoProcedimento servProcedimento : found.getOrdemServico().getFechamentoOrdemServico().getServicoProcedimentos()) {
                if (!servProcedimento.getServico().getIdentificador().equals(preServicoProcedimento.getServico().getIdentificador())) continue;
                servProcedimento.getProcedimento().addAll(this.getProcedimentos(preServicoProcedimento, servProcedimento, found));
                ServicoProcedimento servicoProcedimento = new ServicoProcedimento();
                servicoProcedimento.setDataCadastro(new Date());
                servicoProcedimento.setPreServicoProcedimento(preServicoProcedimento);
                servicoProcedimento.setEmpresa(preServicoProcedimento.getEmpresa());
                servicoProcedimento.setFechamentoOrdemServico(found.getOrdemServico().getFechamentoOrdemServico());
                servicoProcedimento.setServico(preServicoProcedimento.getServico());
                servicoProcedimento.setProcedimento(this.getProcedimentos(preServicoProcedimento, servicoProcedimento, found));
                found.getOrdemServico().getFechamentoOrdemServico().getServicoProcedimentos().add(servicoProcedimento);
                continue block0;
            }
        }
    }

    private void setServicosOSDiagnostico(DiagnosticoOSAtivo vo, List<PreServicoProcedimento> preServicosProcedimentos) {
        for (PreServicoProcedimento preServicoProcedimento : preServicosProcedimentos) {
            List filtered = vo.getServicos().stream().filter(item -> item.getPreServicoProcedimento().equals((Object)preServicoProcedimento)).collect(Collectors.toList());
            if (!filtered.isEmpty()) continue;
            DiagnosticoOSAtivoServico found = new DiagnosticoOSAtivoServico();
            found.setPreServicoProcedimento(preServicoProcedimento);
            found.setDiagnosticoOSAtivo(vo);
            found.setServico(preServicoProcedimento.getServico());
            vo.getServicos().add(found);
            this.getProcedimentosDiagnostico(preServicoProcedimento, found);
        }
    }

    private void getProcedimentosDiagnostico(PreServicoProcedimento preServicoProcedimento, DiagnosticoOSAtivoServico vo) {
        for (PreProcedimento preProcedimento : preServicoProcedimento.getPreProcedimento()) {
            List filtered = vo.getProcedimentos().stream().filter(item -> item.getPreProcedimento().equals((Object)preServicoProcedimento)).collect(Collectors.toList());
            if (!filtered.isEmpty()) continue;
            DiagnosticoOSAtivoServProc found = new DiagnosticoOSAtivoServProc();
            found.setDiagnosticoOSAtivoServ(vo);
            found.setObservacaoProcedimento(preProcedimento.getDescricao());
            found.setPreProcedimento(preProcedimento);
            vo.getProcedimentos().add(found);
            this.getProdutosPrevisaoManutencaoDiagnostico(preProcedimento, found);
        }
    }

    private void getProdutosPrevisaoManutencaoDiagnostico(PreProcedimento preProcedimento, DiagnosticoOSAtivoServProc found) {
        for (PreProdutoPrevManutencao preProdutoPrevManutencao : preProcedimento.getPreProdutosPrevisaoManutencao()) {
            DiagnosticoOSAtivoItens produtoPrevManutencao = new DiagnosticoOSAtivoItens();
            produtoPrevManutencao.setDiagnosticoOSAtivoServProc(found);
            produtoPrevManutencao.setGradeCor(preProdutoPrevManutencao.getGradeCor());
            produtoPrevManutencao.setQuantidade(preProdutoPrevManutencao.getQtdPrevista());
            found.getItens().add(produtoPrevManutencao);
        }
    }

    private List<Procedimento> getProcedimentos(PreServicoProcedimento preServicoProcedimento, ServicoProcedimento servicoProcedimento, OrdemServicoAlteracaoDataProgramacao found) {
        ArrayList<Procedimento> procedimentos = new ArrayList<Procedimento>();
        for (PreProcedimento preProcedimento : preServicoProcedimento.getPreProcedimento()) {
            Procedimento procedimento = new Procedimento();
            procedimento.setDataCadastro(new Date());
            procedimento.setDescricao(preProcedimento.getDescricao());
            procedimento.setEmpresa(preProcedimento.getEmpresa());
            procedimento.setServicoProcedimento(servicoProcedimento);
            procedimento.setPreProcedimento(preProcedimento);
            procedimento.setProdutosPrevisaoManutencao(this.getProdutosPrevisaoManutencao(procedimento, preProcedimento, found));
            procedimentos.add(procedimento);
        }
        return procedimentos;
    }

    private List<ProdutoPrevManutencao> getProdutosPrevisaoManutencao(Procedimento procedimento, PreProcedimento preProcedimento, OrdemServicoAlteracaoDataProgramacao found) {
        ArrayList<ProdutoPrevManutencao> produtosPrevManutencao = new ArrayList<ProdutoPrevManutencao>();
        for (PreProdutoPrevManutencao preProdutoPrevManutencao : preProcedimento.getPreProdutosPrevisaoManutencao()) {
            ProdutoPrevManutencao produtoPrevManutencao = new ProdutoPrevManutencao();
            produtoPrevManutencao.setDataCadastro(new Date());
            produtoPrevManutencao.setEmpresa(preProdutoPrevManutencao.getEmpresa());
            produtoPrevManutencao.setPreProdutoPrevManutencao(preProdutoPrevManutencao);
            produtoPrevManutencao.setProcedimento(procedimento);
            produtoPrevManutencao.setGradeCor(preProdutoPrevManutencao.getGradeCor());
            produtoPrevManutencao.setQtdPrevista(preProdutoPrevManutencao.getQtdPrevista());
            produtosPrevManutencao.add(produtoPrevManutencao);
            OrdemServicoNecMateriais necMateriais = new OrdemServicoNecMateriais();
            necMateriais.setGradeCor(preProdutoPrevManutencao.getGradeCor());
            necMateriais.setQuantidade(preProdutoPrevManutencao.getQtdPrevista());
            necMateriais.setOrdemServico(found.getOrdemServico());
            found.getOrdemServico().getOrdemServicoNecMateriais().add(necMateriais);
        }
        return produtosPrevManutencao;
    }
}

