/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.pedidoalmoxarifado;

import com.touchcomp.basementor.model.vo.DeParaFornecedorItem;
import com.touchcomp.basementor.model.vo.DiagnosticoOSAtivo;
import com.touchcomp.basementor.model.vo.DiagnosticoOSAtivoItens;
import com.touchcomp.basementor.model.vo.DiagnosticoOSAtivoServProc;
import com.touchcomp.basementor.model.vo.DiagnosticoOSAtivoServico;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeItemPedidoAlmoxarifado;
import com.touchcomp.basementor.model.vo.ItemPedidoAlmoxarifado;
import com.touchcomp.basementor.model.vo.PedidoAlmoxarifado;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.BaseMethods;
import com.touchcomp.basementorservice.service.impl.deparafornecedor.ServiceDeParaFornecedorItemImpl;
import com.touchcomp.basementorservice.service.impl.gradecor.ServiceGradeCorImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompPedidoAlmoxarifado
extends BaseMethods {
    @Autowired
    private ServiceDeParaFornecedorItemImpl serviceDeParaFornecedor;
    @Autowired
    private ServiceGradeCorImpl serviceGradeCorImpl;

    public void substituirProdutos(List<PedidoAlmoxarifado> pedidos, Empresa empresaAtend) throws ExceptionInvalidData {
        for (PedidoAlmoxarifado ped : pedidos) {
            if (ToolMethods.isEquals((Object)ped.getEmpresa(), (Object)empresaAtend)) continue;
            this.substituir(ped, empresaAtend);
        }
    }

    private void substituir(PedidoAlmoxarifado ped, Empresa empresaAtend) throws ExceptionInvalidData {
        for (ItemPedidoAlmoxarifado item : ped.getItensPedido()) {
            DeParaFornecedorItem depara = this.serviceDeParaFornecedor.getDeParaFornecedorItem(ped.getNaturezaOperacao(), item.getProduto(), ped.getEmpresa(), empresaAtend.getPessoa());
            if (depara == null || depara.getProdutoSaida() == null) continue;
            if (item.getProdutoOriginal() == null) {
                item.setProdutoOriginal(item.getProduto());
            }
            item.setProduto(depara.getProdutoSaida());
            List<GradeCor> grades = this.serviceGradeCorImpl.get(item.getProduto());
            List gradesItemPed = item.getGradesItensAlmoxarifado();
            for (GradeItemPedidoAlmoxarifado grItem : gradesItemPed) {
                Optional<GradeCor> found = grades.stream().filter(i -> ToolMethods.isEquals((Object)i.getCor(), (Object)grItem.getGradeCor().getCor())).findFirst();
                if (found.isPresent()) {
                    if (grItem.getGradeCorOriginal() == null) {
                        grItem.setGradeCorOriginal(grItem.getGradeCor());
                    }
                    grItem.setGradeCor(found.get());
                    continue;
                }
                throw new ExceptionInvalidData("01-02-00716", new Object[]{item.getProdutoOriginal(), item.getProduto()});
            }
        }
    }

    public void substituir(ItemPedidoAlmoxarifado item, Produto prod) throws ExceptionInvalidData {
        block6: {
            block5: {
                if (prod != null) break block5;
                if (item.getProdutoOriginal() == null) break block6;
                item.setProduto(item.getProdutoOriginal());
                item.setProdutoOriginal(null);
                for (GradeItemPedidoAlmoxarifado grItem : item.getGradesItensAlmoxarifado()) {
                    grItem.setGradeCor(grItem.getGradeCorOriginal());
                    grItem.setGradeCorOriginal(null);
                }
                break block6;
            }
            if (item.getProdutoOriginal() == null) {
                item.setProdutoOriginal(item.getProduto());
            }
            item.setProduto(prod);
            List<GradeCor> grades = this.serviceGradeCorImpl.get(item.getProduto());
            List gradesItemPed = item.getGradesItensAlmoxarifado();
            for (GradeItemPedidoAlmoxarifado grItem : gradesItemPed) {
                Optional<GradeCor> found = grades.stream().filter(i -> ToolMethods.isEquals((Object)i.getCor(), (Object)grItem.getGradeCor().getCor())).findFirst();
                if (found.isPresent()) {
                    if (grItem.getGradeCorOriginal() == null) {
                        grItem.setGradeCorOriginal(grItem.getGradeCor());
                    }
                    grItem.setGradeCor(found.get());
                    continue;
                }
                throw new ExceptionInvalidData("01-02-00716", new Object[]{item.getProdutoOriginal(), item.getProduto()});
            }
        }
    }

    public void gerarPedidoAlmoxarifado(DiagnosticoOSAtivo vo, Usuario usuario) {
        if (this.isAffimative(vo.getGerarPedAlmoxarifado())) {
            PedidoAlmoxarifado ped = vo.getPedidoAlmoxarifado();
            if (ped == null) {
                ped = new PedidoAlmoxarifado();
                ped.setDiagnosticoOS(vo);
            }
            ped.setDataAgendamento(vo.getDataNecessidade());
            ped.setDataEmissao(new Date());
            ped.setDataCadastro(new Date());
            ped.setUsuario(usuario);
            ped.setDiagnosticoOS(vo);
            if (vo.getOrdemServico() != null) {
                ped.setEmpresa(vo.getOrdemServico().getEmpresa());
            }
            ped.setObservacao(vo.getObservacao());
            this.getItensPedido(ped, vo);
            vo.setPedidoAlmoxarifado(ped);
        }
    }

    void getItensPedido(PedidoAlmoxarifado ped, DiagnosticoOSAtivo vo) {
        if (vo.getServicos() != null) {
            for (DiagnosticoOSAtivoServico servico : vo.getServicos()) {
                if (servico.getProcedimentos() == null) continue;
                for (DiagnosticoOSAtivoServProc procedimento : servico.getProcedimentos()) {
                    if (servico.getProcedimentos() == null) continue;
                    for (DiagnosticoOSAtivoItens iten : procedimento.getItens()) {
                        if (iten.getItemPedidoAlmoxarifado() != null) continue;
                        ItemPedidoAlmoxarifado itAl = new ItemPedidoAlmoxarifado();
                        itAl.setPedidoAlmoxarifado(ped);
                        if (vo.getOrdemServico() != null) {
                            itAl.setCentroCusto(vo.getOrdemServico().getCentroCusto());
                        }
                        if (iten.getGradeCor() != null && iten.getGradeCor().getProdutoGrade() != null) {
                            itAl.setProduto(iten.getGradeCor().getProdutoGrade().getProduto());
                        }
                        itAl.setQuantidadeTotal(iten.getQuantidade());
                        iten.setItemPedidoAlmoxarifado(itAl);
                        ped.getItensPedido().add(itAl);
                        GradeItemPedidoAlmoxarifado gr = new GradeItemPedidoAlmoxarifado();
                        gr.setGradeCor(iten.getGradeCor());
                        gr.setItemPedidoAlmoxarifado(itAl);
                        gr.setQuantidade(iten.getQuantidade());
                        itAl.getGradesItensAlmoxarifado().add(gr);
                    }
                }
            }
        }
    }
}

