/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.pessoa;

import com.touchcomp.basementor.constants.enums.pessoa.EnumConstTipoPessoaComplementar;
import com.touchcomp.basementor.model.impl.ImplLogradouro;
import com.touchcomp.basementor.model.vo.Complemento;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Proxy;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.impl.google.ExceptionGoogle;
import com.touchcomp.basementorservice.components.proxy.CompProxy;
import com.touchcomp.basementorservice.service.impl.cidade.ServiceCidadeImpl;
import com.touchcomp.basementorservice.service.impl.endereco.ServiceEnderecoImpl;
import com.touchcomp.basementorservice.service.impl.pessoa.ServicePessoaImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.model.net.ProxyNet;
import com.touchcomp.basementortools.tools.googlelocations.ToolGoogleLocations;
import com.touchcomp.basementortools.tools.googlelocations.model.GoogleAddress;
import com.touchcomp.basementortools.tools.googlelocations.model.GoogleGeographicPosition;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.string.TString;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompPessoa {
    @Autowired
    ServiceEnderecoImpl serviceEndereco;
    @Autowired
    ServiceCidadeImpl serviceCidadeImpl;

    public GoogleGeographicPosition calcularPosicao(String keyAPIGoogle, Proxy proxyHTTP, String logradouro, String numero, String bairro, String cidade, String sigla) throws ExceptionGoogle {
        return ToolGoogleLocations.getGeographicPosition((String)keyAPIGoogle, (GoogleAddress)new GoogleAddress(logradouro, numero, bairro, cidade, sigla), (ProxyNet)CompProxy.convert(proxyHTTP));
    }

    public Endereco pesquisarEnderecoCep(String cep, Empresa empresa) throws ExceptionBase {
        ImplLogradouro logradouro = this.serviceEndereco.getLogroudroByCep(cep, empresa);
        if (TMethods.isNotNull((Object)logradouro).booleanValue()) {
            Endereco e = new Endereco();
            e.setBairro(logradouro.getBairro());
            e.setCep(cep);
            e.setCidade(logradouro.getCidade());
            e.setComplemento(logradouro.getComplemento());
            e.setLogradouro(logradouro.getLogradouro());
            return e;
        }
        return new Endereco();
    }

    public Pessoa criarPessoa(Empresa empresa, String razaoSocial, String cnpj, String logradouro, String bairro, String cep, String complemento, Double latitude, Double longitude, String codIbgeMun, String numero) throws ExceptionBase {
        Pessoa p = new Pessoa();
        p.setAtivo(Short.valueOf((short)0));
        p.setDataCadastro(new Date());
        p.setDataInicioRelacionamento(new Date());
        p.setNome(razaoSocial);
        p.setNomeFantasia(razaoSocial);
        p.setLatitude(latitude);
        p.setLongitude(longitude);
        p.setEndereco(this.criarEndereco(empresa, cep, logradouro, bairro, numero, complemento, codIbgeMun));
        p.setComplemento(this.criarComplemento(cnpj, p.getAtivo()));
        return ((ServicePessoaImpl)ConfApplicationContext.getBean(ServicePessoaImpl.class)).saveOrUpdate(p);
    }

    private Endereco criarEndereco(Empresa empresa, String cep, String logradouro, String bairro, String numero, String complemento, String codMunicipio) throws ExceptionBase {
        ImplLogradouro logradouroPesq;
        if (!TMethods.isStrWithData((String)numero)) {
            numero = "SN";
        }
        Endereco e = new Endereco();
        e.setCep(cep);
        e.setLogradouro(logradouro);
        e.setBairro(bairro);
        e.setNumero(numero);
        e.setComplemento(complemento);
        codMunicipio = TString.onlyNumbers((String)codMunicipio);
        if (TMethods.isStrWithData((String)codMunicipio)) {
            e.setCidade(this.serviceCidadeImpl.getByCodigoIBGE(codMunicipio));
        }
        if (e.getCidade() == null && (logradouroPesq = this.serviceEndereco.getLogroudroByCep(cep, empresa)) != null) {
            e.setCidade(logradouroPesq.getCidade());
        }
        return e;
    }

    private Complemento criarComplemento(String cnpj, Short ativo) {
        Complemento c = new Complemento();
        c.setAtivo(ativo);
        c.setCnpj(ToolString.refina((String)cnpj));
        c.setTipoPessoa(this.getPessoaFisicaJuridica(c.getCnpj()));
        return c;
    }

    private Short getPessoaFisicaJuridica(String cnpj) {
        if (cnpj != null && cnpj.trim().length() == 14) {
            return EnumConstTipoPessoaComplementar.JURIDICA.getEnumId();
        }
        return EnumConstTipoPessoaComplementar.FISICA.getEnumId();
    }
}

