/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.planoconta;

import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.Cooperado;
import com.touchcomp.basementor.model.vo.Fornecedor;
import com.touchcomp.basementor.model.vo.GeracaoContaPessoa;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDadosRuntime;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.BaseMethods;
import com.touchcomp.basementorservice.helpers.impl.planoconta.HelperPlanoConta;
import com.touchcomp.basementorservice.service.impl.geracaocontapessoa.ServiceGeracaoContaPessoaImpl;
import com.touchcomp.basementorservice.service.impl.planoconta.ServicePlanoContaImpl;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompPlanoConta
extends BaseMethods {
    @Autowired
    private ServicePlanoContaImpl servicePlanoConta;
    @Autowired
    private ServiceGeracaoContaPessoaImpl serviceContasPessoa;
    @Autowired
    private HelperPlanoConta helperPC;

    public PlanoConta getPlanoContaCooperado(GeracaoContaPessoa gerContaPessoa, Cooperado cooperado, OpcoesContabeis opcoesContabeis) {
        if (gerContaPessoa.getPlanoContaCooperado() != null) {
            return gerContaPessoa.getPlanoContaCooperado();
        }
        PlanoConta planoConta = opcoesContabeis.getOpcoesContabeisGerContaPessoa().getPlanoContaCooperado();
        if (planoConta == null) {
            throw new ExceptionValidacaoDadosRuntime(new ExcepCodeDetail("E.ERP.1757.004", new String[]{opcoesContabeis.getEmpresa().toString()}));
        }
        if (((HelperPlanoConta)Context.get(HelperPlanoConta.class)).isAnalitica(planoConta)) {
            gerContaPessoa.setPlanoContaCooperado(planoConta);
        } else {
            planoConta = this.servicePlanoConta.getNewPlanoConta(opcoesContabeis.getOpcoesContabeisGerContaPessoa().getPlanoContaCooperado(), cooperado.getCliente().getPessoa().getNome(), opcoesContabeis);
            gerContaPessoa.setPlanoContaCooperado(planoConta);
            gerContaPessoa = this.serviceContasPessoa.saveOrUpdate(gerContaPessoa);
        }
        return gerContaPessoa.getPlanoContaCooperado();
    }

    public GeracaoContaPessoa gerarPlanoContaCliente(Cliente cliente, OpcoesContabeis opcoes) throws ExceptionInvalidData {
        return this.buildPlanoConta(cliente, opcoes);
    }

    public GeracaoContaPessoa gerarPlanoContaFornecedor(Fornecedor fornecedor, OpcoesContabeis opcoes) throws ExceptionInvalidData {
        return this.buildPlanoConta(fornecedor, opcoes);
    }

    public GeracaoContaPessoa gerarPlanoContaRepresentante(Representante representante, OpcoesContabeis opcoes) throws ExceptionInvalidData {
        return this.buildPlanoConta(representante, opcoes);
    }

    public GeracaoContaPessoa buildPlanoConta(Cliente cliente, OpcoesContabeis opcoes) throws ExceptionInvalidData {
        PlanoConta codPlanoConta = opcoes.getOpcoesContabeisGerContaPessoa().getPlanoContaCliente();
        if (this.isNull(codPlanoConta).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.1757.002", new Object[]{opcoes.getEmpresa().toString()});
        }
        if (this.isNull(cliente).booleanValue() || this.isNull(cliente.getPessoa()).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.1758.001", new Object[0]);
        }
        PlanoConta planoConta = this.servicePlanoConta.getNewPlanoConta(opcoes.getOpcoesContabeisGerContaPessoa().getPlanoContaCliente(), cliente.getPessoa().getNome(), cliente.getPessoa().getComplemento().getCnpj(), opcoes);
        if (this.isNull(planoConta).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.1758.002", new Object[]{opcoes.getEmpresa()});
        }
        GeracaoContaPessoa vo = this.build(cliente);
        vo.setPlanoContaAtivo(planoConta);
        vo = this.serviceContasPessoa.saveOrUpdateFlush(vo);
        return vo;
    }

    public PlanoConta buildPlanoContaCliente(Pessoa pessoa, OpcoesContabeis opcoes) throws ExceptionInvalidData {
        PlanoConta codPlanoConta = opcoes.getOpcoesContabeisGerContaPessoa().getPlanoContaCliente();
        if (this.isNull(codPlanoConta).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.1757.002", new Object[]{opcoes.getEmpresa().toString()});
        }
        if (this.isNull(pessoa).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.1758.001", new Object[0]);
        }
        PlanoConta planoConta = this.servicePlanoConta.getNewPlanoConta(opcoes.getOpcoesContabeisGerContaPessoa().getPlanoContaCliente(), pessoa.getNome(), pessoa.getComplemento().getCnpj(), opcoes);
        if (this.isNull(planoConta).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.1758.002", new Object[]{opcoes.getEmpresa()});
        }
        return this.servicePlanoConta.saveOrUpdateFlush(planoConta);
    }

    public PlanoConta buildPlanoContaFornecedor(Pessoa fornecedor, OpcoesContabeis opcoes) throws ExceptionInvalidData {
        PlanoConta codPlanoConta = opcoes.getOpcoesContabeisGerContaPessoa().getPlanoAntecipFornecedor();
        if (this.isNull(codPlanoConta).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.1757.007", new Object[]{opcoes.getEmpresa()});
        }
        if (this.isNull(fornecedor).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.1758.003", new Object[0]);
        }
        PlanoConta planoConta = this.servicePlanoConta.getNewPlanoConta(codPlanoConta, fornecedor.getNome(), fornecedor.getComplemento().getCnpj(), opcoes);
        if (this.isNull(planoConta).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.1758.002", new Object[]{opcoes.getEmpresa()});
        }
        return this.servicePlanoConta.saveOrUpdate(planoConta);
    }

    public PlanoConta buildPlanoContaTomador(Pessoa tomador, OpcoesContabeis opcoes) throws ExceptionInvalidData {
        PlanoConta codPlanoConta = opcoes.getOpcoesContabeisGerContaPessoa().getPlanoContaTomador();
        if (this.isNull(codPlanoConta).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.1757.010", new Object[]{opcoes.getEmpresa()});
        }
        if (this.isNull(tomador).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.1758.003", new Object[0]);
        }
        PlanoConta planoConta = this.servicePlanoConta.getNewPlanoConta(codPlanoConta, tomador.getNome(), tomador.getComplemento().getCnpj(), opcoes);
        if (this.isNull(planoConta).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.1758.002", new Object[]{opcoes.getEmpresa()});
        }
        return this.servicePlanoConta.saveOrUpdate(planoConta);
    }

    public GeracaoContaPessoa buildPlanoContaAntecip(Cliente cliente, OpcoesContabeis opcoes) throws ExceptionInvalidData {
        PlanoConta codPlanoConta = opcoes.getOpcoesContabeisGerContaPessoa().getPlanoAntecipCliente();
        if (this.isNull(codPlanoConta).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.1757.003", new Object[]{opcoes.getEmpresa()});
        }
        if (this.isNull(cliente).booleanValue() || this.isNull(cliente.getPessoa()).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.1758.001", new Object[0]);
        }
        PlanoConta planoConta = this.servicePlanoConta.getNewPlanoConta(codPlanoConta, cliente.getPessoa().getNome(), cliente.getPessoa().getComplemento().getCnpj(), opcoes);
        if (this.isNull(planoConta).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.1758.002", new Object[]{opcoes.getEmpresa()});
        }
        planoConta = this.servicePlanoConta.saveOrUpdateFlush(planoConta);
        GeracaoContaPessoa vo = this.build(cliente);
        vo.setPlanoContaAntecAtivo(planoConta);
        vo = this.serviceContasPessoa.saveOrUpdateFlush(vo);
        return vo;
    }

    public GeracaoContaPessoa gerarPlanoContaClienteAntecip(Cliente cliente, OpcoesContabeis opcoes) throws ExceptionInvalidData {
        GeracaoContaPessoa vo = this.buildPlanoContaAntecip(cliente, opcoes);
        this.serviceContasPessoa.saveOrUpdate(vo);
        return vo;
    }

    public GeracaoContaPessoa buildPlanoConta(Fornecedor fornecedor, OpcoesContabeis opcoes) throws ExceptionInvalidData {
        PlanoConta codPlanoConta = opcoes.getOpcoesContabeisGerContaPessoa().getPlanoContaFornecedor();
        if (this.isNull(codPlanoConta).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.1757.007", new Object[]{opcoes.getEmpresa()});
        }
        if (this.isNull(fornecedor).booleanValue() || this.isNull(fornecedor.getPessoa()).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.1758.003", new Object[0]);
        }
        PlanoConta planoConta = this.servicePlanoConta.getNewPlanoConta(codPlanoConta, fornecedor.getPessoa().getNome(), fornecedor.getPessoa().getComplemento().getCnpj(), opcoes);
        if (this.isNull(planoConta).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.1758.002", new Object[]{opcoes.getEmpresa()});
        }
        GeracaoContaPessoa vo = this.build(fornecedor);
        vo.setPlanoContaPassivo(planoConta);
        vo = this.serviceContasPessoa.saveOrUpdateFlush(vo);
        return vo;
    }

    public GeracaoContaPessoa buildPlanoContaAntecip(Fornecedor fornecedor, OpcoesContabeis opcoes) throws ExceptionInvalidData {
        PlanoConta codPlanoConta = opcoes.getOpcoesContabeisGerContaPessoa().getPlanoAntecipFornecedor();
        if (this.isNull(codPlanoConta).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.1757.008", new Object[]{opcoes.getEmpresa()});
        }
        if (this.isNull(fornecedor).booleanValue() || this.isNull(fornecedor.getPessoa()).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.1758.003", new Object[0]);
        }
        PlanoConta planoConta = this.servicePlanoConta.getNewPlanoConta(codPlanoConta, fornecedor.getPessoa().getNome(), fornecedor.getPessoa().getComplemento().getCnpj(), opcoes);
        if (this.isNull(planoConta).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.1758.002", new Object[]{opcoes.getEmpresa()});
        }
        planoConta = this.servicePlanoConta.saveOrUpdateFlush(planoConta);
        GeracaoContaPessoa vo = this.build(fornecedor);
        vo.setPlanoContaAntecPassivo(planoConta);
        vo = this.serviceContasPessoa.saveOrUpdateFlush(vo);
        return vo;
    }

    public GeracaoContaPessoa gerarPlanoContaFornecedorAntecip(Fornecedor fornecedor, OpcoesContabeis opcoes) throws ExceptionInvalidData {
        GeracaoContaPessoa vo = this.buildPlanoContaAntecip(fornecedor, opcoes);
        this.serviceContasPessoa.saveOrUpdate(vo);
        return vo;
    }

    public GeracaoContaPessoa build(Fornecedor fornecedor) {
        GeracaoContaPessoa vo = fornecedor.getPessoa().getContasPessoa();
        if (this.isNull(vo).booleanValue()) {
            vo = new GeracaoContaPessoa();
        }
        vo.setPessoa(fornecedor.getPessoa());
        fornecedor.getPessoa().setContasPessoa(vo);
        return vo;
    }

    public GeracaoContaPessoa build(Representante representante) {
        GeracaoContaPessoa vo = representante.getPessoa().getContasPessoa();
        if (this.isNull(vo).booleanValue()) {
            vo = new GeracaoContaPessoa();
        }
        vo.setPessoa(representante.getPessoa());
        representante.getPessoa().setContasPessoa(vo);
        return vo;
    }

    public GeracaoContaPessoa buildPlanoConta(Representante representante, OpcoesContabeis opcoes) throws ExceptionInvalidData {
        PlanoConta codPlanoConta = opcoes.getOpcoesContabeisGerContaPessoa().getPlanoContaRepresentante();
        if (this.isNull(codPlanoConta).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.1757.009", new Object[]{opcoes.getEmpresa()});
        }
        if (this.isNull(representante).booleanValue() || this.isNull(representante.getPessoa()).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.1758.004", new Object[0]);
        }
        PlanoConta planoConta = this.servicePlanoConta.getNewPlanoConta(codPlanoConta, representante.getPessoa().getNome(), representante.getPessoa().getComplemento().getCnpj(), opcoes);
        if (this.isNull(planoConta).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.1758.002", new Object[]{opcoes.getEmpresa()});
        }
        GeracaoContaPessoa vo = this.build(representante);
        vo.setPlanoContaPassivo(planoConta);
        vo = this.serviceContasPessoa.saveOrUpdateFlush(vo);
        return vo;
    }

    public GeracaoContaPessoa build(Cliente cliente) {
        GeracaoContaPessoa vo = cliente.getPessoa().getContasPessoa();
        if (this.isNull(vo).booleanValue()) {
            vo = new GeracaoContaPessoa();
        }
        vo.setPessoa(cliente.getPessoa());
        cliente.getPessoa().setContasPessoa(vo);
        return vo;
    }

    public GeracaoContaPessoa findPlanoContaAnalitico(Cliente cliente, PlanoConta planoConta) throws ExceptionInvalidData {
        if (this.isNull(cliente).booleanValue() || this.isNull(cliente.getPessoa()).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.1758.001", new Object[0]);
        }
        if (this.isNull(cliente.getPessoa().getContasPessoa()).booleanValue()) {
            cliente.getPessoa().setContasPessoa(this.build(cliente));
        }
        cliente.getPessoa().getContasPessoa().setPlanoContaAtivo(this.findPlanoContaAnalitico(planoConta));
        return cliente.getPessoa().getContasPessoa();
    }

    public PlanoConta findPlanoContaAnalitico(PlanoConta conta) throws ExceptionInvalidData {
        if (this.isNotNull(conta).booleanValue()) {
            if (!this.isAffimative(conta.getAtivo())) {
                throw new ExceptionInvalidData("E.ERP.0160.009", new Object[0]);
            }
            if (this.helperPC.build(conta).isAnalitica(conta)) {
                return conta;
            }
            throw new ExceptionInvalidData("E.ERP.0160.010", new Object[]{conta.toString()});
        }
        return null;
    }

    public GeracaoContaPessoa findPlanoContaAnalitico(Cliente cliente, String contaReduzida) throws ExceptionInvalidData {
        if (this.isStrWithData(contaReduzida)) {
            List<PlanoConta> contas = this.servicePlanoConta.findContasReduzidas(contaReduzida = ToolString.completaZeros((String)contaReduzida, (int)5, (boolean)true));
            if (CompPlanoConta.isWithData(contas)) {
                PlanoConta aux = contas.iterator().next();
                if (!this.isAffimative(aux.getAtivo())) {
                    throw new ExceptionInvalidData("E.ERP.0160.009", new Object[0]);
                }
                if (this.helperPC.build(aux).isAnalitica()) {
                    if (this.isNull(cliente.getPessoa().getContasPessoa()).booleanValue()) {
                        cliente.getPessoa().setContasPessoa(this.build(cliente));
                    }
                    cliente.getPessoa().getContasPessoa().setPlanoContaAtivo(aux);
                    return cliente.getPessoa().getContasPessoa();
                }
                throw new ExceptionInvalidData("E.ERP.0160.010", new Object[]{aux.toString()});
            }
            throw new ExceptionInvalidData("E.ERP.0160.011", new Object[]{contaReduzida});
        }
        return null;
    }
}

