/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.planomanutencao;

import com.touchcomp.basementor.constants.enums.ordemservico.EnumConstStatusOrdemServico;
import com.touchcomp.basementor.constants.enums.tipopontocontrole.EnumConstTipoPontoControle;
import com.touchcomp.basementor.model.vo.AtivoDataUltimaManutencao;
import com.touchcomp.basementor.model.vo.AtivoTipoPontoControle;
import com.touchcomp.basementor.model.vo.Coleta;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Equipamento;
import com.touchcomp.basementor.model.vo.LocalizacaoAtivo;
import com.touchcomp.basementor.model.vo.OrdemServico;
import com.touchcomp.basementor.model.vo.PlanoManutencaoAtivo;
import com.touchcomp.basementor.model.vo.PlanoManutencaoAtivoAtivo;
import com.touchcomp.basementorservice.BaseMethods;
import com.touchcomp.basementorservice.helpers.impl.planomanutencaoativo.HelperPlanoManutencaoAtivo;
import com.touchcomp.basementorservice.service.impl.coleta.ServiceColetaImpl;
import com.touchcomp.basementorservice.service.impl.equipamento.ServiceEquipamentoImpl;
import com.touchcomp.basementorservice.service.impl.ordemservico.ServiceOrdemServicoImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompPlanoManutencaoAtivo
extends BaseMethods {
    @Autowired
    HelperPlanoManutencaoAtivo helperPlanoManutencaoAtivo;
    @Autowired
    ServiceEquipamentoImpl serviceEquipamento;
    @Autowired
    ServiceColetaImpl serviceColeta;
    @Autowired
    ServiceOrdemServicoImpl serviceOrdemServico;

    public List<PlanoManutencaoAtivoAtivo> buildPlanoManutencaoAtivoAtivo(List<PlanoManutencaoAtivo> planosAcumulativos, List<PlanoManutencaoAtivo> planosPeriodicos, List<PlanoManutencaoAtivo> planosSobDemanda, Empresa empresaLogada, LocalizacaoAtivo localizacaoAtivo, Date dataInicial, Date dataFinal, Boolean validar, Short opcaoPesquisa, Short gerarOSAtivoNaoExisteOS) {
        List<PlanoManutencaoAtivoAtivo> planosToReturn = new ArrayList<PlanoManutencaoAtivoAtivo>();
        for (PlanoManutencaoAtivo planoManutencaoAtivo : planosAcumulativos) {
            planosToReturn.add(this.buildPlanoManutencaoAtivoAtivoInternal(planoManutencaoAtivo, empresaLogada, localizacaoAtivo, dataInicial, dataFinal, validar, opcaoPesquisa, true, gerarOSAtivoNaoExisteOS));
        }
        for (PlanoManutencaoAtivo planoManutencaoAtivo : planosPeriodicos) {
            planosToReturn.add(this.buildPlanoManutencaoAtivoAtivoInternal(planoManutencaoAtivo, empresaLogada, localizacaoAtivo, dataInicial, dataFinal, validar, opcaoPesquisa, true, gerarOSAtivoNaoExisteOS));
        }
        planosToReturn = this.helperPlanoManutencaoAtivo.clearPlanosSemAtivo(planosToReturn);
        for (PlanoManutencaoAtivo planoManutencaoAtivo : planosSobDemanda) {
            planosToReturn.add(this.buildPlanoManutencaoAtivoAtivoInternal(planoManutencaoAtivo, empresaLogada, localizacaoAtivo, dataInicial, dataFinal, validar, opcaoPesquisa, false, gerarOSAtivoNaoExisteOS));
        }
        return planosToReturn;
    }

    private PlanoManutencaoAtivoAtivo buildPlanoManutencaoAtivoAtivoInternal(PlanoManutencaoAtivo planoManutencaoAtivo, Empresa empresaLogada, LocalizacaoAtivo localizacaoAtivo, Date dataInicial, Date dataFinal, Boolean validar, Short opcaoPesquisa, Boolean setTipoPontoControle, Short gerarOSAtivoNaoExisteOS) {
        PlanoManutencaoAtivoAtivo newPlanoManutencaoAtivoAtivo = new PlanoManutencaoAtivoAtivo();
        newPlanoManutencaoAtivoAtivo.setDataCadastro(new Date());
        newPlanoManutencaoAtivoAtivo.setEmpresa(empresaLogada);
        newPlanoManutencaoAtivoAtivo.setPlanoManutencaoAtivo(planoManutencaoAtivo);
        if (setTipoPontoControle.booleanValue()) {
            newPlanoManutencaoAtivoAtivo.getAtivoTipoPontoControle().addAll(this.getAtivoTipoPontoControle(planoManutencaoAtivo, empresaLogada, localizacaoAtivo, newPlanoManutencaoAtivoAtivo, dataInicial, dataFinal, validar, opcaoPesquisa, gerarOSAtivoNaoExisteOS));
        }
        return newPlanoManutencaoAtivoAtivo;
    }

    private List<AtivoTipoPontoControle> getAtivoTipoPontoControle(PlanoManutencaoAtivo planoManutencaoAtivo, Empresa empresaLogada, LocalizacaoAtivo localizacaoAtivo, PlanoManutencaoAtivoAtivo newPlanoManutencaoAtivoAtivo, Date dataInicial, Date dataFinal, Boolean validar, Short opcaoPesquisa, Short gerarOSAtivoNaoExisteOS) {
        ArrayList<AtivoTipoPontoControle> toReturn = new ArrayList<AtivoTipoPontoControle>();
        for (AtivoDataUltimaManutencao ativoDataUltimaManutencao : planoManutencaoAtivo.getAtivos()) {
            if (ToolMethods.isAffirmative((Number)gerarOSAtivoNaoExisteOS) && (!ToolMethods.isAffirmative((Number)gerarOSAtivoNaoExisteOS) || !this.validarOSAtivoPlanoMan(empresaLogada, planoManutencaoAtivo, ativoDataUltimaManutencao.getAtivo()).booleanValue())) continue;
            AtivoTipoPontoControle ativoTipoPontoControle = this.helperPlanoManutencaoAtivo.getAtivoTipoPontoControle(empresaLogada, newPlanoManutencaoAtivoAtivo, ativoDataUltimaManutencao, planoManutencaoAtivo);
            if (planoManutencaoAtivo.getTipoPontoControle() != null) {
                Coleta ultimaColeta = this.serviceColeta.findColetaAnterior(ativoDataUltimaManutencao.getAtivo(), planoManutencaoAtivo.getTipoPontoControle());
                ativoTipoPontoControle.setColetaLimite(ultimaColeta);
            }
            if (this.isEquals(planoManutencaoAtivo.getTipoControle().getIdentificador(), EnumConstTipoPontoControle.TIPO_PONTO_PERIODICO.getValue()) && (!validar.booleanValue() || this.isValidPeriodico(planoManutencaoAtivo, ativoDataUltimaManutencao, localizacaoAtivo, dataInicial, dataFinal, opcaoPesquisa).booleanValue())) {
                if (toReturn.contains(ativoTipoPontoControle)) continue;
                toReturn.add(ativoTipoPontoControle);
                continue;
            }
            if (this.isEquals(planoManutencaoAtivo.getTipoControle().getIdentificador(), EnumConstTipoPontoControle.TIPO_PONTO_ACUMULATIVO.getValue()) && (!validar.booleanValue() || this.isValidAcumulativo(planoManutencaoAtivo, ativoDataUltimaManutencao, ativoTipoPontoControle).booleanValue())) {
                if (toReturn.contains(ativoTipoPontoControle)) continue;
                toReturn.add(ativoTipoPontoControle);
                continue;
            }
            if (!this.isEquals(planoManutencaoAtivo.getTipoControle().getIdentificador(), EnumConstTipoPontoControle.TIPO_PONTO_DEMANDA.getValue()) || toReturn.contains(ativoTipoPontoControle)) continue;
            toReturn.add(ativoTipoPontoControle);
        }
        return toReturn;
    }

    private Boolean isValidPeriodico(PlanoManutencaoAtivo planoManutencaoAtivo, AtivoDataUltimaManutencao ativoDataUltimaManutencao, LocalizacaoAtivo localizacaoAtivo, Date dataInicial, Date dataFinal, Short opcaoPesquisa) {
        Timestamp dataUltimaManutencao = this.serviceEquipamento.getDataUltimaManutencao(planoManutencaoAtivo, ativoDataUltimaManutencao.getAtivo(), planoManutencaoAtivo.getEmpresa(), opcaoPesquisa);
        if (dataUltimaManutencao == null) {
            dataUltimaManutencao = ativoDataUltimaManutencao.getDataUltimaManutencao();
        }
        if (dataInicial == null ? ToolDate.dataSemHora((Date)new Date()).after(ToolDate.nextDays((Date)ToolDate.dataSemHora((Date)dataUltimaManutencao), (int)planoManutencaoAtivo.getPeriodicidade())) || ToolDate.dataSemHora((Date)new Date()).equals(ToolDate.nextDays((Date)ToolDate.dataSemHora((Date)dataUltimaManutencao), (int)planoManutencaoAtivo.getPeriodicidade())) && (localizacaoAtivo == null || localizacaoAtivo.equals((Object)ativoDataUltimaManutencao.getAtivo().getLocalizacaoAtivo())) : this.helperPlanoManutencaoAtivo.verificaIntevaloDataUltimaManutencao(dataUltimaManutencao, dataInicial, dataFinal, planoManutencaoAtivo.getPeriodicidade()) != false && (localizacaoAtivo == null || localizacaoAtivo.equals((Object)ativoDataUltimaManutencao.getAtivo().getLocalizacaoAtivo()))) {
            return true;
        }
        return false;
    }

    private Boolean isValidAcumulativo(PlanoManutencaoAtivo planoManutencaoAtivo, AtivoDataUltimaManutencao ativoDataUltimaManutencao, AtivoTipoPontoControle ativoTipoPontoControle) {
        Coleta ultimaColeta = this.serviceColeta.findColetaAnterior(ativoDataUltimaManutencao.getAtivo(), planoManutencaoAtivo.getTipoPontoControle());
        if (ultimaColeta == null) {
            return false;
        }
        if (ativoDataUltimaManutencao.getValorAcumulado() >= planoManutencaoAtivo.getLimite()) {
            ativoTipoPontoControle.setTipoPontoControle(ultimaColeta.getTipoPontoControle());
            ativoTipoPontoControle.setColetaLimite(ultimaColeta);
            return true;
        }
        return false;
    }

    private Boolean validarOSAtivoPlanoMan(Empresa empresa, PlanoManutencaoAtivo planoManutencaoAtivo, Equipamento ativo) {
        List<OrdemServico> listOrdemServico = this.serviceOrdemServico.pesquisarOrdemServicoEmpresaAtivoStatusPlanoManAtivo(empresa, ativo, EnumConstStatusOrdemServico.ABERTO.getValue(), planoManutencaoAtivo);
        return listOrdemServico == null || listOrdemServico.isEmpty();
    }
}

