/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.rateio.notapropria;

import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;

public class AdapterRateioNotaFiscalPropria {
    private NotaFiscalPropria nota;

    public AdapterRateioNotaFiscalPropria(NotaFiscalPropria nota) {
        this.nota = nota;
    }

    public void ratearValoresAcessorios() {
        this.ratearDesconto();
        this.ratearDespAcess();
        this.ratearFrete();
        this.ratearSeguro();
        this.ratearFreteCTe();
        this.calcularTotalDesconto();
        this.calcularTotalFrete();
        this.calcularTotalDespAcessoria();
        this.calcularTotalSeguro();
    }

    private void ratearDesconto() {
        Short tipoDescRateado = this.nota.getValoresNfPropria().getTipoDescInf();
        Double valorDescRateado = this.nota.getValoresNfPropria().getValorDescInf();
        Double percDescRateado = this.nota.getValoresNfPropria().getPercDescInf();
        double valorTotalUnitario = 0.0;
        for (ItemNotaFiscalPropria it : this.nota.getItensNotaPropria()) {
            if (it.getDescontoItem() == 1) continue;
            valorTotalUnitario += it.getValorUnitario() * it.getQuantidadeTotal();
        }
        ItemNotaFiscalPropria lastItem = null;
        double valorDescTotal = 0.0;
        for (ItemNotaFiscalPropria item : this.nota.getItensNotaPropria()) {
            this.setDescontoInformadoItem(item);
            this.setDescontoRateado(item, tipoDescRateado, valorDescRateado, percDescRateado, valorTotalUnitario);
            valorDescTotal += item.getValorDescontoRateado().doubleValue();
            lastItem = item;
        }
        if (lastItem != null && valorDescRateado > 0.0) {
            lastItem.setValorDescontoRateado(Double.valueOf(lastItem.getValorDescontoRateado() + (valorDescRateado - valorDescTotal)));
        }
    }

    private void ratearFrete() {
        Short tipoFreteRateado = this.nota.getValoresNfPropria().getTipoFreteInf();
        Double valorFreteRateado = this.nota.getValoresNfPropria().getValorFreteInf();
        Double percFreteRateado = this.nota.getValoresNfPropria().getPercFreteInf();
        double valorTotalUnitario = 0.0;
        for (ItemNotaFiscalPropria it : this.nota.getItensNotaPropria()) {
            if (it.getFreteItem() == 1) continue;
            valorTotalUnitario += it.getValorUnitario() * it.getQuantidadeTotal();
        }
        ItemNotaFiscalPropria lastItem = null;
        double valorFreteTotal = 0.0;
        for (ItemNotaFiscalPropria item : this.nota.getItensNotaPropria()) {
            this.setFreteInformadoItem(item);
            this.setFreteRateado(item, tipoFreteRateado, valorFreteRateado, percFreteRateado, valorTotalUnitario);
            valorFreteTotal += item.getValorFreteRateado().doubleValue();
            lastItem = item;
        }
        if (lastItem != null && valorFreteRateado > 0.0) {
            lastItem.setValorFreteRateado(Double.valueOf(lastItem.getValorFreteRateado() + (valorFreteRateado - valorFreteTotal)));
        }
    }

    private void ratearDespAcess() {
        Short tipoDespRateado = this.nota.getValoresNfPropria().getTipoDespAcessInf();
        Double valorDespRateado = this.nota.getValoresNfPropria().getValorDespAcessInf();
        Double percDespRateado = this.nota.getValoresNfPropria().getPercDespAcessInf();
        double valorTotalUnitario = 0.0;
        for (ItemNotaFiscalPropria it : this.nota.getItensNotaPropria()) {
            if (it.getDespAcessItem() == 1) continue;
            valorTotalUnitario += it.getValorUnitario() * it.getQuantidadeTotal();
        }
        ItemNotaFiscalPropria lastItem = null;
        double valorDespTotal = 0.0;
        for (ItemNotaFiscalPropria item : this.nota.getItensNotaPropria()) {
            this.setDespAcessRateado(item, tipoDespRateado, valorDespRateado, percDespRateado, valorTotalUnitario);
            valorDespTotal += item.getValorDespAcessRateado().doubleValue();
            lastItem = item;
            this.setDespAcessInformadoItem(item);
        }
        if (lastItem != null && valorDespRateado > 0.0) {
            lastItem.setValorDespAcessRateado(Double.valueOf(lastItem.getValorDespAcessRateado() + (valorDespRateado - valorDespTotal)));
        }
    }

    private void ratearSeguro() {
        Short tipoSeguroRateado = this.nota.getValoresNfPropria().getTipoSeguroInf();
        Double valorSeguroRateado = this.nota.getValoresNfPropria().getValorSeguroInf();
        Double percSeguroRateado = this.nota.getValoresNfPropria().getPercSeguroInf();
        double valorTotalUnitario = 0.0;
        for (ItemNotaFiscalPropria it : this.nota.getItensNotaPropria()) {
            if (it.getSeguroItem() == 1) continue;
            valorTotalUnitario += it.getValorUnitario() * it.getQuantidadeTotal();
        }
        ItemNotaFiscalPropria lastItem = null;
        double valorSeguroTotal = 0.0;
        for (ItemNotaFiscalPropria item : this.nota.getItensNotaPropria()) {
            this.setSeguroRateado(item, tipoSeguroRateado, valorSeguroRateado, percSeguroRateado, valorTotalUnitario);
            valorSeguroTotal += item.getValorSeguroRateado().doubleValue();
            lastItem = item;
            this.setSeguroInformadoItem(item);
        }
        if (lastItem != null && valorSeguroRateado > 0.0) {
            lastItem.setValorSeguroRateado(Double.valueOf(lastItem.getValorSeguroRateado() + (valorSeguroRateado - valorSeguroTotal)));
        }
    }

    private void ratearFreteCTe() {
        Double valorTotalProdutos = this.getValorRatFreteCTeAutonomo();
        for (ItemNotaFiscalPropria item : this.nota.getItensNotaPropria()) {
            Double valorFreteCTe = this.nota.getValoresNfPropria().getValorFreteCTe() == null ? 0.0 : this.nota.getValoresNfPropria().getValorFreteCTe();
            if (!(valorTotalProdutos > 0.0)) continue;
            double aux = item.getVrProduto() / valorTotalProdutos * valorFreteCTe;
            item.setValorFreteCTe(Double.valueOf(aux));
        }
    }

    private Double getValorRatFreteCTeAutonomo() {
        double valorTotalProdutos = 0.0;
        for (ItemNotaFiscalPropria item : this.nota.getItensNotaPropria()) {
            valorTotalProdutos += item.getVrProduto() + item.getVrServico();
        }
        return valorTotalProdutos;
    }

    private void calcularTotalDesconto() {
        for (ItemNotaFiscalPropria item : this.nota.getItensNotaPropria()) {
            Double valorTotalBruto = ToolFormatter.arrredondarNumero((Double)(item.getVrProduto() + item.getVrServico()), (int)2);
            Double valorTotalDesconto = ToolFormatter.arrredondarNumero((Double)(item.getValorDescontoItemInf() + item.getValorDescontoRateado() + item.getValorDescontoTrib()), (int)2);
            Double percDesconto = 0.0;
            if (valorTotalDesconto > 0.0 && valorTotalBruto > 0.0) {
                percDesconto = ToolFormatter.arrredondarNumero((Double)(valorTotalDesconto * 100.0 / valorTotalBruto), (int)4);
            }
            item.setValorDesconto(valorTotalDesconto);
            item.setPercDesconto(percDesconto);
        }
    }

    private void calcularTotalFrete() {
        for (ItemNotaFiscalPropria item : this.nota.getItensNotaPropria()) {
            Double valorTotalBruto = ToolFormatter.arrredondarNumero((Double)(item.getVrProduto() + item.getVrServico()), (int)2);
            Double valorTotalFrete = ToolFormatter.arrredondarNumero((Double)(item.getValorFreteItemInf() + item.getValorFreteRateado()), (int)2);
            Double percFrete = 0.0;
            if (valorTotalFrete > 0.0 && valorTotalBruto > 0.0) {
                percFrete = ToolFormatter.arrredondarNumero((Double)(valorTotalFrete * 100.0 / valorTotalBruto), (int)4);
            }
            item.setValorFrete(valorTotalFrete);
            item.setPercFrete(percFrete);
        }
    }

    private void calcularTotalDespAcessoria() {
        for (ItemNotaFiscalPropria item : this.nota.getItensNotaPropria()) {
            Double valorTotalBruto = ToolFormatter.arrredondarNumero((Double)(item.getVrProduto() + item.getVrServico()), (int)2);
            Double valorTotalDesp = ToolFormatter.arrredondarNumero((Double)(item.getValorDespAcessItemInf() + item.getValorDespAcessRateado()), (int)2);
            Double percDesp = 0.0;
            if (valorTotalDesp > 0.0 && valorTotalBruto > 0.0) {
                percDesp = ToolFormatter.arrredondarNumero((Double)(valorTotalDesp * 100.0 / valorTotalBruto), (int)4);
            }
            item.setValorDespAcessoria(valorTotalDesp);
            item.setPercDespAcessoria(percDesp);
        }
    }

    private void calcularTotalSeguro() {
        for (ItemNotaFiscalPropria item : this.nota.getItensNotaPropria()) {
            Double valorTotalBruto = ToolFormatter.arrredondarNumero((Double)(item.getVrProduto() + item.getVrServico()), (int)2);
            Double valorTotalSeguro = ToolFormatter.arrredondarNumero((Double)(item.getValorSeguroItemInf() + item.getValorSeguroRateado()), (int)2);
            Double percSeguro = 0.0;
            if (valorTotalSeguro > 0.0 && valorTotalBruto > 0.0) {
                percSeguro = ToolFormatter.arrredondarNumero((Double)(valorTotalSeguro * 100.0 / valorTotalBruto), (int)4);
            }
            item.setVrSeguro(valorTotalSeguro);
            item.setPercSeguro(percSeguro);
        }
    }

    private void setDescontoRateado(ItemNotaFiscalPropria item, Short tipoDescRateado, Double valorDescRateado, Double percDescRateado, Double valorTotalUnitario) {
        double vlrProduto = item.getVrProduto() + item.getVrServico();
        double valorDescCalc = 0.0;
        double percDescCalc = 0.0;
        if (tipoDescRateado == 1) {
            valorDescCalc = ToolFormatter.arrredondarNumero((Double)(percDescRateado / 100.0 * vlrProduto), (int)2);
            percDescCalc = percDescRateado;
        } else {
            percDescCalc = valorDescRateado > 0.0 ? ToolFormatter.arrredondarNumero((Double)(valorDescRateado / valorTotalUnitario * 100.0), (int)4) : 0.0;
            valorDescCalc = ToolFormatter.arrredondarNumero((Double)(vlrProduto * percDescCalc / 100.0), (int)2);
        }
        item.setPercDescontoRateado(Double.valueOf(percDescCalc));
        item.setValorDescontoRateado(Double.valueOf(valorDescCalc));
    }

    private void setDescontoInformadoItem(ItemNotaFiscalPropria item) {
        double vlrProduto = item.getVrProduto() + item.getVrServico();
        double valorDescCalc = 0.0;
        double percDescCalc = 0.0;
        if (ToolMethods.isEquals((Object)item.getTipoDesconto(), (Object)0)) {
            valorDescCalc = ToolFormatter.arrredondarNumero((Double)(item.getPercDescontoItemInf() / 100.0 * vlrProduto), (int)2);
            item.setValorDescontoItemInf(Double.valueOf(valorDescCalc));
        } else {
            percDescCalc = item.getValorDescontoItemInf() > 0.0 ? ToolFormatter.arrredondarNumero((Double)(item.getValorDescontoItemInf() / vlrProduto * 100.0), (int)4) : 0.0;
            item.setPercDescontoItemInf(Double.valueOf(percDescCalc));
        }
    }

    private void setFreteRateado(ItemNotaFiscalPropria item, Short tipoFreteRateado, Double valorFreteRateado, Double percFreteRateado, Double valorTotalUnitario) {
        double vlrProduto = item.getVrProduto() + item.getVrServico();
        double valocCalc = 0.0;
        double percCalc = 0.0;
        if (tipoFreteRateado == 1) {
            valocCalc = ToolFormatter.arrredondarNumero((Double)(percFreteRateado / 100.0 * vlrProduto), (int)2);
            percCalc = percFreteRateado;
        } else {
            percCalc = valorFreteRateado > 0.0 ? ToolFormatter.arrredondarNumero((Double)(valorFreteRateado / valorTotalUnitario * 100.0), (int)4) : 0.0;
            valocCalc = ToolFormatter.arrredondarNumero((Double)(vlrProduto * percCalc / 100.0), (int)2);
        }
        item.setPercFreteRateado(Double.valueOf(percCalc));
        item.setValorFreteRateado(Double.valueOf(valocCalc));
    }

    private void setFreteInformadoItem(ItemNotaFiscalPropria item) {
        double vlrProduto = item.getVrProduto() + item.getVrServico();
        double valorCalc = 0.0;
        double percCalc = 0.0;
        if (ToolMethods.isEquals((Object)item.getTipoFrete(), (Object)0)) {
            valorCalc = ToolFormatter.arrredondarNumero((Double)(item.getPercFreteItemInf() / 100.0 * vlrProduto), (int)2);
            item.setValorFreteItemInf(Double.valueOf(valorCalc));
        } else {
            percCalc = item.getValorFreteItemInf() > 0.0 ? ToolFormatter.arrredondarNumero((Double)(item.getValorFreteItemInf() / vlrProduto * 100.0), (int)4) : 0.0;
            item.setPercFreteItemInf(Double.valueOf(percCalc));
        }
    }

    private void setSeguroRateado(ItemNotaFiscalPropria item, Short tipoSeguroRateado, Double valorSeguroRateado, Double percSeguroRateado, Double valorTotalUnitario) {
        double vlrProduto = item.getVrProduto() + item.getVrServico();
        double valocCalc = 0.0;
        double percCalc = 0.0;
        if (tipoSeguroRateado == 1) {
            valocCalc = ToolFormatter.arrredondarNumero((Double)(percSeguroRateado / 100.0 * vlrProduto), (int)2);
            percCalc = percSeguroRateado;
        } else {
            percCalc = valorSeguroRateado > 0.0 ? ToolFormatter.arrredondarNumero((Double)(valorSeguroRateado / valorTotalUnitario * 100.0), (int)4) : 0.0;
            valocCalc = ToolFormatter.arrredondarNumero((Double)(vlrProduto * percCalc / 100.0), (int)2);
        }
        item.setPercSeguroRateado(Double.valueOf(percCalc));
        item.setValorSeguroRateado(Double.valueOf(valocCalc));
    }

    private void setSeguroInformadoItem(ItemNotaFiscalPropria item) {
        double vlrProduto = item.getVrProduto() + item.getVrServico();
        double valorCalc = 0.0;
        double percCalc = 0.0;
        if (ToolMethods.isEquals((Object)item.getTipoSeguro(), (Object)0)) {
            valorCalc = ToolFormatter.arrredondarNumero((Double)(item.getPercSeguroItemInf() / 100.0 * vlrProduto), (int)2);
            item.setValorSeguroItemInf(Double.valueOf(valorCalc));
        } else {
            percCalc = item.getValorSeguroItemInf() > 0.0 ? ToolFormatter.arrredondarNumero((Double)(item.getValorSeguroItemInf() / vlrProduto * 100.0), (int)4) : 0.0;
            item.setPercSeguroItemInf(Double.valueOf(percCalc));
        }
    }

    private void setDespAcessRateado(ItemNotaFiscalPropria item, Short tipoDespAcessRateado, Double valorDespAcessRateado, Double percDespAcessRateado, Double valorTotalUnitario) {
        double vlrProduto = item.getVrProduto() + item.getVrServico();
        double valorCalc = 0.0;
        double percCalc = 0.0;
        if (tipoDespAcessRateado == 1) {
            valorCalc = ToolFormatter.arrredondarNumero((Double)(percDespAcessRateado / 100.0 * vlrProduto), (int)2);
            percCalc = percDespAcessRateado;
        } else {
            percCalc = valorDespAcessRateado > 0.0 ? ToolFormatter.arrredondarNumero((Double)(valorDespAcessRateado / valorTotalUnitario * 100.0), (int)4) : 0.0;
            valorCalc = ToolFormatter.arrredondarNumero((Double)(vlrProduto * percCalc / 100.0), (int)2);
        }
        item.setPercDespAcessRateado(Double.valueOf(percCalc));
        item.setValorDespAcessRateado(Double.valueOf(valorCalc));
    }

    private void setDespAcessInformadoItem(ItemNotaFiscalPropria item) {
        double vlrProduto = item.getVrProduto() + item.getVrServico();
        double valorCalc = 0.0;
        double percCalc = 0.0;
        if (ToolMethods.isEquals((Object)item.getTipoDespAcessoria(), (Object)0)) {
            valorCalc = ToolFormatter.arrredondarNumero((Double)(item.getPercDespAcessItemInf() / 100.0 * vlrProduto), (int)2);
            item.setValorDespAcessItemInf(Double.valueOf(valorCalc));
        } else {
            percCalc = item.getValorDespAcessItemInf() > 0.0 ? ToolFormatter.arrredondarNumero((Double)(item.getValorDespAcessItemInf() / vlrProduto * 100.0), (int)4) : 0.0;
            item.setPercDespAcessItemInf(Double.valueOf(percCalc));
        }
    }
}

