/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.rateio.pedido;

import com.touchcomp.basementor.model.vo.ItemPedido;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;

public class AdapterRateioPedido {
    private Pedido pedido;

    public AdapterRateioPedido(Pedido pedido) {
        this.pedido = pedido;
    }

    public void ratearValoresAcessorios() {
        this.ratearDesconto();
        this.ratearDespAcess();
        this.ratearFrete();
        this.ratearSeguro();
        this.calcularTotalDesconto();
        this.calcularTotalFrete();
        this.calcularTotalDespAcessoria();
        this.calcularTotalSeguro();
    }

    private void ratearDesconto() {
        Short tipoDescRateado = this.pedido.getTipoDesconto();
        Double valorDescRateado = this.pedido.getValorDescontoInf();
        Double percDescRateado = this.pedido.getPercDescontoInf();
        double valorTotalUnitario = 0.0;
        for (ItemPedido it : this.pedido.getItemPedido()) {
            valorTotalUnitario += it.getValorUnitario() * it.getQuantidadeTotal();
        }
        ItemPedido lastItem = null;
        double valorDescTotal = 0.0;
        for (ItemPedido item : this.pedido.getItemPedido()) {
            this.setDescontoInformadoItem(item);
            this.setDescontoRateado(item, tipoDescRateado, valorDescRateado, percDescRateado, valorTotalUnitario);
            valorDescTotal += item.getValorDescontoRateado().doubleValue();
            lastItem = item;
        }
        if (lastItem != null && valorDescRateado > 0.0) {
            lastItem.setValorDescontoRateado(Double.valueOf(lastItem.getValorDescontoRateado() + (valorDescRateado - valorDescTotal)));
        }
    }

    private void ratearFrete() {
        Short tipoFreteRateado = this.pedido.getTipoFreteInf();
        Double valorFreteRateado = this.pedido.getValorFreteInf();
        Double percFreteRateado = this.pedido.getPercFreteInf();
        double valorTotalUnitario = 0.0;
        for (ItemPedido it : this.pedido.getItemPedido()) {
            valorTotalUnitario += it.getValorUnitario() * it.getQuantidadeTotal();
        }
        ItemPedido lastItem = null;
        double valorFreteTotal = 0.0;
        for (ItemPedido item : this.pedido.getItemPedido()) {
            this.setFreteInformadoItem(item);
            this.setFreteRateado(item, tipoFreteRateado, valorFreteRateado, percFreteRateado, valorTotalUnitario);
            valorFreteTotal += item.getValorFreteRateado().doubleValue();
            lastItem = item;
        }
        if (lastItem != null && valorFreteRateado > 0.0) {
            lastItem.setValorFreteRateado(Double.valueOf(lastItem.getValorFreteRateado() + (valorFreteRateado - valorFreteTotal)));
        }
    }

    private void ratearDespAcess() {
        Short tipoDespRateado = this.pedido.getTipoDespAcessInf();
        Double valorDespRateado = this.pedido.getValorDespAcessoriaInf();
        Double percDespRateado = this.pedido.getPercDespAcessoriaInf();
        double valorTotalUnitario = 0.0;
        for (ItemPedido it : this.pedido.getItemPedido()) {
            valorTotalUnitario += it.getValorUnitario() * it.getQuantidadeTotal();
        }
        ItemPedido lastItem = null;
        double valorDespTotal = 0.0;
        for (ItemPedido item : this.pedido.getItemPedido()) {
            this.setDespAcessRateado(item, tipoDespRateado, valorDespRateado, percDespRateado, valorTotalUnitario);
            valorDespTotal += item.getValorDespAcessRateado().doubleValue();
            lastItem = item;
            this.setDespAcessInformadoItem(item);
        }
        if (lastItem != null && valorDespRateado > 0.0) {
            lastItem.setValorDespAcessRateado(Double.valueOf(lastItem.getValorDespAcessRateado() + (valorDespRateado - valorDespTotal)));
        }
    }

    private void ratearSeguro() {
        Short tipoSeguroRateado = this.pedido.getTipoSeguroInf();
        Double valorSeguroRateado = this.pedido.getValorSeguroInf();
        Double percSeguroRateado = this.pedido.getPercSeguroInf();
        double valorTotalUnitario = 0.0;
        for (ItemPedido it : this.pedido.getItemPedido()) {
            valorTotalUnitario += it.getValorUnitario() * it.getQuantidadeTotal();
        }
        ItemPedido lastItem = null;
        double valorSeguroTotal = 0.0;
        for (ItemPedido item : this.pedido.getItemPedido()) {
            this.setSeguroRateado(item, tipoSeguroRateado, valorSeguroRateado, percSeguroRateado, valorTotalUnitario);
            valorSeguroTotal += item.getValorSeguroRateado().doubleValue();
            lastItem = item;
            this.setSeguroInformadoItem(item);
        }
        if (lastItem != null && valorSeguroRateado > 0.0) {
            lastItem.setValorSeguroRateado(Double.valueOf(lastItem.getValorSeguroRateado() + (valorSeguroRateado - valorSeguroTotal)));
        }
    }

    private void calcularTotalDesconto() {
        for (ItemPedido item : this.pedido.getItemPedido()) {
            Double valorTotalBruto = ToolFormatter.arrredondarNumero((Double)item.getValorTotalBruto(), (int)2);
            Double valorTotalDesconto = ToolFormatter.arrredondarNumero((Double)(item.getValorDescontoItemInf() + item.getValorDescontoRateado() + item.getValorDescontoTrib()), (int)2);
            Double percDesconto = 0.0;
            if (valorTotalDesconto > 0.0 && valorTotalBruto > 0.0) {
                percDesconto = ToolFormatter.arrredondarNumero((Double)(valorTotalDesconto * 100.0 / valorTotalBruto), (int)4);
            }
            item.setValorDesconto(valorTotalDesconto);
            item.setPercDesconto(percDesconto);
        }
    }

    private void calcularTotalFrete() {
        for (ItemPedido item : this.pedido.getItemPedido()) {
            Double valorTotalBruto = ToolFormatter.arrredondarNumero((Double)item.getValorTotalBruto(), (int)2);
            Double valorTotalFrete = ToolFormatter.arrredondarNumero((Double)(item.getValorFreteItemInf() + item.getValorFreteRateado()), (int)2);
            Double percFrete = 0.0;
            if (valorTotalFrete > 0.0 && valorTotalBruto > 0.0) {
                percFrete = ToolFormatter.arrredondarNumero((Double)(valorTotalFrete * 100.0 / valorTotalBruto), (int)4);
            }
            item.setValorFrete(valorTotalFrete);
            item.setPercFrete(percFrete);
        }
    }

    private void calcularTotalDespAcessoria() {
        for (ItemPedido item : this.pedido.getItemPedido()) {
            Double valorTotalBruto = ToolFormatter.arrredondarNumero((Double)item.getValorTotalBruto(), (int)2);
            Double valorTotalDesp = ToolFormatter.arrredondarNumero((Double)(item.getValorDespAcessItemInf() + item.getValorDespAcessRateado()), (int)2);
            Double percDesp = 0.0;
            if (valorTotalDesp > 0.0 && valorTotalBruto > 0.0) {
                percDesp = ToolFormatter.arrredondarNumero((Double)(valorTotalDesp * 100.0 / valorTotalBruto), (int)4);
            }
            item.setValorDespesaAcessoria(valorTotalDesp);
            item.setPercDespesaAcessoria(percDesp);
        }
    }

    private void calcularTotalSeguro() {
        for (ItemPedido item : this.pedido.getItemPedido()) {
            Double valorTotalBruto = ToolFormatter.arrredondarNumero((Double)item.getValorTotalBruto(), (int)2);
            Double valorTotalSeguro = ToolFormatter.arrredondarNumero((Double)(item.getValorSeguroItemInf() + item.getValorSeguroRateado()), (int)2);
            Double percSeguro = 0.0;
            if (valorTotalSeguro > 0.0 && valorTotalBruto > 0.0) {
                percSeguro = ToolFormatter.arrredondarNumero((Double)(valorTotalSeguro * 100.0 / valorTotalBruto), (int)4);
            }
            item.setValorSeguro(valorTotalSeguro);
            item.setPercSeguro(percSeguro);
        }
    }

    private void setDescontoRateado(ItemPedido item, Short tipoDescRateado, Double valorDescRateado, Double percDescRateado, Double valorTotalUnitario) {
        double vlrProduto = item.getValorTotalBruto();
        double valorDescCalc = 0.0;
        double percDescCalc = 0.0;
        if (tipoDescRateado == 1) {
            valorDescCalc = ToolFormatter.arrredondarNumero((Double)(percDescRateado / 100.0 * vlrProduto), (int)2);
            percDescCalc = percDescRateado;
        } else {
            percDescCalc = valorDescRateado > 0.0 ? ToolFormatter.arrredondarNumero((Double)(valorDescRateado / valorTotalUnitario * 100.0), (int)4) : 0.0;
            valorDescCalc = ToolFormatter.arrredondarNumero((Double)(vlrProduto * percDescCalc / 100.0), (int)2);
        }
        item.setPercDescontoRateado(Double.valueOf(percDescCalc));
        item.setValorDescontoRateado(Double.valueOf(valorDescCalc));
    }

    private void setDescontoInformadoItem(ItemPedido item) {
        double vlrProduto = item.getValorTotalBruto();
        double valorDescCalc = 0.0;
        double percDescCalc = 0.0;
        if (ToolMethods.isEquals((Object)item.getTipoDesconto(), (Object)0)) {
            valorDescCalc = ToolFormatter.arrredondarNumero((Double)(item.getPercDescontoItemInf() / 100.0 * vlrProduto), (int)2);
            item.setValorDescontoItemInf(Double.valueOf(valorDescCalc));
        } else {
            percDescCalc = item.getValorDescontoItemInf() > 0.0 ? ToolFormatter.arrredondarNumero((Double)(item.getValorDescontoItemInf() / vlrProduto * 100.0), (int)4) : 0.0;
            item.setPercDescontoItemInf(Double.valueOf(percDescCalc));
        }
    }

    private void setFreteRateado(ItemPedido item, Short tipoFreteRateado, Double valorFreteRateado, Double percFreteRateado, Double valorTotalUnitario) {
        double vlrProduto = item.getValorTotalBruto();
        double valocCalc = 0.0;
        double percCalc = 0.0;
        if (tipoFreteRateado == 1) {
            valocCalc = ToolFormatter.arrredondarNumero((Double)(percFreteRateado / 100.0 * vlrProduto), (int)2);
            percCalc = percFreteRateado;
        } else {
            percCalc = valorFreteRateado > 0.0 ? ToolFormatter.arrredondarNumero((Double)(valorFreteRateado / valorTotalUnitario * 100.0), (int)4) : 0.0;
            valocCalc = ToolFormatter.arrredondarNumero((Double)(vlrProduto * percCalc / 100.0), (int)2);
        }
        item.setPercFreteRateado(Double.valueOf(percCalc));
        item.setValorFreteRateado(Double.valueOf(valocCalc));
    }

    private void setFreteInformadoItem(ItemPedido item) {
        double vlrProduto = item.getValorTotalBruto();
        double valorCalc = 0.0;
        double percCalc = 0.0;
        if (ToolMethods.isEquals((Object)item.getTipoFrete(), (Object)0)) {
            valorCalc = ToolFormatter.arrredondarNumero((Double)(item.getPercFreteItemInf() / 100.0 * vlrProduto), (int)2);
            item.setValorFreteItemInf(Double.valueOf(valorCalc));
        } else {
            percCalc = item.getValorFreteItemInf() > 0.0 ? ToolFormatter.arrredondarNumero((Double)(item.getValorFreteItemInf() / vlrProduto * 100.0), (int)4) : 0.0;
            item.setPercFreteItemInf(Double.valueOf(percCalc));
        }
    }

    private void setSeguroRateado(ItemPedido item, Short tipoSeguroRateado, Double valorSeguroRateado, Double percSeguroRateado, Double valorTotalUnitario) {
        double vlrProduto = item.getValorTotalBruto();
        double valocCalc = 0.0;
        double percCalc = 0.0;
        if (tipoSeguroRateado == 1) {
            valocCalc = ToolFormatter.arrredondarNumero((Double)(percSeguroRateado / 100.0 * vlrProduto), (int)2);
            percCalc = percSeguroRateado;
        } else {
            percCalc = valorSeguroRateado > 0.0 ? ToolFormatter.arrredondarNumero((Double)(valorSeguroRateado / valorTotalUnitario * 100.0), (int)4) : 0.0;
            valocCalc = ToolFormatter.arrredondarNumero((Double)(vlrProduto * percCalc / 100.0), (int)2);
        }
        item.setPercSeguroRateado(Double.valueOf(percCalc));
        item.setValorSeguroRateado(Double.valueOf(valocCalc));
    }

    private void setSeguroInformadoItem(ItemPedido item) {
        double vlrProduto = item.getValorTotalBruto();
        double valorCalc = 0.0;
        double percCalc = 0.0;
        if (ToolMethods.isEquals((Object)item.getTipoSeguro(), (Object)0)) {
            valorCalc = ToolFormatter.arrredondarNumero((Double)(item.getPercSeguroItemInf() / 100.0 * vlrProduto), (int)2);
            item.setValorSeguroItemInf(Double.valueOf(valorCalc));
        } else {
            percCalc = item.getValorSeguroItemInf() > 0.0 ? ToolFormatter.arrredondarNumero((Double)(item.getValorSeguroItemInf() / vlrProduto * 100.0), (int)4) : 0.0;
            item.setPercSeguroItemInf(Double.valueOf(percCalc));
        }
    }

    private void setDespAcessRateado(ItemPedido item, Short tipoDespAcessRateado, Double valorDespAcessRateado, Double percDespAcessRateado, Double valorTotalUnitario) {
        double vlrProduto = item.getValorTotalBruto();
        double valorCalc = 0.0;
        double percCalc = 0.0;
        if (tipoDespAcessRateado == 1) {
            valorCalc = ToolFormatter.arrredondarNumero((Double)(percDespAcessRateado / 100.0 * vlrProduto), (int)2);
            percCalc = percDespAcessRateado;
        } else {
            percCalc = valorDespAcessRateado > 0.0 ? ToolFormatter.arrredondarNumero((Double)(valorDespAcessRateado / valorTotalUnitario * 100.0), (int)4) : 0.0;
            valorCalc = ToolFormatter.arrredondarNumero((Double)(vlrProduto * percCalc / 100.0), (int)2);
        }
        item.setPercDespAcessRateado(Double.valueOf(percCalc));
        item.setValorDespAcessRateado(Double.valueOf(valorCalc));
    }

    private void setDespAcessInformadoItem(ItemPedido item) {
        double vlrProduto = item.getValorTotalBruto();
        double valorCalc = 0.0;
        double percCalc = 0.0;
        if (ToolMethods.isEquals((Object)item.getTipoDespAcessoria(), (Object)0)) {
            valorCalc = ToolFormatter.arrredondarNumero((Double)(item.getPercDespAcessItemInf() / 100.0 * vlrProduto), (int)2);
            item.setValorDespAcessItemInf(Double.valueOf(valorCalc));
        } else {
            percCalc = item.getValorDespAcessItemInf() > 0.0 ? ToolFormatter.arrredondarNumero((Double)(item.getValorDespAcessItemInf() / vlrProduto * 100.0), (int)4) : 0.0;
            item.setPercDespAcessItemInf(Double.valueOf(percCalc));
        }
    }
}

