/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.relpessoacontato;

import com.touchcomp.basementor.constants.enums.relpessoacontato.EnumConstRelPessoaContStatus;
import com.touchcomp.basementor.model.vo.RelPessoaContato;
import com.touchcomp.basementor.model.vo.TicketAtendTouch;
import com.touchcomp.basementorservice.service.impl.versaomentor.ServiceVersaoMentorImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.TString;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompRelPessoaContato {
    @Autowired
    ServiceVersaoMentorImpl serviceVersao;

    public void avaliaDefineStatus(RelPessoaContato rel) {
        if (ToolMethods.isEquals((Object)0, (Object)rel.getFinalizado())) {
            rel.setStatus(Short.valueOf(EnumConstRelPessoaContStatus.ABERTO_ATEND_TOUCH.getValue()));
            return;
        }
        if (rel.getNotaAtendimento() != null) {
            rel.setStatus(Short.valueOf(EnumConstRelPessoaContStatus.FECHADO_DEFINITIVAMENTE.getValue()));
            return;
        }
        rel.setStatus(Short.valueOf(EnumConstRelPessoaContStatus.FECHADO_AGUARDANDO_NOTA.getValue()));
    }

    public RelPessoaContato getNewAtendimento(TicketAtendTouch t) {
        if (t.getRelPessoaContato() != null) {
            return t.getRelPessoaContato();
        }
        RelPessoaContato rel = new RelPessoaContato();
        rel.setAssunto(t.getObservacao());
        rel.setClienteContSistemas(t.getUsuario().getClienteContSistemas());
        rel.setDataCadastro(new Date());
        rel.setDataRelacionamento(new Date());
        rel.setEmails(t.getEmail());
        rel.setNodo(t.getNodo());
        rel.setStatus(Short.valueOf(EnumConstRelPessoaContStatus.ABERTO_ATEND_TOUCH_TICKET.getValue()));
        rel.setUsuarioCliContSistemas(t.getUsuario());
        rel.setNrProtocolo(t.getNrProtocolo());
        if (TString.isALongNumber((String)t.getCodigoVersao())) {
            rel.setVersaoAtual(this.serviceVersao.getByCodigo(Long.valueOf(t.getCodigoVersao())));
        }
        rel.setArquivamentoDoc(t.getArquivamentoDoc());
        return rel;
    }
}

