/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.repositorioexcecoes;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.ServidorFTP;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorlogger.impl.Repository;
import com.touchcomp.basementorlogger.model.TouchException;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.service.impl.servidorftp.ServiceServidorFTPImpl;
import com.touchcomp.basementortools.tools.downloadweb.ToolDownloadWeb;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.ftp.ToolFTP;
import com.touchcomp.basementortools.tools.json.ToolJson;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchvomodel.vo.touchexceptions.DTOTouchException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompRepositorioExcecoes {
    @Autowired
    private ServiceServidorFTPImpl serviceServidorFTP;
    private final String FILE = "exceptions.json";
    private final String PATH = "/mentor/touch_comp_erp/";
    private final String URL = "https://www.toucherp.com.br/mentor/touch_comp_erp/exceptions.json";

    public List<DTOTouchException> getExceptionsMappedNotReported(String codigo) throws IOException {
        List exceptions = Repository.getInstance().getExceptionsNotReport();
        if (exceptions != null && codigo != null && !codigo.trim().isEmpty()) {
            List filter = exceptions.stream().filter(e -> e.getCodigo().contains(codigo)).collect(Collectors.toList());
            ArrayList<DTOTouchException> returned = new ArrayList<DTOTouchException>();
            for (TouchException t : filter) {
                DTOTouchException dto = new DTOTouchException();
                dto.setCodigo(t.getCodigo());
                dto.setMessage(t.getMessage());
                dto.setNaoReportar(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
                returned.add(dto);
            }
            return returned;
        }
        return new ArrayList<DTOTouchException>();
    }

    public DTOTouchException getDetailsException(String codigo) throws IOException {
        String message = MessagesBaseMentor.getErrorMsg((String)codigo, (Object[])new Object[0]);
        DTOTouchException dto = new DTOTouchException();
        dto.setCodigo(codigo);
        if (message == null || ToolMethods.isEquals((Object)codigo, (Object)message)) {
            dto.setMessage(codigo);
        } else {
            dto.setMessage(message);
        }
        if (this.checkExceptionsIsNotReport(codigo).booleanValue()) {
            dto.setNaoReportar(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
        } else {
            dto.setNaoReportar(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
        }
        return dto;
    }

    private Boolean checkExceptionsIsNotReport(String codigo) {
        List exceptions = Repository.getInstance().getExceptionsNotReport();
        for (TouchException ex : exceptions) {
            if (!TMethods.isEquals((Object)ex.getCodigo(), (Object)codigo)) continue;
            return true;
        }
        return false;
    }

    public void addExceptionNotReported(String codigo) throws ExceptionInvalidData, IOException, ExceptionIO {
        if (!ToolMethods.isStrWithData((String)codigo)) {
            return;
        }
        TouchException exception = new TouchException();
        String message = MessagesBaseMentor.getErrorMsg((String)codigo, (Object[])new Object[0]);
        exception.setCodigo(codigo);
        if (message != null && !ToolMethods.isEquals((Object)codigo, (Object)message)) {
            exception.setMessage(ToolString.clearSpecialCharacXMLFile((String)message));
        } else {
            exception.setMessage(ToolString.clearSpecialCharacXMLFile((String)codigo));
        }
        ServidorFTP servidor = this.getServidor();
        if (servidor == null) {
            throw new ExceptionInvalidData("E.ERP.1962.001", new Object[0]);
        }
        if (this.checkExceptionsIsNotReport(codigo).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.1962.004", new Object[0]);
        }
        List exceptions = Repository.getInstance().getExceptionsNotReport();
        exceptions.add(exception);
        this.storeFileExceptions(exceptions, servidor);
    }

    private void storeFileExceptions(List<TouchException> exceptions, ServidorFTP servidor) throws ExceptionIO {
        Collections.sort(exceptions, Comparator.comparing(TouchException::getCodigo));
        String json = ToolJson.toJson(exceptions);
        ByteArrayInputStream targetStream = new ByteArrayInputStream(json.getBytes());
        ToolFTP.useFTP((String)servidor.getEndereco(), (String)servidor.getCaminhoBaseFtp(), (String)"/mentor/touch_comp_erp/", (String)"exceptions.json", (InputStream)targetStream, (String)servidor.getUsuario(), (String)servidor.getSenha());
    }

    public void removeExceptionNotReported(String codigo) throws ExceptionInvalidData, IOException, ExceptionIO {
        ServidorFTP servidor = this.getServidor();
        if (servidor == null) {
            throw new ExceptionInvalidData("E.ERP.1962.001", new Object[0]);
        }
        List exceptions = Repository.getInstance().getExceptionsNotReport();
        ArrayList<TouchException> newExceptions = new ArrayList<TouchException>();
        for (TouchException e : exceptions) {
            if (TMethods.isEquals((Object)codigo, (Object)e.getCodigo())) continue;
            newExceptions.add(e);
        }
        if (TMethods.isEquals((Object)newExceptions.size(), (Object)exceptions.size())) {
            throw new ExceptionInvalidData("E.ERP.1962.003", new Object[0]);
        }
        Repository.getInstance().setExceptionsNotReport(newExceptions);
        this.storeFileExceptions(newExceptions, servidor);
    }

    public void initEventsNotReported() throws ExceptionIO, IOException {
        File file = ToolFile.createTempFile((String)"exceptions.json");
        ToolDownloadWeb.downloadFileToServer((File)file, (String)"https://www.toucherp.com.br/mentor/touch_comp_erp/exceptions.json");
        List exceptions = ToolJson.readJsonList((File)file, TouchException.class);
        Repository.getInstance().setExceptionsNotReport(exceptions);
    }

    ServidorFTP getServidor() throws ExceptionIO {
        List servidores = this.serviceServidorFTP.findAll();
        if (TMethods.isWithData(servidores)) {
            return (ServidorFTP)servidores.getFirst();
        }
        return null;
    }
}

