/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.requisicao.auxcomp;

import com.touchcomp.basementor.model.vo.ItemGradeFormulaProduto;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import java.util.HashMap;
import java.util.Set;

public class AuxGradesQtd {
    private HashMap dados = new HashMap();

    public Boolean contemGrade(ItemGradeFormulaProduto g) {
        return this.dados.containsKey(g);
    }

    public Set<ItemGradeFormulaProduto> getGrades() {
        return this.dados.keySet();
    }

    public void print() {
        Set<ItemGradeFormulaProduto> grades = this.getGrades();
        grades.forEach(g -> {
            System.out.print(g.getGradeCor().toString());
            System.out.print("\t");
            System.out.println("Qtd: " + String.valueOf(this.dados.get(g)));
        });
    }

    public Double getQuantidade(ItemGradeFormulaProduto i) {
        if (this.dados.containsKey(i)) {
            return (Double)this.dados.get(i);
        }
        return 0.0;
    }

    public void usarQuantidade(ItemGradeFormulaProduto g, Double qtd) {
        Double qtdOld = ToolFormatter.arrredondarNumero((Double)this.getQuantidade(g), (int)6);
        Double qtdNew = ToolFormatter.arrredondarNumero((Double)(qtdOld - qtd), (int)6);
        this.dados.put(g, qtdNew);
    }

    public void add(ItemGradeFormulaProduto g, Double qtd) {
        Double qtdOld = this.getQuantidade(g);
        Double qtdNew = qtdOld + qtd;
        this.dados.put(g, qtdNew);
    }

    public void analisarQtdFaltantes() throws ExceptionBase {
        String msg = this.getMensagem();
        if (msg.length() > 0) {
            throw new ExceptionInvalidData("E.ERP.289.003", new Object[]{msg});
        }
    }

    public String getMensagem() {
        Object msg = "";
        Set<ItemGradeFormulaProduto> grades = this.getGrades();
        for (ItemGradeFormulaProduto i : grades) {
            Double qtd = (Double)this.dados.get(i);
            if (!(qtd > 0.0)) continue;
            msg = (String)msg + MessagesBaseMentor.getMsg((String)"M.ERP.0289.001", (Object[])new Object[]{i.getGradeCor().getProdutoGrade().getProduto(), i.getGradeCor(), qtd});
        }
        return msg;
    }
}

