/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.requisicao.auxcomp;

import com.touchcomp.basementor.model.impl.SaldoEstoqueGeralBasico;
import com.touchcomp.basementor.model.vo.CelulaProdCentroEstoque;
import com.touchcomp.basementor.model.vo.CelulaProdutiva;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CacheSaldoProduto {
    private Set<String> celulasGradesPesquisadas = new HashSet<String>();
    private HashMap cache = new HashMap();
    private Set<String> combinacaoSaldo = new HashSet<String>();

    public void addCelularGradePesquisada(CelulaProdutiva celulaProdutiva, GradeCor gc) {
        String key = this.getKeyCelulaGrade(celulaProdutiva, gc);
        this.celulasGradesPesquisadas.add(key);
    }

    public Boolean celulaGradeJaPesquisada(CelulaProdutiva celulaProdutiva, GradeCor gc) {
        String key = this.getKeyCelulaGrade(celulaProdutiva, gc);
        return this.celulasGradesPesquisadas.contains(key);
    }

    public void addSaldos(GradeCor grade, List<SaldoEstoqueGeralBasico> newSaldos, CelulaProdutiva celulaProdutiva) {
        for (SaldoEstoqueGeralBasico s : newSaldos) {
            String key = this.getKeySaldoGradeCentroEstoqueLote(s);
            if (this.combinacaoSaldo.contains(key)) continue;
            this.combinacaoSaldo.add(key);
            String keyGradeCettroEstoque = this.getKeyCentroEstoqueGrade(s.getIdGradeCor(), s.getIdCentroEstoque());
            List<SaldoEstoqueGeralBasico> saldos = this.getSaldosCentroEstoqueGrade(keyGradeCettroEstoque);
            saldos.add(s);
        }
    }

    public List<SaldoEstoqueGeralBasico> getSaldoCache(GradeCor grade, CelulaProdutiva celulaProdutiva) {
        HashSet<String> keysCelulaGrade = new HashSet<String>();
        for (CelulaProdCentroEstoque ce : celulaProdutiva.getCentroEstoque()) {
            keysCelulaGrade.add(this.getKeyCentroEstoqueGrade(grade, ce.getCentroEstoque()));
        }
        ArrayList<SaldoEstoqueGeralBasico> list = new ArrayList<SaldoEstoqueGeralBasico>();
        for (String keyGradeCettroEstoque : keysCelulaGrade) {
            List<SaldoEstoqueGeralBasico> listAux = this.getSaldosCentroEstoqueGrade(keyGradeCettroEstoque);
            list.addAll(listAux);
        }
        return list;
    }

    public void usarSaldo(SaldoEstoqueGeralBasico s, Double qtd) {
        s.setQuantidade(ToolFormatter.arrredondarNumero((Double)(s.getQuantidade() - qtd), (int)6));
    }

    private List<SaldoEstoqueGeralBasico> getSaldosCentroEstoqueGrade(String key) {
        ArrayList list = (ArrayList)this.cache.get(key);
        if (ToolMethods.isNull((Object)list).booleanValue()) {
            list = new ArrayList();
            this.cache.put(key, list);
        }
        return list;
    }

    private String getKeyCentroEstoqueGrade(GradeCor g, CentroEstoque ce) {
        return this.getKeyCentroEstoqueGrade(g.getIdentificador(), ce.getIdentificador());
    }

    private String getKeyCentroEstoqueGrade(Long g, Long ce) {
        StringBuilder sb = new StringBuilder();
        sb.append("grade:").append(g);
        sb.append("|-|");
        sb.append("centro-estoque:").append(ce);
        return sb.toString();
    }

    private String getKeySaldoGradeCentroEstoqueLote(SaldoEstoqueGeralBasico s) {
        StringBuilder sb = new StringBuilder();
        sb.append("lote:").append(s.getIdLoteFabricacao());
        sb.append("|-|");
        sb.append("grade:").append(s.getIdGradeCor());
        sb.append("|-|");
        sb.append("centro-estoque:").append(s.getIdCentroEstoque());
        return sb.toString();
    }

    private String getKeyCelulaGrade(CelulaProdutiva celulaProdutiva, GradeCor gc) {
        StringBuilder sb = new StringBuilder();
        sb.append("celula:").append(celulaProdutiva.getIdentificador());
        sb.append("|-|");
        sb.append("grade:").append(gc.getIdentificador());
        return sb.toString();
    }
}

