/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.requisicao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.ApuracidadeEstoque;
import com.touchcomp.basementor.model.vo.GradeItemRequisicao;
import com.touchcomp.basementor.model.vo.ItemRequisicao;
import com.touchcomp.basementor.model.vo.Requisicao;
import com.touchcomp.basementorservice.components.requisicao.CompRequisicao;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class CompRequisicaoAcuracidade
extends CompRequisicao {
    public Requisicao gerarRequisicao(ApuracidadeEstoque vo) {
        Requisicao req = this.buildRequisicao(vo);
        if (ToolMethods.isNull((Object)req).booleanValue()) {
            return null;
        }
        this.aglutinarItens(req);
        return req;
    }

    private Requisicao buildRequisicao(ApuracidadeEstoque apuracidadeEstoque) {
        if (!ToolMethods.isEquals((Object)apuracidadeEstoque.getTipoBaixaEstoque(), (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            return null;
        }
        Requisicao req = apuracidadeEstoque.getRequisicao();
        req = this.getOrNewRequisicao(req);
        req.setTipoRequisicao(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
        req.setDataCadastro(apuracidadeEstoque.getDataCadastro());
        req.setDataRequisicao(apuracidadeEstoque.getDataApuracidadeEstoque());
        req.setEmpresa(apuracidadeEstoque.getEmpresa());
        req.getItensRequisicao().clear();
        req.getItensRequisicao().addAll(this.buildItensRequisicao(req, apuracidadeEstoque));
        return req;
    }

    private List<ItemRequisicao> buildItensRequisicao(Requisicao req, ApuracidadeEstoque apuracidadeEstoque) {
        ArrayList<ItemRequisicao> itens = new ArrayList<ItemRequisicao>();
        apuracidadeEstoque.getItensApuracidadeEstoque().forEach(i -> {
            if (i.getQuantidadeInicial() > i.getQuantidadeFinal()) {
                ItemRequisicao ir = new ItemRequisicao();
                ir.setNaturezaRequisicao(i.getNaturezaRequisicao());
                ir.setCentroCusto(apuracidadeEstoque.getCentroCusto());
                ir.setCentroEstoque(apuracidadeEstoque.getCentroEstoque());
                ir.setProduto(i.getGradeCor().getProdutoGrade().getProduto());
                ir.setRequisicao(req);
                GradeItemRequisicao grade = new GradeItemRequisicao();
                grade.setDataMovimentacao(req.getDataRequisicao());
                grade.setGradeCor(i.getGradeCor());
                grade.setLoteFabricacao(i.getLoteFabricacao());
                grade.setQuantidade(Double.valueOf(i.getQuantidadeInicial() - i.getQuantidadeFinal()));
                grade.setItemRequisicao(ir);
                grade.setCentroEstoque(ir.getCentroEstoque());
                grade.setEmpresa(req.getEmpresa());
                ArrayList<GradeItemRequisicao> listGrades = new ArrayList<GradeItemRequisicao>();
                listGrades.add(grade);
                ir.setGradeItemRequisicao(listGrades);
                itens.add(ir);
            }
        });
        return itens;
    }
}

