/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.requisicao.impl;

import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.model.impl.SaldoEstoqueGeral;
import com.touchcomp.basementor.model.vo.AtendPedidoAlmox;
import com.touchcomp.basementor.model.vo.AtendPedidoAlmoxItem;
import com.touchcomp.basementor.model.vo.AtendPedidoAlmoxItemGrade;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeItemPedidoAlmoxarifado;
import com.touchcomp.basementor.model.vo.GradeItemRequisicao;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.ItemPedidoAlmoxarifado;
import com.touchcomp.basementor.model.vo.ItemRequisicao;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.NaturezaRequisicao;
import com.touchcomp.basementor.model.vo.PedidoAlmoxarifado;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.Requisicao;
import com.touchcomp.basementorexceptions.exceptions.impl.parametrizacaoctbrequisicao.ExceptionParamCtbRequisicao;
import com.touchcomp.basementorservice.components.requisicao.CompRequisicao;
import com.touchcomp.basementorservice.service.impl.naturezarequisicao.ServiceNaturezaRequisicaoImpl;
import com.touchcomp.basementorservice.service.impl.saldoestoque.ServiceSaldoEstoqueImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompRequisicaoAtendimentoPedAlmox
extends CompRequisicao {
    ServiceNaturezaRequisicaoImpl serviceNaturezaRequisicao;
    ServiceSaldoEstoqueImpl serviceSaldoEstoque;

    @Autowired
    public CompRequisicaoAtendimentoPedAlmox(ServiceNaturezaRequisicaoImpl serviceNaturezaRequisicao, ServiceSaldoEstoqueImpl serviceSaldoEstoque) {
        this.serviceNaturezaRequisicao = serviceNaturezaRequisicao;
        this.serviceSaldoEstoque = serviceSaldoEstoque;
    }

    public Double transferirItensReq(Date dataMovimentacao, AtendPedidoAlmoxItemGrade gr, List<SaldoEstoqueGeral> saldos, Double qtd) throws ExceptionParamCtbRequisicao {
        for (SaldoEstoqueGeral s : saldos) {
            PedidoAlmoxarifado p = gr.getAtendPedidoAlmoxItem().getAtendPedidoAlmox().getPedidoAlmoxarifado();
            CentroCusto cc = ToolMethods.isNull((Object)p.getItensPedido()) == false && !p.getItensPedido().isEmpty() ? ((ItemPedidoAlmoxarifado)p.getItensPedido().get(0)).getCentroCusto() : null;
            ItemRequisicao it = new ItemRequisicao();
            it.setCentroCusto(cc);
            it.setCentroEstoque(s.getCentroEstoque());
            it.setProduto(gr.getAtendPedidoAlmoxItem().getItemPedidoAlmoxarifado().getProduto());
            NaturezaRequisicao n = this.getNaturezaRequisicao(it.getProduto(), p.getEmpresa().getEmpresaDados().getGrupoEmpresa());
            it.setNaturezaRequisicao(n);
            GradeItemRequisicao grade = new GradeItemRequisicao();
            grade.setItemRequisicao(it);
            grade.setGradeCor(gr.getGradeItemPedAlmox().getGradeCor());
            grade.setLoteFabricacao(s.getLoteFabricacao());
            grade.setDataMovimentacao(dataMovimentacao);
            grade.setCentroEstoque(s.getCentroEstoque());
            it.getGradeItemRequisicao().add(grade);
            if (s.getQuantidade() > qtd) {
                grade.setQuantidade(qtd);
                it.setQuantidadeTotal(qtd);
                qtd = 0.0;
                if (!(it.getQuantidadeTotal() > 0.0)) break;
                gr.getItensRequisicao().add(it);
                break;
            }
            grade.setQuantidade(s.getQuantidade());
            it.setQuantidadeTotal(s.getQuantidade());
            qtd = qtd - s.getQuantidade();
            if (!(it.getQuantidadeTotal() > 0.0)) continue;
            gr.getItensRequisicao().add(it);
        }
        return qtd;
    }

    private NaturezaRequisicao getNaturezaRequisicao(Produto produto, GrupoEmpresa grupoEmpresa) throws ExceptionParamCtbRequisicao {
        return this.serviceNaturezaRequisicao.getFirstOrThrow(produto, grupoEmpresa);
    }

    public List<GradeItemRequisicao> buildGradesItemReq(ItemPedidoAlmoxarifado itemPedidoAlmoxarifado, Empresa emp) {
        LinkedList<GradeItemRequisicao> gr = new LinkedList<GradeItemRequisicao>();
        for (GradeItemPedidoAlmoxarifado gi : itemPedidoAlmoxarifado.getGradesItensAlmoxarifado()) {
            GradeItemRequisicao gf = new GradeItemRequisicao();
            gf.setDataMovimentacao(new Date());
            gf.setGradeCor(gi.getGradeCor());
            gf.setQuantidade(gi.getQuantidade());
            LoteFabricacao lf = this.serviceSaldoEstoque.findMelhorLoteFabricacao(ToolDate.getCurrentDate(), gf.getGradeCor(), emp, EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO);
            gf.setLoteFabricacao(lf);
            gr.add(gf);
        }
        return gr;
    }

    public Requisicao buildRequisicao(AtendPedidoAlmox a) {
        ArrayList<ItemRequisicao> itens = new ArrayList<ItemRequisicao>();
        for (AtendPedidoAlmoxItem item : a.getAtendPedidoAlmoxItem()) {
            for (AtendPedidoAlmoxItemGrade gr : item.getAtendPedAlmoxGrades()) {
                itens.addAll(gr.getItensRequisicao());
            }
        }
        return this.getRequisicao(a, itens);
    }

    private Requisicao getRequisicao(AtendPedidoAlmox a, List<ItemRequisicao> itens) {
        if (itens.isEmpty()) {
            return null;
        }
        Date dataEntSai = a.getGrupoAtendPedidoAlmox().getDataAtendimento();
        Requisicao r = a.getRequisicao();
        r = this.getOrNewRequisicao(r);
        r.setDataCadastro(dataEntSai);
        r.setDataRequisicao(dataEntSai);
        r.setEmpresa(a.getPedidoAlmoxarifado().getEmpresa());
        r.setItensRequisicao(itens);
        return r;
    }
}

