/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.requisicao.impl;

import com.touchcomp.basementor.constants.enums.opcoesmanutencaoativos.EnumConstTipoMovimentoConsumo;
import com.touchcomp.basementor.model.vo.ConsumoAtivo;
import com.touchcomp.basementor.model.vo.GradeItemConsumoAtivo;
import com.touchcomp.basementor.model.vo.GradeItemRequisicao;
import com.touchcomp.basementor.model.vo.ItemConsumoAtivo;
import com.touchcomp.basementor.model.vo.ItemRequisicao;
import com.touchcomp.basementor.model.vo.NaturezaRequisicao;
import com.touchcomp.basementor.model.vo.Requisicao;
import com.touchcomp.basementorexceptions.exceptions.impl.parametrizacaoctbrequisicao.ExceptionParamCtbRequisicao;
import com.touchcomp.basementorservice.components.requisicao.CompRequisicao;
import com.touchcomp.basementorservice.service.impl.naturezarequisicao.ServiceNaturezaRequisicaoImpl;
import com.touchcomp.basementorservice.service.impl.requisicao.ServiceRequisicaoImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class CompRequisicaoConsumoAtivo
extends CompRequisicao {
    @Autowired
    ServiceNaturezaRequisicaoImpl serviceNaturezaRequisicao;
    ServiceRequisicaoImpl serviceRequisicao;

    public CompRequisicaoConsumoAtivo(ServiceNaturezaRequisicaoImpl serviceNaturezaRequisicao) {
        this.serviceNaturezaRequisicao = serviceNaturezaRequisicao;
    }

    @Autowired
    public CompRequisicaoConsumoAtivo(@Lazy ServiceRequisicaoImpl serviceRequisicao) {
        this.serviceRequisicao = serviceRequisicao;
    }

    public CompRequisicaoConsumoAtivo() {
    }

    public Requisicao gerarRequisicao(ConsumoAtivo consumoAtivo) throws ExceptionParamCtbRequisicao {
        Requisicao vo = consumoAtivo.getRequisicao();
        if (TMethods.isWithData((Collection)(vo = this.getOrNewRequisicao(vo)).getItensRequisicao())) {
            vo.getItensRequisicao().clear();
            this.serviceRequisicao.saveOrUpdateFlush(vo);
        }
        vo.setDataCadastro(consumoAtivo.getDataCadastro());
        vo.setDataRequisicao(consumoAtivo.getDataMovimentacao());
        vo.setEmpresa(consumoAtivo.getEmpresa());
        List<ItemRequisicao> itens = this.getItensRequisicao(vo, consumoAtivo);
        if (ToolMethods.isNull(itens).booleanValue() || itens.isEmpty()) {
            return null;
        }
        vo.setItensRequisicao(itens);
        this.aglutinarItens(vo);
        return vo;
    }

    private List<ItemRequisicao> getItensRequisicao(Requisicao vo, ConsumoAtivo consumoAtivo) throws ExceptionParamCtbRequisicao {
        List listReturn = vo.getItensRequisicao();
        listReturn.clear();
        for (ItemConsumoAtivo itemConsumoAtivo : consumoAtivo.getItemConsumoAtivo()) {
            if (!ToolMethods.isEquals((Object)itemConsumoAtivo.getMovInterno(), (Object)EnumConstTipoMovimentoConsumo.CONSUMO_INTERNO.getValue())) continue;
            listReturn.addAll(this.gerarItemRequisicao(vo, itemConsumoAtivo, consumoAtivo));
        }
        return listReturn;
    }

    private List<ItemRequisicao> gerarItemRequisicao(Requisicao vo, ItemConsumoAtivo itemConsumoAtivo, ConsumoAtivo consumoAtivo) throws ExceptionParamCtbRequisicao {
        ArrayList<ItemRequisicao> listRet = new ArrayList<ItemRequisicao>();
        for (GradeItemConsumoAtivo g : itemConsumoAtivo.getGradeItemConsumoAtivo()) {
            if (!(g.getQuantidade() > 0.0)) continue;
            ItemRequisicao itemRequisicao = new ItemRequisicao();
            NaturezaRequisicao natureza = itemConsumoAtivo.getNaturezaRequisicao();
            if (ToolMethods.isNull((Object)natureza).booleanValue()) {
                natureza = this.serviceNaturezaRequisicao.getFirstOrThrow(itemConsumoAtivo.getProduto(), consumoAtivo.getEmpresa());
            }
            itemRequisicao.setNaturezaRequisicao(natureza);
            itemRequisicao.setCentroEstoque(itemConsumoAtivo.getCentroEstoque());
            itemRequisicao.setProduto(itemConsumoAtivo.getProduto());
            itemRequisicao.setCentroCusto(itemConsumoAtivo.getCentroCusto());
            itemRequisicao.setRequisicao(vo);
            consumoAtivo.setRequisicao(vo);
            GradeItemRequisicao gradeItemRequisicao = new GradeItemRequisicao(g.getGradeCor());
            gradeItemRequisicao.setQuantidade(g.getQuantidade());
            gradeItemRequisicao.setLoteFabricacao(g.getLoteFabricacao());
            gradeItemRequisicao.setItemRequisicao(itemRequisicao);
            gradeItemRequisicao.setDataMovimentacao(consumoAtivo.getDataMovimentacao());
            gradeItemRequisicao.setCentroEstoque(itemRequisicao.getCentroEstoque());
            gradeItemRequisicao.setEmpresa(itemRequisicao.getRequisicao().getEmpresa());
            itemRequisicao.getGradeItemRequisicao().add(gradeItemRequisicao);
            itemRequisicao.setQuantidadeTotal(g.getQuantidade());
            listRet.add(itemRequisicao);
        }
        return listRet;
    }
}

