/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.requisicao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.ControleEntregaEquipamento;
import com.touchcomp.basementor.model.vo.GradeItemRequisicao;
import com.touchcomp.basementor.model.vo.ItemControleEquipamento;
import com.touchcomp.basementor.model.vo.ItemRequisicao;
import com.touchcomp.basementor.model.vo.Requisicao;
import com.touchcomp.basementorservice.components.requisicao.CompRequisicao;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class CompRequisicaoControleEntregaEquipamento
extends CompRequisicao {
    public Requisicao criarRequisicaoEquipamentos(ControleEntregaEquipamento c) {
        Requisicao obj = c.getRequisicao();
        obj = this.getOrNewRequisicao(obj);
        obj.setTipoRequisicao(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
        obj.setDataCadastro(c.getDataCadastro());
        obj.setDataRequisicao(c.getDataEntrega());
        obj.setEmpresa(c.getEmpresa());
        List<ItemRequisicao> itens = this.getItensRequisicao(obj, c.getItemControleEquipamentos());
        obj.setItensRequisicao(itens);
        return obj;
    }

    private List<ItemRequisicao> getItensRequisicao(Requisicao vo, List<ItemControleEquipamento> itemControleEquipamento) {
        ArrayList<ItemRequisicao> itens = new ArrayList<ItemRequisicao>();
        for (ItemControleEquipamento i : itemControleEquipamento) {
            ItemRequisicao ir = new ItemRequisicao();
            ir.setCentroEstoque(i.getCentroEstoque());
            ir.setProduto(i.getGradeCor().getProdutoGrade().getProduto());
            ir.setCentroCusto(i.getControleEntregaEquipamento().getColaborador().getCentroCusto());
            GradeItemRequisicao g = new GradeItemRequisicao();
            g.setGradeCor(i.getGradeCor());
            g.setQuantidade(i.getQuantidade());
            g.setLoteFabricacao(i.getLoteFabricacao());
            g.setItemRequisicao(ir);
            g.setDataMovimentacao(vo.getDataRequisicao());
            g.setCentroEstoque(ir.getCentroEstoque());
            g.setEmpresa(vo.getEmpresa());
            ir.setGradeItemRequisicao(Arrays.asList(g));
            ir.setNaturezaRequisicao(i.getNaturezaRequisicao());
            ir.setRequisicao(vo);
            if (!(g.getQuantidade() > 0.0)) continue;
            itens.add(ir);
        }
        return itens;
    }
}

