/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.requisicao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.GradeItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.GradeItemRequisicao;
import com.touchcomp.basementor.model.vo.ItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.ItemRequisicao;
import com.touchcomp.basementor.model.vo.LancCtoItemNota;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.Requisicao;
import com.touchcomp.basementorservice.components.requisicao.CompRequisicao;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class CompRequisicaoNotaFiscalTerceiros
extends CompRequisicao {
    public Requisicao criarRequisicaoNotaTerceiros(NotaFiscalTerceiros n) {
        if (ToolMethods.isNull((Object)n).booleanValue() || n.getItemNotaTerceiros().isEmpty()) {
            return null;
        }
        Requisicao obj = n.getRequisicao();
        obj = this.getOrNewRequisicao(obj);
        obj.setTipoRequisicao(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
        obj.setDataCadastro(n.getDataCadastro());
        obj.setDataRequisicao(n.getDataEntrada());
        obj.setEmpresa(n.getEmpresa());
        List<ItemRequisicao> itens = this.getItensRequisicao(obj, n.getItemNotaTerceiros());
        if (ToolMethods.isNull(itens).booleanValue() || itens.isEmpty()) {
            return null;
        }
        obj.setItensRequisicao(itens);
        return obj;
    }

    private List<ItemRequisicao> getItensRequisicao(Requisicao r, List<ItemNotaTerceiros> itemNotaTerceiros) {
        ArrayList<ItemRequisicao> itens = new ArrayList<ItemRequisicao>();
        for (ItemNotaTerceiros i : itemNotaTerceiros) {
            if (ToolMethods.isNull((Object)i.getLancCtoEntrada()).booleanValue()) continue;
            for (LancCtoItemNota l : i.getLancCtoEntrada()) {
                GradeItemNotaTerceiros grade = null;
                for (GradeItemNotaTerceiros gradeItemNotaTerceiros : i.getGrade()) {
                    if (!ToolMethods.isEquals((Object)gradeItemNotaTerceiros.getGradeCor(), (Object)l.getLancCtoCusto().getGradeCor())) continue;
                    grade = gradeItemNotaTerceiros;
                    break;
                }
                if (ToolMethods.isNull(grade).booleanValue() || !ToolMethods.isEquals((Object)l.getGerarRequisicao(), (Object)1)) continue;
                ItemRequisicao ir = new ItemRequisicao();
                ir.setCentroEstoque(l.getItemNotaTerceiros().getCentroEstoque());
                ir.setProduto(l.getItemNotaTerceiros().getProduto());
                ir.setCentroCusto(l.getLancCtoCusto().getCentroCusto());
                ir.setNaturezaRequisicao(l.getNaturezaRequisicao());
                ir.setRequisicao(r);
                ArrayList<GradeItemRequisicao> listGrades = new ArrayList<GradeItemRequisicao>();
                GradeItemRequisicao g = new GradeItemRequisicao();
                g.setDataMovimentacao(r.getDataRequisicao());
                g.setEmpresa(r.getEmpresa());
                g.setCentroEstoque(ir.getCentroEstoque());
                g.setGradeCor(l.getLancCtoCusto().getGradeCor());
                g.setItemRequisicao(ir);
                if (!ToolMethods.isNull((Object)l.getLancCtoCusto().getLoteFabricacao()).booleanValue()) {
                    g.setLoteFabricacao(l.getLancCtoCusto().getLoteFabricacao());
                } else {
                    g.setLoteFabricacao(grade.getLoteFabricacao());
                }
                g.setQuantidade(l.getLancCtoCusto().getQuantidade());
                listGrades.add(g);
                ir.setGradeItemRequisicao(listGrades);
                if (!(g.getQuantidade() > 0.0)) continue;
                itens.add(ir);
            }
        }
        return itens;
    }
}

