/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.requisicao.impl;

import com.touchcomp.basementor.model.vo.GradeItemRequisicao;
import com.touchcomp.basementor.model.vo.ItemRequisicao;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.Requisicao;
import com.touchcomp.basementor.model.vo.WmsPedidoItem;
import com.touchcomp.basementor.model.vo.WmsPedidoItemGrade;
import com.touchcomp.basementor.model.vo.WmsSeparacaoPedido;
import com.touchcomp.basementor.model.vo.WmsSeparacaoPedidoEmb;
import com.touchcomp.basementor.model.vo.WmsSeparacaoPedidoGrConf;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.components.requisicao.CompRequisicao;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class CompRequisicaoWmsSaidaEstoque
extends CompRequisicao {
    public Requisicao gerarRequisicao(WmsSeparacaoPedido wmsSeparacaoPedido) {
        Requisicao vo = wmsSeparacaoPedido.getWmsSaidaEstoque().getBaixaEfetiva();
        vo = this.getOrNewRequisicao(vo);
        vo.setDataCadastro(wmsSeparacaoPedido.getDataCadastro());
        vo.setDataRequisicao(wmsSeparacaoPedido.getDataSaida());
        vo.setEmpresa(wmsSeparacaoPedido.getEmpresa());
        vo.setObservacao(MessagesBaseMentor.getMsg((String)"M.ERP.1916.001", (Object[])new Object[]{wmsSeparacaoPedido.getIdentificador()}));
        List<ItemRequisicao> itens = this.getItensRequisicao(vo, wmsSeparacaoPedido);
        if (ToolMethods.isNull(itens).booleanValue() || itens.isEmpty()) {
            return null;
        }
        vo.setItensRequisicao(itens);
        this.aglutinarItens(vo);
        return vo;
    }

    private List<ItemRequisicao> getItensRequisicao(Requisicao vo, WmsSeparacaoPedido wmsSeparacaoPedido) {
        List listReturn = vo.getItensRequisicao();
        listReturn.clear();
        for (WmsPedidoItem wmsPedidoItem : wmsSeparacaoPedido.getPedidoWms().getItens()) {
            listReturn.add(this.gerarItemRequisicao(wmsPedidoItem, wmsSeparacaoPedido));
        }
        return listReturn;
    }

    private ItemRequisicao gerarItemRequisicao(WmsPedidoItem wmsPedidoItem, WmsSeparacaoPedido wmsSeparacaoPedido) {
        ItemRequisicao item = new ItemRequisicao();
        WmsSeparacaoPedidoGrConf wmsSeparacaoPedidoGrConf = (WmsSeparacaoPedidoGrConf)((WmsSeparacaoPedidoEmb)wmsSeparacaoPedido.getEmbalagens().getFirst()).getGradesConf().getFirst();
        item.setCentroEstoque(wmsSeparacaoPedidoGrConf.getWmsEndereco().getCentroEstoque());
        item.setProduto(wmsPedidoItem.getProduto());
        item.setGradeItemRequisicao(this.gerarGradeItemRequisicao(item, wmsPedidoItem, wmsSeparacaoPedido, wmsSeparacaoPedidoGrConf.getLoteFabricacao()));
        item.setQuantidadeTotal(wmsPedidoItem.getQuantidadeTotal());
        item.setCentroCusto(wmsPedidoItem.getCentroCusto());
        return item;
    }

    private List<GradeItemRequisicao> gerarGradeItemRequisicao(ItemRequisicao vo, WmsPedidoItem wmsPedidoItem, WmsSeparacaoPedido wmsSeparacaoPedido, LoteFabricacao loteFabricacao) {
        ArrayList<GradeItemRequisicao> listGrades = new ArrayList<GradeItemRequisicao>();
        for (WmsPedidoItemGrade g : wmsPedidoItem.getGrades()) {
            if (!(g.getQuantidade() > 0.0)) continue;
            GradeItemRequisicao gradeItemRequisicao = new GradeItemRequisicao();
            gradeItemRequisicao.setGradeCor(g.getGradeCor());
            gradeItemRequisicao.setQuantidade(g.getQuantidade());
            gradeItemRequisicao.setDataMovimentacao(wmsSeparacaoPedido.getDataCadastro());
            gradeItemRequisicao.setCentroEstoque(vo.getCentroEstoque());
            gradeItemRequisicao.setItemRequisicao(vo);
            gradeItemRequisicao.setLoteFabricacao(loteFabricacao);
            listGrades.add(gradeItemRequisicao);
        }
        return listGrades;
    }
}

