/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.requisicao.impl.comunicadoproducao;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FaseProdutiva;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeFormulaProduto;
import com.touchcomp.basementor.model.vo.ItemComunicadoProducao;
import com.touchcomp.basementor.model.vo.ItemGradeFormulaProduto;
import com.touchcomp.basementor.model.vo.ItemRequisicao;
import com.touchcomp.basementor.model.vo.NaturezaRequisicao;
import com.touchcomp.basementor.model.vo.OpcoesPCP;
import com.touchcomp.basementor.model.vo.OrdemServicoProdLinhaProd;
import com.touchcomp.basementor.model.vo.Requisicao;
import com.touchcomp.basementor.model.vo.SubdivisaoOSProdLinhaProd;
import com.touchcomp.basementorservice.components.requisicao.CompRequisicao;
import com.touchcomp.basementorservice.components.requisicao.auxcomp.AuxGradesQtd;
import com.touchcomp.basementorservice.components.requisicao.auxcomp.CacheSaldoProduto;
import com.touchcomp.basementorservice.components.requisicao.impl.comunicadoproducao.CompRequisicaoComunicadoProducaoAux;
import com.touchcomp.basementorservice.helpers.impl.requisicao.HelperRequisicao;
import com.touchcomp.basementorservice.service.impl.gradeformulaproduto.ServiceGradeFormulaProdutoImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompRequisicaoComunicadoProducao
extends CompRequisicao {
    HelperRequisicao helperRequisicao;
    CompRequisicaoComunicadoProducaoAux compAux;
    ServiceGradeFormulaProdutoImpl serviceGradeFormulaProduto;

    @Autowired
    public CompRequisicaoComunicadoProducao(HelperRequisicao helperRequisicao, CompRequisicaoComunicadoProducaoAux compAux, ServiceGradeFormulaProdutoImpl serviceGradeFormulaProduto) {
        this.helperRequisicao = helperRequisicao;
        this.compAux = compAux;
        this.serviceGradeFormulaProduto = serviceGradeFormulaProduto;
    }

    public Requisicao gerarRequisicaoItemComProducao(ItemComunicadoProducao i, GradeFormulaProduto form, Date data, OrdemServicoProdLinhaProd os, FaseProdutiva fase, SubdivisaoOSProdLinhaProd sub, OpcoesPCP opPcp, AuxGradesQtd auxGradesQtd, CacheSaldoProduto cacheSaldoProduto) {
        Requisicao r = null;
        Iterator iterator = i.getRequisicoes().iterator();
        if (iterator.hasNext()) {
            Requisicao rTmp;
            r = rTmp = (Requisicao)iterator.next();
        }
        r = this.getOrNewRequisicao(r);
        List<ItemRequisicao> itensReq = this.getItemReqLinhaProd(i.getQuantidadeTotal(), i.getQuantidadeTotalRef(), form, data, os, fase, sub, opPcp, auxGradesQtd, cacheSaldoProduto);
        if (!itensReq.isEmpty()) {
            r = this.novaRequisicao(r, i, data, itensReq, os.getEmpresa());
        }
        r = this.helperRequisicao.beforeSave(r);
        return r;
    }

    public List<ItemRequisicao> getItemReqLinhaProdGrade(Double qtdTotal, Double qtdRef, ItemGradeFormulaProduto form, Date data, OrdemServicoProdLinhaProd os, FaseProdutiva fase, SubdivisaoOSProdLinhaProd sub, OpcoesPCP opPcp, AuxGradesQtd gradesQtd, CacheSaldoProduto cacheSaldoProduto) {
        if (ToolMethods.isNull((Object)form).booleanValue()) {
            return new ArrayList<ItemRequisicao>();
        }
        if (ToolMethods.isNull((Object)gradesQtd).booleanValue()) {
            gradesQtd = new AuxGradesQtd();
        }
        this.calcularQuantidadeProdutosItem(qtdTotal, qtdRef, os, form, gradesQtd);
        List<ItemRequisicao> itens = this.compAux.buildItensRequisicao(gradesQtd, fase, opPcp, os, data, sub, cacheSaldoProduto, qtdTotal);
        return itens;
    }

    public List<ItemRequisicao> getItemReqLinhaProd(Double qtdTotal, Double qtdRef, GradeFormulaProduto form, Date data, OrdemServicoProdLinhaProd os, FaseProdutiva fase, SubdivisaoOSProdLinhaProd sub, OpcoesPCP opPcp, AuxGradesQtd gradesQtd, CacheSaldoProduto cacheSaldoProduto) {
        if (ToolMethods.isNull((Object)form).booleanValue()) {
            return new ArrayList<ItemRequisicao>();
        }
        if (ToolMethods.isNull((Object)gradesQtd).booleanValue()) {
            gradesQtd = new AuxGradesQtd();
        }
        this.calcularQuantidadeProdutos(qtdTotal, qtdRef, form, os, gradesQtd);
        List<ItemRequisicao> itens = this.compAux.buildItensRequisicao(gradesQtd, fase, opPcp, os, data, sub, cacheSaldoProduto, this.getQuantidadeRequisicao(form, qtdTotal, qtdRef));
        return itens;
    }

    public ItemRequisicao getItemRequisicao(GradeCor gc, NaturezaRequisicao nat, CentroCusto cc, GradeCor gcSubstituto) {
        ItemRequisicao ir = new ItemRequisicao();
        ir.setNaturezaRequisicao(nat);
        ir.setCentroCusto(cc);
        ir.setProduto(gc.getProdutoGrade().getProduto());
        if (!ToolMethods.isNull((Object)gcSubstituto).booleanValue()) {
            ir.setProdutoSubstituto(gcSubstituto.getProdutoGrade().getProduto());
        }
        return ir;
    }

    public Requisicao novaRequisicao(Requisicao r, ItemComunicadoProducao i, Date data, List<ItemRequisicao> itens, Empresa emp) {
        r = this.getOrNewRequisicao(r);
        r.setDataCadastro(ToolDate.getCurrentDate());
        r.setDataRequisicao(data);
        r.setEmpresa(emp);
        r.setItemComunicadoProducao(i);
        r.setItensRequisicao(itens);
        r = this.helperRequisicao.beforeSave(r);
        return r;
    }

    public void calcularQuantidadeProdutos(Double qtdTotal, Double qtdRef, GradeFormulaProduto form, OrdemServicoProdLinhaProd os, AuxGradesQtd gradesQtd) {
        if (!ToolMethods.isNull((Object)form).booleanValue()) {
            List itensForm = form.getItemGradeFormulaProduto();
            for (ItemGradeFormulaProduto ig : itensForm) {
                if (ToolMethods.isEquals((Object)ig.getNaoRequisitarAutomatico(), (Object)EnumConstantsMentorSimNao.SIM.getValue())) continue;
                this.calcularQuantidadeProdutosItem(qtdTotal, qtdRef, os, ig, gradesQtd);
            }
        }
    }

    public void calcularQuantidadeProdutosItem(Double qtdTotal, Double qtdRef, OrdemServicoProdLinhaProd os, ItemGradeFormulaProduto ig, AuxGradesQtd gradesQtd) {
        GradeFormulaProduto formulaGrade = this.serviceGradeFormulaProduto.findMelhorGradeFormulaProduto(ig.getGradeCor());
        if (!ToolMethods.isNull((Object)os).booleanValue() && ToolMethods.isEquals((Object)os.getNaoGerarSubOS(), (Object)1) && !ToolMethods.isNull((Object)formulaGrade).booleanValue() && !ToolMethods.isEquals((Object)formulaGrade.getNaoGerarSubOS(), (Object)1)) {
            this.calcularQuantidadeProdutos(qtdTotal, qtdRef, formulaGrade, os, gradesQtd);
        } else {
            Double qtdRemas = !ToolMethods.isEquals((Object)ig.getGradeFormulaProduto().getTipoBaixaEstoque(), (Object)1) ? ToolFormatter.arrredondarNumero((Double)(ig.getQuantidade() * qtdTotal), (int)6) : ToolFormatter.arrredondarNumero((Double)(ig.getQuantidade() * qtdRef), (int)6);
            gradesQtd.add(ig, qtdRemas);
        }
    }

    private Double getQuantidadeRequisicao(GradeFormulaProduto form, Double qtdTotal, Double qtdRef) {
        if (!ToolMethods.isEquals((Object)form.getTipoBaixaEstoque(), (Object)1)) {
            return qtdTotal;
        }
        return qtdRef;
    }
}

