/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.requisicao.impl.comunicadoproducao;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstDisponibilidade;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoCarregQtdeVlr;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoSaldo;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoSaldoQtde;
import com.touchcomp.basementor.model.impl.SaldoEstoqueGeralBasico;
import com.touchcomp.basementor.model.vo.CelulaProdCentroEstoque;
import com.touchcomp.basementor.model.vo.CelulaProdutiva;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FaseProdutiva;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeItemRequisicao;
import com.touchcomp.basementor.model.vo.ItemGradeFormulaProduto;
import com.touchcomp.basementor.model.vo.ItemGradeFormulaProdutoSubstituto;
import com.touchcomp.basementor.model.vo.ItemRequisicao;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.OpcoesPCP;
import com.touchcomp.basementor.model.vo.OrdemServicoProdLinhaProd;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.SubdivisaoOSProdLinhaProd;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.components.requisicao.auxcomp.AuxGradesQtd;
import com.touchcomp.basementorservice.components.requisicao.auxcomp.CacheSaldoProduto;
import com.touchcomp.basementorservice.service.impl.centroestoque.ServiceCentroEstoqueImpl;
import com.touchcomp.basementorservice.service.impl.gradecor.ServiceGradeCorImpl;
import com.touchcomp.basementorservice.service.impl.lotefabricacao.ServiceLoteFabricacaoImpl;
import com.touchcomp.basementorservice.service.impl.saldoestoque.ServiceSaldoEstoqueImpl;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompRequisicaoComunicadoProducaoAux {
    @Autowired
    ServiceSaldoEstoqueImpl serviceSaldoEstoque;
    @Autowired
    ServiceLoteFabricacaoImpl serviceLoteFabricacao;
    @Autowired
    ServiceCentroEstoqueImpl serviceCentroEstoque;
    @Autowired
    ServiceGradeCorImpl serviceGradeCor;

    public List<ItemRequisicao> buildItensRequisicao(AuxGradesQtd grades, FaseProdutiva fase, OpcoesPCP opPcp, OrdemServicoProdLinhaProd os, Date data, SubdivisaoOSProdLinhaProd sub, CacheSaldoProduto cacheSaldo, Double qtdeTotalItemComunicado) {
        Set<ItemGradeFormulaProduto> gradesItens = grades.getGrades();
        CentroCusto centroCusto = fase.getCelulaProdutiva().getCentroCusto();
        if (ToolMethods.isNull((Object)centroCusto).booleanValue()) {
            centroCusto = sub.getCentroCusto();
        }
        ArrayList<ItemRequisicao> listItensRequisicao = new ArrayList<ItemRequisicao>();
        block0: for (ItemGradeFormulaProduto i : gradesItens) {
            if (!ToolMethods.isEquals((Object)opPcp.getNaoSugerirLoteEvtLinhaProd(), (Object)0)) continue;
            List<SaldoEstoqueGeralBasico> saldos = this.pesquisarSaldo(i, fase, os, data, sub, cacheSaldo);
            for (SaldoEstoqueGeralBasico sal : saldos) {
                Double quatidadeNecessaria = grades.getQuantidade(i);
                if (!(quatidadeNecessaria > 0.0)) continue block0;
                if (!(sal.getQuantidade() > 0.0)) continue;
                Double quantidadeSaldo = ToolFormatter.arrredondarNumero((Double)sal.getQuantidade(), (int)6);
                GradeItemRequisicao grade = new GradeItemRequisicao();
                grade.setGradeCor((GradeCor)this.serviceGradeCor.get(sal.getIdGradeCor()));
                Double qtdGrade = 0.0;
                qtdGrade = quatidadeNecessaria <= quantidadeSaldo ? quatidadeNecessaria : quantidadeSaldo;
                cacheSaldo.usarSaldo(sal, qtdGrade);
                grades.usarQuantidade(i, qtdGrade);
                grade.setLoteFabricacao((LoteFabricacao)this.serviceLoteFabricacao.get(sal.getIdLoteFabricacao()));
                grade.setQuantidade(qtdGrade);
                grade.setCentroEstoque((CentroEstoque)this.serviceCentroEstoque.get(sal.getIdCentroEstoque()));
                ArrayList<GradeItemRequisicao> listGrades = new ArrayList<GradeItemRequisicao>();
                listGrades.add(grade);
                ItemRequisicao ir = new ItemRequisicao();
                grade.setItemRequisicao(ir);
                ir.setGradeItemRequisicao(listGrades);
                ir.setNaturezaRequisicao(i.getNaturezaRequisicao());
                ir.setCentroCusto(centroCusto);
                ir.setCentroEstoque(grade.getCentroEstoque());
                ir.setProduto(grade.getGradeCor().getProdutoGrade().getProduto());
                if (!ToolMethods.isEquals((Object)grade.getGradeCor(), (Object)i.getGradeCor())) {
                    ir.setProdutoOriginal(i.getGradeCor().getProdutoGrade().getProduto());
                }
                listItensRequisicao.add(ir);
            }
        }
        for (ItemGradeFormulaProduto i : gradesItens) {
            Double quantidadeFaltante = 0.0;
            quantidadeFaltante = ToolMethods.isEquals((Object)opPcp.getNaoSugerirLoteEvtLinhaProd(), (Object)1) ? Double.valueOf(i.getQuantidade() * qtdeTotalItemComunicado) : grades.getQuantidade(i);
            if (!(quantidadeFaltante > 0.0)) continue;
            ItemRequisicao iVazio = this.buildItemRequisicaoSimbolico(i, quantidadeFaltante, centroCusto, os.getEmpresa());
            listItensRequisicao.add(iVazio);
        }
        return listItensRequisicao;
    }

    private List<SaldoEstoqueGeralBasico> pesquisarSaldo(ItemGradeFormulaProduto i, FaseProdutiva fase, OrdemServicoProdLinhaProd os, Date data, SubdivisaoOSProdLinhaProd sub, CacheSaldoProduto cacheSaldo) {
        Boolean celulaGradeJaPEsquisada = cacheSaldo.celulaGradeJaPesquisada(fase.getCelulaProdutiva(), i.getGradeCor());
        if (!celulaGradeJaPEsquisada.booleanValue()) {
            List<SaldoEstoqueGeralBasico> saldosNovos = this.getSaldosEstoque(fase.getCelulaProdutiva(), i.getGradeCor(), os.getEmpresa(), i.getGradeCor().getProdutoGrade().getProduto(), data, EnumConstCentroEstTipoPropTerc.get((Object)i.getTipoEstoque()), os.getPessoaParceiro(), sub.getOrdemServicoProdLinhaProd());
            if (ToolMethods.isWithData(saldosNovos)) {
                cacheSaldo.addSaldos(i.getGradeCor(), saldosNovos, fase.getCelulaProdutiva());
                cacheSaldo.addCelularGradePesquisada(fase.getCelulaProdutiva(), i.getGradeCor());
            } else {
                for (ItemGradeFormulaProdutoSubstituto t : i.getItensSubstitutos()) {
                    saldosNovos = this.getSaldosEstoque(fase.getCelulaProdutiva(), t.getGradeCor(), os.getEmpresa(), t.getGradeCor().getProdutoGrade().getProduto(), data, EnumConstCentroEstTipoPropTerc.get((Object)i.getTipoEstoque()), os.getPessoaParceiro(), sub.getOrdemServicoProdLinhaProd());
                    if (!ToolMethods.isWithData(saldosNovos)) continue;
                    cacheSaldo.addSaldos(t.getGradeCor(), saldosNovos, fase.getCelulaProdutiva());
                    cacheSaldo.addCelularGradePesquisada(fase.getCelulaProdutiva(), t.getGradeCor());
                    return cacheSaldo.getSaldoCache(t.getGradeCor(), fase.getCelulaProdutiva());
                }
            }
        }
        return cacheSaldo.getSaldoCache(i.getGradeCor(), fase.getCelulaProdutiva());
    }

    private ItemRequisicao buildItemRequisicaoSimbolico(ItemGradeFormulaProduto itemFormula, Double qtde, CentroCusto centroCusto, Empresa empresa) {
        GradeItemRequisicao grade = new GradeItemRequisicao();
        grade.setGradeCor(itemFormula.getGradeCor());
        grade.setQuantidade(qtde);
        grade.setEmpresa(empresa);
        ItemRequisicao i = new ItemRequisicao();
        grade.setItemRequisicao(i);
        i.setGradeItemRequisicao(Arrays.asList(grade));
        i.setNaturezaRequisicao(itemFormula.getNaturezaRequisicao());
        i.setQuantidadeTotal(qtde);
        i.setProduto(itemFormula.getGradeCor().getProdutoGrade().getProduto());
        i.setCentroCusto(centroCusto);
        if (ToolMethods.isEquals((Object)i.getProduto().getLoteUnico(), (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            grade.setLoteFabricacao(this.serviceLoteFabricacao.findLoteUnico(itemFormula.getGradeCor()));
        }
        return i;
    }

    private List<SaldoEstoqueGeralBasico> getSaldosEstoque(CelulaProdutiva celulaProdutiva, GradeCor gc, Empresa empresa, Produto pr, Date data, EnumConstCentroEstTipoPropTerc tipoEstoque, Pessoa parceiro, OrdemServicoProdLinhaProd os) {
        Long idParceiro = null;
        if (ToolMethods.isNull((Object)tipoEstoque).booleanValue()) {
            tipoEstoque = EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO;
        }
        if (ToolMethods.isEquals((Object)tipoEstoque, (Object)EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_TERCEIROS) && ToolMethods.isNull((Object)parceiro).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.289.004", new Object[]{os}));
        }
        if (ToolMethods.isEquals((Object)tipoEstoque, (Object)EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_TERCEIROS)) {
            idParceiro = parceiro.getIdentificador();
        }
        List<SaldoEstoqueGeralBasico> saldos = this.serviceSaldoEstoque.findSaldoGradeCentroEstoqueLoteListaBasico(pr, pr, gc, gc, data, empresa, empresa, null, null, null, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS, tipoEstoque, idParceiro, EnumConstSaldoEstTipoSaldo.TIPO_SALDO_LOTE_FABRICACAO, EnumConstSaldoEstTipoSaldoQtde.TIPO_SALDO_QTQ_MAIOR_0, EnumConstSaldoEstTipoCarregQtdeVlr.TIPO_SALDO_QTQ_VLR_SOMENTE_QTD);
        return this.filtrarSaldos(saldos, celulaProdutiva, gc, empresa);
    }

    private List<SaldoEstoqueGeralBasico> filtrarSaldos(List<SaldoEstoqueGeralBasico> cacheSaldo, CelulaProdutiva c, GradeCor gc, Empresa empresa) {
        LinkedList<Long> centrosLiberados = new LinkedList<Long>();
        for (CelulaProdCentroEstoque centroEstoque : c.getCentroEstoque()) {
            if (!ToolMethods.isEquals((Object)centroEstoque.getUtilizarReq(), (Object)1) || !ToolMethods.isEquals((Object)centroEstoque.getCentroEstoque().getEmpresa(), (Object)empresa)) continue;
            centrosLiberados.add(centroEstoque.getCentroEstoque().getIdentificador());
        }
        LinkedList<SaldoEstoqueGeralBasico> ret = new LinkedList<SaldoEstoqueGeralBasico>();
        for (SaldoEstoqueGeralBasico cacheSaldo1 : cacheSaldo) {
            if (!centrosLiberados.contains(cacheSaldo1.getIdCentroEstoque()) || !ToolMethods.isEquals((Object)cacheSaldo1.getIdGradeCor(), (Object)gc.getIdentificador())) continue;
            ret.add(cacheSaldo1);
        }
        return ret;
    }
}

