/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.rps;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.pessoa.EnumConstTipoPessoa;
import com.touchcomp.basementor.constants.enums.rps.EnumConstRpsExigibilidadeIss;
import com.touchcomp.basementor.constants.enums.situacaodocumento.EnumConstSituacaoDocumento;
import com.touchcomp.basementor.constants.enums.statusobjeto.EnumConstStatusObjeto;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CategoriaPessoa;
import com.touchcomp.basementor.model.vo.Cidade;
import com.touchcomp.basementor.model.vo.ClassificacaoClientes;
import com.touchcomp.basementor.model.vo.Complemento;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.ItemServicoRPS;
import com.touchcomp.basementor.model.vo.ItemServicoRPSRPS;
import com.touchcomp.basementor.model.vo.ModeloRPS;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesFaturamentoNFSe;
import com.touchcomp.basementor.model.vo.OpcoesLocacao;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Rps;
import com.touchcomp.basementor.model.vo.ServicoRPS;
import com.touchcomp.basementor.model.vo.TomadorPrestadorRps;
import com.touchcomp.basementor.model.vo.UnidadeFatTomPrestRPS;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.impl.parametrizacao.ExceptionParametrizacao;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.BaseMethods;
import com.touchcomp.basementorservice.components.calculovalores.rps.CompCalcularValoresFiscaisRps;
import com.touchcomp.basementorservice.components.contabil.CompParametrizacaoContabilRps;
import com.touchcomp.basementorservice.components.planoconta.CompPlanoConta;
import com.touchcomp.basementorservice.components.titulos.impl.CompTitulosRps;
import com.touchcomp.basementorservice.service.impl.cidade.ServiceCidadeImpl;
import com.touchcomp.basementorservice.service.impl.condicoespagamento.ServiceCondicoesPagamentoImpl;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.itemservicorps.ServiceItemServicoRPSImpl;
import com.touchcomp.basementorservice.service.impl.modelorps.ServiceModeloRPSImpl;
import com.touchcomp.basementorservice.service.impl.naturezaoperacaorps.ServiceNaturezaOperacaoRpsImpl;
import com.touchcomp.basementorservice.service.impl.opcoescontabeis.ServiceOpcoesContabeisImpl;
import com.touchcomp.basementorservice.service.impl.opcoesfaturamentonfse.ServiceOpcoesFaturamentoNFSeImpl;
import com.touchcomp.basementorservice.service.impl.opcoesfinanceiras.ServiceOpcoesFinanceirasImpl;
import com.touchcomp.basementorservice.service.impl.opcoeslocacao.ServiceOpcoesLocacaoImpl;
import com.touchcomp.basementorservice.service.impl.paramtribcbsibs.ServiceParamTribCbsIbsImpl;
import com.touchcomp.basementorservice.service.impl.regimeespecialtributacaorps.ServiceRegimeEspecialTributacaoRPSImpl;
import com.touchcomp.basementorservice.service.impl.rps.ServiceRpsImpl;
import com.touchcomp.basementorservice.service.impl.servicorps.ServiceServicoRPSImpl;
import com.touchcomp.basementorservice.service.impl.situacaodocumento.ServiceSituacaoDocumentoImpl;
import com.touchcomp.basementorservice.service.impl.tomadorprestadorrps.ServiceTomadorPrestadorRpsImpl;
import com.touchcomp.basementorservice.service.impl.unidadefattomprestrps.ServiceUnidadeFatTomPrestRPSImpl;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.number.ToolNumber;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementorvalidator.entities.impl.rps.ValidRps;
import com.touchcomp.basementorvalidator.entities.impl.tomadorprestadorrps.ValidTomadorPrestadorRps;
import com.touchcomp.touchvomodel.vo.rps.web.importacao.DTOImportacaoRps;
import com.touchcomp.touchvomodel.vo.rps.web.importacao.DTOResultadoImportacaoRps;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class CompImportacaoRps
extends BaseMethods {
    ServiceEmpresaImpl serviceEmpresa;
    ServiceNaturezaOperacaoRpsImpl serviceNaturezaOperacaoRps;
    ServiceOpcoesFaturamentoNFSeImpl serviceOpFatNfse;
    ServiceSituacaoDocumentoImpl serviceSituacaoDocumento;
    ServiceCondicoesPagamentoImpl serviceCondicoesPagamento;
    ServiceRegimeEspecialTributacaoRPSImpl serviceRegEspecialTribRps;
    ServiceServicoRPSImpl serviceServicoRps;
    ServiceItemServicoRPSImpl serviceItemServicoRps;
    ServiceUnidadeFatTomPrestRPSImpl serviceUnidadeFatTomPrestRPS;
    ServiceCidadeImpl serviceCidade;
    ServiceTomadorPrestadorRpsImpl serviceTomadorPrestRPS;
    ValidRps validRps;
    ValidTomadorPrestadorRps validTomadorRps;
    ServiceRpsImpl serviceRps;
    ServiceOpcoesFinanceirasImpl serviceOpcoesFinanceiras;
    ServiceOpcoesContabeisImpl serviceOpcoesContabeis;
    ServiceOpcoesLocacaoImpl serviceOpcoesLocacao;
    CompCalcularValoresFiscaisRps compCalculoRps;
    CompTitulosRps compTitulosRps;
    CompPlanoConta compPlanoConta;
    ServiceModeloRPSImpl serviceModeloRPS;

    public CompImportacaoRps(ServiceEmpresaImpl serviceEmpresa, ServiceNaturezaOperacaoRpsImpl serviceNaturezaOperacaoRps, ServiceOpcoesFaturamentoNFSeImpl serviceOpFatNfse, ServiceSituacaoDocumentoImpl serviceSituacaoDocumento, ServiceCondicoesPagamentoImpl serviceCondicoesPagamento, ServiceRegimeEspecialTributacaoRPSImpl serviceRegEspecialTribRps, ServiceServicoRPSImpl serviceServicoRps, ServiceItemServicoRPSImpl serviceItemServicoRps, ServiceUnidadeFatTomPrestRPSImpl serviceUnidadeFatTomPrestRPS, ServiceCidadeImpl serviceCidade, ServiceTomadorPrestadorRpsImpl serviceTomadorPrestRPS, ValidRps validRps, ValidTomadorPrestadorRps validTomadorRps, ServiceRpsImpl serviceRps, ServiceOpcoesFinanceirasImpl serviceOpcoesFinanceiras, ServiceOpcoesContabeisImpl serviceOpcoesContabeis, ServiceOpcoesLocacaoImpl serviceOpcoesLocacao, CompCalcularValoresFiscaisRps compCalculoRps, CompTitulosRps compTitulosRps, CompPlanoConta compPlanoConta, ServiceModeloRPSImpl serviceModeloRPS) {
        this.serviceEmpresa = serviceEmpresa;
        this.serviceNaturezaOperacaoRps = serviceNaturezaOperacaoRps;
        this.serviceOpFatNfse = serviceOpFatNfse;
        this.serviceSituacaoDocumento = serviceSituacaoDocumento;
        this.serviceCondicoesPagamento = serviceCondicoesPagamento;
        this.serviceRegEspecialTribRps = serviceRegEspecialTribRps;
        this.serviceServicoRps = serviceServicoRps;
        this.serviceItemServicoRps = serviceItemServicoRps;
        this.serviceUnidadeFatTomPrestRPS = serviceUnidadeFatTomPrestRPS;
        this.serviceCidade = serviceCidade;
        this.serviceTomadorPrestRPS = serviceTomadorPrestRPS;
        this.validRps = validRps;
        this.validTomadorRps = validTomadorRps;
        this.serviceRps = serviceRps;
        this.serviceOpcoesFinanceiras = serviceOpcoesFinanceiras;
        this.serviceOpcoesContabeis = serviceOpcoesContabeis;
        this.serviceOpcoesLocacao = serviceOpcoesLocacao;
        this.compCalculoRps = compCalculoRps;
        this.compTitulosRps = compTitulosRps;
        this.compPlanoConta = compPlanoConta;
        this.serviceModeloRPS = serviceModeloRPS;
    }

    public List<DTOResultadoImportacaoRps> importar(List<DTOImportacaoRps> input) throws ExceptionBase {
        LinkedList<DTOResultadoImportacaoRps> result = new LinkedList<DTOResultadoImportacaoRps>();
        for (DTOImportacaoRps dto : input) {
            DTOResultadoImportacaoRps ret = new DTOResultadoImportacaoRps();
            this.validarDadosImportacao(dto, ret);
            try {
                ret.setDados(dto);
                this.importar(dto, ret);
            }
            catch (Exception ex) {
                this.logError(ex);
                ret.addErrorMessage(MessagesBaseMentor.getErrorMsg((String)"E.INT.0657.001", (Object[])new Object[]{ex.getMessage()}));
            }
            result.add(ret);
        }
        return result;
    }

    private void importar(DTOImportacaoRps dto, DTOResultadoImportacaoRps ret) throws ExceptionBase {
        Rps rps = new Rps();
        rps.setDataCadastro(new Date());
        rps.setSerie("");
        rps.setEmpresa(this.serviceEmpresa.findByCnpj(dto.getCnpjEmpresa()));
        rps.setNaturezaOperacaoRps(this.serviceNaturezaOperacaoRps.findByCodigo(dto.getNaturezaOperacao()));
        if (this.isNotNull(rps.getEmpresa()).booleanValue()) {
            OpcoesContabeis opcoesContabeis = this.serviceOpcoesContabeis.findByEmpresa(rps.getEmpresa());
            OpcoesLocacao opcoesLocacao = this.serviceOpcoesLocacao.getByIdEmpresa(rps.getEmpresa().getIdentificador());
            OpcoesFaturamentoNFSe opcoesNfse = this.serviceOpFatNfse.getByIdEmpresa(rps.getEmpresa().getIdentificador());
            rps.setCidade(rps.getEmpresa().getPessoa().getEndereco().getCidade());
            if (this.isNotNull(opcoesNfse).booleanValue()) {
                this.setTomadorServico(dto, ret, rps, opcoesNfse.getCategoriaPadraoTomador(), opcoesNfse.getClassificacaoPadraoTomador(), opcoesContabeis);
                if (this.isNull(rps.getUnidadeTomPrestRPS()).booleanValue()) {
                    return;
                }
            }
            rps.setCompetencia(ToolDate.strToDate((String)dto.getCompetencia(), (String)"yyyy-MM-dd'T'HH:mm:ss"));
            rps.setDataExecucaoServico(rps.getCompetencia());
            rps.setStatus(Short.valueOf(EnumConstStatusObjeto.ATIVO.getValue()));
            rps.setSituacaoDocumento(this.serviceSituacaoDocumento.get(EnumConstSituacaoDocumento.REGULAR));
            rps.setExigibilidadeISS(this.isExigivelIss(dto, ret));
            rps.setMovimentaEstoque(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
            rps.setGerarFinanceiro(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
            this.setCondicoesPagamento(dto, ret, rps);
            this.setRegimeEspecialTributacao(dto, rps);
            this.setServicoRps(dto, ret, rps);
            this.setPlanoContas(ret, opcoesContabeis, rps);
            this.checkDataHoraEmissao(dto, ret, rps);
            rps.setParamTribCbsIbsClass(((ServiceParamTribCbsIbsImpl)Context.get(ServiceParamTribCbsIbsImpl.class)).getParametrizacaoRpsNFSe(rps.getDataEmissao(), rps.getEmpresa(), rps.getUnidadeTomPrestRPS(), rps.getNbs()));
            this.compCalculoRps.calcular(rps);
            this.compTitulosRps.criarTitulos(rps, this.serviceOpcoesFinanceiras.findByEmpresa(rps.getEmpresa()), opcoesNfse, opcoesLocacao);
            this.validAndSave(ret, rps);
        } else {
            ret.addErrorMessage(MessagesBaseMentor.getErrorMsg((String)"E.INT.0657.002", (Object[])new Object[]{dto.getCnpjEmpresa()}));
        }
    }

    private void validAndSave(DTOResultadoImportacaoRps ret, Rps rps) {
        this.validRps.clearContainer();
        this.validRps.isValidData((InterfaceVO)rps);
        if (this.validRps.hasErrors()) {
            ret.addErrorMessage(MessagesBaseMentor.getErrorMsg((String)"E.INT.0657.003", (Object[])new Object[]{this.validRps.getContainer().asString()}));
        } else {
            rps = this.serviceRps.saveOrUpdateFlush(rps);
            ret.addSucessMessage("RPS salvo com sucesso. Identificador: " + rps.getIdentificador());
        }
    }

    private void setCondicoesPagamento(DTOImportacaoRps dto, DTOResultadoImportacaoRps ret, Rps rps) {
        rps.setCondicoesPagamento(this.serviceCondicoesPagamento.getCondicoesPagamentoByCodSincronizacao(dto.getCondicaoDePagamento()));
        if (this.isNotNull(rps.getCondicoesPagamento()).booleanValue()) {
            rps.setParcelas(dto.getParcelas());
            rps.setMeioPagamento(rps.getCondicoesPagamento().getMeioPagamento());
        } else {
            ret.addErrorMessage(MessagesBaseMentor.getErrorMsg((String)"E.INT.0657.004", (Object[])new Object[0]));
        }
    }

    private void validarDadosImportacao(DTOImportacaoRps dto, DTOResultadoImportacaoRps ret) {
        ret.setAlias(dto.getAlias());
        if (this.isNull(dto.getTomador()).booleanValue()) {
            ret.addErrorMessage(MessagesBaseMentor.getErrorMsg((String)"E.INT.0657.005", (Object[])new Object[0]));
        }
        if (!CompImportacaoRps.isWithData(dto.getServicos())) {
            ret.addErrorMessage(MessagesBaseMentor.getErrorMsg((String)"E.INT.0657.006", (Object[])new Object[0]));
        }
    }

    private Short isExigivelIss(DTOImportacaoRps dto, DTOResultadoImportacaoRps ret) {
        if (!(this.isEquals(dto.getExibilidadeIss(), EnumConstRpsExigibilidadeIss.NAO_INCIDENCIA.getValue()) || this.isEquals(dto.getExibilidadeIss(), EnumConstRpsExigibilidadeIss.ISENCAO.getValue()) || this.isEquals(dto.getExibilidadeIss(), EnumConstRpsExigibilidadeIss.IMUNIDADE.getValue()) || this.isEquals(dto.getExibilidadeIss(), EnumConstRpsExigibilidadeIss.EXPORTACAO.getValue()) || this.isEquals(dto.getExibilidadeIss(), EnumConstRpsExigibilidadeIss.EXIGIVEL.getValue()) || this.isEquals(dto.getExibilidadeIss(), EnumConstRpsExigibilidadeIss.EXIGIBILIDADE_SUSPENSA_PROCESSO_ADMINISTRATIVO.getValue()) || this.isEquals(dto.getExibilidadeIss(), EnumConstRpsExigibilidadeIss.EXIGIBILIDADE_SUSPENSA_DECISAO_JUDICIAL.getValue()))) {
            ret.addWarningMessage(MessagesBaseMentor.getErrorMsg((String)"E.INT.0657.007", (Object[])new Object[]{dto.getAlias()}));
            return EnumConstantsMentorSimNao.NAO.getValue();
        }
        return EnumConstRpsExigibilidadeIss.get((Object)dto.getExibilidadeIss()).getValue();
    }

    private void setRegimeEspecialTributacao(DTOImportacaoRps dto, Rps rps) {
        if (this.isStrWithData(dto.getRegimeEspecialTributacao())) {
            rps.setRegimeEspTributacao(this.serviceRegEspecialTribRps.findByCodigo(dto.getRegimeEspecialTributacao()));
            if (TMethods.isNull((Object)rps.getRegimeEspTributacao()).booleanValue()) {
                rps.setRegimeEspecialRecol(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
            } else {
                rps.setRegimeEspecialRecol(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
            }
        }
    }

    private void checkDataHoraEmissao(DTOImportacaoRps dto, DTOResultadoImportacaoRps ret, Rps rps) {
        if (this.isStrWithData(dto.getEmissao())) {
            String[] dataHoraStr = dto.getEmissao().split("T");
            rps.setDataEmissao(ToolDate.strToDate((String)dataHoraStr[0], (String)"yyyy-MM-dd"));
            rps.setHoraEmissao(ToolDate.strToDate((String)dataHoraStr[1], (String)"HH:mm:ss"));
        } else {
            ret.addErrorMessage(MessagesBaseMentor.getErrorMsg((String)"E.INT.0657.008", (Object[])new Object[0]));
        }
    }

    private void setServicoRps(DTOImportacaoRps dto, DTOResultadoImportacaoRps ret, Rps rps) {
        rps.setCodigoTributacaoServ(dto.getCodigoTributacaoServico());
        ServicoRPS servicoRps = this.serviceServicoRps.findServicoRpsByCodigoServico(dto.getCodigoServico(), dto.getCodigoTributacaoServico());
        if (this.isNotNull(servicoRps).booleanValue()) {
            rps.setServicoRPS(servicoRps);
            rps.setNbs(rps.getServicoRPS().getNbs());
            rps.setDiscriminacao(servicoRps.getDiscriminacao());
            rps.setTaxaTributacaoFederal(servicoRps.getGrupoServicoRPS().getTaxaFederal());
            rps.setTaxaTributacaoMunicipal(servicoRps.getGrupoServicoRPS().getTaxaMunicipal());
            List<ModeloRPS> listModeloRps = this.serviceModeloRPS.pesquisarModeloRpsCategoriaPessoaServicoRps(rps.getUnidadeTomPrestRPS().getTomadorPrestadorRPS().getCategoriaPessoa(), servicoRps, rps.getEmpresa());
            ModeloRPS modeloRps = null;
            if (CompImportacaoRps.isWithData(listModeloRps)) {
                modeloRps = listModeloRps.get(0);
            }
            if (TMethods.isNotNull(modeloRps).booleanValue()) {
                rps.setModeloRps(modeloRps);
                if (TMethods.isNotNull((Object)rps.getModeloRps()).booleanValue()) {
                    rps.setCnae(rps.getModeloRps().getCnae());
                }
                rps.setTipoServico(rps.getModeloRps().getReinfTipoServico());
                rps.setEntradaSaida(rps.getModeloRps().getEntradaSaida());
                rps.setIncidenciaPisCofins(rps.getModeloRps().getIncidenciaPisCofins());
                rps.setTipoPis(rps.getModeloRps().getTipoPis());
                rps.setAliquotaPis(ToolNumber.asZeroIfNull((Double)rps.getModeloRps().getAliquotaPis()));
                rps.setTipoCofins(rps.getModeloRps().getTipoCofins());
                rps.setAliquotaCofins(ToolNumber.asZeroIfNull((Double)rps.getModeloRps().getAliquotaCofins()));
                rps.setAliquotaInss(ToolNumber.asZeroIfNull((Double)rps.getModeloRps().getAliquotaINSS()));
                rps.setTipoIss(rps.getModeloRps().getTipoIss());
                rps.setAliquotaIss(ToolNumber.asZeroIfNull((Double)rps.getModeloRps().getAliquotaISS()));
                rps.setAliquotaIr(ToolNumber.asZeroIfNull((Double)rps.getModeloRps().getAliquotaIRRF()));
                rps.setAliquotaContSoc(ToolNumber.asZeroIfNull((Double)rps.getModeloRps().getAliquotaCSLL()));
                rps.setAliquotaOutros(ToolNumber.asZeroIfNull((Double)rps.getModeloRps().getAliquotaOutros()));
            }
            if (CompImportacaoRps.isWithData(dto.getServicos())) {
                for (DTOImportacaoRps.DTOImpServicosRps dtoServ : dto.getServicos()) {
                    ItemServicoRPS baseItem = this.serviceItemServicoRps.findByCodigoSincronizacao(dtoServ.getItemServico());
                    if (this.isNotNull(baseItem).booleanValue()) {
                        ItemServicoRPSRPS itemServico = new ItemServicoRPSRPS();
                        itemServico.setIncidirCSLL(baseItem.getIncidirCSLL());
                        itemServico.setIncidirCofins(baseItem.getIncidirCofins());
                        itemServico.setIncidirIR(baseItem.getIncidirIR());
                        itemServico.setIncidirISS(baseItem.getIncidirISS());
                        itemServico.setIncidirInss(baseItem.getIncidirInss());
                        itemServico.setIncidirOutros(baseItem.getIncidirOutros());
                        itemServico.setIncidirPis(baseItem.getIncidirPis());
                        itemServico.setRps(rps);
                        itemServico.setValor(ToolNumber.asZeroIfNull((Double)dtoServ.getValorBrutoServico()));
                        itemServico.setItemServicoRPS(baseItem);
                        rps.getItensRps().add(itemServico);
                        continue;
                    }
                    ret.addErrorMessage(MessagesBaseMentor.getErrorMsg((String)"E.INT.0657.009", (Object[])new Object[]{dtoServ.getItemServico()}));
                }
            }
        } else {
            ret.addErrorMessage(MessagesBaseMentor.getErrorMsg((String)"E.INT.0657.010", (Object[])new Object[]{dto.getCodigoServico(), dto.getCodigoTributacaoServico()}));
        }
    }

    private void setTomadorServico(DTOImportacaoRps dto, DTOResultadoImportacaoRps ret, Rps rps, CategoriaPessoa categoriaPessoa, ClassificacaoClientes classClientes, OpcoesContabeis opcoesContabeis) throws ExceptionBase {
        if (TMethods.isNotNull((Object)dto.getTomador()).booleanValue()) {
            DTOImportacaoRps.DTOImpTomadorRps tomador = dto.getTomador();
            UnidadeFatTomPrestRPS unidadeFatTomador = this.serviceUnidadeFatTomPrestRPS.findByCpfCnpj(tomador.getCnpj());
            if (TMethods.isNotNull((Object)unidadeFatTomador).booleanValue()) {
                rps.setUnidadeTomPrestRPS(unidadeFatTomador);
            } else {
                rps.setUnidadeTomPrestRPS(this.criarTomadorServico(tomador, ret, rps.getEmpresa(), categoriaPessoa, classClientes, opcoesContabeis));
            }
            if (TMethods.isNotNull((Object)tomador.getEmail()).booleanValue()) {
                rps.setEmail(ToolString.cut((String)tomador.getEmail(), (int)250));
            }
        }
    }

    private UnidadeFatTomPrestRPS criarTomadorServico(DTOImportacaoRps.DTOImpTomadorRps tomadorRps, DTOResultadoImportacaoRps ret, Empresa empresa, CategoriaPessoa categoriaPessoa, ClassificacaoClientes classClientes, OpcoesContabeis opcoesContabeis) throws ExceptionBase {
        Pessoa pessoa = this.buildPessoa(tomadorRps);
        UnidadeFatTomPrestRPS unidadeFatTomador = new UnidadeFatTomPrestRPS();
        unidadeFatTomador.setDescricao(ToolString.cut((String)pessoa.getNome(), (int)80));
        unidadeFatTomador.setInscricaoEstadual(tomadorRps.getInscricaoEstadual());
        unidadeFatTomador.setEndereco(pessoa.getEndereco());
        if (this.isNull(classClientes).booleanValue() || this.isNull(categoriaPessoa).booleanValue()) {
            ret.addErrorMessage(MessagesBaseMentor.getErrorMsg((String)"E.INT.0657.012", (Object[])new Object[0]));
        }
        TomadorPrestadorRps tomador = new TomadorPrestadorRps();
        tomador.setAtivo(Short.valueOf(EnumConstStatusObjeto.ATIVO.getValue()));
        tomador.setDataCadastro(new Date());
        tomador.setEmpresa(empresa);
        tomador.setCategoriaPessoa(categoriaPessoa);
        tomador.setClassificacaoPessoa(classClientes);
        tomador.setPessoa(pessoa);
        tomador.setPlanoContaCliente(this.compPlanoConta.buildPlanoContaCliente(tomador.getPessoa(), opcoesContabeis));
        tomador.setPlanoContaFornecedor(this.compPlanoConta.buildPlanoContaFornecedor(tomador.getPessoa(), opcoesContabeis));
        tomador.setPlanoContaTomadorAntec(this.compPlanoConta.buildPlanoContaTomador(tomador.getPessoa(), opcoesContabeis));
        unidadeFatTomador.setTomadorPrestadorRPS(tomador);
        tomador.getUnidadesFat().add(unidadeFatTomador);
        tomador = this.validAndSaveTomador(tomador, ret);
        if (tomador != null) {
            return (UnidadeFatTomPrestRPS)tomador.getUnidadesFat().getFirst();
        }
        return null;
    }

    private Pessoa buildPessoa(DTOImportacaoRps.DTOImpTomadorRps tomadorRps) {
        Pessoa pessoa = new Pessoa();
        pessoa.setAtivo(Short.valueOf(EnumConstStatusObjeto.ATIVO.getValue()));
        pessoa.setTipoPessoa(EnumConstTipoPessoa.PESSOA_PRIMARIA.getEnumId());
        pessoa.setNome(ToolString.cut((String)tomadorRps.getNome(), (int)150));
        pessoa.setNomeFantasia(ToolString.cut((String)tomadorRps.getNomeFantasia(), (int)60));
        pessoa.setEndereco(this.buildEndereco(tomadorRps));
        pessoa.setComplemento(this.buildComplemento(tomadorRps));
        return pessoa;
    }

    private Endereco buildEndereco(DTOImportacaoRps.DTOImpTomadorRps tomadorRps) {
        Endereco endereco = new Endereco();
        endereco.setBairro(ToolString.cut((String)tomadorRps.getBairro(), (int)60));
        endereco.setCep(ToolString.cut((String)tomadorRps.getCep(), (int)9));
        endereco.setComplemento(ToolString.cut((String)tomadorRps.getComplemento(), (int)60));
        endereco.setLogradouro(ToolString.cut((String)tomadorRps.getLogradouro(), (int)60));
        endereco.setNumero(ToolString.cut((String)tomadorRps.getNumero(), (int)10));
        Cidade cidade = this.serviceCidade.getByCodigoIBGECompleto(tomadorRps.getCodigoMunicipio());
        if (TMethods.isNotNull((Object)cidade).booleanValue()) {
            endereco.setCidade(cidade);
        }
        return endereco;
    }

    private Complemento buildComplemento(DTOImportacaoRps.DTOImpTomadorRps tomadorRps) {
        Complemento complemento = new Complemento();
        complemento.setFone1(ToolString.cut((String)tomadorRps.getTelefone(), (int)14));
        complemento.setEmailPrincipal(ToolString.cut((String)tomadorRps.getEmail(), (int)300));
        complemento.setCnpj(ToolString.cut((String)tomadorRps.getCnpj(), (int)18));
        complemento.setInscricaoMunicipal(ToolString.cut((String)tomadorRps.getInscricaoMunicial(), (int)18));
        complemento.setInscEst(ToolString.cut((String)tomadorRps.getInscricaoEstadual(), (int)18));
        if (ToolString.isAShortNumber((String)tomadorRps.getContribuinteDoEstado())) {
            complemento.setContribuinteEstado(Short.valueOf(tomadorRps.getContribuinteDoEstado()));
        }
        complemento.setAtivo(Short.valueOf(EnumConstStatusObjeto.ATIVO.getValue()));
        return complemento;
    }

    private TomadorPrestadorRps validAndSaveTomador(TomadorPrestadorRps vo, DTOResultadoImportacaoRps ret) {
        this.validTomadorRps.clearContainer();
        this.validTomadorRps.isValidData((InterfaceVO)vo);
        if (this.validTomadorRps.hasErrors()) {
            ret.addErrorMessage(MessagesBaseMentor.getErrorMsg((String)"E.INT.0657.011", (Object[])new Object[]{this.validTomadorRps.getContainer().asString()}));
            return null;
        }
        vo = this.serviceTomadorPrestRPS.saveOrUpdateFlush(vo);
        vo = (TomadorPrestadorRps)this.serviceTomadorPrestRPS.get(vo.getIdentificador());
        return vo;
    }

    private void setPlanoContas(DTOResultadoImportacaoRps ret, OpcoesContabeis opcoesContabeis, Rps rps) {
        try {
            CompParametrizacaoContabilRps.DadosContas dados = new CompParametrizacaoContabilRps().getPlanoContasNfPropria(rps.getModeloRps(), rps.getUnidadeTomPrestRPS(), rps.getEmpresa(), rps.getUnidadeTomPrestRPS().getTomadorPrestadorRPS().getCategoriaPessoa(), opcoesContabeis, rps.getUnidadeTomPrestRPS().getTomadorPrestadorRPS().getClassificacaoPessoa());
            if (this.isNotNull(dados).booleanValue()) {
                rps.setPlanoContaCred(dados.getPlanoContaCred());
                rps.setPlanoContaDeb(dados.getPlanoContaDeb());
            }
        }
        catch (ExceptionParametrizacao ex) {
            ret.addErrorMessage(ex.getFormattedMessage());
        }
    }
}

