/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.saneamentocolaborador;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.EnumEsocialTipoEvento;
import com.touchcomp.basementor.constants.enums.colaborador.EnumConstTipoColaborador;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstESocialStatus;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstEventoProducao;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstTipoEventoESocial;
import com.touchcomp.basementor.helper.impl.colaborador.HelperColaborador;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.ColaboradorDependente;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.ItemSaneamentoDadosColaborador;
import com.touchcomp.basementor.model.vo.Recisao;
import com.touchcomp.basementor.model.vo.Rubricas2299;
import com.touchcomp.basementor.model.vo.TerminoTrabalhadorSemVinculo;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.BaseMethods;
import com.touchcomp.basementorservice.helpers.impl.esocpreevento.HelperEsocPreEvento;
import com.touchcomp.basementorservice.service.impl.esocpreevento.ServiceEsocPreEventoImpl;
import com.touchcomp.basementorservice.service.impl.itemsaneamentodadoscolaborador.ServiceItemSaneamentoDadosColaboradorImpl;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.date.ToolDate;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompSaneamentoColaborador
extends BaseMethods {
    @Autowired
    private ServiceItemSaneamentoDadosColaboradorImpl serviceItemSaneamentoColab;
    @Autowired
    private HelperEsocPreEvento helperEsocPreEvento;
    @Autowired
    private ServiceEsocPreEventoImpl serviceEsocPreEvento;

    public void geracaoEventoS2200(Colaborador vo, Usuario usuario, Empresa empresa) throws ExceptionEsocial {
        EsocPreEvento preEvento = this.helperEsocPreEvento.getEvento(vo, usuario, empresa, EnumConstTipoEventoESocial.CADASTRAMENTO_INICIAL_VINC_ADMISSAO_INGRESSO_TRAB, EnumConstEventoProducao.EVENTO_PRODUCAO_TESTE, EnumConstantsMentorSimNao.NAO.getValue());
        preEvento.setTipoEvento(Short.valueOf(EnumEsocialTipoEvento.TIPO_EVENTO_INCLUSAO.value));
        this.serviceEsocPreEvento.saveOrUpdate(preEvento);
        preEvento = this.helperEsocPreEvento.getEvento(vo, usuario, empresa, EnumConstTipoEventoESocial.CADASTRAMENTO_INICIAL_VINC_ADMISSAO_INGRESSO_TRAB, EnumConstEventoProducao.EVENTO_PRODUCAO, EnumConstantsMentorSimNao.NAO.getValue());
        preEvento.setTipoEvento(Short.valueOf(EnumEsocialTipoEvento.TIPO_EVENTO_INCLUSAO.value));
        this.serviceEsocPreEvento.saveOrUpdate(preEvento);
    }

    public void geracaoEventoS2300(Colaborador vo, Usuario usuario, Empresa empresa) throws ExceptionEsocial {
        EsocPreEvento preEvento = this.helperEsocPreEvento.getEvento(vo, usuario, empresa, EnumConstTipoEventoESocial.TRABALHADOR_SEM_VINC_EMPREGO_INICIO, EnumConstEventoProducao.EVENTO_PRODUCAO_TESTE, EnumConstantsMentorSimNao.NAO.getValue());
        preEvento.setTipoEvento(Short.valueOf(EnumEsocialTipoEvento.TIPO_EVENTO_INCLUSAO.value));
        this.serviceEsocPreEvento.saveOrUpdate(preEvento);
        preEvento = this.helperEsocPreEvento.getEvento(vo, usuario, empresa, EnumConstTipoEventoESocial.TRABALHADOR_SEM_VINC_EMPREGO_INICIO, EnumConstEventoProducao.EVENTO_PRODUCAO, EnumConstantsMentorSimNao.NAO.getValue());
        preEvento.setTipoEvento(Short.valueOf(EnumEsocialTipoEvento.TIPO_EVENTO_INCLUSAO.value));
        this.serviceEsocPreEvento.saveOrUpdate(preEvento);
    }

    public void geracaoEventoS2299(TerminoTrabalhadorSemVinculo vo, Usuario usuario, Empresa empresa) throws ExceptionEsocial {
        EsocPreEvento preEvento = this.helperEsocPreEvento.getEvento(vo, usuario, empresa, EnumConstEventoProducao.EVENTO_PRODUCAO_TESTE, (Short)EnumConstantsMentorSimNao.NAO.getValue());
        preEvento.setTipoEvento(Short.valueOf(EnumEsocialTipoEvento.TIPO_EVENTO_INCLUSAO.value));
        this.serviceEsocPreEvento.saveOrUpdate(preEvento);
        preEvento = this.helperEsocPreEvento.getEvento(vo, usuario, empresa, EnumConstEventoProducao.EVENTO_PRODUCAO, (Short)EnumConstantsMentorSimNao.NAO.getValue());
        preEvento.setTipoEvento(Short.valueOf(EnumEsocialTipoEvento.TIPO_EVENTO_INCLUSAO.value));
        this.serviceEsocPreEvento.saveOrUpdate(preEvento);
    }

    public List<ItemSaneamentoDadosColaborador> buildSaneamentoESocial(List<Colaborador> colaboradores) {
        LinkedList<ItemSaneamentoDadosColaborador> aux = new LinkedList<ItemSaneamentoDadosColaborador>();
        if (CompSaneamentoColaborador.isWithData(colaboradores)) {
            for (Colaborador c : colaboradores) {
                ItemSaneamentoDadosColaborador i = this.serviceItemSaneamentoColab.getItemSaneamentoByColaborador(c);
                if (i != null || (i = this.buildItemSaneamento(c)) == null) continue;
                aux.add(i);
            }
        }
        this.ordenarListaItensByLiberacao(aux);
        return aux;
    }

    public ItemSaneamentoDadosColaborador buildItemSaneamento(Colaborador colaborador) {
        String ocorrencias = null;
        ItemSaneamentoDadosColaborador i = new ItemSaneamentoDadosColaborador();
        i.setColaborador(colaborador);
        if (this.isEquals(colaborador.getTipoColaborador().getIdentificador(), EnumConstTipoColaborador.EMPREGADO.getValue()) || this.isEquals(colaborador.getTipoColaborador().getIdentificador(), EnumConstTipoColaborador.MENOR_APRENDIZ.getValue())) {
            ocorrencias = this.isValidRegistroEventoS2200(colaborador);
        } else if (this.isEquals(colaborador.getTipoColaborador().getIdentificador(), EnumConstTipoColaborador.SOCIO_DIRETOR.getValue()) || this.isEquals(colaborador.getTipoColaborador().getIdentificador(), EnumConstTipoColaborador.ESTAGIARIO.getValue()) || this.isEquals(colaborador.getTipoColaborador().getIdentificador(), EnumConstTipoColaborador.AUTONOMO.getValue()) || this.isEquals(colaborador.getTipoColaborador().getIdentificador(), EnumConstTipoColaborador.AUTONOMO_FRETE.getValue())) {
            ocorrencias = this.isValidRegistroEventoS2300(colaborador);
        } else {
            return null;
        }
        i.setProducao(ocorrencias);
        if (this.isStrWithData(ocorrencias)) {
            i.setLiberado(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
        } else {
            i.setLiberado(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
        }
        return i;
    }

    public List<ItemSaneamentoDadosColaborador> buildSaneamentoESocialRescisao(List<Recisao> rescisoes) throws ExceptionInvalidData {
        LinkedList<ItemSaneamentoDadosColaborador> aux = new LinkedList<ItemSaneamentoDadosColaborador>();
        if (CompSaneamentoColaborador.isWithData(rescisoes)) {
            for (Recisao r : rescisoes) {
                ItemSaneamentoDadosColaborador i = this.buildItemSaneamentoRescisao(r);
                if (!this.isNotNull(i).booleanValue()) continue;
                aux.add(i);
            }
        }
        this.ordenarListaItensByLiberacao(aux);
        return aux;
    }

    public ItemSaneamentoDadosColaborador buildItemSaneamentoRescisao(Recisao r) throws ExceptionInvalidData {
        if (this.recisaoNaoSaneado(r).booleanValue()) {
            String ocorrencias = this.isValidRegistroEventoS2299(r);
            ItemSaneamentoDadosColaborador i = new ItemSaneamentoDadosColaborador();
            i.setRecisao(r);
            i.setProducao(ocorrencias);
            if (this.isStrWithData(ocorrencias)) {
                i.setLiberado(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
            } else {
                i.setLiberado(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
            }
            return i;
        }
        return null;
    }

    private Boolean recisaoNaoSaneado(Recisao r) throws ExceptionInvalidData {
        ItemSaneamentoDadosColaborador i = this.serviceItemSaneamentoColab.getItemSaneamentoByRescisao(r);
        if (this.isAffimative(r.getRecisaoComplementar()) && this.isNull(r.getRecisaoComplementarAc()).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.1682.003", new Object[]{r.getColaborador().getPessoa().getNome()});
        }
        if (this.isNull(i).booleanValue()) {
            return true;
        }
        if (!CompSaneamentoColaborador.isWithData(r.getPreEventosEsocial())) {
            return true;
        }
        throw new ExceptionInvalidData("E.ERP.1682.004", new Object[]{r.getColaborador().getPessoa().getNome()});
    }

    public List<ItemSaneamentoDadosColaborador> buildSaneamentoESocialTermino(List<TerminoTrabalhadorSemVinculo> terminos) throws ExceptionInvalidData {
        LinkedList<ItemSaneamentoDadosColaborador> aux = new LinkedList<ItemSaneamentoDadosColaborador>();
        if (CompSaneamentoColaborador.isWithData(terminos)) {
            for (TerminoTrabalhadorSemVinculo r : terminos) {
                ItemSaneamentoDadosColaborador i = this.buildItemSaneamentoTermino(r);
                if (!this.isNotNull(i).booleanValue()) continue;
                aux.add(i);
            }
        }
        this.ordenarListaItensByLiberacao(aux);
        return aux;
    }

    public ItemSaneamentoDadosColaborador buildItemSaneamentoTermino(TerminoTrabalhadorSemVinculo t) throws ExceptionInvalidData {
        if (this.terminoTsvNaoSaneado(t).booleanValue()) {
            ItemSaneamentoDadosColaborador i = new ItemSaneamentoDadosColaborador();
            i.setLiberado(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
            i.setTermino(t);
            return i;
        }
        return null;
    }

    private Boolean terminoTsvNaoSaneado(TerminoTrabalhadorSemVinculo t) throws ExceptionInvalidData {
        ItemSaneamentoDadosColaborador i = this.serviceItemSaneamentoColab.getItemSaneamentoByTermino(t);
        if (this.isNull(i).booleanValue()) {
            return true;
        }
        throw new ExceptionInvalidData("E.ERP.1682.005", new Object[0]);
    }

    private List<ItemSaneamentoDadosColaborador> ordenarListaItensByLiberacao(List<ItemSaneamentoDadosColaborador> itens) {
        Collections.sort(itens, (o1, o2) -> {
            Boolean n1 = o1.getProducao() != null && !o1.getProducao().isEmpty();
            Boolean n2 = o2.getProducao() != null && !o2.getProducao().isEmpty();
            return n2.compareTo(n1);
        });
        return itens;
    }

    public String isValidRegistroEventoS2200(Colaborador vo) {
        StringBuilder ocorrencias = new StringBuilder();
        if (!this.isStrWithData(vo.getPessoa().getComplemento().getCnpj())) {
            ocorrencias.append(MessagesBaseMentor.getMsg((String)"cpfNaoInformado", (Object[])new Object[0])).append("\n");
        }
        if (!this.isStrWithData(vo.getPessoa().getNome())) {
            ocorrencias.append(MessagesBaseMentor.getMsg((String)"nomeColaboradorNaoInformado", (Object[])new Object[0])).append("\n");
        }
        if (this.isNull(vo.getSexo()).booleanValue()) {
            ocorrencias.append(MessagesBaseMentor.getMsg((String)"sexoColaboradorNaoInformado", (Object[])new Object[0])).append("\n");
        }
        if (this.isNull(vo.getRacaCor()).booleanValue()) {
            ocorrencias.append(MessagesBaseMentor.getMsg((String)"racaCorColaboradorNaoInformado", (Object[])new Object[0])).append("\n");
        }
        if (this.isNull(vo.getGrauInstrucao()).booleanValue()) {
            ocorrencias.append(MessagesBaseMentor.getMsg((String)"grauInstrColaboradorNaoInformado", (Object[])new Object[0])).append("\n");
        }
        if (this.isNull(vo.getPessoa().getComplemento().getDataNascimento()).booleanValue()) {
            ocorrencias.append(MessagesBaseMentor.getMsg((String)"dataNascimentoColaboradorNaoInformado", (Object[])new Object[0])).append("\n");
        }
        if (this.isNull(vo.getCidadeNascimento()).booleanValue() || !this.isStrWithData(vo.getCidadeNascimento().getCodIbgeCompleto())) {
            ocorrencias.append(MessagesBaseMentor.getMsg((String)"codIbgeCidadeNascColaboradorNaoInformado", (Object[])new Object[0])).append("\n");
        }
        if (this.isNull(vo.getNacionalidade()).booleanValue()) {
            ocorrencias.append(MessagesBaseMentor.getMsg((String)"nacionalidadeColaboradorNaoInformado", (Object[])new Object[0])).append("\n");
        }
        if (this.isNotNull(vo.getNacionalidade()).booleanValue() && !this.isStrWithData(vo.getNacionalidade().getCodigo())) {
            ocorrencias.append(MessagesBaseMentor.getMsg((String)"nacionalidadeColaboradorNaoPossuiCodInformado", (Object[])new Object[0])).append("\n");
        }
        if (this.isNotNull(vo.getNacionalidade()).booleanValue() && (this.isEquals(vo.getNacionalidade().getCodigo(), "10") || this.isEquals(vo.getNacionalidade().getCodigo(), "20"))) {
            if (this.isNotNull(vo.getPessoa().getComplemento().getFone1()).booleanValue() && vo.getPessoa().getComplemento().getFone1().length() > 0 && vo.getPessoa().getComplemento().getFone1().length() < 10) {
                ocorrencias.append(MessagesBaseMentor.getMsg((String)"telefoneCelularDeveConter10Digitos", (Object[])new Object[0])).append("\n");
            }
            if (this.isNotNull(vo.getPessoa().getComplemento().getCel1()).booleanValue() && vo.getPessoa().getComplemento().getCel1().length() > 0 && vo.getPessoa().getComplemento().getCel1().length() < 10) {
                ocorrencias.append(MessagesBaseMentor.getMsg((String)"telefoneCelularDeveConter10Digitos", (Object[])new Object[0])).append("\n");
            }
            if (this.isNotNull(vo.getPessoa().getComplemento().getOrgaoEmissor()).booleanValue() && vo.getPessoa().getComplemento().getOrgaoEmissor().length() > 0 && vo.getPessoa().getComplemento().getOrgaoEmissor().length() < 3) {
                ocorrencias.append(MessagesBaseMentor.getMsg((String)"orgaoEmissorDeveConter3Digitos", (Object[])new Object[0])).append("\n");
            }
        }
        if (this.isNotNull(vo.getNacionalidade()).booleanValue() && (this.isEquals(vo.getNacionalidade().getCodigo(), "10") || this.isEquals(vo.getNacionalidade().getCodigo(), "20"))) {
            if (this.isNull(vo.getTipoLogradouroEndereco()).booleanValue()) {
                ocorrencias.append(MessagesBaseMentor.getMsg((String)"tipoLogradEnderecoColaboradorNaoInformado", (Object[])new Object[0])).append("\n");
            }
            if (!this.isStrWithData(vo.getPessoa().getEndereco().getLogradouro())) {
                ocorrencias.append(MessagesBaseMentor.getMsg((String)"descricaoLogradColaboradorNaoInformado", (Object[])new Object[0])).append("\n");
            }
            if (!this.isStrWithData(vo.getPessoa().getEndereco().getNumero())) {
                ocorrencias.append(MessagesBaseMentor.getMsg((String)"numeroLogradColabNaoInformadoInformarSN", (Object[])new Object[0])).append("\n");
            }
            if (!this.isStrWithData(vo.getPessoa().getEndereco().getCep())) {
                ocorrencias.append(MessagesBaseMentor.getMsg((String)"cepColaboradorNaoInformado", (Object[])new Object[0])).append("\n");
            }
            if (this.isNotNull(vo.getPessoa().getEndereco().getCidade()).booleanValue()) {
                if (!this.isStrWithData(vo.getPessoa().getEndereco().getCidade().getCodIbge())) {
                    ocorrencias.append(MessagesBaseMentor.getMsg((String)"codIbgeCidadeColaboradorNaoInformado", (Object[])new Object[0])).append("\n");
                }
                if (this.isNull(vo.getPessoa().getEndereco().getCidade().getUf()).booleanValue()) {
                    ocorrencias.append(MessagesBaseMentor.getMsg((String)"ufCidadeColaboradorNaoInformado", (Object[])new Object[0])).append("\n");
                }
            }
        }
        List dependentes = ((HelperColaborador)Context.get(HelperColaborador.class)).build(vo).getDependentesIRRF(new Date());
        for (ColaboradorDependente d : dependentes) {
            if (this.isNull(d.getTipoDependente()).booleanValue()) {
                ocorrencias.append(MessagesBaseMentor.getMsg((String)"tipoParentescoDependenteNaoInformado", (Object[])new Object[]{d.getNomeDependente()})).append("\n");
            }
            if (!this.isStrWithData(d.getNomeDependente())) {
                ocorrencias.append(MessagesBaseMentor.getMsg((String)"nomeDependenteNaoInformado", (Object[])new Object[0])).append("\n");
            }
            if (this.isNull(d.getSexo()).booleanValue()) {
                ocorrencias.append(MessagesBaseMentor.getMsg((String)"sexoDependenteNaoInformado", (Object[])new Object[0])).append("\n");
            }
            if (this.isNull(d.getDataNascimento()).booleanValue()) {
                ocorrencias.append(MessagesBaseMentor.getMsg((String)"dataNascimentoDependenteNaoInformado", (Object[])new Object[]{d.getNomeDependente()})).append("\n");
            }
            if (this.isNull(d.getDependenteIncapacitado()).booleanValue()) {
                ocorrencias.append(MessagesBaseMentor.getMsg((String)"opcaoDependenteInvalidoNaoInformada", (Object[])new Object[]{d.getNomeDependente()})).append("\n");
            }
            if (!this.isNotNull(d.getDataNascimento()).booleanValue() || ToolDate.differenceYearsBetweenDates((Date)d.getDataNascimento(), (Date)new Date()) <= 7 || this.isStrWithData(d.getCpf())) continue;
            ocorrencias.append(MessagesBaseMentor.getMsg((String)"cpfDependenteNaoInformado", (Object[])new Object[]{d.getNomeDependente()})).append("\n");
        }
        List filhos = ((HelperColaborador)Context.get(HelperColaborador.class)).build(vo).getDependentesSalFam(new Date());
        for (ColaboradorDependente f : filhos) {
            if (!this.isStrWithData(f.getNomeDependente())) {
                ocorrencias.append(MessagesBaseMentor.getMsg((String)"nomeDependenteNaoInformado", (Object[])new Object[0])).append("\n");
            }
            if (this.isNull(f.getSexo()).booleanValue()) {
                ocorrencias.append(MessagesBaseMentor.getMsg((String)"sexoDependenteNaoInformado", (Object[])new Object[0])).append("\n");
            }
            if (this.isNull(f.getDataNascimento()).booleanValue()) {
                ocorrencias.append(MessagesBaseMentor.getMsg((String)"dataNascimentoDependenteNaoInformado", (Object[])new Object[]{f.getNomeDependente()})).append("\n");
            }
            if (!this.isNull(f.getDependenteIncapacitado()).booleanValue()) continue;
            ocorrencias.append(MessagesBaseMentor.getMsg((String)"opcaoFilhoInvalidoNaoInformada", (Object[])new Object[]{f.getNomeDependente()})).append("\n");
        }
        if (!this.isStrWithData(vo.getNumeroRegistro())) {
            ocorrencias.append(MessagesBaseMentor.getMsg((String)"numeroRegistroColaboradorNaoInformado", (Object[])new Object[0])).append("\n");
        }
        if (this.isNull(vo.getRegimeTrabalhista()).booleanValue()) {
            ocorrencias.append(MessagesBaseMentor.getMsg((String)"regimeTrabalhistaColaboradorNaoInformado", (Object[])new Object[0])).append("\n");
        }
        if (this.isNull(vo.getRegimePrevidenciario()).booleanValue()) {
            ocorrencias.append(MessagesBaseMentor.getMsg((String)"regimePrevidenciarioColaboradorNaoInformado", (Object[])new Object[0])).append("\n");
        }
        if (this.isNull(vo.getDataAdmissao()).booleanValue()) {
            ocorrencias.append(MessagesBaseMentor.getMsg((String)"dataAdmissaoColaboradorNaoInformado", (Object[])new Object[0])).append("\n");
        }
        if (this.isNull(vo.getTipoAdmissaoEsocial()).booleanValue()) {
            ocorrencias.append(MessagesBaseMentor.getMsg((String)"tipoAdmissaoEsocialColaboradorNaoInformado", (Object[])new Object[0])).append("\n");
        }
        if (this.isNull(vo.getIndicativoAdmissao()).booleanValue()) {
            ocorrencias.append(MessagesBaseMentor.getMsg((String)"indicativoAdmissaoColaboradorNaoInformado", (Object[])new Object[0])).append("\n");
        }
        if (this.isNull(vo.getRegimeJornadaTrabalho()).booleanValue()) {
            ocorrencias.append(MessagesBaseMentor.getMsg((String)"regimeJornadaTrabalhoColaboradorNaoInformado", (Object[])new Object[0])).append("\n");
        }
        if (this.isNull(vo.getNaturezaAtividade()).booleanValue()) {
            ocorrencias.append(MessagesBaseMentor.getMsg((String)"naturezaAtividadeESocialColaboradorNaoInformado", (Object[])new Object[0])).append("\n");
        }
        if (this.isNull(vo.getSindicato()).booleanValue()) {
            ocorrencias.append(MessagesBaseMentor.getMsg((String)"sindicatoColaboradorNaoInformado", (Object[])new Object[0])).append("\n");
        }
        if (this.isNull(vo.getOptanteFgts()).booleanValue()) {
            ocorrencias.append(MessagesBaseMentor.getMsg((String)"optanteFgtsColaboradorNaoInformado", (Object[])new Object[0])).append("\n");
        }
        if (this.isNull(vo.getFuncao()).booleanValue()) {
            ocorrencias.append(MessagesBaseMentor.getMsg((String)"funcaoColaboradorNaoInformado", (Object[])new Object[0])).append("\n");
        }
        if (!this.isStrWithData(vo.getFuncao().getCodigoCargo())) {
            ocorrencias.append(MessagesBaseMentor.getMsg((String)"codigoCargoFuncaoColaboradorNaoInformado", (Object[])new Object[0])).append("\n");
        }
        if (this.isNull(vo.getEsocCategoriaTrabalhador()).booleanValue()) {
            ocorrencias.append(MessagesBaseMentor.getMsg((String)"categoriaTrabalhadorESocialColaboradorNaoInformado", (Object[])new Object[0])).append("\n");
        }
        if (this.isNull(vo.getEmpresa().getPessoa().getComplemento().getTipoPessoa()).booleanValue()) {
            ocorrencias.append(MessagesBaseMentor.getMsg((String)"tipoPessoaEmpresaColaboradorNaoInformado", (Object[])new Object[0])).append("\n");
        }
        if (!this.isStrWithData(vo.getEmpresa().getPessoa().getComplemento().getCnpj())) {
            ocorrencias.append(MessagesBaseMentor.getMsg((String)"cnpjEmpresaColaboradorNaoInformado", (Object[])new Object[0])).append("\n");
        }
        if (this.isNull(vo.getHorarioTrabalho().getEsocCadastroHorario()).booleanValue() || this.isNull(vo.getHorarioTrabalho().getEsocCadastroHorario().getTipoJornada()).booleanValue()) {
            ocorrencias.append(MessagesBaseMentor.getMsg((String)"informeTipoJornadaCadastroHorario", (Object[])new Object[0])).append("\n");
        }
        return ocorrencias.toString();
    }

    public String isValidRegistroEventoS2300(Colaborador vo) {
        String categoria;
        StringBuilder ocorrencias = new StringBuilder();
        if (!this.isStrWithData(vo.getPessoa().getComplemento().getCnpj())) {
            ocorrencias.append(MessagesBaseMentor.getMsg((String)"cpfNaoInformado", (Object[])new Object[0])).append("\n");
        }
        if (this.isEquals(categoria = vo.getEsocCategoriaTrabalhador().getCodigo(), "901") && this.isEquals(categoria, "904") && this.isEquals(categoria, "903") && !this.isStrWithData(vo.getNumeroPis())) {
            ocorrencias.append(MessagesBaseMentor.getMsg((String)"nisPisNaoInformado", (Object[])new Object[0])).append("\n");
        }
        if (!this.isStrWithData(vo.getPessoa().getNome())) {
            ocorrencias.append(MessagesBaseMentor.getMsg((String)"nomeColaboradorNaoInformado", (Object[])new Object[0])).append("\n");
        }
        if (this.isNull(vo.getSexo()).booleanValue()) {
            ocorrencias.append(MessagesBaseMentor.getMsg((String)"sexoColaboradorNaoInformado", (Object[])new Object[0])).append("\n");
        }
        if (this.isNull(vo.getRacaCor()).booleanValue()) {
            ocorrencias.append(MessagesBaseMentor.getMsg((String)"racaCorColaboradorNaoInformado", (Object[])new Object[0])).append("\n");
        }
        if (this.isNull(vo.getGrauInstrucao()).booleanValue()) {
            ocorrencias.append(MessagesBaseMentor.getMsg((String)"grauInstrColaboradorNaoInformado", (Object[])new Object[0])).append("\n");
        }
        if (this.isNull(vo.getTipoLogradouroEndereco()).booleanValue()) {
            ocorrencias.append(MessagesBaseMentor.getMsg((String)"tipoLogradEnderecoColaboradorNaoInformado", (Object[])new Object[0])).append("\n");
        }
        if (this.isNull(vo.getPessoa().getComplemento().getDataNascimento()).booleanValue()) {
            ocorrencias.append(MessagesBaseMentor.getMsg((String)"dataNascimentoColaboradorNaoInformado", (Object[])new Object[0])).append("\n");
        }
        if (this.isNotNull(vo.getPessoa().getComplemento().getFone1()).booleanValue() && vo.getPessoa().getComplemento().getFone1().length() > 0 && vo.getPessoa().getComplemento().getFone1().length() < 10) {
            ocorrencias.append(MessagesBaseMentor.getMsg((String)"telefoneCelularDeveConter10Digitos", (Object[])new Object[0])).append("\n");
        }
        if (this.isNotNull(vo.getPessoa().getComplemento().getCel1()).booleanValue() && vo.getPessoa().getComplemento().getCel1().length() > 0 && vo.getPessoa().getComplemento().getCel1().length() < 10) {
            ocorrencias.append(MessagesBaseMentor.getMsg((String)"telefoneCelularDeveConter10Digitos", (Object[])new Object[0])).append("\n");
        }
        if (this.isNotNull(vo.getPessoa().getComplemento().getRg()).booleanValue() && vo.getPessoa().getComplemento().getRg().length() > 0 && (!this.isStrWithData(vo.getPessoa().getComplemento().getOrgaoEmissor()) || vo.getPessoa().getComplemento().getOrgaoEmissor().length() < 3)) {
            ocorrencias.append(MessagesBaseMentor.getMsg((String)"orgaoEmissorDeveConter3Digitos", (Object[])new Object[0])).append("\n");
        }
        if (this.isNotNull(vo.getFuncao()).booleanValue() && this.isAffimative(vo.getFuncao().getCbo().getObrigatoriedadeExameToxicologico())) {
            if (!this.isStrWithData(vo.getCarteiraHabilitacao())) {
                ocorrencias.append(MessagesBaseMentor.getMsg((String)"cnhColaboradoNaoInformado", (Object[])new Object[0])).append("\n");
            }
            if (this.isNull(vo.getUfCNH()).booleanValue()) {
                ocorrencias.append(MessagesBaseMentor.getMsg((String)"ufCnhColaboradorNaoInformado", (Object[])new Object[0])).append("\n");
            }
            if (this.isNull(vo.getDataValidadeCNH()).booleanValue()) {
                ocorrencias.append(MessagesBaseMentor.getMsg((String)"dataValidadeCnhColaboradorNaoInformado", (Object[])new Object[0])).append("\n");
            }
            if (!this.isStrWithData(vo.getCategoriaCNH())) {
                ocorrencias.append(MessagesBaseMentor.getMsg((String)"categoriaCnhColaboradorNaoInformado", (Object[])new Object[0])).append("\n");
            }
        }
        List dependentes = ((HelperColaborador)Context.get(HelperColaborador.class)).build(vo).getDependentesIRRF(new Date());
        for (ColaboradorDependente d : dependentes) {
            if (this.isNull(d.getTipoDependente()).booleanValue()) {
                ocorrencias.append(MessagesBaseMentor.getMsg((String)"tipoParentescoDependenteNaoInformado", (Object[])new Object[]{d.getNomeDependente()})).append("\n");
            }
            if (!this.isStrWithData(d.getNomeDependente())) {
                ocorrencias.append(MessagesBaseMentor.getMsg((String)"nomeDependenteNaoInformado", (Object[])new Object[0])).append("\n");
            }
            if (this.isNull(d.getDataNascimento()).booleanValue()) {
                ocorrencias.append(MessagesBaseMentor.getMsg((String)"dataNascimentoDependenteNaoInformado", (Object[])new Object[]{d.getNomeDependente()})).append("\n");
            }
            if (this.isNull(d.getDependenteIncapacitado()).booleanValue()) {
                ocorrencias.append(MessagesBaseMentor.getMsg((String)"opcaoDependenteInvalidoNaoInformada", (Object[])new Object[]{d.getNomeDependente()})).append("\n");
            }
            if (!this.isNotNull(d.getDataNascimento()).booleanValue() || ToolDate.differenceYearsBetweenDates((Date)d.getDataNascimento(), (Date)new Date()) <= 11 || this.isStrWithData(d.getCpf())) continue;
            ocorrencias.append(MessagesBaseMentor.getMsg((String)"cpfDependenteNaoInformado", (Object[])new Object[]{d.getNomeDependente()})).append("\n");
        }
        List filhos = ((HelperColaborador)Context.get(HelperColaborador.class)).build(vo).getDependentesSalFam(new Date());
        for (ColaboradorDependente f : filhos) {
            if (!this.isStrWithData(f.getNomeDependente())) {
                ocorrencias.append(MessagesBaseMentor.getMsg((String)"nomeDependenteNaoInformado", (Object[])new Object[0])).append("\n");
            }
            if (this.isNull(f.getDataNascimento()).booleanValue()) {
                ocorrencias.append(MessagesBaseMentor.getMsg((String)"dataNascimentoDependenteNaoInformado", (Object[])new Object[]{f.getNomeDependente()})).append("\n");
            }
            if (!this.isNull(f.getDependenteIncapacitado()).booleanValue()) continue;
            ocorrencias.append(MessagesBaseMentor.getMsg((String)"opcaoFilhoInvalidoNaoInformada", (Object[])new Object[]{f.getNomeDependente()})).append("\n");
        }
        if (this.isNull(vo.getEsocCategoriaTrabalhador()).booleanValue()) {
            ocorrencias.append(MessagesBaseMentor.getMsg((String)"categoriaTrabalhadorESocialColaboradorNaoInformado", (Object[])new Object[0])).append("\n");
        }
        if (this.isNull(vo.getDataAdmissao()).booleanValue()) {
            ocorrencias.append(MessagesBaseMentor.getMsg((String)"dataAdmissaoColaboradorNaoInformado", (Object[])new Object[0])).append("\n");
        }
        if (this.isNotNull(vo.getEsocCategoriaTrabalhador()).booleanValue() && this.isEquals(vo.getEsocCategoriaTrabalhador().getCodigo(), "901")) {
            if (this.isNull(vo.getNaturezaEstagio()).booleanValue()) {
                ocorrencias.append(MessagesBaseMentor.getMsg((String)"naturezaEstagioNaoInformado", (Object[])new Object[0])).append("\n");
            }
            if (this.isNull(vo.getNivelEstagio()).booleanValue()) {
                ocorrencias.append(MessagesBaseMentor.getMsg((String)"nivelEstagioNaoInformado", (Object[])new Object[0])).append("\n");
            }
            if (this.isNull(vo.getDataTerminoEstagio()).booleanValue()) {
                ocorrencias.append(MessagesBaseMentor.getMsg((String)"dataTerminoEstagioNaoInformado", (Object[])new Object[0])).append("\n");
            }
            if (this.isNull(vo.getInstituicaoEnsinoEstagio()).booleanValue()) {
                ocorrencias.append(MessagesBaseMentor.getMsg((String)"instituicaoEnsinoEstagioNaoInformado", (Object[])new Object[0])).append("\n");
            }
        }
        return ocorrencias.toString();
    }

    public String isValidRegistroEventoS2299(Recisao vo) {
        StringBuilder ocorrencias = new StringBuilder();
        if (this.isNull(vo.getCadastroRecisao().getEsocMotivoDesligamento()).booleanValue()) {
            ocorrencias.append(MessagesBaseMentor.getMsg((String)"informeMotivoDesligESocialTipoResc", (Object[])new Object[0])).append("\n");
        }
        if (this.isNull(vo.getColaborador().getLotacaoTributaria()).booleanValue()) {
            ocorrencias.append(MessagesBaseMentor.getMsg((String)"informeLotacaoTributariaColaborador", (Object[])new Object[0])).append("\n");
        }
        if (CompSaneamentoColaborador.isWithData(vo.getRubricas())) {
            for (Rubricas2299 rubrica : vo.getRubricas()) {
                TipoCalculoEvento tp = rubrica.getTipoCalculo();
                Boolean enviada = false;
                for (EsocPreEvento e : tp.getPreEventosEsocial()) {
                    if (!this.isNotNull(e.getEsocEvento()).booleanValue() || !this.isEquals(e.getEsocEvento().getStatus(), EnumConstESocialStatus.STATUS_SUCESSO.getValue())) continue;
                    enviada = true;
                    break;
                }
                if (enviada.booleanValue()) continue;
                ocorrencias.append(MessagesBaseMentor.getMsg((String)"rubricaNaoEnviada", (Object[])new Object[]{tp.getEvento().getCodigo(), tp.getEvento().toString()})).append("\n");
            }
        }
        if (this.isNull(vo.getColaborador().getGrauExposicao()).booleanValue()) {
            ocorrencias.append(MessagesBaseMentor.getMsg((String)"informeGrauExposicaoColaborador", (Object[])new Object[]{vo.getColaborador().toString()})).append("\n");
        }
        return ocorrencias.toString();
    }
}

