/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.searchclass;

import com.touchcomp.basementor.constants.enums.searchclass.EnumConstSmartSearchClass;
import com.touchcomp.basementor.model.impl.VOSmartSearchClassField;
import com.touchcomp.basementor.model.vo.SearchClass;
import com.touchcomp.basementor.model.vo.SearchClassField;
import com.touchcomp.basementortools.constants.EnumConstantsCriteria;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementorvalidator.others.cpfcnpj.ValidadeCPFCNPJ;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.stereotype.Component;

@Component
public class CompSmartSearchClass {
    private int CNPJ_LENGHT = 14;
    private int CPF_LENGHT = 11;

    public List<VOSmartSearchClassField> getSearchFieldSmartSearch(SearchClass searchClass, String dataToAnalise) {
        if (dataToAnalise == null) {
            dataToAnalise = "";
            return this.detectAsText(searchClass, dataToAnalise);
        }
        List<VOSmartSearchClassField> found = this.detectAsSpecific(searchClass, dataToAnalise);
        if (!found.isEmpty()) {
            return found;
        }
        found = this.detectAsCodigo(searchClass, dataToAnalise);
        if (!found.isEmpty()) {
            return found;
        }
        found = this.detectAsDate(searchClass, dataToAnalise);
        if (!found.isEmpty()) {
            return found;
        }
        found = this.detectAsNumber(searchClass, dataToAnalise);
        if (!found.isEmpty()) {
            return found;
        }
        found = this.detectAsDecNumber(searchClass, dataToAnalise);
        if (!found.isEmpty()) {
            return found;
        }
        found = this.detectAsText(searchClass, dataToAnalise);
        return found;
    }

    private List<SearchClassField> findIt(List<SearchClassField> searchFields, EnumConstSmartSearchClass enumConstSmartSearchClass) {
        LinkedList<SearchClassField> ret = new LinkedList<SearchClassField>();
        for (SearchClassField searchField : searchFields) {
            if (searchField == null || !TMethods.isAffirmative((Number)searchField.getAtivo()) || !ToolMethods.isEquals((Object)searchField.getTipoSmartSearch(), (Object)enumConstSmartSearchClass.getValue())) continue;
            ret.add(searchField);
        }
        return ret;
    }

    private LinkedList<VOSmartSearchClassField> detectAsDecNumber(SearchClass searchClass, String dataToAnalise) {
        LinkedList<VOSmartSearchClassField> ret = new LinkedList<VOSmartSearchClassField>();
        if (dataToAnalise.length() < String.valueOf(Double.MAX_VALUE).length() - 2 && ToolString.isADoubleNumberPT((String)dataToAnalise)) {
            Number n;
            List<SearchClassField> field = this.findIt(searchClass.getSearchFields(), EnumConstSmartSearchClass.NUMERICO_DECIMAL);
            try {
                n = NumberFormat.getInstance(new Locale("pt", "BR")).parse(dataToAnalise);
            }
            catch (ParseException ex) {
                Logger.getLogger(CompSmartSearchClass.class.getName()).log(Level.SEVERE, null, ex);
                return null;
            }
            this.addFiels(ret, field, dataToAnalise, n, EnumConstSmartSearchClass.NUMERICO_DECIMAL, EnumConstantsCriteria.EQUAL);
        }
        return ret;
    }

    private List<VOSmartSearchClassField> detectAsNumber(SearchClass searchClass, String dataToAnalise) {
        LinkedList<VOSmartSearchClassField> ret = new LinkedList<VOSmartSearchClassField>();
        if (dataToAnalise.length() < String.valueOf(Long.MAX_VALUE).length() - 2 && ToolString.isAIntegerNumber((String)dataToAnalise)) {
            List<SearchClassField> field = this.findIt(searchClass.getSearchFields(), EnumConstSmartSearchClass.NUMERICO_INTEIRO);
            if (field.isEmpty()) {
                return ret;
            }
            Long translate = Long.valueOf(dataToAnalise);
            this.addFiels(ret, field, dataToAnalise, translate, EnumConstSmartSearchClass.NUMERICO_INTEIRO, EnumConstantsCriteria.EQUAL);
        }
        return ret;
    }

    private List<VOSmartSearchClassField> detectAsDate(SearchClass searchClass, String dataToAnalise) {
        List<SearchClassField> field;
        LinkedList<VOSmartSearchClassField> ret = new LinkedList<VOSmartSearchClassField>();
        if (ToolString.isADateClassic((String)dataToAnalise, (String)"dd-MM-yy")) {
            field = this.findIt(searchClass.getSearchFields(), EnumConstSmartSearchClass.DATA);
            if (field.isEmpty()) {
                return ret;
            }
            this.addFiels(ret, field, dataToAnalise, ToolDate.strToDate((String)dataToAnalise, (String)"dd-MM-yy"), EnumConstSmartSearchClass.DATA, EnumConstantsCriteria.EQUAL);
        }
        if (ToolString.isADateClassic((String)dataToAnalise, (String)"dd-MM-yyyy")) {
            field = this.findIt(searchClass.getSearchFields(), EnumConstSmartSearchClass.DATA);
            if (field.isEmpty()) {
                return ret;
            }
            this.addFiels(ret, field, dataToAnalise, ToolDate.strToDate((String)dataToAnalise, (String)"dd-MM-yyyy"), EnumConstSmartSearchClass.DATA, EnumConstantsCriteria.EQUAL);
        }
        if (ToolString.isADateClassic((String)dataToAnalise, (String)"dd/MM/yy")) {
            field = this.findIt(searchClass.getSearchFields(), EnumConstSmartSearchClass.DATA);
            if (field.isEmpty()) {
                return ret;
            }
            this.addFiels(ret, field, dataToAnalise, ToolDate.strToDate((String)dataToAnalise, (String)"dd/MM/yy"), EnumConstSmartSearchClass.DATA, EnumConstantsCriteria.EQUAL);
        }
        if (ToolString.isADateClassic((String)dataToAnalise, (String)"dd/MM/yyyy")) {
            field = this.findIt(searchClass.getSearchFields(), EnumConstSmartSearchClass.DATA);
            if (field.isEmpty()) {
                return ret;
            }
            this.addFiels(ret, field, dataToAnalise, ToolDate.strToDate((String)dataToAnalise, (String)"dd/MM/yyyy"), EnumConstSmartSearchClass.DATA, EnumConstantsCriteria.EQUAL);
        }
        if (ToolString.isADateClassic((String)dataToAnalise, (String)"dd.MM.yyyy")) {
            field = this.findIt(searchClass.getSearchFields(), EnumConstSmartSearchClass.DATA);
            this.addFiels(ret, field, dataToAnalise, ToolDate.strToDate((String)dataToAnalise, (String)"dd.MM.yyyy"), EnumConstSmartSearchClass.DATA, EnumConstantsCriteria.EQUAL);
        }
        if (ToolString.isADateClassic((String)dataToAnalise, (String)"dd.MM.yy")) {
            field = this.findIt(searchClass.getSearchFields(), EnumConstSmartSearchClass.DATA);
            this.addFiels(ret, field, dataToAnalise, ToolDate.strToDate((String)dataToAnalise, (String)"dd.MM.yy"), EnumConstSmartSearchClass.DATA, EnumConstantsCriteria.EQUAL);
        }
        return ret;
    }

    private List<VOSmartSearchClassField> detectAsText(SearchClass searchClass, String dataToAnalise) {
        LinkedList<VOSmartSearchClassField> ret = new LinkedList<VOSmartSearchClassField>();
        List<SearchClassField> field = this.findIt(searchClass.getSearchFields(), EnumConstSmartSearchClass.TEXTO);
        field.removeIf(f -> !ToolMethods.isEquals((Object)f.getNumeroCaracteres(), (Object)0) && dataToAnalise.length() > f.getNumeroCaracteres() - 1);
        if (field != null) {
            this.addFiels(ret, field, dataToAnalise, dataToAnalise, EnumConstSmartSearchClass.TEXTO, EnumConstantsCriteria.ILIKE_RIGTH);
        }
        return ret;
    }

    private List<VOSmartSearchClassField> detectAsCodigo(SearchClass searchClass, String dataToAnalise) {
        List<SearchClassField> field;
        LinkedList<VOSmartSearchClassField> ret = new LinkedList<VOSmartSearchClassField>();
        if (ToolString.onlyNumbers((String)dataToAnalise).length() == this.CNPJ_LENGHT && ValidadeCPFCNPJ.isValidCnpj((String)dataToAnalise)) {
            field = this.findIt(searchClass.getSearchFields(), EnumConstSmartSearchClass.CNPJ);
            this.addFiels(ret, field, dataToAnalise, dataToAnalise, EnumConstSmartSearchClass.CNPJ, EnumConstantsCriteria.EQUAL);
        }
        if (ToolString.onlyNumbers((String)dataToAnalise).length() == this.CPF_LENGHT && ValidadeCPFCNPJ.isValideCPF((String)dataToAnalise)) {
            field = this.findIt(searchClass.getSearchFields(), EnumConstSmartSearchClass.CPF);
            this.addFiels(ret, field, dataToAnalise, dataToAnalise, EnumConstSmartSearchClass.CPF, EnumConstantsCriteria.EQUAL);
        }
        return ret;
    }

    private List<VOSmartSearchClassField> detectAsSpecific(SearchClass searchClass, String dataToAnalise) {
        LinkedList<VOSmartSearchClassField> ret = new LinkedList<VOSmartSearchClassField>();
        if (!dataToAnalise.contains("|")) {
            return ret;
        }
        Optional<SearchClassField> found = searchClass.getSearchFields().stream().filter(i -> ToolMethods.isEquals((Object)i.getTipoSmartSearch(), (Object)EnumConstSmartSearchClass.ESPECIFICO.getValue()) && dataToAnalise.startsWith(i.getCodigoPesqInteligenteEspec())).findFirst();
        if (found.isPresent()) {
            String str = dataToAnalise;
            str = str.substring(found.get().getCodigoPesqInteligenteEspec().length());
            EnumConstantsCriteria criteria = EnumConstantsCriteria.valueOfByValue((Integer)found.get().getDefaultCriteria());
            if (criteria == null) {
                criteria = EnumConstantsCriteria.EQUAL;
            }
            this.addFiels(ret, (List<SearchClassField>)ToolMethods.toList((Object[])new Object[]{found.get()}), str, str, EnumConstSmartSearchClass.ESPECIFICO, criteria);
        }
        return ret;
    }

    private void addFiels(List<VOSmartSearchClassField> ret, List<SearchClassField> fields, String typed, Object value, EnumConstSmartSearchClass type, EnumConstantsCriteria criteria) {
        for (SearchClassField field : fields) {
            VOSmartSearchClassField temp = new VOSmartSearchClassField(typed, value, type, field, criteria);
            ret.add(temp);
        }
    }

    private void addFiels(List<VOSmartSearchClassField> ret, List<SearchClassField> fields, String typed, Number value, EnumConstSmartSearchClass type, EnumConstantsCriteria criteria) {
        for (SearchClassField field : fields) {
            if (field.getFieldClass().equals(Short.class.getCanonicalName())) {
                value = value.shortValue();
            }
            if (field.getFieldClass().equals(Integer.class.getCanonicalName())) {
                value = value.intValue();
            }
            if (field.getFieldClass().equals(Float.class.getCanonicalName())) {
                value = Float.valueOf(value.floatValue());
            }
            if (field.getFieldClass().equals(Double.class.getCanonicalName())) {
                value = value.doubleValue();
            }
            VOSmartSearchClassField temp = new VOSmartSearchClassField(typed, (Object)value, type, field, criteria);
            ret.add(temp);
        }
    }
}

