/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.spedpiscofins.lancamentospedpiscofins;

import com.touchcomp.basementor.constants.enums.spedpiscofins.EnumConstSpedContF100IndOrig;
import com.touchcomp.basementor.model.vo.BaixaTitulo;
import com.touchcomp.basementor.model.vo.ContasPisCofinsSpedCont;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LancamentoSpedPisCofins;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.TipoDoc;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;

public class CompLancamentoSpedPisCofins {
    public static LancamentoSpedPisCofins getNew(BaixaTitulo baixa) {
        TipoDoc tipoDoc = baixa.getTitulo().getTipoDoc();
        if (tipoDoc != null && ToolMethods.isEquals((Object)tipoDoc.getGerarLancamentoPisCofins(), (Object)1) && (ToolMethods.isEquals((Object)tipoDoc.getTipoTitulo(), (Object)2) || ToolMethods.isEquals((Object)tipoDoc.getTipoTitulo(), (Object)baixa.getTitulo().getPagRec()))) {
            LancamentoSpedPisCofins vo = baixa.getLancamentoPisCofins();
            if (vo == null) {
                vo = new LancamentoSpedPisCofins();
            }
            Double valor = baixa.getTotalOperacao();
            vo.setDataOper(baixa.getGrupoDeBaixaFormas().getGrupoDeBaixa().getDataLiquidacao());
            vo.setVrOper(valor);
            vo.setCstPis(tipoDoc.getIncidenciaPisCofins());
            vo.setCstCofins(tipoDoc.getIncidenciaPisCofins());
            vo.setVrBcPis(valor);
            vo.setVrBcCofins(valor);
            vo.setAliqPis(tipoDoc.getAliquotaPis());
            vo.setPlanoConta(baixa.getTitulo().getPlanoConta());
            vo.setParticipante(baixa.getTitulo().getPessoa());
            vo.setAliqCofins(tipoDoc.getAliquotaCofins());
            vo.setVrPis(ToolFormatter.arrredondarNumero((Double)(vo.getVrBcPis() * (vo.getAliqPis() / 100.0)), (int)2));
            vo.setVrCofins(ToolFormatter.arrredondarNumero((Double)(vo.getVrBcCofins() * (vo.getAliqCofins() / 100.0)), (int)2));
            vo.setNatBcCredito(tipoDoc.getNatBcCredito());
            vo.setIndOrigCred(tipoDoc.getIndOrigCred());
            if (tipoDoc.getIncidenciaPisCofins().getCodigo().equals("01") || tipoDoc.getIncidenciaPisCofins().getCodigo().equals("02") || tipoDoc.getIncidenciaPisCofins().getCodigo().equals("03") || tipoDoc.getIncidenciaPisCofins().getCodigo().equals("01")) {
                vo.setIndOper(Short.valueOf("1"));
            } else if (tipoDoc.getIncidenciaPisCofins().getCodigo().equals("04") || tipoDoc.getIncidenciaPisCofins().getCodigo().equals("06") || tipoDoc.getIncidenciaPisCofins().getCodigo().equals("07") || tipoDoc.getIncidenciaPisCofins().getCodigo().equals("08") || tipoDoc.getIncidenciaPisCofins().getCodigo().equals("09") || tipoDoc.getIncidenciaPisCofins().getCodigo().equals("49") || tipoDoc.getIncidenciaPisCofins().getCodigo().equals("99")) {
                vo.setIndOper(Short.valueOf("2"));
            } else {
                vo.setIndOper(Short.valueOf("0"));
            }
            vo.setDataCadastro(new Date());
            vo.setEmpresa(baixa.getTitulo().getEmpresa());
            return vo;
        }
        return null;
    }

    public static LancamentoSpedPisCofins getNew(ItemNotaTerceiros itemNotaTerceiros, Empresa empresa) {
        LancamentoSpedPisCofins vo = new LancamentoSpedPisCofins();
        vo.setProduto(itemNotaTerceiros.getProduto());
        vo.setParticipante(itemNotaTerceiros.getNotaFiscalTerceiros().getUnidadeFatFornecedor().getPessoa());
        vo.setPlanoConta(itemNotaTerceiros.getPlanoContaDeb());
        vo.setDataOper(itemNotaTerceiros.getNotaFiscalTerceiros().getDataEntrada());
        vo.setVrOper(itemNotaTerceiros.getItemNotaLivroFiscal().getValorTotal());
        vo.setCstPis(itemNotaTerceiros.getIncidenciaPisCofins());
        vo.setCstCofins(itemNotaTerceiros.getIncidenciaPisCofins());
        vo.setVrBcPis(itemNotaTerceiros.getItemNotaLivroFiscal().getVrBCPis());
        vo.setVrBcCofins(itemNotaTerceiros.getItemNotaLivroFiscal().getVrBCCofins());
        vo.setAliqPis(itemNotaTerceiros.getItemNotaLivroFiscal().getAliquotaPis());
        vo.setAliqCofins(itemNotaTerceiros.getItemNotaLivroFiscal().getAliquotaCofins());
        vo.setVrPis(itemNotaTerceiros.getItemNotaLivroFiscal().getVrPis());
        vo.setVrCofins(itemNotaTerceiros.getItemNotaLivroFiscal().getVrCofins());
        if (itemNotaTerceiros.getNaturezaBCCredito() != null) {
            vo.setNatBcCredito(itemNotaTerceiros.getNaturezaBCCredito());
        } else {
            vo.setNatBcCredito(itemNotaTerceiros.getModeloFiscal().getModeloFiscalPisCofins().getNaturezaBCCredito());
        }
        vo.setIndOrigCred(itemNotaTerceiros.getModeloFiscal().getModeloFiscalPisCofins().getModeloPisCofinsF100().getIndOrigCred());
        vo.setIndOper(itemNotaTerceiros.getModeloFiscal().getModeloFiscalPisCofins().getModeloPisCofinsF100().getIndOper());
        vo.setDataCadastro(new Date());
        vo.setEmpresa(itemNotaTerceiros.getNotaFiscalTerceiros().getEmpresa());
        vo.setItemNotaOrigemTerc(itemNotaTerceiros);
        return vo;
    }

    public static LancamentoSpedPisCofins getNew(ItemNotaFiscalPropria itemNotaPropria, Empresa empresa) {
        LancamentoSpedPisCofins vo = new LancamentoSpedPisCofins();
        vo.setProduto(itemNotaPropria.getProduto());
        vo.setParticipante(itemNotaPropria.getNotaFiscalPropria().getUnidadeFatCliente().getPessoa());
        vo.setPlanoConta(itemNotaPropria.getPlanoContaDeb());
        vo.setDataOper(itemNotaPropria.getNotaFiscalPropria().getDataEmissaoNota());
        vo.setVrOper(itemNotaPropria.getItemNotaLivroFiscal().getValorTotal());
        vo.setCstPis(itemNotaPropria.getIncidenciaPisCofins());
        vo.setCstCofins(itemNotaPropria.getIncidenciaPisCofins());
        vo.setVrBcPis(itemNotaPropria.getItemNotaLivroFiscal().getVrBCPis());
        vo.setVrBcCofins(itemNotaPropria.getItemNotaLivroFiscal().getVrBCCofins());
        vo.setAliqPis(itemNotaPropria.getItemNotaLivroFiscal().getAliquotaPis());
        vo.setAliqCofins(itemNotaPropria.getItemNotaLivroFiscal().getAliquotaCofins());
        vo.setVrPis(itemNotaPropria.getItemNotaLivroFiscal().getVrPis());
        vo.setVrCofins(itemNotaPropria.getItemNotaLivroFiscal().getVrCofins());
        if (itemNotaPropria.getNaturezaBCCredito() != null) {
            vo.setNatBcCredito(itemNotaPropria.getNaturezaBCCredito());
        } else {
            vo.setNatBcCredito(itemNotaPropria.getModeloFiscal().getModeloFiscalPisCofins().getNaturezaBCCredito());
        }
        vo.setIndOrigCred(itemNotaPropria.getModeloFiscal().getModeloFiscalPisCofins().getModeloPisCofinsF100().getIndOrigCred());
        vo.setIndOper(itemNotaPropria.getModeloFiscal().getModeloFiscalPisCofins().getModeloPisCofinsF100().getIndOper());
        vo.setDataCadastro(new Date());
        vo.setEmpresa(itemNotaPropria.getNotaFiscalPropria().getEmpresa());
        vo.setItemNotaOrigemProp(itemNotaPropria);
        return vo;
    }

    public static LancamentoSpedPisCofins getNew(Lancamento lancamento, Empresa empresa, ContasPisCofinsSpedCont contasPisCofinsSpedCont, PlanoConta planoConta) {
        LancamentoSpedPisCofins vo = new LancamentoSpedPisCofins();
        vo.setIndOper(EnumConstSpedContF100IndOrig.OPERACAO_MERC_INTERNO_0.getEnumId());
        if (contasPisCofinsSpedCont.getIncidenciaPis().getCodigo().equals("01") || contasPisCofinsSpedCont.getIncidenciaPis().getCodigo().equals("02") || contasPisCofinsSpedCont.getIncidenciaPis().getCodigo().equals("03")) {
            vo.setIndOper(Short.valueOf("1"));
        } else if (contasPisCofinsSpedCont.getIncidenciaPis().getCodigo().equals("04") || contasPisCofinsSpedCont.getIncidenciaPis().getCodigo().equals("06") || contasPisCofinsSpedCont.getIncidenciaPis().getCodigo().equals("07") || contasPisCofinsSpedCont.getIncidenciaPis().getCodigo().equals("08") || contasPisCofinsSpedCont.getIncidenciaPis().getCodigo().equals("09") || contasPisCofinsSpedCont.getIncidenciaPis().getCodigo().equals("49") || contasPisCofinsSpedCont.getIncidenciaPis().getCodigo().equals("99")) {
            vo.setIndOper(Short.valueOf("2"));
        } else {
            vo.setIndOper(Short.valueOf("0"));
        }
        vo.setIndOrigCred(EnumConstSpedContF100IndOrig.OPERACAO_MERC_INTERNO_0.getEnumId());
        vo.setPlanoConta(planoConta);
        vo.setDataOper(lancamento.getDataLancamento());
        vo.setVrOper(lancamento.getValor());
        vo.setCstPis(contasPisCofinsSpedCont.getIncidenciaPis());
        vo.setCstCofins(contasPisCofinsSpedCont.getIncidenciaCofins());
        if (contasPisCofinsSpedCont.getAliquotaPis() > 0.0) {
            vo.setVrBcPis(lancamento.getValor());
            vo.setAliqPis(contasPisCofinsSpedCont.getAliquotaPis());
        }
        if (contasPisCofinsSpedCont.getAliquotaCofins() > 0.0) {
            vo.setVrBcCofins(lancamento.getValor());
            vo.setAliqCofins(contasPisCofinsSpedCont.getAliquotaCofins());
        }
        vo.setNatBcCredito(contasPisCofinsSpedCont.getNaturezaBCCredito());
        vo.setVrPis(ToolFormatter.arrredondarNumero((Double)(lancamento.getValor() * contasPisCofinsSpedCont.getAliquotaPis() / 100.0), (int)2));
        vo.setVrCofins(ToolFormatter.arrredondarNumero((Double)(lancamento.getValor() * contasPisCofinsSpedCont.getAliquotaCofins() / 100.0), (int)2));
        vo.setEmpresa(lancamento.getEmpresa());
        vo.setDataCadastro(new Date());
        return vo;
    }
}

