/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.tabelapreco;

import com.touchcomp.basementor.constants.enums.EnumConstIncrementarSubstituir;
import com.touchcomp.basementor.constants.enums.EnumConstPercentualValor;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.number.ToolNumber;

public class CompCalculosTabelaPreco {
    public Double calcValorVenda(Double valorCusto, Double margemLucro) {
        if (valorCusto == null) {
            valorCusto = 0.0;
        }
        if (margemLucro == null) {
            margemLucro = 0.0;
        }
        Double valorVenda = valorCusto + valorCusto * margemLucro / 100.0;
        return valorVenda;
    }

    public Double calcValorVenda(Double valorCusto, Double margemLucro, Integer nrCasasDec, Integer fracao) {
        Double valorVenda = this.calcValorVenda(valorCusto, margemLucro);
        valorVenda = this.ajustaValor(valorVenda, nrCasasDec, fracao);
        return valorVenda;
    }

    public Double calcValorMin(Double valorVenda, Double percMin) {
        if (valorVenda == null) {
            valorVenda = 0.0;
        }
        if (percMin == null) {
            percMin = 0.0;
        }
        valorVenda = valorVenda - valorVenda * percMin / 100.0;
        return valorVenda;
    }

    public Double calcValorMax(Double valorVenda, Double percMax) {
        if (valorVenda == null) {
            valorVenda = 0.0;
        }
        if (percMax == null) {
            percMax = 0.0;
        }
        valorVenda = valorVenda + valorVenda * percMax / 100.0;
        return valorVenda;
    }

    public Double calcPercMin(Double valorVenda, Double valorMin) {
        if (valorVenda == null) {
            return 0.0;
        }
        if (valorMin == null) {
            return 0.0;
        }
        if (valorMin == 0.0) {
            return 0.0;
        }
        Double perc = ToolNumber.calcDifPercentual((Double)valorVenda, (Double)valorMin);
        return Math.abs(perc);
    }

    public Double calcPercMax(Double valorVenda, Double valorMax) {
        if (valorVenda == null) {
            return 0.0;
        }
        if (valorMax == null) {
            return 0.0;
        }
        if (valorMax == 0.0) {
            return 0.0;
        }
        Double perc = ToolNumber.calcDifPercentual((Double)valorVenda, (Double)valorMax);
        return perc;
    }

    public Double calcMargemLucro(Double valorCusto, Double valorVenda) {
        if (valorCusto == null) {
            valorCusto = 0.0;
        }
        if (valorVenda == null) {
            valorVenda = 0.0;
        }
        Double margemLucro = 0.0;
        if (valorCusto > 0.0) {
            margemLucro = (valorVenda - valorCusto) * 100.0 / valorCusto;
        }
        return margemLucro;
    }

    public Double calcMargemLucro(Double margemBase, EnumConstIncrementarSubstituir operador, Double margemAdicional) {
        if (margemBase == null) {
            margemBase = 0.0;
        }
        if (margemAdicional == null) {
            margemAdicional = 0.0;
        }
        if (ToolMethods.isEquals((Object)operador, (Object)EnumConstIncrementarSubstituir.INCREMENTAR)) {
            return margemBase + margemAdicional;
        }
        if (ToolMethods.isEquals((Object)operador, (Object)EnumConstIncrementarSubstituir.SUBSTITUIR)) {
            return margemAdicional;
        }
        return margemBase - margemAdicional;
    }

    public Double calcValorVenda(Double valorVendaBase, EnumConstIncrementarSubstituir operador, Double valorVenda, EnumConstPercentualValor opcaoValor) {
        if (valorVendaBase == null) {
            valorVendaBase = 0.0;
        }
        if (valorVenda == null) {
            valorVenda = 0.0;
        }
        if (opcaoValor.equals((Object)EnumConstPercentualValor.PERCENTUAL)) {
            valorVenda = valorVendaBase * valorVenda / 100.0;
        }
        if (ToolMethods.isEquals((Object)operador, (Object)EnumConstIncrementarSubstituir.INCREMENTAR)) {
            return valorVendaBase + valorVenda;
        }
        if (ToolMethods.isEquals((Object)operador, (Object)EnumConstIncrementarSubstituir.SUBSTITUIR)) {
            return valorVenda;
        }
        return valorVendaBase - valorVenda;
    }

    public Double calcValorVenda(Double valorVendaBase, EnumConstIncrementarSubstituir operador, Double valorVenda, EnumConstPercentualValor opcaoValor, Integer nrCasasDec, Integer fracao) {
        Double valorRet = this.calcValorVenda(valorVendaBase, operador, valorVenda, opcaoValor);
        valorRet = this.ajustaValor(valorRet, nrCasasDec, fracao);
        return valorRet;
    }

    public Double ajustaValor(Double valorRet, Integer nrCasasDec, Integer fracao) {
        return ToolNumber.arredondarNumero((Double)valorRet, (Integer)nrCasasDec, (Integer)fracao);
    }
}

