/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.titulos;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumTipoLancamentoCTBGerencial;
import com.touchcomp.basementor.model.vo.ClassificacaoClientes;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.MeioPagamento;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesFinanceirasTaxas;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.TituloRepresentante;
import com.touchcomp.basementorexceptions.exceptions.impl.titulo.EnumExcepTitulo;
import com.touchcomp.basementorexceptions.exceptions.impl.titulo.ExceptionTitulo;
import com.touchcomp.basementorservice.helpers.impl.condicoespagamento.HelperCondicoesPagamento;
import com.touchcomp.basementorservice.helpers.impl.lancamentoctbgerencial.HelperLancamentoCtbGerencial;
import com.touchcomp.basementorservice.helpers.impl.opcoes.opcoesfinanceiras.HelperOpcoesFinanceiras;
import com.touchcomp.basementorservice.helpers.impl.titulo.HelperTitulos;
import com.touchcomp.basementorservice.service.impl.feriado.ServiceFeriadoImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public abstract class BaseTitulo<E> {
    protected List<Titulo> getTitulosMutanteInternal(CondicoesPagamento cd, Pessoa p, Double valorTotalNota, PlanoConta pc, Double percComissao, String parcelas, Short tipoPessoa, Short pagRec, Short provReal, Date dataBase, String observacao, Date dataEmissao, Date dataEntradaSaida, Date dataCadastro, Date dataCompetencia, Empresa empresa, OpcoesFinanceiras opcoes, MeioPagamento meioPagamento, ClassificacaoClientes classificacaoPessoa) throws ExceptionTitulo {
        List<Integer> parc = ((HelperCondicoesPagamento)Context.get(HelperCondicoesPagamento.class)).getParcelas(parcelas);
        if (parc.isEmpty()) {
            throw new ExceptionTitulo(EnumExcepTitulo.CONDICAO_PAG_INVALIDA, new Object[]{cd.getNome() + " - " + p.getNome()});
        }
        if (pc == null) {
            throw new ExceptionTitulo(EnumExcepTitulo.PLANO_CONTA_CONTABIL_NAO_INF, new Object[]{p});
        }
        if (valorTotalNota <= 0.0) {
            return new ArrayList<Titulo>();
        }
        ArrayList<Titulo> ret = new ArrayList<Titulo>();
        Double valorTitulo = valorTotalNota / (double)parc.size();
        Double valorAux = 0.0;
        valorTitulo = this.arrredondarNumero(valorTitulo, 2);
        valorTotalNota = this.arrredondarNumero(valorTotalNota, 2);
        for (short i = 1; i <= parc.size(); i = (short)(i + 1)) {
            Date dataTitulo = ToolDate.nextDays((Date)dataBase, (int)parc.get(i - 1));
            if (i == parc.size()) {
                valorTitulo = valorTotalNota - valorAux;
            } else {
                valorAux = i == 1 ? Double.valueOf(valorAux + valorTitulo) : Double.valueOf(valorAux + valorTitulo);
            }
            if (cd.getExcluirDiasNaoUteis() != null && cd.getExcluirDiasNaoUteis() == 1) {
                dataTitulo = this.getDataVencimentoDiasNaoUteis(dataTitulo, empresa);
            }
            Titulo t = this.newTitulo(p, pc, tipoPessoa, pagRec, provReal, dataTitulo, observacao, dataEmissao, dataTitulo, dataCadastro, dataCompetencia, empresa, opcoes, i, parc.size(), valorTitulo, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, meioPagamento, cd, classificacaoPessoa);
            ret.add(t);
        }
        this.setarPercJurosMultaDesconto(ret, opcoes);
        return ret;
    }

    protected Double arrredondarNumero(Double numero, int casasDec) {
        return ToolFormatter.arrredondarNumero((Double)numero, (int)casasDec);
    }

    protected List<Titulo> getTitulosNaoMutanteInternal(CondicoesPagamento cd, Pessoa p, Double valorTotalNota, PlanoConta pc, Double percComissao, Short tipoPessoa, Short pagRec, Short provReal, Date dataTitulo, String observacao, Date dataEmissao, Date dataEntradaSaida, Date dataCadastro, Date dataCompetencia, Empresa empresa, OpcoesFinanceiras opcoes, MeioPagamento meioPagamento, ClassificacaoClientes classificacaoPessoa) throws ExceptionTitulo {
        ArrayList<Titulo> ret = new ArrayList<Titulo>();
        if (pc == null) {
            throw new ExceptionTitulo(EnumExcepTitulo.PLANO_CONTA_CONTABIL_NAO_INF, new Object[]{p});
        }
        if (valorTotalNota != 0.0) {
            if (cd == null) {
                return new ArrayList<Titulo>();
            }
            short s = cd.getNumeroParcelas().intValue();
            Double valorTitulo = valorTotalNota / (double)s;
            Double valorAux = 0.0;
            valorTitulo = this.arrredondarNumero(valorTitulo, 2);
            valorTotalNota = this.arrredondarNumero(valorTotalNota, 2);
            for (short i = 1; i <= s; i = (short)(i + 1)) {
                if (cd.getEntrada() != 1 || i != 1) {
                    dataTitulo = ToolDate.nextDays((Date)dataTitulo, (int)cd.getNumeroDiasVencimento());
                }
                if (i == s) {
                    valorTitulo = valorTotalNota - valorAux;
                } else {
                    valorAux = i == 1 ? Double.valueOf(valorAux + valorTitulo) : Double.valueOf(valorAux + valorTitulo);
                }
                if (cd.getExcluirDiasNaoUteis() != null && cd.getExcluirDiasNaoUteis() == 1) {
                    dataTitulo = this.getDataVencimentoDiasNaoUteis(dataTitulo, empresa);
                }
                Titulo t = this.newTitulo(p, pc, tipoPessoa, pagRec, provReal, dataTitulo, observacao, dataEmissao, dataTitulo, dataCadastro, dataCompetencia, empresa, opcoes, i, s, valorTitulo, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, meioPagamento, cd, classificacaoPessoa);
                ret.add(t);
            }
        }
        this.setarPercJurosMultaDesconto(ret, opcoes);
        return ret;
    }

    protected Double getValorTotalTitulos(List<Titulo> titulos) {
        if (titulos == null) {
            return 0.0;
        }
        Double valorTotal = 0.0;
        for (Titulo t : titulos) {
            valorTotal = valorTotal + t.getValor();
        }
        return valorTotal;
    }

    protected String getNrTituloBaixadoFromBDError(String msg) {
        String aux;
        int end;
        int init = msg.indexOf("@");
        if (init > -1 && (end = (aux = msg.substring(init + 1)).indexOf("@")) > -1) {
            return aux.substring(0, end);
        }
        return "";
    }

    protected Titulo newTitulo(Pessoa p, PlanoConta pc, Short tipoPessoa, Short pagRec, Short provisionadoRealizado, Date dataVencimento, String observacao, Date dataEmissao, Date dataEntradaSaida, Date dataCadastro, Date dataCompetencia, Empresa empresa, OpcoesFinanceiras opcoes, short parcela, int numParc, double valorTitulo, double multa, double multaEmbutida, double juros, double jurosEmbutido, double valorAdicional, double desconto, MeioPagamento meioPagamento, CondicoesPagamento cp, ClassificacaoClientes classificacaoPessoa) {
        return this.newTitulo(new Titulo(), p, pc, tipoPessoa, pagRec, provisionadoRealizado, dataVencimento, observacao, dataEmissao, dataEntradaSaida, dataCadastro, dataCompetencia, empresa, opcoes, parcela, numParc, valorTitulo, multa, multaEmbutida, juros, jurosEmbutido, valorAdicional, desconto, meioPagamento, cp, classificacaoPessoa);
    }

    protected Titulo newTitulo(Pessoa p, PlanoConta pc, Short tipoPessoa, Short pagRec, Short provisionadoRealizado, Date dataVencimento, String observacao, Date dataEmissao, Date dataEntradaSaida, Date dataCompetencia, Empresa empresa, OpcoesFinanceiras opcoes, double valorTitulo, MeioPagamento meioPagamento, ClassificacaoClientes classificacaoPessoa) {
        short parcela = 1;
        int numParc = 1;
        return this.newTitulo(p, pc, tipoPessoa, pagRec, provisionadoRealizado, dataVencimento, observacao, dataEmissao, dataEntradaSaida, dataCompetencia, empresa, opcoes, parcela, numParc, valorTitulo, meioPagamento, classificacaoPessoa);
    }

    protected Titulo newTitulo(Pessoa p, PlanoConta pc, Short tipoPessoa, Short pagRec, Short provisionadoRealizado, Date dataVencimento, String observacao, Date dataEmissao, Date dataEntradaSaida, Date dataCompetencia, Empresa empresa, OpcoesFinanceiras opcoes, short parcela, int numParc, double valorTitulo, MeioPagamento meioPagamento, ClassificacaoClientes classificacaoPessoa) {
        double multa = 0.0;
        double multaEmbutida = 0.0;
        double juros = 0.0;
        double jurosEmbutido = 0.0;
        double valorAdicional = 0.0;
        double desconto = 0.0;
        Date dataCadastro = new Date();
        CondicoesPagamento cp = null;
        return this.newTitulo(new Titulo(), p, pc, tipoPessoa, pagRec, provisionadoRealizado, dataVencimento, observacao, dataEmissao, dataEntradaSaida, dataCadastro, dataCompetencia, empresa, opcoes, parcela, numParc, valorTitulo, multa, multaEmbutida, juros, jurosEmbutido, valorAdicional, desconto, meioPagamento, cp, classificacaoPessoa);
    }

    protected Titulo newTitulo(Titulo t, Pessoa p, PlanoConta pc, Short tipoPessoa, Short pagRec, Short provisionadoRealizado, Date dataVencimento, String observacao, Date dataEmissao, Date dataEntradaSaida, Date dataCadastro, Date dataCompetencia, Empresa empresa, OpcoesFinanceiras opcoes, short parcela, int numParc, double valorTitulo, double multa, double multaEmbutida, double juros, double jurosEmbutido, double valorAdicional, double desconto, MeioPagamento meioPagamento, CondicoesPagamento cp, ClassificacaoClientes classificacaoPessoa) {
        if (p == null) {
            return null;
        }
        if (t == null) {
            t = new Titulo();
        }
        t.setPagRec(pagRec);
        t.setProvisao(provisionadoRealizado);
        HelperOpcoesFinanceiras helperOpFin = (HelperOpcoesFinanceiras)Context.get(HelperOpcoesFinanceiras.class);
        if (helperOpFin != null) {
            t.setCarteiraCobranca(helperOpFin.build(opcoes).getCarteiraCobranca(pagRec));
            t.setCartCobrancaDestino(helperOpFin.build(opcoes).getCarteiraCobrancaDestino(p, cp));
        }
        t.setTipoDoc(opcoes.getTipoDocFinanceiro());
        if (observacao == null || observacao.trim().isEmpty()) {
            t.setObservacao("Titulo " + parcela + "/" + numParc);
        } else {
            t.setObservacao(observacao + "(" + parcela + "/" + numParc + ")");
        }
        t.setNumeroParcelas(Short.valueOf((short)numParc));
        t.setValor(Double.valueOf(valorTitulo));
        t.setValorMultaEmbutida(Double.valueOf(multaEmbutida));
        t.setValorJurosEmbutido(Double.valueOf(jurosEmbutido));
        t.setPercMulta(Double.valueOf(multa));
        t.setPercJurosMes(Double.valueOf(juros));
        t.setDescontoFinanceiro(Double.valueOf(desconto));
        t.setValorAdicional(Double.valueOf(valorAdicional));
        t.setNumParcTituloEstnota(Short.valueOf(parcela));
        t.setPessoa(p);
        t.setClassificacaoPessoa(classificacaoPessoa);
        t.setTipoPessoa(tipoPessoa);
        t.setDataEmissao(dataEmissao);
        t.setDataVencimento(dataVencimento);
        t.setDataVencimentoBase(dataVencimento);
        t.setDataCompetencia(dataCompetencia);
        t.setDataEntradaSaida(t.getDataCompetencia());
        t.setEmpresa(empresa);
        t.setDataCadastro(dataCadastro);
        t.setPlanoConta(pc);
        if (pagRec == 1) {
            // empty if block
        }
        t.setMeioPagamento(meioPagamento);
        this.setarJurosMultaDescontoTitulo(t, opcoes);
        return t;
    }

    public void setarJurosMultaDescontoTitulo(Titulo tit, OpcoesFinanceiras opcoes) {
        HelperTitulos helper = (HelperTitulos)Context.get(HelperTitulos.class);
        if (helper != null) {
            helper.setarPercJurosMultaDesconto(tit, opcoes);
        }
    }

    private Date getDataVencimentoDiasNaoUteis(Date dataEmissao, Empresa empresa) {
        Date data = dataEmissao;
        Integer diaSemana = ToolDate.diaDaSemana((Date)dataEmissao);
        if (diaSemana.equals(7)) {
            data = ToolDate.nextDays((Date)data, (int)1);
            diaSemana = 1;
        }
        if (diaSemana.equals(1)) {
            data = ToolDate.nextDays((Date)data, (int)1);
        }
        if (this.existeFeriado(data, empresa).booleanValue()) {
            diaSemana = ToolDate.diaDaSemana((Date)(data = ToolDate.nextDays((Date)data, (int)1)));
            if (diaSemana.equals(7)) {
                data = ToolDate.nextDays((Date)data, (int)1);
                diaSemana = 1;
            }
            if (diaSemana.equals(1)) {
                data = ToolDate.nextDays((Date)data, (int)1);
            }
        }
        return data;
    }

    private Boolean existeFeriado(Date data, Empresa empresa) {
        ServiceFeriadoImpl serviceFeriado = (ServiceFeriadoImpl)ConfApplicationContext.getBean(ServiceFeriadoImpl.class);
        return serviceFeriado.isFeriado(data, empresa);
    }

    private void setarPercJurosMultaDesconto(List<Titulo> titulos, OpcoesFinanceiras op) {
        for (Titulo t : titulos) {
            if (t.getPagRec() != 1) continue;
            Double percJuros = op.getPercJurosMes();
            Double percDesc = op.getPercDescMes();
            Double percMulta = op.getPercMulta();
            OpcoesFinanceirasTaxas opTaxas = this.getOpcoesFinanceirasTaxas(t.getMeioPagamento(), op);
            if (opTaxas != null) {
                percJuros = opTaxas.getPercJurosMes();
                percDesc = opTaxas.getPercDescMes();
                percMulta = opTaxas.getPercMulta();
            }
            if (percJuros != null) {
                t.setPercJurosMes(percJuros);
                t.setVrJurosDia(Double.valueOf(t.getValor() * (percJuros / 100.0) / 30.0));
            } else {
                t.setPercJurosMes(Double.valueOf(0.0));
                t.setVrJurosDia(Double.valueOf(0.0));
            }
            if (percDesc != null) {
                t.setPercDescontoMes(percDesc);
            } else {
                t.setPercDescontoMes(Double.valueOf(0.0));
            }
            if (percMulta != null) {
                t.setPercMulta(percMulta);
                continue;
            }
            t.setPercMulta(Double.valueOf(0.0));
        }
    }

    private OpcoesFinanceirasTaxas getOpcoesFinanceirasTaxas(MeioPagamento meioPagamento, OpcoesFinanceiras op) {
        if (meioPagamento != null) {
            for (OpcoesFinanceirasTaxas taxa : op.getTaxas()) {
                if (!taxa.getMeioPagamento().equals((Object)meioPagamento)) continue;
                return taxa;
            }
        }
        return null;
    }

    public void newAddTituloRepresentante(Titulo t, Representante representante, double percComissao, double vrBcComissao) {
        TituloRepresentante tr = new TituloRepresentante();
        tr.setPercComissao(Double.valueOf(percComissao));
        tr.setVrBCComissao(Double.valueOf(vrBcComissao));
        tr.setRepresentante(representante);
        tr.setTitulo(t);
        t.getRepresentantes().add(tr);
    }

    public void newAddLancamentoGerencial(Titulo t, PlanoContaGerencial pcGer, EnumTipoLancamentoCTBGerencial compLiq, String obs) {
        EnumLancamentoCTBGerencial debCred = EnumLancamentoCTBGerencial.DEBITO;
        if (TMethods.isEquals((Object[])new Object[]{(short)1})) {
            debCred = EnumLancamentoCTBGerencial.CREDITO;
        }
        Double valor = t.getValor();
        this.newAddLancamentoGerencial(t, pcGer, debCred, compLiq, obs, valor);
    }

    public void newAddLancamentoGerencial(Titulo t, PlanoContaGerencial pcGer, EnumLancamentoCTBGerencial debCred, EnumTipoLancamentoCTBGerencial compLiq, String obs, Double valor) {
        HelperLancamentoCtbGerencial helperLancGerencial = (HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class);
        LancamentoCtbGerencial l = helperLancGerencial.newLancamentoCtbGerencial(null, t.getDataCadastro(), t.getDataVencimento(), debCred.getValue(), t.getEmpresa(), EnumConstantsMentorSimNao.SIM.getValue(), obs, pcGer, t.getProvisao(), compLiq.getValue(), null, valor, null);
        t.getLancCtbGerencial().add(l);
    }
}

