/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.titulos.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumTipoLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.pessoa.EnumConstPessoa;
import com.touchcomp.basementor.model.interfaces.InterfaceStaticObjects;
import com.touchcomp.basementor.model.vo.BaixaTitulo;
import com.touchcomp.basementor.model.vo.ClassificacaoClientes;
import com.touchcomp.basementor.model.vo.CompensacaoChequeTerceiros;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.MeioPagamento;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.components.titulos.BaseTitulo;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Iterator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompGeraTituloChequeTerceiros
extends BaseTitulo<CompensacaoChequeTerceiros> {
    @Autowired
    InterfaceStaticObjects staticObjects;

    public void gerarTitulo(CompensacaoChequeTerceiros vo, PlanoContaGerencial pcGer, Empresa emp) {
        OpcoesFinanceiras opFinanceiros = this.staticObjects.getOpcoesFinanceiras(emp);
        OpcoesContabeis opContabeis = this.staticObjects.getOpcoesContabeis(emp);
        MeioPagamento meioPagamento = opFinanceiros.getMeioPagamento();
        if (opFinanceiros.getMeioPagamentoChequeDev() != null) {
            meioPagamento = opFinanceiros.getMeioPagamentoChequeDev();
        }
        ClassificacaoClientes classificacaoPessoa = opFinanceiros.getClassificacaoClientes();
        if (vo.getCheque().getClassificacaoPessoa() != null) {
            classificacaoPessoa = vo.getCheque().getClassificacaoPessoa();
        }
        PlanoConta pc = vo.getPlanoConta();
        if (!ToolMethods.isEquals((Object)opContabeis.getUsarContaDeUltimoBorderoParaTitulosDeChequesDevolvidos(), (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            pc = this.getPlanoConta(vo);
        }
        Titulo t = this.newTitulo(vo.getCheque().getPessoa(), pc, EnumConstPessoa.PESSOA.getEnumId(), (short)1, (short)1, vo.getCheque().getDataVencimento(), "obs", vo.getDataCompensacao(), vo.getDataCompensacao(), vo.getDataCompensacao(), emp, opFinanceiros, vo.getCheque().getValor(), meioPagamento, classificacaoPessoa);
        t.getRepresentantes().clear();
        this.newAddTituloRepresentante(t, vo.getCheque().getRepresentante(), 0.0, 0.0);
        t.getLancCtbGerencial().clear();
        String obs = MessagesBaseMentor.getMsg((String)"M.ERP.0331.001", (Object[])new Object[]{t.getPessoa().getNome()});
        this.newAddLancamentoGerencial(t, pcGer, EnumTipoLancamentoCTBGerencial.COMPETENCIA, obs);
        vo.setTitulo(t);
    }

    private PlanoConta getPlanoConta(CompensacaoChequeTerceiros vo) {
        Iterator iterator;
        if (vo.getCheque().getGrupoDeBaixaFormasRec() != null && (iterator = vo.getCheque().getGrupoDeBaixaFormasRec().getBaixaTitulo().iterator()).hasNext()) {
            BaixaTitulo baixaTitulo = (BaixaTitulo)iterator.next();
            return baixaTitulo.getTitulo().getPlanoConta();
        }
        if (vo.getCheque().getGrupoDeBaixaFormasPag() != null && (iterator = vo.getCheque().getGrupoDeBaixaFormasPag().getBaixaTitulo().iterator()).hasNext()) {
            BaixaTitulo baixaTitulo = (BaixaTitulo)iterator.next();
            return baixaTitulo.getTitulo().getPlanoConta();
        }
        return vo.getPlanoConta();
    }
}

