/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.titulos.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumTipoLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.pessoa.EnumConstPessoa;
import com.touchcomp.basementor.constants.enums.pessoa.EnumConstTipoPessoa;
import com.touchcomp.basementor.model.vo.Cooperado;
import com.touchcomp.basementor.model.vo.GeracaoTitulos;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.LancamentoEventoCooperado;
import com.touchcomp.basementor.model.vo.OpcoesContabeisBaixaTitulos;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.TipoValoresTitulosEventoCooperado;
import com.touchcomp.basementor.model.vo.TipoValoresTitulosTitulos;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.components.titulos.BaseTitulo;
import com.touchcomp.basementorservice.helpers.impl.lancamentoctbgerencial.HelperLancamentoCtbGerencial;
import com.touchcomp.basementorservice.service.impl.cooperado.ServiceCooperadoImpl;
import com.touchcomp.basementorservice.service.impl.opcoescontabeisbaixatitulos.ServiceOpcoesContabeisBaixaTitulosImpl;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class CompGeracaoTitulosImpl
extends BaseTitulo<GeracaoTitulos> {
    final ServiceOpcoesContabeisBaixaTitulosImpl serviceOpcoesContabeisBaixaTitulosImpl;
    final ServiceCooperadoImpl serviceCooperadoImpl;

    public CompGeracaoTitulosImpl(ServiceOpcoesContabeisBaixaTitulosImpl serviceOpcoesContabeisBaixaTitulosImpl, ServiceCooperadoImpl serviceCooperadoImpl) {
        this.serviceOpcoesContabeisBaixaTitulosImpl = serviceOpcoesContabeisBaixaTitulosImpl;
        this.serviceCooperadoImpl = serviceCooperadoImpl;
    }

    public List<Titulo> criaTituloPessoa(GeracaoTitulos vo, OpcoesFinanceiras opcoesFinanceiras) throws Exception {
        LinkedList<Titulo> titulos = new LinkedList<Titulo>();
        if (vo.getTipoPesquisa().equals((short)0)) {
            titulos.addAll(this.criaTituloPessoaInternal(vo, opcoesFinanceiras, vo.getPessoa()));
        } else {
            if (vo.getGrupoPessoas() == null) {
                return titulos;
            }
            for (Pessoa pessoa : vo.getGrupoPessoas().getPessoas()) {
                if (!ToolMethods.isEquals((Object)pessoa.getTipoPessoa(), (Object)EnumConstTipoPessoa.PESSOA_PRIMARIA.value) || !ToolMethods.isAffirmative((Number)pessoa.getAtivo())) continue;
                titulos.addAll(this.criaTituloPessoaInternal(vo, opcoesFinanceiras, pessoa));
            }
        }
        return titulos;
    }

    private List<Titulo> criaTituloPessoaInternal(GeracaoTitulos vo, OpcoesFinanceiras opcoesFinanceiras, Pessoa pessoa) throws Exception {
        Date dataVencimento = vo.getDataVencimentoInicial();
        Date dataEmissao = vo.getDataEmissao();
        Date dataEntrada = vo.getDataEmissao();
        Date dataCompetencia = vo.getDataCompetencia();
        Integer diaBaseVencimento = ToolDate.dayFromDate((Date)dataVencimento);
        int diasParcelas = vo.getDiasEntreParcelas();
        if (ToolMethods.isAffirmative((Number)vo.getGerarDatasFixas())) {
            diasParcelas = 30;
        }
        ArrayList<Titulo> titulos = new ArrayList<Titulo>();
        for (int nrParcela = 1; nrParcela <= vo.getNrParcelas(); ++nrParcela) {
            Titulo t = this.newTitulo(pessoa, vo.getPlanoConta(), EnumConstPessoa.PESSOA.getEnumId(), vo.getPagRec(), vo.getTipoTitulo(), dataVencimento, vo.getObservacao(), dataEmissao, dataEntrada, dataCompetencia, vo.getEmpresa(), opcoesFinanceiras, vo.getValorTitulo(), vo.getMeioPagamento(), vo.getClassificacaoPessoa());
            t.setAntecipado(vo.getAntecipado());
            t.setValor(Double.valueOf(t.getValor() + vo.getJurosEmbutidos()));
            t.setTipoDoc(vo.getTipoDoc());
            t.setLancContAdicDocFinanc(vo.getLancContAdicDocFinanc());
            t.setNumParcTituloEstnota(Short.valueOf((short)nrParcela));
            t.setNumeroParcelas(Short.valueOf(vo.getNrParcelas().shortValue()));
            t.setDescontoFinanceiro(vo.getDesconto());
            t.setPercJurosMes(vo.getPercentualJuros());
            t.setPercMulta(vo.getPercentualMulta());
            if (ToolMethods.isWithData((Number)t.getPercJurosMes())) {
                t.setVrJurosDia(Double.valueOf(t.getValor() * (t.getPercJurosMes() / 100.0) / 30.0));
            } else {
                t.setVrJurosDia(Double.valueOf(0.0));
            }
            t.setValorJurosEmbutido(vo.getJurosEmbutidos());
            t.setDataLimiteDesconto(vo.getDataLimiteDesconto());
            t.setNrDocOrigemManual(vo.getNrDocOrigem());
            this.setDadosEventoCooperado(t, vo);
            t.setLancCtbGerencial(this.getLancamentoGerencial(t, vo));
            titulos.add(t);
            if (ToolMethods.isAffirmative((Number)vo.getVariarDataCompetencia())) {
                dataCompetencia = ToolDate.nextDays((Date)dataCompetencia, (int)diasParcelas);
            }
            if (ToolMethods.isAffirmative((Number)vo.getVariarDataEmissao())) {
                dataEmissao = ToolDate.nextDays((Date)dataEmissao, (int)diasParcelas);
            }
            if (ToolMethods.isAffirmative((Number)vo.getVariarDataEntSai())) {
                dataEntrada = ToolDate.nextDays((Date)dataEntrada, (int)diasParcelas);
            }
            if (!ToolMethods.isAffirmative((Number)vo.getGerarDatasFixas())) continue;
            dataCompetencia = ToolDate.asDate((LocalDate)ToolDate.formatarLocalDate((Date)dataCompetencia).withDayOfMonth(diaBaseVencimento));
            dataEmissao = ToolDate.asDate((LocalDate)ToolDate.formatarLocalDate((Date)dataCompetencia).withDayOfMonth(diaBaseVencimento));
            dataEntrada = ToolDate.asDate((LocalDate)ToolDate.formatarLocalDate((Date)dataCompetencia).withDayOfMonth(diaBaseVencimento));
        }
        return titulos;
    }

    private List<LancamentoCtbGerencial> getLancamentoGerencial(Titulo t, GeracaoTitulos vo) throws Exception {
        Double valorTitulo = t.getValor();
        Double valorJurosEmbutidos = t.getValorJurosEmbutido();
        OpcoesContabeisBaixaTitulos opcoesContabeisBaixaTitulos = this.serviceOpcoesContabeisBaixaTitulosImpl.findOpcaoContabilBaixaTituloComFormaPagCache(t.getPagRec(), t.getTipoDoc(), t.getClassificacaoPessoa(), (short)1, vo.getEmpresa());
        ArrayList<LancamentoCtbGerencial> lanc = new ArrayList<LancamentoCtbGerencial>();
        LancamentoCtbGerencial l = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, t.getDataCompetencia(), t.getDataVencimento(), ToolMethods.isEquals((Object)t.getPagRec(), (Object)0) ? EnumLancamentoCTBGerencial.DEBITO.getValue() : EnumLancamentoCTBGerencial.CREDITO.getValue(), t.getEmpresa(), EnumConstantsMentorSimNao.NAO.getValue(), vo.getObservacao(), vo.getPlanoContaGerencial(), t.getProvisao(), EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue(), vo.getCentroCusto(), valorTitulo - valorJurosEmbutidos, null);
        PlanoContaGerencial p = vo.getPagRec().equals((short)0) ? opcoesContabeisBaixaTitulos.getPlanoGerencialJurosEmbutidosPag() : opcoesContabeisBaixaTitulos.getPlanoGerencialJurosEmbutidosRec();
        if (valorJurosEmbutidos > 0.0 && p != null) {
            LancamentoCtbGerencial ll = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, t.getDataCompetencia(), t.getDataVencimento(), ToolMethods.isEquals((Object)t.getPagRec(), (Object)0) ? EnumLancamentoCTBGerencial.DEBITO.getValue() : EnumLancamentoCTBGerencial.CREDITO.getValue(), t.getEmpresa(), EnumConstantsMentorSimNao.NAO.getValue(), vo.getObservacao(), p, t.getProvisao(), EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue(), vo.getCentroCusto(), valorJurosEmbutidos, null);
            lanc.add(l);
            lanc.add(ll);
        } else {
            l.setValor(valorTitulo);
            lanc.add(l);
        }
        return lanc;
    }

    private void setDadosEventoCooperado(Titulo t, GeracaoTitulos vo) throws ExceptionObjNotFound {
        if (!ToolMethods.isAffirmative((Number)vo.getGerarEvtCooperado())) {
            return;
        }
        if (vo.getEventoCooperado() == null) {
            return;
        }
        Double valorPercentualEventoCooperado = 0.0;
        for (TipoValoresTitulosEventoCooperado j : vo.getEventoCooperado().getTipoValoresTitulosEventoCooperado()) {
            valorPercentualEventoCooperado = valorPercentualEventoCooperado + j.getValor() / 100.0 * t.getValor();
            TipoValoresTitulosTitulos tipoValoresTitulosTitulos = new TipoValoresTitulosTitulos();
            tipoValoresTitulosTitulos.setTitulo(t);
            tipoValoresTitulosTitulos.setTipoValoresTitulos(j.getTipoValoresTitulos());
            tipoValoresTitulosTitulos.setValor(Double.valueOf(j.getValor() / 100.0 * t.getValor()));
            t.getTipoValoresTitulosTitulos().add(tipoValoresTitulosTitulos);
        }
        t.setValor(Double.valueOf(t.getValor() + valorPercentualEventoCooperado));
        if (!ToolMethods.isAffirmative((Number)vo.getGerarLancCooperado())) {
            return;
        }
        Cooperado cooperado = this.serviceCooperadoImpl.findCooperadoOrThrow(t.getPessoa());
        LancamentoEventoCooperado lancCooperado = new LancamentoEventoCooperado();
        lancCooperado.setDataCadastro(new Date());
        lancCooperado.setEmpresa(vo.getEmpresa());
        lancCooperado.setDataMovimento(t.getDataCompetencia());
        lancCooperado.setEventoCooperado(vo.getEventoCooperado());
        lancCooperado.setCooperado(cooperado);
        lancCooperado.getTitulos().add(t);
        t.setLancamentoCooperado(lancCooperado);
        lancCooperado.setValorOperacao(vo.getValorTitulo());
        lancCooperado.setObservacao(vo.getObservacao());
        lancCooperado.setGeracaoTitulo(vo);
        if (vo.getEventoCooperado().getHistoricoPadrao() != null) {
            lancCooperado.setHistoricoPadrao(vo.getEventoCooperado().getHistoricoPadrao());
            lancCooperado.setHistorico(vo.getEventoCooperado().getHistoricoPadrao().getDescricao());
        }
        vo.getLancamentosEventos().add(lancCooperado);
    }
}

