/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.titulos.impl;

import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumTipoLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.opcoescontabeis.EnumConstImpostosRetidos;
import com.touchcomp.basementor.constants.enums.pessoa.EnumConstPessoa;
import com.touchcomp.basementor.constants.enums.titulo.EnumConstTituloPagRec;
import com.touchcomp.basementor.constants.enums.titulo.EnumConstTituloProvReal;
import com.touchcomp.basementor.model.interfaces.InterfaceStaticObjects;
import com.touchcomp.basementor.model.vo.ApuracaoReinf;
import com.touchcomp.basementor.model.vo.ItemReinf4020;
import com.touchcomp.basementor.model.vo.ItemReinfNotas4020;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesContabeisImpostosRetidos;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.components.opcoes.CompOpcoesContabeis;
import com.touchcomp.basementorservice.components.titulos.BaseTitulo;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompGerarTitulosImpostosReinf
extends BaseTitulo<Titulo> {
    @Autowired
    InterfaceStaticObjects staticObjects;

    public List<Titulo> criarTitulos(ApuracaoReinf apuracaoReinf) throws ExceptionInvalidData {
        OpcoesContabeis opcoesContabeis = this.staticObjects.getOpcoesContabeis(apuracaoReinf.getEmpresa());
        OpcoesFinanceiras opcoesFinanceiras = this.staticObjects.getOpcoesFinanceiras(apuracaoReinf.getEmpresa());
        if (ToolMethods.isNull((Object)opcoesContabeis).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.1757.001", new Object[]{opcoesContabeis});
        }
        Double valorPis = 0.0;
        Double valorCofins = 0.0;
        Double valorCsll = 0.0;
        Double valorAgregado = 0.0;
        for (ItemReinf4020 itemReinf4020 : apuracaoReinf.getItensReinf4020()) {
            for (ItemReinfNotas4020 itemReinfNotas4020 : itemReinf4020.getItensNotas()) {
                valorPis = valorPis + itemReinfNotas4020.getValorPis();
                valorCofins = valorCofins + itemReinfNotas4020.getValorCofins();
                valorCsll = valorCsll + itemReinfNotas4020.getValorCsll();
                valorAgregado = valorAgregado + itemReinfNotas4020.getValorAgregado();
            }
        }
        return this.criarTitulosApuracao(apuracaoReinf, valorPis, valorCofins, valorCsll, valorAgregado, opcoesContabeis, opcoesFinanceiras);
    }

    private List<Titulo> criarTitulosApuracao(ApuracaoReinf apuracaoReinf, Double valorPis, Double valorCofins, Double valorCsll, Double valorAgregado, OpcoesContabeis opcoesContabeis, OpcoesFinanceiras opcoesFinanceiras) {
        Titulo titulo;
        Date data;
        ArrayList<Titulo> listTitulo = new ArrayList<Titulo>();
        if (ToolMethods.isWithData((Number)valorPis)) {
            OpcoesContabeisImpostosRetidos pis = CompOpcoesContabeis.getOpcoesImpostoRetido(opcoesContabeis, EnumConstImpostosRetidos.PIS);
            data = ToolDate.intToDate((Integer)ToolDate.getYearFromDate((Date)apuracaoReinf.getPeriodo()), (Integer)ToolDate.monthFromDate((Date)ToolDate.nextMonth((Date)apuracaoReinf.getPeriodo(), (int)1)), (Integer)pis.getDiaVencimentoImpostoRetido().intValue());
            titulo = this.newTitulo(pis.getPessoaImpostoRetido(), pis.getPlanoContaImpostoRetido(), EnumConstPessoa.PESSOA.getEnumId(), EnumConstTituloPagRec.TIPO_TITULO_PAG.getValue(), EnumConstTituloProvReal.REALIZADO.getValue(), data, "Titulo Referente ao PIS apurado em: " + String.valueOf(apuracaoReinf.getPeriodo()), data, data, data, apuracaoReinf.getEmpresa(), opcoesFinanceiras, valorPis, opcoesFinanceiras.getMeioPagamentoTituloRetido(), opcoesFinanceiras.getClassificacaoClientes());
            this.newAddLancamentoGerencial(titulo, pis.getPlanoContaGerencialImpostoRetido(), EnumLancamentoCTBGerencial.DEBITO, EnumTipoLancamentoCTBGerencial.COMPETENCIA, "Titulo Referente ao PIS apurado em: " + String.valueOf(apuracaoReinf.getPeriodo()), valorPis);
            listTitulo.add(titulo);
        }
        if (ToolMethods.isWithData((Number)valorCofins)) {
            OpcoesContabeisImpostosRetidos cofins = CompOpcoesContabeis.getOpcoesImpostoRetido(opcoesContabeis, EnumConstImpostosRetidos.COFINS);
            data = ToolDate.intToDate((Integer)ToolDate.getYearFromDate((Date)apuracaoReinf.getPeriodo()), (Integer)ToolDate.monthFromDate((Date)ToolDate.nextMonth((Date)apuracaoReinf.getPeriodo(), (int)1)), (Integer)cofins.getDiaVencimentoImpostoRetido().intValue());
            titulo = this.newTitulo(cofins.getPessoaImpostoRetido(), cofins.getPlanoContaImpostoRetido(), EnumConstPessoa.PESSOA.getEnumId(), EnumConstTituloPagRec.TIPO_TITULO_PAG.getValue(), EnumConstTituloProvReal.REALIZADO.getValue(), data, "Titulo Referente ao COFINS apurado em: " + String.valueOf(apuracaoReinf.getPeriodo()), data, data, data, apuracaoReinf.getEmpresa(), opcoesFinanceiras, valorCofins, opcoesFinanceiras.getMeioPagamentoTituloRetido(), opcoesFinanceiras.getClassificacaoClientes());
            this.newAddLancamentoGerencial(titulo, cofins.getPlanoContaGerencialImpostoRetido(), EnumLancamentoCTBGerencial.DEBITO, EnumTipoLancamentoCTBGerencial.COMPETENCIA, "Titulo Referente ao COFINS apurado em: " + String.valueOf(apuracaoReinf.getPeriodo()), valorCofins);
            listTitulo.add(titulo);
        }
        if (ToolMethods.isWithData((Number)valorCsll)) {
            OpcoesContabeisImpostosRetidos csll = CompOpcoesContabeis.getOpcoesImpostoRetido(opcoesContabeis, EnumConstImpostosRetidos.CSLL);
            data = ToolDate.intToDate((Integer)ToolDate.getYearFromDate((Date)apuracaoReinf.getPeriodo()), (Integer)ToolDate.monthFromDate((Date)ToolDate.nextMonth((Date)apuracaoReinf.getPeriodo(), (int)1)), (Integer)csll.getDiaVencimentoImpostoRetido().intValue());
            titulo = this.newTitulo(csll.getPessoaImpostoRetido(), csll.getPlanoContaImpostoRetido(), EnumConstPessoa.PESSOA.getEnumId(), EnumConstTituloPagRec.TIPO_TITULO_PAG.getValue(), EnumConstTituloProvReal.REALIZADO.getValue(), data, "Titulo Referente ao CSLL apurado em: " + String.valueOf(apuracaoReinf.getPeriodo()), data, data, data, apuracaoReinf.getEmpresa(), opcoesFinanceiras, valorCsll, opcoesFinanceiras.getMeioPagamentoTituloRetido(), opcoesFinanceiras.getClassificacaoClientes());
            this.newAddLancamentoGerencial(titulo, csll.getPlanoContaGerencialImpostoRetido(), EnumLancamentoCTBGerencial.DEBITO, EnumTipoLancamentoCTBGerencial.COMPETENCIA, "Titulo Referente ao CSLL apurado em: " + String.valueOf(apuracaoReinf.getPeriodo()), valorCsll);
            listTitulo.add(titulo);
        }
        if (ToolMethods.isWithData((Number)valorAgregado)) {
            OpcoesContabeisImpostosRetidos lei10833 = CompOpcoesContabeis.getOpcoesImpostoRetido(opcoesContabeis, EnumConstImpostosRetidos.LEI_10833);
            data = ToolDate.intToDate((Integer)ToolDate.getYearFromDate((Date)apuracaoReinf.getPeriodo()), (Integer)ToolDate.monthFromDate((Date)ToolDate.nextMonth((Date)apuracaoReinf.getPeriodo(), (int)1)), (Integer)lei10833.getDiaVencimentoImpostoRetido().intValue());
            titulo = this.newTitulo(lei10833.getPessoaImpostoRetido(), lei10833.getPlanoContaImpostoRetido(), EnumConstPessoa.PESSOA.getEnumId(), EnumConstTituloPagRec.TIPO_TITULO_PAG.getValue(), EnumConstTituloProvReal.REALIZADO.getValue(), data, "Titulo Referente ao AGREGADO apurado em: " + String.valueOf(apuracaoReinf.getPeriodo()), data, data, data, apuracaoReinf.getEmpresa(), opcoesFinanceiras, valorAgregado, opcoesFinanceiras.getMeioPagamentoTituloRetido(), opcoesFinanceiras.getClassificacaoClientes());
            this.newAddLancamentoGerencial(titulo, lei10833.getPlanoContaGerencialImpostoRetido(), EnumLancamentoCTBGerencial.DEBITO, EnumTipoLancamentoCTBGerencial.COMPETENCIA, "Titulo Referente ao AGREGADO apurado em: " + String.valueOf(apuracaoReinf.getPeriodo()), valorAgregado);
            listTitulo.add(titulo);
        }
        return listTitulo;
    }
}

