/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.titulos.impl;

import com.touchcomp.basementor.constants.enums.pessoa.EnumConstPessoa;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemOrdemCompra;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OrdemCompra;
import com.touchcomp.basementor.model.vo.OrdemCompraVencimentos;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.titulo.EnumExcepTitulo;
import com.touchcomp.basementorexceptions.exceptions.impl.titulo.ExceptionTitulo;
import com.touchcomp.basementorservice.components.lancamentoctbgerencial.CompGeracaoLancCtbGerencial;
import com.touchcomp.basementorservice.components.titulos.BaseTitulo;
import com.touchcomp.basementorservice.service.impl.planoconta.SCompPlanoConta;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompGerarTitulosOrdemCompra
extends BaseTitulo<Titulo> {
    @Autowired
    SCompPlanoConta compPlanoConta;

    public HashMap getValorFinanceiroOC(List<ItemOrdemCompra> itens) {
        HashMap<String, Double> h = new HashMap<String, Double>();
        Double valor = 0.0;
        Double valorIcmsSt = 0.0;
        for (ItemOrdemCompra o : itens) {
            ItemOrdemCompra i = o;
            if (i.getModeloFiscal() == null || i.getModeloFiscal().getGerarFinanceiro() != 1) continue;
            valor = valor + i.getItemOrdemCompraLF().getValorTotal();
            valorIcmsSt = valorIcmsSt + i.getItemOrdemCompraLF().getVrIcmsSt();
        }
        h.put("valorTotal", valor);
        h.put("valorICMSST", valorIcmsSt);
        h.put("valorTotalICMSST", valor + valorIcmsSt);
        return h;
    }

    public List criarTitulos(OrdemCompra vo, OpcoesFinanceiras opcoes, OpcoesContabeis opcoesContabeis) throws ExceptionTitulo, ExceptionInvalidData {
        List<Object> titulos = new ArrayList();
        Double valorTotalNota = (Double)this.getValorFinanceiroOC(vo.getItemOrdemCompra()).get("valorTotal");
        if (valorTotalNota == 0.0) {
            vo.setTitulos(new ArrayList());
            vo.setVencimentosOrdemCompra(new ArrayList());
            return vo.getTitulos();
        }
        Date dataBase = vo.getDataPrevFaturamento();
        if (vo.getTipoDataTitulo() != null && vo.getTipoDataTitulo() == 0) {
            dataBase = vo.getDataEmissao();
        }
        String obs = "Ordem Compra: " + vo.getUnidadeFatFornecedor().getFornecedor().getPessoa().getNome();
        titulos = vo.getCondicaoPagamento().getCondMutante() != null && vo.getCondicaoPagamento().getCondMutante() == 1 ? this.getTitulosMutanteInternal(vo.getCondicaoPagamento(), vo.getUnidadeFatFornecedor().getFornecedor().getPessoa(), valorTotalNota, this.compPlanoConta.getPlanoConta(vo.getUnidadeFatFornecedor().getFornecedor(), opcoesContabeis), 0.0, vo.getParcelas(), EnumConstPessoa.FORNECEDOR.getEnumId(), (short)0, (short)0, dataBase, obs, vo.getDataEmissao(), vo.getDataEmissao(), vo.getDataCadastro(), vo.getDataEmissao(), vo.getEmpresa(), opcoes, vo.getCondicaoPagamento().getMeioPagamento(), vo.getUnidadeFatFornecedor().getFornecedor().getClassificacaoPessoa()) : this.getTitulosNaoMutanteInternal(vo.getCondicaoPagamento(), vo.getUnidadeFatFornecedor().getFornecedor().getPessoa(), valorTotalNota, this.compPlanoConta.getPlanoConta(vo.getUnidadeFatFornecedor().getFornecedor(), opcoesContabeis), 0.0, EnumConstPessoa.FORNECEDOR.getEnumId(), (short)0, (short)0, dataBase, obs, vo.getDataEmissao(), vo.getDataEmissao(), vo.getDataCadastro(), vo.getDataEmissao(), vo.getEmpresa(), opcoes, vo.getCondicaoPagamento().getMeioPagamento(), vo.getUnidadeFatFornecedor().getFornecedor().getClassificacaoPessoa());
        for (Titulo titulo : titulos) {
            titulo.setOrdemCompra(vo);
        }
        this.criarLancamentosCTBGerencial(vo, titulos, vo.getEmpresa());
        vo.getTitulos().clear();
        vo.getTitulos().addAll(titulos);
        vo.getVencimentosOrdemCompra().clear();
        vo.getVencimentosOrdemCompra().addAll(this.getPrevVencimentosOC(vo));
        return titulos;
    }

    public void validarValoresTitulos(OrdemCompra vo) throws ExceptionTitulo {
        Double valorTotalNota = (Double)this.getValorFinanceiroOC(vo.getItemOrdemCompra()).get("valorTotal");
        Double valorTitulos = 0.0;
        if (vo.getTitulos() != null && !vo.getTitulos().isEmpty()) {
            for (Object o : vo.getTitulos()) {
                Titulo t = (Titulo)o;
                valorTitulos = valorTitulos + t.getValor();
            }
            BigDecimal bd = new BigDecimal(valorTitulos);
            bd = bd.setScale(2, 5);
            valorTitulos = bd.doubleValue();
            bd = new BigDecimal(valorTotalNota);
            bd = bd.setScale(2, 5);
            valorTotalNota = bd.doubleValue();
            Double diferenca = valorTitulos - valorTotalNota;
            if ((diferenca = ToolFormatter.arrredondarNumero((Double)diferenca, (int)2)) > 0.2 || diferenca < -0.2) {
                throw new ExceptionTitulo(EnumExcepTitulo.DIFERENCA_VLR_TITULOS_VR_TOTAL_DOC, new Object[]{ToolFormatter.formataNumero((Number)diferenca, (int)2)});
            }
        }
    }

    public Titulo criarTitulos(OrdemCompraVencimentos venc, OpcoesFinanceiras opcoes, OpcoesContabeis opcoesContabeis) throws ExceptionInvalidData {
        return this.newTitulo(venc.getOrdemCompra().getUnidadeFatFornecedor().getFornecedor().getPessoa(), this.compPlanoConta.getPlanoConta(venc.getOrdemCompra().getUnidadeFatFornecedor().getFornecedor(), opcoesContabeis), EnumConstPessoa.FORNECEDOR.getEnumId(), (short)0, (short)0, venc.getDataVencimento(), "observacao", venc.getOrdemCompra().getDataEmissao(), venc.getOrdemCompra().getDataPrevFaturamento(), venc.getOrdemCompra().getDataCadastro(), venc.getOrdemCompra().getDataEmissao(), venc.getOrdemCompra().getEmpresa(), opcoes, venc.getNumeroParcela(), venc.getNumeroParcelas().shortValue(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, venc.getOrdemCompra().getCondicaoPagamento().getMeioPagamento(), venc.getOrdemCompra().getCondicaoPagamento(), venc.getOrdemCompra().getUnidadeFatFornecedor().getFornecedor().getClassificacaoPessoa());
    }

    private void criarLancamentosCTBGerencial(OrdemCompra ordemCompra, List<Titulo> titulos, Empresa empresa) {
        CompGeracaoLancCtbGerencial.criarSetarLancamentosCTBGerencial(ordemCompra, titulos, empresa);
    }

    public LinkedList getPrevVencimentosOC(OrdemCompra oc) {
        Double valorTotal = this.getValorTotalTitulos(oc.getTitulos());
        LinkedList<OrdemCompraVencimentos> ret = new LinkedList<OrdemCompraVencimentos>();
        for (Titulo t : oc.getTitulos()) {
            OrdemCompraVencimentos venc = new OrdemCompraVencimentos();
            venc.setDataVencimento(t.getDataVencimento());
            venc.setOrdemCompra(oc);
            venc.setPercPagOrdemCompra(Double.valueOf(t.getValor() / valorTotal * 100.0));
            venc.setNumeroParcela(t.getNumParcTituloEstnota());
            venc.setNumeroParcelas(t.getNumParcTituloEstnota());
            ret.add(venc);
        }
        return ret;
    }
}

